library IEEE;
use IEEE.std_logic_1164.all;
use work.all;



entity icebreaker_tb is
end icebreaker_tb;


architecture arch_icebreaker_tb of icebreaker_tb is

signal BTN1, BTN2, LED1, LED2, LED3, CLK : std_logic;
constant CLK_period : time := 83333 ps; --12MHz

begin

icebreaker_0 : entity icebreaker port map (
BTN1 => BTN1,
BTN2 => BTN2,
CLK => CLK,
LED1 => LED1,
LED2 => LED2,
LED3 => LED3
);

-- Clock definition.
CLK_process :process
      begin
        CLK <= '0';
        wait for CLK_period / 2;
        CLK <= '1';
        wait for CLK_period / 2;
      end process;

stimuli: process
      begin
        BTN1 <= '0'; BTN2 <= '0'; -- Initial conditions.
        wait for 1 ms;
		BTN1 <= '0'; BTN2 <= '1';
        wait for 1 ms;
		BTN1 <= '1'; BTN2 <= '0';
        wait for 1 ms;
        BTN1 <= '1'; BTN2 <= '1';
        wait;
end process;


end arch_icebreaker_tb;
