library IEEE;
use IEEE.std_logic_1164.all;


-- Pressing button 1 (A) and/or 2 (B) will compare the two signals
-- and enable one of the built-in LEDs:
--      A < B: L2
--      A = B: L1
--      A > B: L3

entity icebreaker is
port(  BTN1, BTN2, CLK : in std_logic;
		LED1, LED2, LED3 : out std_logic);
end entity icebreaker;

architecture arch_icebreaker of icebreaker is
begin


process(CLK)
begin
	if rising_edge(CLK) then
		if BTN1>BTN2 then LED1 <= '1'; LED2 <= '0'; LED3 <= '0';
		elsif BTN1=BTN2 then LED1 <= '0'; LED2 <= '1'; LED3 <= '0';
		elsif BTN1<BTN2 then LED1 <= '0'; LED2 <= '0'; LED3 <= '1';
		else LED1 <= '0'; LED2 <= '0'; LED3 <= '0';
		end if;
	end if;	
end process;


end arch_icebreaker;
