


--*********************************************************************************
--		SEQUENCEUR du CORRELATEUR
--*********************************************************************************
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.stimul_pack.all;

entity sequ_correlateur is
    
    port(
        
        clk, reset, clke, ref, s_44 : in std_logic;
        ld_pile_ref, ld_pile_rec, ld_reg_pdt, ld_reg_sum, calc, raz_reg_pdt,
        raz_reg_sum, raz_pile_rec, raz_pile_ref, raz_count, count_enable : out std_logic
        
        
        );
end sequ_correlateur;

architecture arch_sequ_correlateur of sequ_correlateur is
    
    type etat_correlateur is (repos, chargmt_ref, attente_0, attente_1, chargmt_rec, chargmt_res_inter, 
                              dernier_prod, sortie, attente_2, attente_3);
    signal etat_cr, etat_sv : etat_correlateur;
      
    
    begin
      
      
     etat_cr <= repos when reset ='1' else
		      etat_sv when rising_edge(clk) else
		      etat_cr;   
      
              
        process(etat_cr, clke, ref, s_44)


        
        begin
   
        ld_pile_ref   <= '0';
        ld_pile_rec   <= '0';
        ld_reg_pdt    <= '0';
        ld_reg_sum    <= '0';
        calc          <= '0';
        raz_reg_pdt   <= '0';
        raz_reg_sum   <= '0';
        raz_pile_rec  <= '0';
        raz_pile_ref  <= '0';
        raz_count     <= '0';
        count_enable  <= '0';

        etat_sv <=etat_cr ;
    
            
            case etat_cr is
                
                when repos                => if ref='1' and clke='1'then etat_sv <= chargmt_ref;
                                             else etat_sv <= repos; end if;
                                               
                                              raz_pile_rec  <='1';
                                              raz_pile_ref  <='1';
                                              raz_count     <= '1';                             
                                                                         
                                                                         
                when chargmt_ref          =>   etat_sv <= attente_0;
                                              ld_pile_ref   <='1';
                                              raz_count     <= '1';
                                                                       
                when attente_0            =>   if clke='0'then etat_sv <= attente_1;
                                               else etat_sv <= attente_0; end if;
                                                 
                when attente_1            =>   if ref='1' and clke='1'then etat_sv <= chargmt_ref;
                                               elsif ref='0' and clke='1' then etat_sv<= chargmt_rec;
                                               else etat_sv <= attente_1; end if;
                                                 
                when chargmt_rec          =>   etat_sv <= chargmt_res_inter;
                                              
                                              raz_reg_pdt   <='1';
                                              raz_reg_sum   <='1';
                                              ld_pile_rec   <='1';
                                              raz_count     <= '1';   
                                                                      
                when chargmt_res_inter    =>   
                                               if s_44='1' then etat_sv <= dernier_prod;
                                               else etat_sv <= chargmt_res_inter; end if;
                                                                         
                                              ld_reg_pdt    <='1' ;
                                              calc          <='1' ; 
                                              ld_reg_sum    <='1' ;                       
                                              count_enable <= '1' ;
                                                
                                                
                when dernier_prod         =>   etat_sv <= sortie;
                                              
                                              ld_reg_sum    <='1';
                                              calc          <='1';
                                              ld_reg_pdt    <='1';
                                              raz_count     <= '1';
                                                                       
                when sortie               =>   if clke='1'then etat_sv <= attente_2;
                                               else etat_sv <= attente_3; end if;
                                                 
                                              ld_reg_sum    <='1';
                                                 
                when attente_2            =>   if clke='0'then etat_sv <= attente_3 ;
                                               else etat_sv <= attente_2; end if;
                                                 
                when attente_3            =>   if ref='1' and clke='1'then etat_sv <= chargmt_ref;
                                               elsif ref='0' and clke='1' then etat_sv <= chargmt_rec;
                                               else etat_sv <= attente_3; end if;
                 
        
             end case;
             
       
          end process;
        
  
end arch_sequ_correlateur; 

--*********************************************************************************
--		COMPTEUR DU SEQUENCEUR
--**********************************************************************
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.stimul_pack.all;


entity compt_seq_correl is
  
  port(	
  
  raz_count , clk, count_enable : in std_logic;
	s_44 : out std_logic
	
	);
end compt_seq_correl;



architecture arch_compteur_seq of compt_seq_correl is	
	
	signal compteur : integer range 0 to 42;
	
	begin
	  
	  process(clk)
	    
	    begin
	      
	      if raz_count='0' then 
	      
	         if rising_edge(clk) then
	        
	           if count_enable = '1' then
	        
	           if compteur =42 then compteur <= 0; else compteur <= compteur+1; end if;
	           end if;
	          end if;
	      
	      else compteur <= 0;
	      end if;
	
  end process;
  
  s_44 <= '1' when compteur=42  else '0';

  
end arch_compteur_seq;



--*********************************************************************************
--		REGISTRE GENERIQUE : taille de l'entrée et taille de la sortie paramétrables
--*********************************************************************************
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.stimul_pack.all;

entity registre is 
generic(taille_entree: natural:=8;
        taille_sortie : natural :=10);
port( 
    load, raz, clk : in std_logic;
    entree : in  std_logic_vector (taille_entree-1 downto 0);
    sortie : out std_logic_vector (taille_sortie-1 downto 0)
   
    );
end registre;


architecture arch_registre of registre is
    
    begin
        process(clk)
            
            begin
            if (rising_edge(clk)) then
                if raz='1' then sortie<=(others => '0'); 

                
                elsif load='1' then 
                
                
                sortie(taille_entree-1 downto 0) <= entree;
                
                 
                 for i in taille_entree-1 to taille_sortie-1  loop
                 sortie(i) <= entree(taille_entree-1) ; 
                 end loop;
                
                
              end if;
                                 
 
                              
          end if;                      
                                    
          
    end process;
    

end arch_registre;



--*********************************************************************************
--		PILE GENERIQUE (un paramètre permet de déterminer la taille de la pile)
--*********************************************************************************
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.stimul_pack.all;

entity pile is
    
generic(taille: natural:=8);
port ( calc, load, clk, raz_pile : in std_logic;
             d_in : in std_logic_vector(7 downto 0);
            d_out : out std_logic_vector(7 downto 0)
            );
            
end pile;     


architecture arch_pile of pile is


        type type_pile is array(0 to taille-1) of std_logic_vector(7 downto 0);
        signal donnee : type_pile;
begin
    
    process(clk)
        
        variable intermediaire : std_logic_vector(7 downto 0);

        begin
        if (raz_pile='1') then for i in 0 to taille-1 loop
                                donnee(i)<="00000000";
                                end loop;
        elsif rising_edge(clk) then
            if (load='1') then for i in 0 to taille-2 loop
                               donnee(i+1) <= donnee(i) ;
                               end loop;
                               donnee(0) <= d_in;
            elsif (calc='1') then  intermediaire := donnee(taille-1);
                                    
                                    
                                   for i in 0 to taille-2 loop
                                   donnee(i+1) <= donnee(i) ;
                                   end loop;
                                   donnee(0) <= intermediaire;
                                                  
        end if;
    end if;
end process;
d_out <= donnee(taille-1);

end arch_pile;      


--*********************************************************************************
--		MULTIPLIEUR GENERIQUE
--*********************************************************************************
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.stimul_pack.all;


entity multiplieur is
    generic(taille : natural:=8);
    port(e1, e2 : in std_logic_vector(taille-1 downto 0);
              sortie : out std_logic_vector(2*taille-1 downto 0)
              );
end multiplieur;              


architecture arch_multiplieur of multiplieur is

begin
  
sortie <= std_logic_vector(signed(e1) * signed(e2));

end arch_multiplieur; 




--*********************************************************************************
--		ADDITIONNEUR GENERIQUE
--*********************************************************************************
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.stimul_pack.all;


entity additionneur is
    
    generic(taille : natural:=8);
    port( e1, e2 : in   std_logic_vector(taille-1 downto 0);
          sortie : out  std_logic_vector (taille-1 downto 0)
              );
end additionneur;  


architecture arch_additionneur of additionneur is

begin
    
    sortie <= std_logic_vector(signed(e1) + signed(e2));

end arch_additionneur; 








--**********************************************************************
--**********************************************************************
--	                              CORRELATEUR
--**********************************************************************
--**********************************************************************
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.stimul_pack.all;
use work.all;

entity correlateur is
    
    port( 
           ref, reset, clk, clke : in std_logic; 
           d_in : in std_logic_vector (7 downto 0);
           correl : out std_logic_vector (20 downto 0)
           );
           
end correlateur;           
           
architecture arch_correlateur of correlateur is
    
signal calc, load_pile_ref, load_pile_rec, raz_pile_rec, raz_reg_prdt, 
         load_reg_prdt, load_reg_add, raz_reg_add, raz_pile_ref, raz_count, count_enable, s_44  : std_logic;
signal sortie_pile_ref, sortie_pile_rec : std_logic_vector (7 downto 0);
signal sortie_prdt : std_logic_vector(15 downto 0);
signal sortie_reg_prdt, sortie_reg_add, sortie_add : std_logic_vector(20 downto 0);

begin

pile_ref : entity pile generic map (44) port map (calc => calc,
                                                  load => load_pile_ref,
                                                  clk => clk,
                                                  raz_pile => raz_pile_ref,
                                                  d_in => d_in,
                                                  d_out => sortie_pile_ref );
                                                     
pile_rec : entity pile generic map (44) port map (calc => calc,
                                                 load => load_pile_rec,
                                                 clk =>clk,
                                                 raz_pile => raz_pile_rec,
                                                 d_in => d_in,
                                                 d_out => sortie_pile_rec);

multip : entity multiplieur generic map (8) port map (e1 => sortie_pile_ref,
                                                      e2 => sortie_pile_rec,
                                                      sortie => sortie_prdt);

reg_mul : entity registre generic map(16,21) port map(load => load_reg_prdt, 
                                                      raz => raz_reg_prdt, 
                                                      clk => clk,
                                                      entree => sortie_prdt,
                                                      sortie => sortie_reg_prdt);
                                                      
add : entity additionneur generic map(21) port map (e1 => sortie_reg_prdt,
                                                    e2 =>  sortie_reg_add, 
                                                    sortie => sortie_add);

reg_add : entity registre generic map (21,21) port map (load => load_reg_add,
                                                        raz => raz_reg_add, 
                                                        clk => clk,
                                                        entree => sortie_add,
                                                        sortie => sortie_reg_add);
 
seq : entity sequ_correlateur port map ( clk => clk, 
                                        reset => reset, 
                                        clke => clke, 
                                        ref => ref,
                                        s_44 => s_44,
                                        ld_pile_ref => load_pile_ref, 
                                        ld_pile_rec => load_pile_rec,
                                        ld_reg_pdt => load_reg_prdt,
                                        ld_reg_sum => load_reg_add,
                                        calc => calc,
                                        raz_reg_pdt => raz_reg_prdt,
                                        raz_reg_sum =>raz_reg_add,
                                        raz_pile_rec => raz_pile_rec,
                                        raz_pile_ref => raz_pile_ref,
                                        raz_count => raz_count,
                                        count_enable => count_enable);  



compteur_seq : entity compt_seq_correl port map ( raz_count => raz_count,
                                                  clk => clk,
                                                  count_enable => count_enable,
                                                  s_44 => 	s_44);



correl <=  sortie_reg_add;      
end arch_correlateur;        
