--*********************************************************************************
--*********************************************************************************
--		TP2 : DESCRIPTION DU BANC DE TEST
--*********************************************************************************
--*********************************************************************************
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.stimul_pack.all;
use work.all;

entity banc_de_test is
    
    port (reset, clk, clke :in std_logic;
           correl : out std_logic_vector(20 downto 0)
           );
           
end banc_de_test;


architecture arch_banc of banc_de_test is  


signal data : std_logic_vector (7 downto 0);
signal ref : std_logic;

begin
    
    stimul :  entity   stimulateur port map (reset => reset,
                                            clke => clke,
                                            d_out => data,
                                            ref => ref);
                                            
    corr :    entity   correlateur port map ( ref => ref, 
                                              reset => reset,
                                              clk => clk,
                                              clke => clke,
                                              d_in => data, 
                                              correl => correl);
    
end arch_banc;



