--*******************************
--        DETECTEUR FRONTS
--******************************* 
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
  
entity detect_front is
  port( clk, reset : in std_logic;
        E : in std_logic;
        front_montant : out std_logic);
end detect_front;

architecture arch_detect_front of detect_front is
type etats_me is (E_0, E_1, E_2);
signal  etat_cr, etat_sv : etats_me;

begin
  
process(clk, reset)
    begin    
    if reset='1' then etat_cr <= E_0 ;
    elsif rising_edge(clk) then etat_cr <= etat_sv ; end if;
end process;

process(etat_cr, E)
    begin
  etat_sv <= etat_cr ; front_montant <= '0' ;  
  case etat_cr is    
  when E_0 => if E='1' then etat_sv <= E_1 ; end if;  
  when E_1 => etat_sv <= E_2 ;
              front_montant <= '1' ;                
  when E_2 => if E='0' then etat_sv <= E_0 ; end if; 
  end case;
  end process;
end arch_detect_front;    
    
--*******************************
--        ME COMPARATEUR PHASES
--******************************* 
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
  
entity me_comp_phase is
  port( clk, reset : in std_logic;
        E, S : in std_logic;
        AR, AV : out std_logic);
end me_comp_phase;

architecture arch_me_comp_phase of me_comp_phase is
type etats_me is (EN_PHASE, RETARD, AVANCE);
signal  etat_cr, etat_sv : etats_me;

begin
  
process(clk, reset)
    begin    
    if reset='1' then etat_cr <= EN_PHASE ;
    elsif rising_edge(clk) then etat_cr <= etat_sv ; end if;
end process;

process(etat_cr, E, S)
    begin
  etat_sv <= etat_cr ; AR <= '0' ; AV <= '0';
  
  case etat_cr is
    
  when EN_PHASE   => if      (S='1' and E='0')   then etat_sv <= RETARD ;
                      elsif   (E='1' and S='0')   then etat_sv <= AVANCE;
                      end if; 
  when AVANCE     => if S='1' then etat_sv <= EN_PHASE; end if;
                      AV <= '1';               
  when RETARD     => if E='1' then etat_sv <= EN_PHASE; end if; 
                      AR <= '1';    
  end case ;  
  end process;  
end arch_me_comp_phase;

--*******************************
--        COMPARATEUR PHASES
--******************************* 
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.all;

entity comparateur_phase is
  port( clk, reset, top_0, top_synchro : in std_logic;
        AV, AR : out std_logic);
      end comparateur_phase;
      
      architecture arch_comp_phase of comparateur_phase is
        signal front_top_0, front_top_synchro : std_logic;
        begin
  
  sequenceur_comp : entity me_comp_phase port map (
                        clk     => clk, 
                        reset   => reset,
                        E       => front_top_0,       -- A VERIFIER
                        S       => front_top_synchro, -- A VERIFIER
                        AR      => AR,
                        AV      => AV);
                        
detect_front_top_0 : entity detect_front port map ( 
                            clk   => clk,
                            reset => reset,
                            E     => top_0,
                            front_montant => front_top_0);

detect_front_top_synchro : entity detect_front port map ( 
                            clk   => clk,
                            reset => reset,
                            E     => top_synchro,
                            front_montant =>front_top_synchro);       

end arch_comp_phase;



