
    
--*******************************
--        COMPTEUR - DECOMPTEUR
--*******************************      
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;      
      
entity compt_dec is
  generic( taille : integer :=8);
  port( clk, reset : in std_logic;
        inc, dec : in std_logic;
        comptage : out std_logic_vector(taille-1 downto 0));
end compt_dec;

architecture arch_compt_dec of compt_dec is
  signal interne :  signed(taille-1 downto 0);  
  begin    
    process(clk, reset)    
      begin
        
        if reset='1' then interne <= (others =>'0');
        elsif rising_edge(clk) then if inc='1' then interne <= interne+1;
                                  elsif dec='1' then interne <= interne -1;
                                  end if;
        end if;
    end process;
    comptage <= std_logic_vector(interne);
end arch_compt_dec;          
--*******************************
--        CORRECTEUR
--*******************************
  
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;  
  
entity correcteur is
generic( taille : integer :=9);
port(E : in std_logic_vector(taille-1 downto 0);
    clk, reset : in std_logic;
    S : out std_logic_vector(taille-1 downto 0));
  end correcteur;
  
  architecture arch_correcteur of correcteur is
    signal mem_E : signed(taille-1 downto 0);
    signal Y : signed(2*taille-1 downto 0);
    begin      
      process(clk, reset)
      begin     
        if reset='1' then mem_E <= (others => '0'); Y <= (others => '0');
        elsif rising_edge(clk) then --S <=  std_logic_vector(shift_right(signed(E),4)); 
                                    --Y <= 16*signed(E) -15*mem_E;
                                   -- Y <= (2*taille)*signed(E) -(2*taille-1)*mem_E;
                                    
                                    Y <= shift_right(18*signed(E)-17*mem_E,2);
                                    mem_E <= signed(E) ;  
        end if;      
      end process;
      S <= std_logic_vector(Y(taille-1 downto 0));     
    end arch_correcteur;

--*******************************
--        FILTRE DE BOUCLE
--*******************************      
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.all;

entity filtre_boucle is
generic( taille : integer :=9);
port ( clk, reset, inc, dec : in std_logic;
      delta_phi : out std_logic_vector(taille-1 downto 0));
end filtre_boucle;

architecture arch_filtre_boucle of filtre_boucle is
signal sortie_compt : std_logic_vector(taille-1 downto 0);
begin
compteur_dec :  entity compt_dec generic map(9) port map (
                            clk     => clk, 
                            reset   => reset,
                            inc     => inc,
                            dec     => dec,
                            comptage => sortie_compt);

correct : entity correcteur generic map(9) port map (
                            E     => sortie_compt,
                            clk   => clk, 
                            reset => reset,
                            S     => delta_phi );
end arch_filtre_boucle;        



