-- cours : registre, raz synchrone ou reset asynchrone
-- conversions
-- TP : enlever ventuellement sub
-- Diffrence machine de moore / Machine de Mealy
-- comment prendre une partie d'un vecteur
-- modelsim : dtailler transcript + affichage graphique et radix
-- prendre les erreurs dans l'ordre
-- comment tester --> regarder tous les signaux
-- bien vrifier toutes les tailles des vecteurs
-- cours prsenter TPs
-- multiplexeurs : valeur par dfaut
-- nom des labels port map

------------------------------------------------------
--               PORTE 3 ETATS
------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity tristate is
  port( oe : in std_logic;
        data_in  : in std_logic_vector( 15 downto 0);
        data_out : inout std_logic_vector(15 downto 0));
end tristate;

architecture arch_tristate of tristate is
begin

data_out <= data_in when oe = '1' else (others => 'Z');

end arch_tristate;  
      
------------------------------------------------------
--               MULTIPLEXEUR MUX A 2 VOIES
------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity mux_A is 
  port( sel : in std_logic;
        e_0, e_1 : in std_logic_vector(11 downto 0);
        s : out std_logic_vector( 11 downto 0));
end mux_A;

architecture arch_mux_A of mux_A is
  begin
    
    s <= e_0 when sel='0' else e_1;
    
end arch_mux_A;    
------------------------------------------------------
--               MULTIPLEXEUR MUX B 2 VOIES
------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity mux_B is 
  port( sel : in std_logic;
        e_0, e_1 : in std_logic_vector(15 downto 0);
        s : out std_logic_vector( 15 downto 0));
end mux_B;

architecture arch_mux_B of mux_B is
  begin
    
    s <= e_0 when sel='0' else e_1;
    
end arch_mux_B;    
------------------------------------------------------
--               MULTIPLEXEUR 4 VOIES
------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity mux_4 is 
  port( sel : in std_logic_vector(1 downto 0);
        e_0, e_1, e_2, e_3 : in std_logic_vector(11 downto 0);
        s : out std_logic_vector( 11 downto 0));
end mux_4;

architecture arch_mux_4 of mux_4 is
  begin
    s <= e_0 when sel="00" else 
         e_1 when sel="01" else
         e_2 when sel="10" else
         e_3 when sel="11" else e_0;
end arch_mux_4; 
------------------------------------------------------
--          UNITE ARITHMETIQUE ET LOGIQUE
------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.up_pack.all;

entity alu is 
  port ( A, B : in std_logic_vector(15 downto 0);
          alufs : in ALU_FCTS;
          S : out std_logic_vector( 15 downto 0));
end alu;

architecture arch_alu of alu is
signal tmp : std_logic_vector(16 downto 0);
begin

tmp <= std_logic_vector(unsigned('0' & A) - unsigned('0' & B)) when alufs=ALU_SUB else
       std_logic_vector(unsigned('0' & A) + unsigned('0' & B));  
  
  
S<= B                               when alufs=ALU_B else
    tmp(15 downto 0)                when alufs=ALU_SUB else
    tmp(15 downto 0)                when alufs=ALU_ADD else
    std_logic_vector(unsigned(B)+1) when alufs=ALU_B_INC else
    A and B                         when alufs=ALU_AND else
    A or B                          when alufs=ALU_OR else
    A xor B                         when alufs=ALU_XOR else
    A; -- Valeur par dfaut

end arch_alu;          

------------------------------------------------------
--               REGISTRE ACCUMULATEUR
------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;


entity accumulator is
  port( clk, raz, load : in std_logic;
        data_in : in std_logic_vector(15 downto 0);
        data_out : out std_logic_vector(15 downto 0);
        acc15, accz : out std_logic );
end accumulator;

architecture arch_acc of accumulator is
  signal q_reg : std_logic_vector(15 downto 0);
  begin
    
process(clk) 
  begin   
    if rising_edge(clk) then 
        if raz='1' then q_reg <= (others => '0'); 
        elsif load = '1' then q_reg <= data_in; 
        end if;
    end if;
end process;
data_out  <=  q_reg;
acc15     <=  q_reg(15);
accz      <=  '1' when to_integer(unsigned(q_reg)) = 0 else '0';      
end arch_acc;
      
------------------------------------------------------
--               REGISTRE PC
------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity pc_reg is
  port( clk, raz, load : in std_logic;
        data_in : in std_logic_vector(11 downto 0);
        data_out : out std_logic_vector(11 downto 0) );
end pc_reg; 

architecture arch_pc_reg of pc_reg is

  begin
    
process(clk) 
  begin   
    if rising_edge(clk) then 
        if raz='1' then data_out <= (others => '0'); 
        elsif load = '1' then data_out <= data_in; 
        end if;
    end if;
end process;

end arch_pc_reg;  
------------------------------------------------------
--               REGISTRE IR (Instruction Register)
------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.up_pack.all; 

entity ir_reg is
  port( clk, raz, load : in std_logic;
        data_in : in std_logic_vector(15 downto 0);
        data_out : out std_logic_vector(11 downto 0);
        opcode : out OPCODE);
end ir_reg; 

architecture arch_ir_reg of ir_reg is
 signal interne :  std_logic_vector(3 downto 0);
begin   
process(clk) 
  begin   
    if rising_edge(clk) then 
        if raz='1' then data_out <= (others => '0'); 
                        interne <= (others => '0'); 
        elsif load = '1' then data_out <= data_in (11 downto 0); 
                              interne  <= data_in (15 downto 12); 
                             
        end if;
    end if;
end process;

opcode <= OP_LDA when interne="0000" else
          OP_STO when interne="0001" else
          OP_ADD when interne="0010" else
          OP_SUB when interne="0011" else
          OP_JMP when interne="0100" else
          OP_JGE when interne="0101" else
          OP_JNE when interne="0110" else
          OP_STP when interne="0111" else
          OP_AND when interne="1000" else
          OP_OR  when interne="1001" else
          OP_XOR when interne="1010" else
          OP_LDR when interne="1011" else
          OP_LDI when interne="1100" else
          OP_STI when interne="1101" else                
          OP_JSR when interne="1110" else
          OP_RET when interne="1111" else
          OP_UNKNOWN;





end arch_ir_reg; 
------------------------------------------------------
--          SEQUENCEUR
------------------------------------------------------
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.up_pack.all;  

entity sequenceur is
  port( clk, reset : in std_logic;
        accz, acc15 : in std_logic;
        opcode : in OPCODE;
        raz  : out std_logic;
        selA : out std_logic_vector(1 downto 0);
        selB : out std_logic;
        selC : out std_logic_vector(1 downto 0);
        acc_ld, pc_ld, r_ld, ir_ld, acc_oe : out std_logic;
        alufs : out ALU_FCTS;
        memrq, rnw : out std_logic );       
end sequenceur;

architecture arch_seq of sequenceur is
  
  type me_states is (INIT, FETCH, EXECUTE, STOP);
  signal  etat_cr, etat_sv : me_states ;
    
    
begin
  
process( clk , reset)
    begin
      if reset='1' then etat_cr <= INIT;
      elsif rising_edge(clk) then etat_cr <= etat_sv; 
      end if;     
end process;   
     
process(etat_cr, opcode, accz, acc15)
    begin
etat_sv <= etat_cr; raz <= '0'; selA <= "00"; selB <= '0'; selC <= "00";
acc_ld <= '0'; acc_oe <= '0';
pc_ld <= '0'; ir_ld <= '0'; r_ld<='0';
alufs <= ALU_B_INC;
memrq <= '1'; rnw <='1';
		
		case etat_cr is
			when INIT =>
				etat_sv <= FETCH;
				raz <= '1';
			when FETCH =>
				etat_sv <= EXECUTE;
				ir_ld <= '1';				           -- load IR with data on the data bus
				alufs <= ALU_B_INC;			      -- op = B+1
				pc_ld <= '1';				           -- load PC with PC+1
			when EXECUTE =>
				case opcode is
					when OP_LDA =>			  -- LDA s
						selA <= "11"; 		 -- IR[mem] on addr bus
						selB <= '1';
						selC <= "01";		  -- data bus to ACC 
 						alufs <= ALU_B;		-- op = B
						acc_ld <= '1';		 -- load data in accumulator
						etat_sv <= FETCH;
					when OP_STO =>			-- STO s
						selA <= "11";		-- IR[mem] on addr bus
						acc_oe <= '1';		-- output accumulator on data bus
						rnw <= '0';			-- select write to memory
						etat_sv <= FETCH;
					when OP_ADD =>			-- ADD s
						selA <= "11";		-- IR[mem] on addr bus
						selB <= '1';		-- data to B alu entry
						alufs <= ALU_ADD;	-- op = A+B
						acc_ld <= '1';		-- load result in accumulator
						etat_sv <= FETCH;
					when OP_SUB =>			-- SUB s
						selA <= "11";		-- IR[mem] on addr bus
						selB <= '1';		-- data to B alu entry
						alufs <= ALU_SUB;	-- op = A-B
						acc_ld <= '1';		-- load result in accumulator
						etat_sv <= FETCH;
					when OP_JMP =>			-- JMP s
						selA <= "11";		-- IR[mem] on addr bus
						alufs <= ALU_B;  	-- op = B
						pc_ld <= '1';		-- load PC with IR[mem]
						etat_sv <= FETCH;
--						-- 0 cycle JMP
--						selA <= "11";ir_ld <= '1';pc_ld <= '1';
					when OP_JGE =>			-- JGE s
						if acc15='0' then	-- jump, else nothing
							selA <= "11";	-- IR[mem] on addr bus
							alufs <= ALU_B;	-- op = B
							pc_ld <= '1';	-- load PC with IR[mem]
						end if;
						etat_sv <= FETCH;
--						-- 0 cycle JGE
--						if acc15='0' then
--							selA <= "11";
--						end if;
--						ir_ld <= '1';pc_ld <= '1';
					when OP_JNE =>			-- JNE s
						if accz='0' then	-- jump, else nothing
							selA <= "11";	-- IR[mem] on addr bus
							alufs <= ALU_B;	-- op = B
							pc_ld <= '1';	-- load PC with IR[mem]
						end if;
						etat_sv <= FETCH;
--						-- 0 cycle JNE
--						if accz='0' then
--							selA <= '1';
--						end if;
--						ir_ld <= '1';pc_ld <= '1';
					when OP_STP =>			-- STP
						etat_sv <= STOP;
					when OP_AND =>			-- AND s
						selA <= "11";		-- IR[mem] on addr bus
						selB <= '1';		-- data to B alu entry
						alufs <= ALU_AND;	-- op = A and B
						acc_ld <= '1';		-- load result in accumulator
						etat_sv <= FETCH;
					when OP_OR =>			-- OR s
						selA <= "11";		-- IR[mem] on addr bus
						selB <= '1';		-- data to B alu entry
						alufs <= ALU_OR;	-- op = A or B
						acc_ld <= '1';		-- load result in accumulator
						etat_sv <= FETCH;
					when OP_XOR =>			-- XOR s
						selA <= "11";		-- IR[mem] on addr bus
						selB <= '1';		-- data to B alu entry
						alufs <= ALU_XOR;	-- op = A xor B
						acc_ld <= '1';		-- load result in accumulator
						etat_sv <= FETCH;
					when OP_LDR =>			-- LDR s
						selA <= "11";		-- IR[mem] on addr bus
--						selB <= '1';		-- data to B alu entry
						alufs <= ALU_B;		-- op = B
						r_ld <= '1';		-- load result in accumulator
						etat_sv <= FETCH;
					when OP_LDI =>			-- LDI val
						selA <= "01";		-- R on addr bus
						selB <= '0';		-- val to B alu entry
						selC <= "01";		-- data bus --> ACC
						alufs <= ALU_B_INC;	-- op = B+1
						acc_ld <= '1';		-- load result in accumulator
						r_ld <= '1';
						etat_sv <= FETCH;
					when OP_STI =>			-- STI
						selA <= "10";		-- R-1 on addr bus
						selB <= '0';		-- val to B alu entry
						alufs <= ALU_B;		-- op = B
						r_ld <= '1';
						acc_oe <= '1';		-- output accumulator on data bus
						rnw <= '0';			-- select write to memory
						etat_sv <= FETCH;
					
					when others =>
						etat_sv <= STOP;
				end case;
			when STOP => etat_sv <= STOP;
		end case;	  
 
end process;

end arch_seq;

------------------------------------------------------
--       INSTANCIATION : DESCRIPTION DE mu0
------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.up_pack.all; 
use work.all;

entity mu0 is
  port( 
    reset, clk : in std_logic;
    data_bus : inout std_logic_vector(15 downto 0);
    addr_bus : inout   std_logic_vector(11 downto 0);
    mem_rq  :  out   std_logic;
    rnw     :  out   std_logic);
  end mu0;
  
architecture arch_mu0 of mu0 is
  signal opcode		  : OPCODE;						                    -- opcode operation
	signal raz			    : std_logic;						                    -- raz for registers
	signal ir_out		  : std_logic_vector(11 downto 0);	     -- output of IR
	signal pc_out		  : std_logic_vector(11 downto 0);	   -- output of PC
	signal r_out		   : std_logic_vector(11 downto 0);	    -- output of R
	signal r_1_out		 : std_logic_vector(11 downto 0);	  -- output of R-1
	signal alu_out		 : std_logic_vector(15 downto 0);	  -- output of ALU
	signal acc_out		 : std_logic_vector(15 downto 0);	  -- output of ACC
	
	signal muxb_out		: std_logic_vector(15 downto 0);	 -- output of MUXb

	signal concat		: std_logic_vector(15 downto 0);	
	signal alufs		   : ALU_FCTS;		    -- function code for alu
	signal ir_ld		   : std_logic;						                   -- load IR
	signal pc_ld		   : std_logic;						                   -- load PC
	signal r_ld			   : std_logic;						                   -- load R
	signal acc_ld		  : std_logic;						                  -- load ACC
	signal acc_oe		  : std_logic;						                  -- enable out buffer
	signal selA			   : std_logic_vector(1 downto 0);		    -- multiplexer A select
	signal selB			   : std_logic;						                   -- multiplexer B select
	signal selC			   : std_logic_vector(1 downto 0);		    -- multiplexer C select
	signal accZ			   : std_logic;						                   -- accumulator all zero's
	signal acc15		   : std_logic;						                   -- accumualtor sign bit
begin

seq : entity sequenceur port map ( 
        clk     =>  clk,
        reset   =>  reset,
        accz    =>  accZ,
        acc15   =>  acc15,
        opcode  =>  opcode,
        raz     =>  raz,
        selA    =>  selA,
        selB    =>  selB,
        selC    =>  selC,
        acc_ld  =>  acc_ld,
        pc_ld   =>  pc_ld,
        r_ld    =>  r_ld,
        ir_ld   =>  ir_ld,
        acc_oe  =>  acc_oe,
        alufs   =>  alufs,
        memrq   =>  mem_rq,
        rnw     =>  rnw
        );
pc : entity pc_reg port map (
        clk       =>   clk,
        raz       =>   raz,
        load      =>   pc_ld,
        data_in   =>   alu_out(11 downto 0),
        data_out  =>   pc_out
        );  
acc : entity accumulator port map (
        clk       =>  clk,
        raz       =>  raz,
        load      =>  acc_ld,
        data_in   =>  alu_out,
        data_out  =>  acc_out,
        acc15     =>  acc15,
        accz      =>  accz
        );
        
ual : entity alu port map ( 
        A       =>  acc_out,
        B       =>  muxb_out,
        alufs   =>  alufs,
        S       =>  alu_out
        );

ir : entity ir_reg port map (
        clk       => clk,
        raz       => raz,
        load      => ir_ld,
        data_in   => data_bus,
        data_out  => ir_out,
        opcode    => opcode
        );
   
 concat <=  "0000" & addr_bus;      
 muxB : entity mux_B port map (
        sel     => selB,
        e_0     => concat,
        e_1     => data_bus,
        s       => muxb_out);
        
  muxA : entity mux_4 port map ( 
        sel   => selA,
        e_0   => pc_out,
        e_1   => (others => '0'),
        e_2   => (others => '0'),
        e_3   => ir_out,
        s     => addr_bus
        );

muxb_outporte_3E  : entity tristate port map (
        oe        => acc_oe,
        data_in   => acc_out,
        data_out  => data_bus
        );




end arch_mu0 ; 


      