--*******************************
--        ADDITIONNEUR
--*******************************
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity additionneur is  
  generic ( taille : integer := 9);
  port (A, B : in std_logic_vector( taille-1 downto 0);
        overflow : out std_logic;
        resultat : out std_logic_vector ( taille-1 downto 0));
end additionneur;
      
      architecture arch_add of additionneur is
        
        signal res_inter : signed(taille-1 downto 0);
        begin        
          res_inter <= signed(A) + signed(B);          
          overflow <= (not( A(taille-1)) and not(B(taille-1)) and res_inter(taille-1)) or  
                      (A(taille-1) and B(taille-1) and not(res_inter(taille-1)));
          resultat <= std_logic_vector(res_inter);
end arch_add;

--*******************************
--        REGISTRE
--*******************************
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity registre is
  generic( taille : integer := 9);
  port( E : in std_logic_vector( taille-1 downto 0);
        clk,reset : in std_logic;
        S: out std_logic_vector( taille-1 downto 0));
end registre;

architecture arch_reg of registre is
signal interne : std_logic_vector(taille-1 downto 0);
begin

process(clk, reset)
  
  begin
    
    if reset='1' then interne <= (others => '0');
    elsif rising_edge(clk) then interne <=E;
    end if;
  end process;
  
  S <= interne;

end arch_reg;   
     

--*******************************
--        OCN
--******************************* 
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all; 
use work.all;

entity OCN is
  generic( taille : integer := 9);
  port( clk, reset : in std_logic;
        delta_phi : in std_logic_vector (taille-1 downto 0);
        top_synchro : out std_logic;
        phase : out std_logic_vector(taille-1 downto 0));
      end OCN;
      
architecture arch_OCN of OCN is
  signal out_add, out_reg : std_logic_vector( taille-1 downto 0);
  begin
    
regi : entity registre generic map (taille) port map (
                                E       => out_add,
                                clk     => clk ,
                                reset   => reset ,
                                S       => out_reg
                                );
    
addi :  entity additionneur generic map (taille) port map (
                                A        => out_reg,
                                B        => delta_phi,
                                overflow => top_synchro,
                                resultat => out_add
                              );  
phase <= out_reg;
  

 
 
end arch_OCN;
    
    


