library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all; 
use work.all;

entity gene_sinus is
  port( reset, clk, top_0 : in std_logic;
        donnee_rom1,donnee_rom2,donnee_rom3 : out std_logic_vector(7 downto 0));
end gene_sinus;

architecture arch_gene_sinus of gene_sinus is 
signal phase : std_logic_vector(8 downto 0);
begin

boucle : entity BVP port map (
        top_0   => top_0,
        clk     => clk,
        reset   => reset,
        phase   => phase);
 

rom_1 : entity rom1 generic map(9) port map(
        adresse => phase ,
        donnee  => donnee_rom1);
rom_2 : entity rom2 generic map(9) port map(
        adresse => phase ,
        donnee  => donnee_rom2);
rom_3 : entity rom3 generic map(9) port map(
        adresse => phase ,
        donnee  => donnee_rom3);

end arch_gene_sinus;        
