--*******************************
--        BVP NUM
--******************************* 
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use work.all;

entity BVP is
  port( top_0, clk, reset : in std_logic;
        phase : out std_logic_vector( 8 downto 0));
end BVP; 

architecture arch_BVP of BVP is
  signal   delta_phi : std_logic_vector( 8 downto 0);
  signal top_synchro, AV, AR : std_logic;
  begin
 
comp_phs : entity comparateur_phase port map (
                            clk    => clk,
                            reset  => reset,
                            top_0   => top_0,
                            top_synchro   => top_synchro,
                            AV     => AV,
                            AR     => AR
                          );

                            
filtre_b : entity filtre_boucle generic map (9) port map (
                            clk      => clk, 
                            reset    => reset, 
                            inc       => AV ,
                            dec       => AR,
                            delta_phi => delta_phi);

          
          
OCNum : entity OCN generic map (9) port map (
          clk   => clk, 
          reset => reset,
          delta_phi => delta_phi,
          top_synchro => top_synchro,
          phase =>phase);
  
  
   
end arch_BVP;

