# -*- coding: utf-8 -*-
from __future__ import unicode_literals

# enibook.py

__author__  = 'jacques.tisseau@enib.fr'

from docutils import io, nodes, statemachine, utils
from docutils.parsers.rst import Directive
from docutils.parsers.rst import directives, roles
from docutils.utils.error_reporting import SafeString, ErrorString
import os, sys, re, time

ENIBOOKERROR = """
\033[1;31mEniBookError\033[0m
"""

#-----------------------------------------------------
def eniBookError(subdirective,directive,header='EniBookError') :
    header = '\033[1;31m' + header + '\033[0m'
    sys.stderr.flush()
    sys.stdout.flush()
    cause = 'La directive \'' + subdirective + '\' doit être une sous-directive de la directive \'' + directive + '\'.'
    fix   = 'Vérifier l\'indentation du bloc \'' + subdirective + '\' par rapport au bloc \'' + directive + '\'.'
    sys.stderr.write('\n'   + header)
    sys.stderr.write('\n  ' + cause)
    sys.stderr.write('\n  ' + fix)
    sys.stderr.write('\n')
    sys.exit(1)

def eniBookWarning(name,message,fix,header='EniBookWarning') :
    header = '\033[1;33m' + header + '\033[0m'
    sys.stderr.flush()
    sys.stdout.flush()
    name = 'Directive \'' + name + '\':'
    sys.stderr.write('\n'   + header)
    sys.stderr.write('\n  ' + name)
    sys.stderr.write('\n  ' + message)
    sys.stderr.write('\n  ' + fix)
    sys.stderr.write('\n')

#-----------------------------------------------------
_base_js_escapes = (
    ('\\', r'\u005C'),
    ('\'', r'\u0027'),
    ('"', r'\u0022'),
    ("'", r'\u0027'),
    ('>', r'\u003E'),
    ('<', r'\u003C'),
    ('&', r'\u0026'),
    ('=', r'\u003D'),
    ('-', r'\u002D'),
    (';', r'\u003B'),
    (u'\u2028', r'\u2028'),
    (u'\u2029', r'\u2029')
)

# Escape every ASCII character with a value less than 32.
_js_escapes = (_base_js_escapes +
               tuple([('%c' % z, '\\u%04X' % z) for z in range(32)]))

# escapejs from Django: https://www.djangoproject.com/
def escapejs(value):
    """Hex encodes characters for use in JavaScript strings."""
    if not isinstance(value, basestring):
        value = str(value)

    for bad, good in _js_escapes:
        value = value.replace(bad, good)

    return value


def boolean(argument) :
    return directives.choice(argument, ("false","true"))


#------------------------------------------------------------------------------
# EniBook
#------------------------------------------------------------------------------
ENIBOOK_HTML_BEGIN = u"""
"""

ENIBOOK_HTML_END = u"""
<script type="text/javascript">
    EniBook.init.push( function() { 
        EniBook['mode'] = '%(modeEnibook)s';
        EniBook['type'] = '%(typeEnibook)s'; 
        EniBook['version'] = '%(version)s';
        EniBook['timeversion'] = '%(timeversion)s';
        EniBook['author'] = '%(author)s';
        EniBook['institute'] = `%(institute)s`;
        EniBook['logo'] = '%(logo)s';
    } );
    EniBook.mode = '%(modeEnibook)s';
    console.log("EniBook %(version)s of %(timeversion)s");
</script>
"""

ENIBOOK_LATEX_BEGIN = u"""
"""

ENIBOOK_LATEX_END = u"""
"""
#------------------------------------------------------------------------------
class enibook(nodes.General, nodes.Element):
    def __init__(self,options):
        super(enibook,self).__init__()
        self.options = options

def visit_html_enibook(self, node):
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_enibook(self,node):
    res = node.html_end % node.options
    self.body.append(res)


def visit_latex_enibook(self, node):
    pass

def depart_latex_enibook(self,node):
    pass
#-----------------------------------------------------
def typeEnibook(argument):
    return directives.choice(argument, ("book","slideshow"))
def modeEnibook(argument):
    return directives.choice(argument, ("learning","assessing","training"))

class EniBook(Directive):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        "class"     : directives.class_option,
        "name"      : directives.unchanged,
        "mode"      : modeEnibook,
        "type"      : typeEnibook,
        "author"    : directives.unchanged,
        "institute" : directives.unchanged,
        "logo"      : directives.path,
        "title"     : directives.unchanged
    }
	
    def run(self) :
        env = self.state.document.settings.env

        self.options['id']          = self.getId().replace('-','_')
        self.options['code-rest']   = self.block_text
        self.options['directive']   = self.name
        self.options['version']     = '1.618033988'
        self.options['timeversion'] = env.config.timeversion
        self.options['modeEnibook'] = env.config.modeEnibook
        self.options['typeEnibook'] = env.config.typeEnibook

        if 'class' not in self.options:
            self.options['class'] = 'user-class'
            
        if 'name' not in self.options:
            self.options['name'] = self.options['id']

        if 'title' not in self.options:
            self.options['title'] = self.options['id']

        if 'author' not in self.options :
            self.options['author'] = '?'

        if 'institute' not in self.options :
            self.options['institute'] = '?'

        if 'logo' not in self.options :
            self.options['logo'] = ''
            
        if not os.path.exists("pyenibook.cfg"):
            file = open("pyenibook.cfg","w")
            txt  = "# -*- coding: utf-8 -*-" + "\n\n"
            txt += "# EniBook " + self.options['version'] + "\n"
            txt += "# mode      : "  + self.options['modeEnibook'] + "\n"
            txt += "# type      : "  + self.options['typeEnibook'] + "\n"
            txt += "# date      : "  + self.options['timeversion'] + "\n"
            txt += "# author    : "  + self.options['author'] + "\n"
            txt += "# institute : "  + self.options['institute'] + "\n\n"
            txt = txt.encode("utf8")
            file.write(txt)
            file.close()
            env.counter = 0
            node = enibook(self.options)
            node.html_begin  = ENIBOOK_HTML_BEGIN
            node.html_end    = ENIBOOK_HTML_END
            node.latex_begin = ENIBOOK_LATEX_BEGIN
            node.latex_end   = ENIBOOK_LATEX_END
            return [node]
        else :
            return []

    def getId(self) :
        env = self.state.document.settings.env
        env.id_counter = self.name + str(self.getNumber())
        return env.id_counter

    def getDate(self) :
        import datetime
        today = datetime.date.today()
        return str(today.day) + '/' + str(today.month) + '/' + str(today.year)

    def getNumber(self) :
        env = self.state.document.settings.env
        if not hasattr(env,'counter'):
            env.counter = 0
        env.counter += 1
        return env.counter

    def getModeEnibook(self) :
        env = self.state.document.settings.env
        if not hasattr(env,'modeEnibook') : return 'learning'
        else : return env.modeEnibook
    
    def getTypeEnibook(self) :
        env = self.state.document.settings.env
        if not hasattr(env,'typeEnibook') : return 'book'
        else : return env.typeEnibook
    
    
    def parseOption(self,str, keys=[':code:`', ':image:`', ':ln:`', ':math:`', ':python:`', ':rest:`']):
        for k in keys:
            i = str.find(k)
            while i >= 0:
                j = i + len(k)
                m = str[j:].find('`')
                if m >= 0:
                    arg = str[j:j+m]
                    if k == ':image:`':
                        arg = r'<img src="_static/_images/' + arg + r'" />'
                    elif k in [':code:`', ':python:`', ':rest:`']:
                        arg = r'<tt class="code docutils literal"><span class="pre">' + arg + r'</span></tt>'
                    elif k == ':math:`':
                        arg = r'\(' + arg + r'\)'
                    elif k == ':ln:`':
                        n = arg.find('<')
                        target = arg[n+1:len(arg)-1]
                        if n > 0:
		                    title = arg[:n-1]
                        else:
		                    title = target
                        arg = r'<a href="' + target + r'" target=_blank>' + title + r'</a>'
                    else: pass
                    str = str.replace(str[i:j+m+1],arg)
                i = str.find(k)
        return str

    def begin_error(self,directive) :
        return "\n\033[1;31mEniBookError\n" + "Directive " + directive + " : "

    def end_error(self) :
        return "\033[0m\n"

    def enibook_error(self,directive,msg,comment="") :
        res = self.begin_error(directive)
        res += msg
        res += self.end_error()
        res += comment
        return res

    def include(self,filename,lines=False) :
        if not self.state.document.settings.file_insertion_enabled:
            raise self.warning('"%s" directive disabled.' % self.name)
        source = self.state_machine.input_lines.source(
            self.lineno - self.state_machine.input_offset - 1)
        source_dir = os.path.dirname(os.path.abspath(source))
        path = directives.path(filename)
        #if path.startswith('<') and path.endswith('>'):
        #    path = os.path.join(self.standard_include_path, path[1:-1])
        path = os.path.normpath(os.path.join(source_dir, path))
        path = utils.relative_path(None, path)
        path = nodes.reprunicode(path)
        encoding = self.options.get(
            'encoding', self.state.document.settings.input_encoding)
        e_handler=self.state.document.settings.input_encoding_error_handler
        tab_width = self.options.get(
            'tab-width', self.state.document.settings.tab_width)
        try:
            self.state.document.settings.record_dependencies.add(path)
            include_file = io.FileInput(source_path=path,
                                        encoding=encoding,
                                        error_handler=e_handler)
        except UnicodeEncodeError, error:
            raise self.severe(u'Problems with "%s" directive path:\n'
                              'Cannot encode input file path "%s" '
                              '(wrong locale?).' %
                              (self.name, SafeString(path)))
        except IOError, error:
            raise self.severe(u'Problems with "%s" directive path:\n%s.' %
                      (self.name, ErrorString(error)))
        try:
            rawtext = include_file.read()
        except UnicodeError, error:
            raise self.severe(u'Problem with "%s" directive:\n%s' %
                              (self.name, ErrorString(error)))

        if lines :
            from docutils.statemachine import StringList
            include_lines = statemachine.string2lines(rawtext, tab_width, convert_whitespace=True)
            content = StringList(include_lines, source)
            return content

        if tab_width >= 0:
            text = rawtext.expandtabs(tab_width)
        else:
            text = rawtext
        #self.state_machine.insert_input(include_lines, path)
        return text

    def include_raw(self,filename) :
        if not self.state.document.settings.file_insertion_enabled:
            raise self.warning('"%s" directive disabled.' % self.name)
        source = self.state_machine.input_lines.source(
            self.lineno - self.state_machine.input_offset - 1)
        source_dir = os.path.dirname(os.path.abspath(source))
        path = directives.path(filename)
        #if path.startswith('<') and path.endswith('>'):
        #    path = os.path.join(self.standard_include_path, path[1:-1])
        path = os.path.normpath(os.path.join(source_dir, path))
        path = utils.relative_path(None, path)
        path = nodes.reprunicode(path)
        encoding = self.options.get(
            'encoding', self.state.document.settings.input_encoding)
        e_handler=self.state.document.settings.input_encoding_error_handler
        tab_width = self.options.get(
            'tab-width', self.state.document.settings.tab_width)
        try:
            self.state.document.settings.record_dependencies.add(path)
            include_file = io.FileInput(source_path=path,
                                        encoding=encoding,
                                        error_handler=e_handler)
        except UnicodeEncodeError, error:
            raise self.severe(u'Problems with "%s" directive path:\n'
                              'Cannot encode input file path "%s" '
                              '(wrong locale?).' %
                              (self.name, SafeString(path)))
        except IOError, error:
            raise self.severe(u'Problems with "%s" directive path:\n%s.' %
                      (self.name, ErrorString(error)))
        try:
            rawtext = include_file.read()
        except UnicodeError, error:
            raise self.severe(u'Problem with "%s" directive:\n%s' %
                              (self.name, ErrorString(error)))
        include_lines = statemachine.string2lines(rawtext, tab_width, convert_whitespace=True)
        if tab_width >= 0:
            text = rawtext.expandtabs(tab_width)
        else:
            text = rawtext
        self.state_machine.insert_input(include_lines, path)
        return []
#------------------------------------------------------------------------------











