# -*- coding: utf-8 -*-

# scope.py

__author__ = 'jacques.tisseau@enib.fr'

from docutils import io, nodes, statemachine, utils
from docutils.parsers.rst import Directive
from docutils.parsers.rst import directives, roles

from enibook import EniBook
from pg_logger import exec_script_str_local, json
from coderun import language_site

#------------------------------------------------------------------------------
# Scope
#-----------------------------------------------------
SCOPE_HTML_BEGIN = u"""
<div id="%(id)s-scope" name="%(name)s-scope" firststep="%(firststep)s"
    file="%(file)s" filename="%(filename)s" collapse="%(collapse)s" zoom="%(zoom)s">
    <span id="%(id)s-scope-zoom" name="%(name)s-scope-zoom"
        class="btn btn-warning glyphicons glyphicons-zoom-%(zoom)s"
        title="rétracter/déployer"
        onclick="EniBook['%(id)s'].toggle();"></span>
    <span id="%(id)s-scope-title" name="%(id)s-scope-title" class="scope-title">
            <span id="%(id)s-scope-lang" name="%(name)s-scope-lang" 
                class="edit-lang %(class)s-edit-lang">%(language)s</span> : %(file)s</span>
    <div id="%(id)s-scope-object" name="%(name)s-scope-object"
        class="scope %(class)s-scope">
        <object width=100%% height=600px type="text/html"
            data="%(filename)s"></object>
        <span id="%(id)s-scope-update" name="%(name)s-scope-update"
            class="btn btn-success glyphicons glyphicons-refresh"
            title="initialiser"
            onclick="EniBook['%(id)s'].update();"></span>
        <span class="btn btn-lightgray glyphicons glyphicons-chevron-up" style="float: right;"
            onclick="$.mobile.silentScroll($('#%(id)s-scope-title').offset().top);"></span>
    </div>
"""

SCOPE_HTML_END = u"""
</div>
<script type="text/javascript">
    //$(document).ready( function() { EniBook.init.push( function() { EniBook["%(id)s"] = new Scope("%(id)s"); }) });
    EniBook.init.push( function() { EniBook["%(id)s"] = new Scope("%(id)s"); } );
</script>
"""

PYTHON_TUTOR_HTML = u"""
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />    
    
    <title>%(title)s</title>

    <!-- Python Tutor -->
    <script type="text/javascript" src="_static/enibook/js/pytutor-embed.bundle.js" charset="utf-8"></script> 

    <link   rel="stylesheet"      href="_static/enibook/css/enibook.css"/>
</head>

<body>
    <div class="pytutorVisualizer" id="%(id)s-scope-page-html" 
        data-tracefile="%(jsonfilename)s"
        data-params='{}'>
    </div>

    <script type="text/javascript">
        createAllVisualizersFromHtmlAttrs();
    </script>
</body>

</html>
"""

"""
        data-params ='{
            "allowEditAnnotations": false,
            "disableHeapNesting": true,
            "drawParentPointers": false,
            "editCodeBaseURL": "http://pythontutor.com/visualize.html",
            "embeddedMode": false,
            "heightChangeCallback": redrawScope,
            "highlightLines": true,
            "showAllFrameLabels": false,
            "startingInstruction": %(firststep)s,
            "textualMemoryLabels": false,
            "verticalStack": false
        }'
"""
#-----------------------------------------------------
class scope(nodes.General, nodes.Element):
    def __init__(self,options):
        super(scope,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_scope(self, node):
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_scope(self,node):
    res = node.html_end % node.options
    self.body.append(res)
#-----------------------------------------------------

#-----------------------------------------------------
from coderun import language, language_extension

class Scope(EniBook):
    required_arguments = 0
    optional_arguments = 1
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'file'      : directives.path,
        'title'     : directives.unchanged,
        'firststep' : directives.nonnegative_int,
        'collapse'  : directives.flag,
        'heap'      : directives.flag,
        'cumulative': directives.flag
    }
	
    def run(self):
        super(Scope,self).run()

        if len(self.arguments) > 0 : 
            self.options['language'] = language(self.arguments[0])
        else :
            self.options['language'] = 'python'

        self.options['site'] = language_site[self.options['language']]

        if 'firststep' not in  self.options :
            self.options['firststep'] = 0

        if 'file' not in self.options :
            self.options['file'] = self.options['id'] + language_extension[self.options['language']]
            source = ''
        else :
            source = self.include(self.options['file'])

        if 'title' not in self.options :
            self.options['title'] = 'Codoscope ' + self.options['language']

        if 'heap' not in self.options :
            self.options['heap'] = False
        else :
            self.options['heap'] = True

        if 'cumulative' not in self.options :
            self.options['cumulative'] = False
        else :
            self.options['cumulative'] = True

        if 'collapse' not in self.options :
            self.options['collapse'] = 'false'
            self.options['zoom']     = 'out'
        else :
            self.options['collapse'] = 'true'
            self.options['zoom']     = 'in'                   

        if self.content:
            source += "\n".join(self.content)
        else:
            source += '\n'

        def finalizer_func(input_code, output_trace):
            res = dict(code=input_code, trace=output_trace)
            return res

        raw_input_lst_json = None
        cumulative_mode = self.options['cumulative']
        heap_primitives = self.options['heap']
        
        #trace = exec_script_str_local(source, raw_input_lst_json, cumulative_mode, heap_primitives, finalizer_func)
        #pg_logger.exec_script_str_local(fin.read(), options.raw_input_lst_json, options.cumulative, options.heapPrimitives, js_var_finalizer))
        trace = exec_script_str_local(source, raw_input_lst_json, cumulative_mode, heap_primitives, finalizer_func)
        json_output = json.dumps(trace, indent=None)
        self.options['trace'] = json_output
        

        import os.path
        jsonfilename = filename = os.path.basename(self.options['file'])
        self.options['file'] = filename
        self.options['filename'] = filename
        self.options['jsonfilename'] = filename
        index = filename.rfind(".")
        if (index != -1) :
            filename = filename[:index] + ".html"
            jsonfilename = jsonfilename[:index] + ".json"
        else :
            filename = filename + ".html"
            jsonfilename = jsonfilename + ".json"
        self.options['filename'] = filename
        self.options['jsonfilename'] = jsonfilename

        if self.options['modeEnibook'] == 'training' :
            f = open("../site/replay/html/" + filename,"w")
            fjson = open("../site/replay/html/" + jsonfilename,"w")
        elif self.options['modeEnibook'] == 'assessing' :
            f = open("../site/assessing/html/" + filename,"w")
            fjson = open("../site/assessing/html/" + jsonfilename,"w")
        else :
            f = open("../site/html/" + filename,"w")
            fjson = open("../site/html/" + jsonfilename,"w")
        #f = open(filename,"w")

        self.options['page-html'] = PYTHON_TUTOR_HTML % self.options

        f.write(self.options['page-html'])
        fjson.write(self.options['trace'])
        f.flush()
        fjson.flush()
        f.close()
        fjson.close()


        testScope = True
        if testScope :
            node = scope(self.options)
            node.html_begin  = SCOPE_HTML_BEGIN
            node.html_end    = SCOPE_HTML_END

            return [node]
        else :
            return []
#-----------------------------------------------------
