function require_error(error) {
    console.error('ERROR: ', error.requireType); 
    console.error('MODULES: ', error.requireModules);
    var msg = 'Modules : ' + error.requireModules + '\n';
    msg += 'Error : ' + error.requireType + '\n\n';
    msg += 'Try to reload the page.\n';
    alert(msg);        
}

require.config({ 
    baseUrl: '_static/enibook/js/',
    paths: { 
    'jquery'                        : 'jquery.min',
    'jquery-ui'                     : 'jquery-ui.min',
    'jquery-touch'                  : 'jquery.ui.touch-punch.min',
    'jquery-mobile'                 : 'jquery.mobile-1.4.5.min',
    'jquery-basictable'             : 'jquery.basictable.min',
    'codemirror'                    : 'codemirror',
    'codemirror-clike'              : 'mode/clike/clike',
    'codemirror-prolog'             : 'mode/prolog/prolog',
    'codemirror-prolog-ctype'       : 'mode/prolog/prolog-ctype',
    'codemirror-python'             : 'mode/python/python',
    'codemirror-rst'                : 'mode/rst/rst',
    'codemirror-sql'                : 'mode/sql/sql',
    'codemirror-xml'                : 'mode/xml/xml',
    'codemirror-javascript'         : 'mode/javascript/javascript',
    'codemirror-css'                : 'mode/css/css',
    'codemirror-htmlmixed'          : 'mode/htmlmixed/htmlmixed',
    'codemirror-placeholder'        : 'addon/display/placeholder',
    'codemirror-fullscreen'         : 'addon/display/fullscreen',
    'codemirror-xml-fold'           : 'addon/fold/xml-fold',
    'codemirror-matchbrackets'      : 'addon/edit/matchbrackets',
    'codemirror-matchtags'          : 'addon/edit/matchtags',
    'codemirror-overlay'            : 'addon/mode/overlay',
    'codemirror-search'             : 'addon/search/search',
    'codemirror-searchcursor'       : 'addon/search/searchcursor',
    'codemirror-match-highlighter'  : 'addon/search/match-highlighter',
    'codemirror-active-line'        : 'addon/selection/active-line',
    'codemirror-mark-selection'     : 'addon/selection/mark-selection',
    'codemirror-dialog'             : 'addon/dialog/dialog',
    'skulpt'                        : 'language/python/skulpt.min',
    'skulpt-stdlib'                 : 'language/python/skulpt-stdlib',
    'sqlite'                        : 'language/sql/sql',
    'go'                            : 'go-debug',
    'PortShiftingTool'              : 'PortShiftingTool',
    'md5'                           : 'md5.min',
    'katex'                         : '../../katex/js/katex.min',
    'katex-auto-render'             : '../../katex/js/auto-render.min',
    'prolog'                        : 'language/prolog/tau-prolog',
    'prolog-stdio'                  : 'language/prolog/tau-prolog-stdio',
    'enibook'                       : 'enibook',
    'enibook-base'                  : 'enibook-base',
    'enibook-config'                : 'enibook-config',
    'enibook-specific'              : '../../enibook-specific'
    },
    shim: {
        'enibook': { deps: ['jquery-ui','jquery-touch','jquery-mobile','jquery-basictable','katex','katex-auto-render','codemirror','md5','enibook-specific'] },
        'enibook-config':{ deps: ['enibook'] },
        'codemirror-search': { deps: ['codemirror-dialog','codemirror-searchcursor'] },
        'codemirror-matchtags': { deps: ['codemirror-xml-fold'] },
        'skulpt-stdlib': { deps: ['skulpt'], exports: 'Sk' },
        'PortShiftingTool' : { deps: ['go'] },
        'prolog-stdio' : { deps: ['prolog'] }
    }
}); 

// Hash function
require(['md5'], 
    function( MD5 ) { md5 = MD5; console.log('cryptographic hash function (md5) loaded'); },
    function (error) { require_error(error); }
);
// Math in LaTeX
require(['katex','katex-auto-render'],
    function(Katex,KatexDom) {        
        katex = Katex;
        katexDom = KatexDom;
        console.log('math interpreter (katex) loaded'); 
    },
    function (error) { require_error(error); }
);
// Text editor
require(['codemirror'],
    function( cm ) { 
        CodeMirror = cm; 
        require(['codemirror-prolog','codemirror-python','codemirror-sql','codemirror-xml','codemirror-overlay','codemirror-xml-fold',
                'codemirror-javascript','codemirror-css','codemirror-htmlmixed','codemirror-placeholder',
                'codemirror-dialog','codemirror-mark-selection','codemirror-active-line','codemirror-matchbrackets',
                'codemirror-match-highlighter','codemirror-searchcursor','codemirror-search','codemirror-matchtags']); 
        console.log('text editor (codemirror) loaded');
    },
    function (error) { require_error(error); }
);
// Graph editor
require(['go'],
    function( go ) { require(['PortShiftingTool']); console.log('graph editor (go) loaded'); },
    function (error) { require_error(error); }
);
