# -*- coding: utf-8 -*-

# assessing.py

__author__ = 'jacques.tisseau@enib.fr'

from docutils import io, nodes, statemachine, utils
from docutils.parsers.rst import Directive
from docutils.parsers.rst import directives, roles

from enibook import EniBook
from coderun import *
import os, os.path
#------------------------------------------------------------------------------
# Save
#------------------------------------------------------------------------------
SAVE_HTML_BEGIN = u"""
<!-- begin %(id)s -->
<div id="%(id)s" name="%(name)s" class="save %(class)s-save"
    file="%(file)s" note="%(note)s" valid="%(valid)s"
    directive="%(directive)s" modeEnibook="%(modeEnibook)s" typeEnibook="%(typeEnibook)s">
        <table>
            <tr>
                <td id="%(id)s-mode" colspan=3 style="text-align: center; font-weight: bold; font-size: 150%%"></td>
            </tr>
            <tr>
                <td>
                <table id="%(id)s-replay" name="%(name)s-replay"
                    onclick="EniBook['%(id)s'].loadConfigFile();"
                    style="background-color: rgba(234,138,0,0.2); display: table;">
                    <tr>
                        <td style="text-align: center;">
                            <span class="btn glyphicons glyphicons-disk-open x3"
                                style="background-color: rgb(234,138,0); font-size: 750%%;">
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td style="text-align: center;">
                            <span id="%(id)s-load-label" style="font-variant: small-caps; font-size: 100%%;">Charger<br />sujet</span>
                        </td>
                    </tr>
                    <tr>
                        <td style="text-align: center;">
                            <span id='%(id)s-tries-replay' style="font-size: 80%%; color: blue;"></span>
                        </td>
                    </tr>
                </table>
                </td>
                <td>
                <table id="%(id)s-save" name="%(name)s-save"
                    onclick="EniBook['%(id)s'].feedback('%(file)s');"
                    style="background-color: rgba(234,138,0,0.2); display: table;">
                    <tr>
                        <td style="text-align: center;">
                            <span class="btn glyphicons glyphicons-disk-save x3"
                                style="background-color: rgb(234,138,0); font-size: 750%%;">
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td style="text-align: center;">
                            <span id="%(id)s-save-label" style="font-variant: small-caps; font-size: 100%%;">Sauvegarder<br />copie</span>
                        </td>
                    </tr>
                    <tr>
                        <td style="text-align: center;">
                            <span id='%(id)s-tries' style="font-size: 80%%; color: blue;"></span>
                        </td>
                    </tr>
                </table>
                </td>

                <td>
                <table id="%(id)s-replay-html" name="%(name)s-replay-html"
                    onclick="EniBook['%(id)s'].toHtml();"
                    style="background-color: rgba(234,138,0,0.2); display: table;">
                    <tr>
                        <td style="text-align: center;">
                            <span class="btn glyphicons glyphicons-disk-save x3"
                                style="background-color: rgb(234,138,0); font-size: 750%%;">
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td style="text-align: center;">
                            <span  id="%(id)s-save-html-label"style="font-variant: small-caps; font-size: 100%%;">Sauvegarder<br />copie corrigée</span>
                        </td>
                    </tr>
                    <tr>
                        <td style="text-align: center;">
                            <span id='%(id)s-tries-replay-html' style="font-size: 80%%; color: blue;"></span>
                        </td>
                    </tr>
                </table>
                </td>


            </tr>
        </table>
        <span id="%(id)s-save-date" name="%(id)s-save-date" style="color: blue;"></span>
        <span id="%(id)s-save-filename" name="%(id)s-save-filename"></span>
        <div  id="%(id)s-save-feedback" name="%(name)s-save-feedback"
            class="save-feedback user-class-save-feedback">
            <table width='100%%'>
                <tr>
                    <td>
                        <table>
                            <tr>
                                <td style="font-weight: bold;">Etablissement</td>
                                <td><table><tr><td>%(institute)s</td><td>&nbsp;</td><td><img src="%(logo)s" alt="logo" style="height:60px"></td></tr></table></td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">Matière</td>
                                <td>%(field)s</td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">Objectif</td>
                                <td>%(objective)s</td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">Contrôle</td>
                                <td>%(type)s</td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">Date</td>
                                <td id="%(id)s-save-feedback-date">Date du contrôle</td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">Nom</td>
                                <td id="%(id)s-save-feedback-student">NOM Prénom</td>
                            </tr>
                        </table>
                    </td>
                    <td style="text-align: right;">
                        <table id="%(id)s-table-evaluation">
                            <tr>
                                <td style="font-weight: bold;">Evaluation</td><td>&nbsp;</td>
                                <td>
                                    <input id="%(id)s-table-evaluation-evaluation" type='text' size='3' placeholder='0' value=''></input>
                                </td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">Validation</td><td>&nbsp;</td>
                                <td id="%(id)s-table-evaluation-validation">
                                    <select>
                                        <option value="-----" selected="selected">-----</option>
                                        <option value="oui">Oui</option>
                                        <option value="non">Non</option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">Date</td><td>&nbsp;</td>
                                <td><span id="%(id)s-table-evaluation-date">Date de l'évaluation</span></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
            <div id="%(id)s-save-feedback-transit" name="%(id)s-save-feedback-transit"></div>
            <div id="%(id)s-save-feedback-notes" name="%(id)s-save-feedback-notes"></div>
            <div id="%(id)s-save-feedback-comments" name="%(id)s-save-feedback-comments"></div>
</div>
"""

SAVE_HTML_END = u"""
<!-- end %(id)s -->
<script type="text/javascript">
    EniBook.init.push( function() { EniBook["%(id)s"] = new Save('%(id)s'); } );
</script>
"""

SAVE_PYTHON_CONFIG = u"""
pyEniBook['assessing']['code-run']['%(id)s'] = {
    'title'     : u"%(title)s",
    'questions' : 1,
    'choices'   : 1,
    'items'     : [],
    'user'      : ""
}
"""

SAVE_HTML_PREFIX = r"""
<!DOCTYPE html>
<html class="ui-mobile">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <link rel="stylesheet" href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/9.8.0/styles/default.min.css">
    <style type="text/css">body {color: black; font-size: 16px; font-weight: normal; display: block; margin: 0px; padding-left: 20px; padding-right: 20px; z-index: -10; }</style>
    <style type="text/css">.save-feedback {border: 1px solid rgb(234,138,0); border-radius: 6px; padding: 5px;}</style>

    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
    <script type="text/javascript" src="https://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS_HTML-full"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/9.8.0/highlight.min.js"></script>
</head>
<body>
"""

SAVE_HTML_SUFFIX = r"""
</body>
</html>
"""

SAVE_LATEX_BEGIN = u"""
"""

SAVE_LATEX_END = u"""
"""
#------------------------------------------------------------------------------
class save(nodes.General, nodes.Element):
    def __init__(self,options):
        super(save,self).__init__()
        self.options = options

def visit_html_save(self, node):
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_save(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_save(self, node):
    pass

def depart_latex_save(self,node):
    pass
#-----------------------------------------------------
def noteEval(argument):
    return directives.choice(argument, ("avg","sum","min","max"))

class Save(EniBook):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        "class"     : directives.class_option,
        "name"      : directives.unchanged,
        "file"      : directives.path,
        "field"     : directives.unchanged,
        "objective" : directives.unchanged,
        "type"      : directives.unchanged,
        "institute" : directives.unchanged,
        "logo"      : directives.path,
        "note"      : noteEval,
        "valid"     : directives.unchanged
    }
	
    def run(self) :
        super(Save,self).run()

        if 'file' not in self.options :
            self.options['file'] = 'enibook-config.json'
        
        if 'field' not in self.options :
            self.options['field'] = ''
        if 'objective' not in self.options :
            self.options['objective'] = ''
        if 'type' not in self.options :
            self.options['type'] = ''
        if 'logo' not in self.options :
            self.options['logo'] = ''
        if 'institute' not in self.options :
            self.options['institute'] = ''
        if 'note' not in self.options :
            self.options['note'] = ''
        if 'valid' not in self.options :
            self.options['valid'] = ''

        
        node = save(self.options)
        node.html_begin  = SAVE_HTML_BEGIN
        node.html_end    = SAVE_HTML_END
        node.latex_begin = SAVE_LATEX_BEGIN
        node.latex_end   = SAVE_LATEX_END

        #self.state.nested_parse(self.content, self.content_offset, node)
        
        comment = """

        options = {}
        options['id']          = self.options['id'] + '-comment'
        options['name']        = self.options['name']
        options['class']       = self.options['class']
        options['file']        = options['id'] + ".html"
        options['filename']    = os.path.basename(options['file'])
        options['remarks']     = 'false'
        options['language']    = "html"
        options['site']        = language_site[options['language']]
        options['mime']        = language_mime[options['language']]
        options['extension']   = language_extension[options['language']]
        options['javascript-object'] = language_javascript[options['language']]
        options['directive']   = 'code-run'
        options['execlimit']   = 5 # secondes
        options['tabsize']     = 4
        options['rows']        = 10
        options['collapse']    = 'false'
        options['linenumbers'] = 'true'
        options['firstline']   = 1
        options['keymap']      = 'default'
        options['theme']       = 'default'
        if self.content : 
            options['initialcode'] = '\n'.join(self.content)
        else : 
            options['initialcode'] = ''
        options['prefix']      = SAVE_HTML_PREFIX
        options['suffix']      = SAVE_HTML_SUFFIX
        options['comment']     = []
        options['modeEnibook'] = self.options['modeEnibook']
        options['typeEnibook'] = self.options['typeEnibook']
        options['title']       = 'Commentaires'

        commentnode = run(options)
        commentnode.html_begin  = RUN_HTML_BEGIN
        commentnode.html_begin += EDIT_HELP_HTML
        commentnode.html_end    = RUN_HTML_END

        if self.options['modeEnibook'] != "learning" and os.path.exists("pyenibook.cfg") :
            file = open("pyenibook.cfg","a")
            txt = SAVE_PYTHON_CONFIG % options
            txt = txt.encode("utf8")
            file.write(txt)
            file.close()

        if self.options['modeEnibook'] == 'training' :
            return [node,commentnode]
        else :
            return [node]

        """
        return [node]


