# -*- coding: utf-8 -*-
from __future__ import unicode_literals

# roles.py

__author__ = 'jacques.tisseau@enib.fr'

import os, os.path

from docutils import io, nodes, statemachine, utils
from docutils.parsers.rst import Directive
from docutils.parsers.rst import directives, roles

from enibook import EniBook

function_role_num = 0


#------------------------------------------------------------------------------
# template
#------------------------------------------------------------------------------
TEMPLATE_HTML = u"""<span class="template">%(template)s</span>"""

def template_function_role(role, rawtext, text, lineno, inliner, options={}, content=[]):
    res = TEMPLATE_HTML % {'template': text}
    return [nodes.raw('',res,format='html')], []
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# ln
#------------------------------------------------------------------------------
LN_HTML = u"""<a href='%(link)s' style="font-weight: normal;" target=%(target)s>%(title)s</a>"""

def ln_function_role(role, rawtext, text, lineno, inliner, options={}, content=[]):
    index = text.find('<')
    link = text[index+1:len(text)-1]
    if index > 0:
        title = text[:index-1]
    else:
        title = link
    if "target" in options : 
        target = options["target"]
    else : 
        target = "_blank"

    res = LN_HTML % {'link': link, 'title': title, 'target': target}
    return [nodes.raw('',res,format='html')], []

ln_function_role.options = {"target" : directives.unchanged}
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# text
#------------------------------------------------------------------------------
TEXT_HTML = u"""<span style="%(style)s">%(title)s</span>"""

def text_function_role(role, rawtext, text, lineno, inliner, options={}, content=[]):
    index = text.find("<")
    if index > 0:
        title = text[:index-1]
        style = text[index+1:len(text)-1]
    else:
        title = text
        if "style" in options : style = options["style"]
        else : style = ""
    res = TEXT_HTML % {"style": style, "title": title}
    return [nodes.raw('',res,format='html')], []
    
text_function_role.options = {"style" : directives.unchanged}
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# solution
#------------------------------------------------------------------------------
SOLUTION_HTML = u"""<span class="highlight">%(title)s</span>"""

def solution_function_role(role, rawtext, text, lineno, inliner, options={}, content=[]):
    res = SOLUTION_HTML % {"title": text}
    return [nodes.raw('',res,format='html')], []
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# input
#------------------------------------------------------------------------------
ROLE_INPUT_HTML = u"""
<!-- début %(id)s -->
    <span id="%(id)s-input-block" name="%(name)s-input-block"
        class="role-input-block %(class)s-role-input-block" 
        directive="%(directive)s" title="%(title)s"
        solution="%(solution)s" re="%(re)s" answer="%(answer)s" question="%(question)s"       
        nbtry="%(nbtry)s" success="undefined" hint="%(hint)s"
        feedbacktrue="%(feedbacktrue)s" feedbackfalse="%(feedbackfalse)s">
        <span style="display: inline-block; position: relative;">
            <input type="%(type)s" id="%(id)s-input" name="%(name)s-input" value=""
                class="input %(class)s-input" title="%(title)s"
                placeholder="%(placeholder)s"  size="%(size)s" data-role="none"
                ondblclick="EniBook['%(id)s'].hint();"
                onkeypress="EniBook['%(id)s'].keypress(event);">
            <span class="input-remove %(class)s-input-remove btn glyphicons glyphicons-circle-remove" 
                onclick="EniBook['%(id)s'].update();"></span>
        </span>
        <span id="%(id)s-hints" name="%(name)s-hints" 
            class="hints %(class)s-hints" onclick="EniBook['%(id)s'].hint();">?</span>
        <span id="%(id)s-roleinput-btns" 
            data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
            <button class='btn' id="%(id)s-roleinput-btn" 
                style="background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2);"
                title="analyser la réponse"
                onclick="EniBook['%(id)s'].feedback();"><span class="glyphicons glyphicons-play" style="color: rgb(162,169,63);"></span></button>
        </span>
        <span id="%(id)s-input-feedback"></span>
    </span>
<!-- fin %(id)s -->
<script type="text/javascript">
    //$(document).ready( function() { EniBook.init.push( function() { EniBook["%(id)s"] = new RoleInput("%(id)s"); }) });
    EniBook.init.push( function() { EniBook["%(id)s"] = new RoleInput("%(id)s"); } );
</script>
"""

ROLEINPUT_PYTHON_CONFIG = u"""
pyEniBook['assessing']['%(directive)s']['%(id)s'] = {
    'title'     : u"%(title)s",
    'questions' : 1,
    'choices'   : 1,
    'items'     : [],
    'user'      : ""
}
"""

def roleinputtype(argument) :
    return directives.choice(argument, ("text", "number", "range"))

def input_function_role(role, rawtext, text, lineno, inliner, options={}, content=[]):
    global function_role_num

    function_role_num += 1
    options = {}
    options["directive"] = "roleinput"
    options["id"] = options["directive"] + str(function_role_num)

    env = inliner.document.settings.env
    options['timeversion'] = env.config.timeversion
    options['modeEnibook'] = env.config.modeEnibook
    options['typeEnibook'] = env.config.typeEnibook

    index = text.find("<")
    if index > 0:
        arg  = text[:index-1]
        opts = text[index+1:len(text)-1].split(";")
        for opt in opts :
            [key,value] = opt.split(":",1)
            options[key.strip()] = value.strip()
    else:
        arg = text

    if options['modeEnibook'] != "assessing" : 
        if arg[0] == "/" :
            options["re"]       = arg
            options["solution"] = ""
        else :
            options["re"]       = ""
            options["solution"] = arg
    else :
        options["re"]       = ""
        options["solution"] = ""

    if "class" not in options :
        options["class"] = "user-class"    
    if "name" not in options :
        options["name"] = options["id"]  
    if "title" not in options :
        options["title"] = options["id"]  
    if "type" not in options : 
        options["type"] = "text"
    if "placeholder" not in options : 
        options["placeholder"] = u"réponse attendue"
    if "size" not in options : 
        options["size"] = str(max(10,len(options["solution"]),len(options["placeholder"])) + 2)
    if "hint" not in options :
        options["hint"] = ""
    if "nbtry" not in options :
        options["nbtry"] = 0
    if "feedbacktrue" not in options :
        options["feedbacktrue"] = ""
    if "feedbackfalse" not in options :
        options["feedbackfalse"] = ""
    options["answer"]   = "undefined"
    options["question"] = "undefined"

    if options['modeEnibook'] != "learning" and os.path.exists("pyenibook.cfg") :
        file = open("pyenibook.cfg","a")
        txt = ROLEINPUT_PYTHON_CONFIG % options
        txt = txt.encode("utf8")
        file.write(txt)
        file.close()

    res = ROLE_INPUT_HTML % options
    return [nodes.raw('',res,format='html')], []
    
input_function_role.options = { 
    "class"       : directives.class_option,
    "name"        : directives.unchanged,
    "placeholder" : directives.unchanged,
    "title"       : directives.unchanged,
    "size"        : directives.positive_int,
    "nbtry"       : directives.nonnegative_int
}

#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# img
#------------------------------------------------------------------------------
IMG_HTML = u"""<img src="_static/_images/%(file)s" alt="%(file)s"></img>"""

def img_function_role(role, rawtext, text, lineno, inliner, options={}, content=[]):
    res = IMG_HTML % {'file' : text}
    return [nodes.raw('',res,format='html')], []
#------------------------------------------------------------------------------

