#!/usr/bin/python
# -*- coding: utf-8 -*-

__author__ = 'jacques.tisseau@enib.fr'

import copy, random, json, os, sys, md5, time

#-------------------------------------------------------------------------------
def generateConfig(dico) :
    if 'assessing' in dico :
        items = dico['assessing'].items()
        for item in items :
            tool = item[0]
            if type(item[1]) is dict :
                values = item[1].values()
                keys = item[1].keys()
                keys.sort()
                for val in values :
                    t = range(val['questions'])
                    if 'norandom' in val.keys() :
                        if val['norandom'] != 'true' : random.shuffle(t)
                    else : 
                        random.shuffle(t)
                    val['items'] = t
    return

#-------------------------------------------------------------------------------
def saveConfig(filename,dico,enibook3,timeversion,replay=False) :
    f = open(filename,'w')
    txt = 'EniBook.config = '
    if 'assessing' in dico :
        enibook1 = "".join([chr(random.randint(33,127)) for x in range(16)]).encode("hex")
        dico['assessing']['enibook1'] = enibook1
        dico['assessing']['enibook2'] = md5.new(enibook1+enibook3).hexdigest()
        dico['assessing']['save'] = 'false'
        dico['assessing']['config'] = filename
        dico['assessing']['date'] = u"Date du contrôle"
        dico['assessing']['student'] = u"NOM Prénom"
        dico['assessing']['timeversion'] = timeversion
        if replay : 
            dico['assessing']['save'] = 'true'
            dico['assessing']['enibook3'] = enibook3
        txt += json.dumps(dico['assessing'], sort_keys=True, encoding="utf-8", separators=(',', ': '))  
    else :
        txt += '{}'
    txt += ';'
    f.write(txt)
    f.close()
    return

#-------------------------------------------------------------------------------
def saveConfigJson(filename,dico,enibook3,timeversion,replay=False) :
    f = open(filename,'w')
    txt = ''
    if 'assessing' in dico :
        enibook1 = "".join([chr(random.randint(33,127)) for x in range(16)]).encode("hex")
        dico['assessing']['enibook1'] = enibook1
        dico['assessing']['enibook2'] = md5.new(enibook1+enibook3).hexdigest()
        dico['assessing']['save'] = 'false'
        dico['assessing']['config'] = filename
        dico['assessing']['timeversion'] = timeversion
        if replay : 
            dico['assessing']['save'] = 'true'
            dico['assessing']['enibook3'] = enibook3
        txt += json.dumps(dico['assessing'], sort_keys=True, encoding="utf-8", separators=(',', ': '))  
    else :
        txt += '{}'
    txt += ''
    f.write(txt)
    f.close()
    return

#-------------------------------------------------------------------------------
pyEniBook = { 
    'assessing':  
        { 
        'container'     : {},
        'mcq'           : {},
        'q-mcq'         : {},
        'exercise'      : {},
        'question'      : {},
        'multisort'     : {},
        'sort'          : {},
        'code-run'      : {},
        'input'         : {},
        'inputlines'    : {},
        'roleinput'     : {},
        'graph'         : {},
        'save'          : "false",
        'eval'          : "",
        'valid'         : "-----",
        'date'          : u"Date du contrôle",
        'student'       : u"NOM Prénom",
        'config'        : "undefined",
        'subject'       : "undefined",
        'answer'        : "undefined",
        'globalcomment' : '',
        'timeversion'   : "undefined"
        } 
}

enibook3 = "Enactive Numerical Intelligent Book for Open Online Knowledge"

#-------------------------------------------------------------------------------
if len(sys.argv) != 3 :
    print "usage: makeConfig.py assessing|replay timeversion"
    exit(1)
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
mode = sys.argv[1]
timeversion = sys.argv[2]
if mode not in ['assessing','replay'] :
    print "usage: makeConfig.py assessing|replay timeversion"
    exit(2)
#-------------------------------------------------------------------------------

if mode == 'replay' : 
    replay = True
    assessing = False
    directory = "../site/replay/html/_static/enibook/js/"
else : 
    replay = False
    assessing = True
    directory = "../site/assessing/html/_static/enibook/js/"

#-------------------------------------------------------------------------------
if not os.path.exists("pyenibook.cfg") :
    print "pyenibook.cfg not found in", os.getcwd()
    exit(3)
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
execfile('pyenibook.cfg')
pyenibook_replay = copy.deepcopy(pyEniBook)
            
generateConfig(pyEniBook)
saveConfig(directory + 'enibook-config.js',pyEniBook,enibook3,timeversion,replay)

if replay == False :
    os.mkdir("../site/assessing/config/")
    print '\tSaving config files (site/assessing/config)',
    for grp in range(1,9) :
        os.mkdir("../site/assessing/config/" + str(grp))
        for i in range(30) :
            n = '%03d' % (i)
            pyEniBook = copy.deepcopy(pyenibook_replay)
            generateConfig(pyEniBook)
            saveConfigJson('../site/assessing/config/' + str(grp) + '/' + n + '-enibook-config.json',pyEniBook,enibook3,timeversion,replay)
    print '... done'
#-------------------------------------------------------------------------------
