# -*- coding: utf-8 -*-

# petri.py

__author__ = 'jacques.tisseau@enib.fr'

from docutils import io, nodes, statemachine, utils
from docutils.parsers.rst import Directive
from docutils.parsers.rst import directives, roles

from enibook import EniBook

#------------------------------------------------------------------------------
# Petri
#------------------------------------------------------------------------------
PETRI_HTML_BEGIN = u"""
<div id="%(id)s-petri" name="%(name)s-petri" 
    class="diagram %(class)s-diagram" directive="%(directive)s"
    type="%(type)s" file="%(file)s" version="%(version)s">
    <table width=100%% data-role="table" class="ui-responsive">
        <thead>
            <th width=15%%>Composants</th>
            <th width=85%%>
                <span class="btn btn-warning glyphicons glyphicons-flowchart"
                onclick="EniBook['%(id)s'].showPalette();"></span> Réseau de Petri : 
                <span id="%(id)s-petri-file" name="%(name)s-petri-file" 
                    class="diagram-file %(class)s-diagram-file">%(file)s</span></th>
        </thead>
        <tbody>
            <tr>
                <td>
                    <div id="%(id)s-petri-palette" name="%(name)s-petri-palette"
                        class="petri-palette %(class)s-petri-palette" 
                        style="height:500px;">
                        <h4>Entrées/Sorties</h4>
                        <div>
                            <div id="%(id)s-petri-palette-0" name="%(name)s-petri-palette-1"
                                style="min-height: 290px;"></div>
                        </div>
                    </div>
                </td>
                <td>
                    <div id="%(id)s-petri-diagram" name="%(name)s-petri-diagram"
                        class="petri-diagram %(class)s-petri-diagram" 
                        style="height:500px; border:1px solid green;"></div>
                </td>
            </tr>
        </tbody>
    </table>
    <table width=100%% data-role="table" class="ui-responsive">
        <thead>
            <th width=15%%>Vue d'ensemble</td>
            <th width=85%%>
                <span id="%(id)s-file-btns"
                      data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
                    <button class='btn btn-info' id='%(id)s-file-btn-reset' style='background-color : rgb(144,209,223);'
                        title="initialiser le petrime"
                        command="<kbd>Ctrl+N</kbd>"
                        icone="<span class='glyphicons glyphicons-refresh'></span>"
                        longtitle="initialiser l'éditeur"
                        onclick="EniBook['%(id)s'].new();"><span class='glyphicons glyphicons-refresh'></span></button>
                    <button class='btn btn-info' id="%(id)s-file-btn-download"  style='background-color : rgb(144,209,223);'  
                        title="charger un petrime au format JSON"
                        command="<kbd>Ctrl+O</kbd>"
                        icone="<span class='glyphicons glyphicons-disk-open'></span>"
                        longtitle="copier le contenu d'un fichier dans l'éditeur"
                        onclick="EniBook['%(id)s'].openJSON();"><span class='glyphicons glyphicons-disk-open'></span></button>
                    <button class='btn btn-info' id="%(id)s-file-btn-upload"  style='background-color : rgb(144,209,223);' 
                        title="sauvegarder le petrime au format JSON"
                        command="<kbd>Ctrl+S</kbd>"
                        icone="<span class='glyphicons glyphicons-disk-save'>"
                        longtitle="sauvegarder le contenu de l'éditeur dans un fichier"
                        onclick="EniBook['%(id)s'].saveJSON();"><span class='glyphicons glyphicons-disk-save'></span></button>
                    <button class='btn btn-info' id="%(id)s-file-btn-print"  style='background-color : rgb(144,209,223);' 
                        title="imprimer le petrime"
                        command="<kbd>Ctrl+P</kbd>"
                        icone="<span class='glyphicons glyphicons-print'></span>"
                        longtitle="imprimer le contenu de l'éditeur"
                        onclick="EniBook['%(id)s'].print();"><span class='glyphicons glyphicons-print'></span></button>
                </span>
                <span id="%(id)s-run-btns"
                      data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
                    <button class='btn btn-warning' id='%(id)s-file-btn-grid' style='background-color : rgb(234,138,0);'
                        title="grille"
                        command="<kbd>Ctrl+N</kbd>"
                        icone="<span class='glyphicons glyphicons-stats'></span>"
                        longtitle="grille"
                        onclick="EniBook['%(id)s'].gridToggle();"><span class='btn-warning glyphicons glyphicons-stats'></span></button>
                    <button class='btn btn-warning' id="%(id)s-file-btn-upload"  style='background-color : rgb(234,138,0);' 
                        title="sauvegarder le petrime au format SVG"
                        command="<kbd>Ctrl+S</kbd>"
                        icone="<span class='glyphicons glyphicons-disk-saveSVG'>"
                        longtitle="sauvegarder le contenu de l'éditeur dans un fichier"
                        onclick="EniBook['%(id)s'].saveSVG();"><span class='glyphicons glyphicons-disk-save'></span></button>
                    <button class='btn btn-warning' id="%(id)s-file-btn-upload"  style='background-color : rgb(234,138,0);' 
                        title="sauvegarder le petrime au format PNG"
                        command="<kbd>Ctrl+S</kbd>"
                        icone="<span class='glyphicons glyphicons-disk-save'>"
                        longtitle="sauvegarder le contenu de l'éditeur dans un fichier"
                        onclick="EniBook['%(id)s'].savePNG();"><span class='glyphicons glyphicons-screenshot'></span></button>
                    <button class='btn btn-success' id="%(id)s-file-btn-download" style='background-color : #5C885C;'  
                        title="analyser le petrime"
                        command="<kbd>Ctrl+O</kbd>"
                        icone="<span class='glyphicons glyphicons-play'></span>"
                        longtitle="vérification"
                        onclick="EniBook['%(id)s'].feedback();"><span class='glyphicons glyphicons-play'></span></button>
                </span>
            </th>
        </thead>
        <tbody>
            <tr>
                <td valign="top">
                    <div id="%(id)s-petri-overview" name="%(name)s-petri-overview"
                        class="petri-overview %(class)s-petri-overview" 
                        style="height:150px; border:1px solid blue;">
                    </div>
                </td>
                <td valign="top">
                    <textarea id="%(id)s-petri-code" name="%(name)s-petri-code"
                        style="display:none;" placeholder="code JSON">%(code)s</textarea>
                    <div id="%(id)s-petri-feedback" name="%(name)s-petri-feedback"
                        class="petri-feedback %(class)s-petri-feedback"></div>
                </td>
            </tr>
        </tbody>
    </table>
"""

PETRI_HTML_END = u"""
</div>
<script type="text/javascript">
    $(document).ready( function() { EniBook["%(id)s"] = Petri("%(id)s"); } );
</script>
"""

PETRI_LATEX_BEGIN = u"""
"""

PETRI_LATEX_END = u"""
"""

#------------------------------------------------------------------------------
class petri(nodes.General, nodes.Element):
    def __init__(self,options):
        super(petri,self).__init__()
        self.options = options

def visit_html_petri(self, node):
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_petri(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_petri(self, node):
    pass
def depart_latex_petri(self,node):
    pass
#-----------------------------------------------------
def versiondiagram(argument) :
    return directives.choice(argument, ("full","light"))

def typediagram(argument) :
    return directives.choice(argument, 
        ("analogic","grafcet","logic","mindmap","petri","uml"))

class Petri(EniBook):
    required_arguments = 1
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'class'   : directives.class_option,
        'name'    : directives.unchanged,
        'file'    : directives.path,
        'version' : versiondiagram
    }

    def run(self):
        super(Petri,self).run()
        
        if typediagram(self.arguments[0]) :
            self.options['type'] = self.arguments[0]

        if 'version' not in self.options :
            self.options['version'] = 'full'

        if 'file' not in self.options :
            self.options['file'] = '' 

        if self.options['file'] != '' :
            text = self.include(self.options['file'])
            self.options['code'] = text
        else :
            self.options['code'] = ''

        node = petri(self.options)
        node.html_begin  = PETRI_HTML_BEGIN
        node.html_end    = PETRI_HTML_END
        node.latex_begin = PETRI_LATEX_BEGIN
        node.latex_end   = PETRI_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)
        return [node]
#------------------------------------------------------------------------------

