# -*- coding: utf-8 -*-
from __future__ import unicode_literals

# code-run.py

__author__ = 'jacques.tisseau@enib.fr'


from docutils import io, nodes, statemachine, utils
from docutils.parsers.rst import Directive
from docutils.parsers.rst import directives, roles

from enibook import EniBook
from block import *

#------------------------------------------------------------------------------
# Run
#------------------------------------------------------------------------------
RUN_HTML_BEGIN = u"""
<!-- begin %(id)s -->
<div class="edit-language-editor %(class)s-edit-language-editor" 
    id="%(id)s-edit-language-editor" name="%(name)s-edit-language-editor"
    collapse="%(collapse)s">
    <span class="btn btn-warning glyphicons glyphicons-edit"
        id="%(id)s-edit-language-editor-btn" name="%(id)s-edit-language-editor-btn"
        onclick="EniBook['%(id)s'].collapse();"></span>
    <span id="%(id)s-edit-lang" name="%(name)s-edit-lang" 
        class="edit-lang %(class)s-edit-lang">%(language)s</span> : 
    <span id="%(id)s-edit-file" name="%(name)s-edit-file" 
        class="edit-file %(class)s-edit-file">%(filename)s</span>
</div>
<div id="%(id)s-run-block" name="%(name)s-run-block" collapse="%(collapse)s"
    class="run run-block %(class)s-run-block"
    execlimit="%(execlimit)s"  title="%(title)s"
    directive="%(directive)s" typeEnibook="%(typeEnibook)s" modeEnibook="%(modeEnibook)s">
    <div class="edit-block %(class)s-edit-block" id="%(id)s-edit-block">
        <span id="%(id)s-btns" name="%(name)s-btns">
            <span id="%(id)s-file-btns"
                  data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
                <button class='btn btn-warning' id='%(id)s-file-btn-reset'   style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'
                    title="nouveau fichier"
                    onclick="EniBook['%(id)s'].newFile();"><span class='glyphicons glyphicons-refresh' style='color:rgb(234,138,0);'></span></button>
                <button class='btn btn-warning' id="%(id)s-file-btn-download"  style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'  
                    title="ouvrir fichier"
                    onclick="EniBook['%(id)s'].openFile();"><span class='glyphicons glyphicons-disk-open' style='color:rgb(234,138,0);'></span></button>
                <button class='btn btn-info' id="%(id)s-file-btn-upload"  style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);' 
                    title="sauvegarder éditeur"
                    onclick="EniBook['%(id)s'].saveFile();"><span class='glyphicons glyphicons-disk-save' style='color:rgb(234,138,0);'></span></button>
                <button class='btn btn-info' id="%(id)s-file-btn-print"  style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);' 
                    title="imprimer éditeur"
                    onclick="EniBook['%(id)s'].printEdit();"><span class='glyphicons glyphicons-print' style='color:rgb(234,138,0);'></span></button>
            </span>
            <span id="%(id)s-edit-btns"
                data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
                <button class='btn btn-default' id="%(id)s-edit-btn-undo" style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'
                    title="annuler"
                    onclick="EniBook['%(id)s'].edit.undo();"><span class='glyphicons glyphicons-undo' style='color:rgb(234,138,0);'></span></button>
                <button class='btn btn-default' id="%(id)s-edit-btn-redo"  style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);' 
                    title="rétablir"
                    onclick="EniBook['%(id)s'].edit.redo();"><span class='glyphicons glyphicons-redo' style='color:rgb(234,138,0);'></span></button>
                <button class='btn btn-default' id="%(id)s-search-btn-search"  style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'
                    title="rechercher"
                    onclick="EniBook['%(id)s'].edit.execCommand('find');"><span class='glyphicons glyphicons-search' style='color:rgb(234,138,0);'></span></button>
                <button class='btn btn-default' id="%(id)s-search-btn-replace" style="position: relative;   background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);"
                    title="remplacer"
                    onclick="EniBook['%(id)s'].edit.execCommand('replace');">
                    <span class='glyphicons glyphicons-search' style="color: white; position: absolute; top: 8px; z-index: 1"></span><span class='glyphicons glyphicons-pencil' style="z-index: 2; color:rgb(234,138,0);"></span></button>
            </span>
            <span id="%(id)s-zoom-btns"
                data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
                <!-- 
                <button class='btn btn-warning' id="%(id)s-display-btn-fullscreen" style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'
                    title="plein écran F11"
                    onclick="EniBook['%(id)s'].edit.setOption('fullScreen', !EniBook['%(id)s'].edit.getOption('fullScreen')); EniBook['%(id)s'].edit.focus();"><span class='glyphicons glyphicons-fit-image-to-frame' style='color:rgb(234,138,0);'></span></button>
                -->
                <button class='btn' id="%(id)s-display-btn-help"
                    style="background-color: rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);"
                    title="aide éditeur"
                    onclick="EniBook['%(id)s'].help();"><span class='glyphicons glyphicons-circle-question-mark' style='color:rgb(234,138,0);'></span></button>
            </span>
        </span>
    </div>
    <div class='edit %(class)s-edit' id='%(id)s-edit' name='%(name)s-edit'>
        <textarea id='%(id)s-prefix' name='%(name)s-prefix' style="display: none;">%(prefix)s</textarea>
        <textarea id='%(id)s' name='%(name)s-textarea' class="run-textarea %(class)s-run-textarea"
            language="%(language)s" placeholder='code « %(language)s »' rows="%(rows)s"
            extension="%(extension)s" mime="%(mime)s" site="%(site)s"
            keymap="%(keymap)s" theme="%(theme)s" file="%(filename)s" title="%(title)s"
            tabsize="%(tabsize)s" linenumbers="%(linenumbers)s" firstline="%(firstline)s">%(initialcode)s</textarea>
        <textarea id='%(id)s-suffix' name='%(name)s-suffix' style="display: none;">%(suffix)s</textarea>
    </div>
    <div class="edit-comment %(class)s-edit-comment" 
        id="%(id)s-edit-comment" name="%(name)s-edit-comment">
    </div>
    <pre id='%(id)s-pre-comment' name='%(name)s-pre-comment' style="display: none; color: blue;"></pre>
    <div id='%(id)s-input-output' name='%(id)s-input-output'>
        <div id='%(id)s-input' name='%(id)s-input' style='display:none; width:100%%; margin-bottom:5px;'>
            <span><b>%(prompt)s</b></span>
            <span style="display: inline-block; position: relative;">
                <input id="%(id)s-input-query" class="input-code-run" type="text" placeholder="Prolog query" size="80" 
                    onkeydown="EniBook['%(id)s'].processQuery(event);" data-role="none"></input>
                <span class="input-remove %(class)s-input-remove btn glyphicons glyphicons-circle-remove" 
                    onclick="EniBook['%(id)s'].clearInput();"></span>
            </span>
        </div>
        <div id='%(id)s-output' name='%(id)s-output'>
            <span><b>Output</b></span>
            <div style="min-height: 1em;">
                <pre class="run-pre" id="%(id)s-run-pre"></pre>
                <div class="run-div" id="%(id)s-run-div"></div>
                <div class="run-error %(class)s-run-error" id="%(id)s-run-error"></div>
                <div class="run-canvas" id="%(id)s-run-canvas"></div>
                <iframe class="run-iframe" id="%(id)s-run-iframe" name="%(name)s-run-iframe" src="" srcdoc="" width="99%%"></iframe>
            </div> 
        </div>
    </div>
    <span id="%(id)s-run-btns" 
        data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
        <button class='btn' id="%(id)s-init-btn" 
            style="background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2);"
            title="initialiser la sortie"
            onclick="EniBook['%(id)s'].clearOutput();"><span class="glyphicons glyphicons-refresh" style="color:rgb(162,169,63);"></span></button>
        <button class='btn' id="%(id)s-display-btn-keyboard"
            style="background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2);"
            title="documentation %(language)s"
            onclick="EniBook['%(id)s'].doc('%(language)s','%(site)s');"><span class='glyphicons glyphicons-circle-question-mark' style="color:rgb(162,169,63);"></span></button>
        <button class='btn' id="%(id)s-run-save-btn" 
            style="background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2); display: none;"
            title="sauvegarder la sortie"
            onclick="EniBook['%(id)s'].saveOutput();"><span class="glyphicons glyphicons-disk-save" style="color:rgb(162,169,63);"></span></button>
        <button class='btn' id="%(id)s-run-btn" 
            style="background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2);"
            title="interpréter le programme"
            onclick="EniBook['%(id)s'].feedback();"><span class="glyphicons glyphicons-play" style="color:rgb(162,169,63);"></span></button>
    </span>
    <span class="btn btn-warning glyphicons glyphicons-chevron-up" style="float: right; font-size: 90%%;"
        onclick="$.mobile.silentScroll($('#%(id)s-edit-language-editor').offset().top);"></span>
</div>
"""

EDIT_HELP_HTML = u"""
<div id="%(id)s-edit-help" name="%(name)s-edit-help" style="display: none;">
    <h4>Interpréteur</h4>
    <table data-role="table" class="ui-responsive ui-shadow">
        <thead><th>Menu</th><th>Action</th></thead>
        <tbody>
            <tr>
                <td><span class="btn btn-success glyphicons glyphicons-refresh" 
                          style="color: rgb(162,169,63); background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2);"></span></td>
                <td>Ré-initialiser les sorties</td>
            </tr>
            <tr>
                <td><span class="btn btn-success glyphicons glyphicons-circle-question-mark" 
                          style="color: rgb(162,169,63); background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2);"></span></td>
                <td>Faire apparaître le menu d'aide</td>
            </tr>
            <tr>
                <td><span class="btn btn-success glyphicons glyphicons-play" 
                          style="color: rgb(162,169,63); background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2);"></span></td>
                <td>Interpréter le programme</td>
            </tr>
        </tbody>
    </table>
    <h4>Editeur</h4>
    <table data-role="table" class="ui-responsive ui-shadow">
        <thead><th>Menu</th><th>Raccouci</th><th>Action</th></thead>
        <tbody>
            <tr>
                <td><span class='btn btn-info glyphicons glyphicons-refresh'
                           style='color: rgb(234,138,0); background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'></span></td>
                <td><kbd>Ctrl+N</kbd></td>
                <td>Initialiser l'éditeur</td>
            </tr>
            <tr>
                <td><span class='btn btn-info glyphicons glyphicons-disk-open'
                           style='color: rgb(234,138,0); background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'></span></td>
                <td><kbd>Ctrl+O</kbd></td>
                <td>Charger le contenu d'un fichier dans l'éditeur</td>
            </tr>
            <tr>
                <td><span class='btn btn-info glyphicons glyphicons-disk-save'
                           style='color: rgb(234,138,0); background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'></span></td>
                <td><kbd>Ctrl+S</kbd></td>
                <td>Sauvegarder le contenu de l'éditeur dans un fichier</td>
            </tr>
            <tr>
                <td><span class='btn btn-info glyphicons glyphicons-print'
                           style='color: rgb(234,138,0); background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'></span></td>
                <td><kbd>Ctrl+P</kbd></td>
                <td>Imprimer le contenu de l'éditeur</td>
            </tr>
            <tr>
                <td><span class='btn btn-gray glyphicons glyphicons-undo'
                           style='color: rgb(234,138,0); background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'></span></td>
                <td><kbd>Ctrl+Z</kbd></td>
                <td>Annuler la dernière modification</td>
            </tr>
            <tr>
                <td><span class='btn btn-gray glyphicons glyphicons-redo'
                           style='color: rgb(234,138,0); background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'></span></td>
                <td><kbd>Maj+Ctrl+Z</kbd></td>
                <td>Rétablir la modification précedente</td>
            </tr>
            <tr>
                <td><span class='btn btn-gray glyphicons glyphicons-search'
                           style='color: rgb(234,138,0); background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'></span></td>
                <td><kbd>Ctrl+F</kbd></td>
                <td>Chercher une expression dans l'éditeur</td>
            </tr>
            <tr>
                <td><span class='btn btn-gray glyphicons glyphicons-pencil'
                           style='color: rgb(234,138,0); background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'></span></td>
                <td><kbd>Maj+Ctrl+F</kbd></td>
                <td>Chercher et remplacer une expression par une autre</td>
            </tr>
            <!-- 
            <tr>
                <td><span class='btn btn-warning glyphicons glyphicons-fit-image-to-frame'
                           style='color: rgb(234,138,0); background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'></span></td>
                <td><kbd>F11</kbd></td>
                <td>Passer en mode plein écran</td>
            </tr>
            -->
            <tr>
                <td><span class='btn btn-warning glyphicons glyphicons-circle-question-mark'
                           style='color: rgb(234,138,0); background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'></span></td>
                <td><kbd>F10</kbd></td>
                <td>Ouvrir une documentation du langage</td>
            </tr>
        </tbody>
    </table>
    <br />
    <table data-role="table" class="ui-responsive ui-shadow">
        <thead><th>Raccourci</th><th>Action</th></thead>
        <tbody>
            <tr>
                <td><kbd>F1</kbd></td>
                <td>Afficher cette aide</td>
            </tr>
            <tr>
                <td><kbd>Tab</kbd></td>
                <td>Indenter la sélection</td>
            </tr>
            <tr>
                <td><kbd>Maj+Tab</kbd></td>
                <td>Désindenter la sélection</td>
            </tr>
            <tr>
                <td><kbd>Ctrl+A</kbd></td>
                <td>Sélectionner le contenu de l'éditeur</td>
            </tr>
            <tr>
                <td><kbd>Ctrl+C</kbd></td>
                <td>Copier la sélection dans le presse-papier</td>
            </tr>
            <tr>
                <td><kbd>Ctrl+V</kbd></td>
                <td>Remplacer la sélection par le contenu du presse-papier</td>
            </tr>
            <tr>
                <td><kbd>Ctrl+X</kbd></td>
                <td>Supprimer la sélection et la copier dans le presse-papier</td>
            </tr>
            <tr>
                <td><kbd>Maj+Ctrl+R</kbd></td>
                <td>Chercher et remplacer une expression par une autre dans tout l'éditeur</td>
            </tr>
        </tbody>
    </table>
</div>
"""

RUN_PYTHON_CONFIG = u"""
pyEniBook['assessing']['%(directive)s']['%(id)s'] = {
    'title'     : u"%(title)s",
    'questions' : 1,
    'choices'   : 1,
    'items'     : [],
    'user'      : ""
}
"""

RUN_HTML_END = u"""
<!-- end %(id)s -->
<script type="text/javascript">
    EniBook.init.push( function() { EniBook['%(id)s'] = new %(javascript-object)s('%(id)s'); } );
</script>
"""
#-----------------------------------------------------
class run(nodes.General, nodes.Element):
    def __init__(self,options):
        super(run,self).__init__()
        self.options = options

def visit_html_run(self, node):
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_run(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_run(self, node):
    pass

def depart_latex_run(self,node):
    pass
#-----------------------------------------------------
def language(argument):
    return directives.choice(argument, 
        ("c","dot","html","javascript","prolog","python","sql","txt","xcas"))
        
language_extension = {
    "c"          : ".c",
    "dot"        : ".dot",
    "html"       : ".html",
    "javascript" : ".js",
    "prolog"     : ".pl",
    "python"     : ".py",
    "sql"        : ".sql",
    "txt"        : ".txt",
    "xcas"       : ".xcas"
}

language_mime = {
    "c"          : "text/x-c++src",
    "dot"        : "text/plain",
    "html"       : "text/html",
    "javascript" : "text/javascript",
    "prolog"     : "text/x-prolog",
    "python"     : "text/x-python",
    "sql"        : "text/x-sql",
    "txt"        : "text/plain",
    "xcas"       : "text/plain"
}

language_site = {
    "c"          : "",
    "dot"        : "http://www.graphviz.org/Documentation.php",
    "html"       : "https://developer.mozilla.org/fr/docs/Web/HTML",
    "javascript" : "https://developer.mozilla.org/fr/docs/Web/JavaScript",
    "prolog"     : "",
    "python"     : "https://docs.python.org/2/",
    "sql"        : "http://sql.sh/cours",
    "txt"        : "",
    "xcas"       : "https://www-fourier.ujf-grenoble.fr/~parisse/giac_fr.html"
}

language_javascript = {
    "c"          : "C",
    "dot"        : "Dot",
    "html"       : "Html",
    "javascript" : "Javascript",
    "prolog"     : "Prolog",
    "python"     : "Python",
    "sql"        : "Sql",
    "txt"        : "Txt",
    "xcas"       : "Xcas"    
}

language_prompt = {
    "c"          : "stdin",
    "dot"        : "",
    "html"       : "",
    "javascript" : ">",
    "prolog"     : "?-",
    "python"     : ">>>",
    "sql"        : ">",
    "txt"        : "",
    "xcas"       : ">"        
}
#-----------------------------------------------------
class Run(EniBook):
    required_arguments = 1
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'tabsize'       : directives.positive_int,
        'linenumbers'   : directives.flag,
        'firstline'     : directives.positive_int,
        'rows'          : directives.positive_int,
        'file'          : directives.path,
        'collapse'      : directives.flag,
        'execlimit'     : directives.positive_int,
        'title'         : directives.unchanged,
        'subtitle'      : directives.unchanged
    }
	
    def run(self):
        import os.path

        super(Run,self).run()

        self.options['remarks']  = 'false'

        if len(self.arguments) > 0 : 
            self.options['language'] = language(self.arguments[0])
        else :
            if 'language' not in self.options :
                self.options['language'] = 'python'

        self.options['site']      = language_site[self.options['language']]
        self.options['mime']      = language_mime[self.options['language']]
        self.options['extension'] = language_extension[self.options['language']]
        self.options['javascript-object'] = language_javascript[self.options['language']]
        self.options['prompt']    = language_prompt[self.options['language']]
        
        if 'execlimit' not in self.options :
            self.options['execlimit'] = 30 # secondes

        if 'tabsize' not in self.options :
            self.options['tabsize'] = 4
    
        if 'rows' not in self.options :
            self.options['rows'] = 10

        if 'collapse' not in self.options :
            self.options['collapse'] = 'false'
        else : 
            self.options['collapse'] = 'true'

        if 'linenumbers' not in  self.options :
            self.options['linenumbers'] = 'true'

        if 'firstline' not in  self.options :
            self.options['firstline'] = 1

        if 'keymap' not in self.options :
            self.options['keymap'] = 'default'

        if 'theme' not in self.options :
            self.options['theme'] = 'default'

        if 'file' in self.options :
            self.content = self.include(self.options['file'],True)
        else :
            self.options['file'] = 'essai' + self.options['extension'];

        if 'subtitle' not in self.options :
            self.options['subtitle'] = os.path.basename(self.options['file'])
        
        self.options['prefix'], self.options['code'], self.options['suffix'], self.options['comment'] = self.get_codes()
        self.options['initialcode'] = self.options['code']

        """
        if 'file' not in self.options :
            self.options['file'] = self.options['id'] + self.options['extension']
            source = ''
        else :
            source = self.include(self.options['file'])
            self.content = []
        """

        self.options['filename'] = os.path.basename(self.options['file'])

        """
        prefix  = ''
        suffix  = ''
        comment = []
        PREFIX  = '----'
        SUFFIX  = '===='
        COMMENT = '++++'

        if self.content :
            if PREFIX in self.content :
                index  = self.content.index(PREFIX)
                prefix = '\n'.join(self.content[:index])
                source = self.content[index+1:]
                if SUFFIX in source :
                    index  = source.index(SUFFIX)
                    suffix = source[index+1:]
                    source = '\n'.join(source[:index])
                    if COMMENT in suffix :
                        index   = suffix.index(COMMENT)
                        comment = suffix[index+1:]
                        suffix  = '\n'.join(suffix[:index])
                    else :
                        suffix  = '\n'.join(suffix)
                        comment = []
                elif COMMENT in source :
                    index   = source.index(COMMENT)
                    comment = source[index+1:]
                    source  = '\n'.join(source[:index])
                    suffix  = '\n'
                else :
                    source  = '\n'.join(source)
                    suffix  = '\n'
                    comment = []
            elif SUFFIX in self.content :
                prefix = ''
                index  = self.content.index(SUFFIX)
                source = '\n'.join(self.content[:index])
                suffix = self.content[index+1:]
                if COMMENT in suffix:
                    index   = suffix.index(COMMENT)
                    comment = suffix[index+1:]
                    suffix  = '\n'.join(suffix[:index])
                else :
                    suffix  = '\n'.join(suffix)
                    comment = []
            elif COMMENT in self.content :
                prefix  = ''
                suffix  = ''
                index   = self.content.index(COMMENT)
                source  = '\n'.join(self.content[:index])
                comment = self.content[index+1:]
            else :
                prefix  = ''
                suffix  = ''
                comment = []
                source  = '\n'.join(self.content)
        """ 

        node = run(self.options)
        node.html_begin  = RUN_HTML_BEGIN
        node.html_begin += EDIT_HELP_HTML
        node.html_end    = RUN_HTML_END

        if self.options['modeEnibook'] != "learning" and os.path.exists("pyenibook.cfg") :
            file = open("pyenibook.cfg","a")
            txt = RUN_PYTHON_CONFIG % self.options
            txt = txt.encode("utf8")
            file.write(txt)
            file.close()
        
        blocknode = None
        from docutils.statemachine import StringList
        if isinstance(self.options['comment'],StringList) :            
            options = {}
            options['id']       = self.options['id'] + '-comment'
            options['name']     = self.options['name']
            options['class']    = self.options['class']
            options['directive']= 'block'
            options['title']    = 'Commentaires'
            options['type']     = 'link'
            options['collapse'] = 'true'
            options['remarks']  = 'true'
            options['nolevels'] = 'false'
            options['maxitems'] = 'single'
            options['items']    = '0'

            blocknode = block(options)
            blocknode.html_begin  = BLOCK_HTML_BEGIN
            blocknode.html_begin += BLOCK_HTML_LINK
            blocknode.html_end    = BLOCK_HTML_END
            blocknode.latex_begin = BLOCK_LATEX_BEGIN
            blocknode.latex_end   = BLOCK_LATEX_END
            self.state.nested_parse(self.options['comment'], self.content_offset, blocknode)
            return [node, blocknode]
        else : 
            return [node]

	#--------------------------------------------
    def get_codes(self) :
        PREFIX  = self.get_comment_prefix() + '----' + self.get_comment_suffix()
        SUFFIX  = self.get_comment_prefix() + '====' + self.get_comment_suffix()
        COMMENT = self.get_comment_prefix() + '++++' + self.get_comment_suffix()

        prefix  = ''
        source  = ''
        suffix  = ''
        comment = []

        if self.content :
            if PREFIX in self.content :
                index  = self.content.index(PREFIX)
                prefix = '\n'.join(self.content[:index])
                source = self.content[index+1:]
                if SUFFIX in source :
                    index  = source.index(SUFFIX)
                    suffix = source[index+1:]
                    source = '\n'.join(source[:index])
                    if COMMENT in suffix :
                        index   = suffix.index(COMMENT)
                        comment = suffix[index+1:]
                        suffix  = '\n'.join(suffix[:index])
                    else :
                        suffix  = '\n'.join(suffix)
                        comment = []
                elif COMMENT in source :
                    index   = source.index(COMMENT)
                    comment = source[index+1:]
                    source  = '\n'.join(source[:index])
                    suffix  = '\n'
                else :
                    source  = '\n'.join(source)
                    suffix  = '\n'
                    comment = []
            elif SUFFIX in self.content :
                prefix = ''
                index  = self.content.index(SUFFIX)
                source = '\n'.join(self.content[:index])
                suffix = self.content[index+1:]
                if COMMENT in suffix:
                    index   = suffix.index(COMMENT)
                    comment = suffix[index+1:]
                    suffix  = '\n'.join(suffix[:index])
                else :
                    suffix  = '\n'.join(suffix)
                    comment = []
            elif COMMENT in self.content :
                prefix  = ''
                suffix  = ''
                index   = self.content.index(COMMENT)
                source  = '\n'.join(self.content[:index])
                comment = self.content[index+1:]
            else :
                prefix  = ''
                suffix  = ''
                comment = []
                source  = '\n'.join(self.content)

        return prefix,source,suffix,comment    

	#--------------------------------------------
    def get_comment_prefix(self) :
        return ''
        
	#--------------------------------------------
    def get_comment_suffix(self) :
        return ''
        

#-----------------------------------------------------
