# -*- coding: utf-8 -*-

# block.py

__author__ = 'jacques.tisseau@enib.fr'

from docutils import nodes
from docutils.parsers.rst import directives

from enibook import EniBook

#------------------------------------------------------------------------------
# Block
#------------------------------------------------------------------------------
BLOCK_HTML_BEGIN = u"""
<div id="%(id)s-block" name="%(name)s-block" class="block %(class)s-block" 
    collapse="%(collapse)s" maxitems="%(maxitems)s" items="%(items)s" 
    levels="%(nolevels)s" remarks="false" directive="%(directive)s">
"""

BLOCK_HTML_HEADER = u"""
    <div id="%(id)s-block-title-header" name="%(name)s-block-title-header" 
        class="block-title-header  %(class)s-block-title-header">
        <div id="%(id)s-block-title" name="%(name)s-block-title" 
            class="block-title-header-title %(class)s-block-title-header-title">%(title)s
            <span id="%(id)s-block-btn" name="%(name)s-block-btn" 
                class="btn btn-warning block-btn-header %(class)s-block-btn-header glyphicons glyphicons-chevron-down"></span>
        </div>
    </div>
    <script type="text/javascript">
        $("#%(id)s-block-title-header").on("click", function(event) { event.stopPropagation(); EniBook['%(id)s'].feedback(); } );
    </script>
    <div class="block-content-header %(class)s-block-content-header" 
        id="%(id)s-block-content" name="%(name)s-block-content">
"""

BLOCK_HTML_LINK = u"""
    <span id="%(id)s-block-title" name="%(name)s-block-title" 
        class="block-title %(class)s-block-title">%(title)s</span>
    <span id="%(id)s-block-btn" name="%(name)s-block-btn" 
            class="btn btn-warning block-btn %(class)s-block-btn 
            glyphicons glyphicons-chevron-down"></span>
    <span id="%(id)s-block-btn-items" name="%(name)s-block-btn-items" 
        class="block-btn-items %(class)s-block-btn-items"></span>
    <div class="block-content %(class)s-block-content" id="%(id)s-block-content" 
        name="%(name)s-block-content">
"""

BLOCK_HTML_END = u"""
    </div>
</div>
<script type="text/javascript">
    $("#%(id)s-block-title").on("click", function(event) { event.stopPropagation(); EniBook["%(id)s"].feedback(); } );
    $("#%(id)s-block-btn").on("click", function(event)   { event.stopPropagation(); EniBook["%(id)s"].feedback(); } );
    //$(document).ready( function() {  EniBook.init.push( function() { EniBook["%(id)s"] = new Block('%(id)s'); }) });
    EniBook.init.push( function() { EniBook["%(id)s"] = new Block('%(id)s'); } );
</script>
"""

BLOCK_LATEX_BEGIN = u"""
"""

BLOCK_LATEX_END = u"""
"""
#-----------------------------------------------------
class block(nodes.General, nodes.Element):
    def __init__(self,options):
        super(block,self).__init__()
        self.options = options

def visit_html_block(self, node):
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_block(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_block(self, node):
    pass

def depart_latex_block(self,node):
    pass
#-----------------------------------------------------

#-----------------------------------------------------
def collapseblock(argument) :
    return directives.choice(argument, ("false","true"))
    
def typeblock(argument):
    return directives.choice(argument, ("link","header"))

class Block(EniBook):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'class'     : directives.class_option,
        'name'      : directives.unchanged,
        'title'     : directives.unchanged,
        'collapse'  : collapseblock,
        'type'      : typeblock,
        'nolevels'  : directives.flag
    }
	
    def run(self):
        super(Block,self).run()
        
        if 'title' not in self.options :
            self.options['title'] = ""

        if 'type' not in self.options :
            self.options['type'] = 'link'

        if 'collapse' not in self.options :
            self.options['collapse'] = 'true'

        if 'nolevels' not in self.options :
            self.options['nolevels'] = 'true'
        else :
            self.options['nolevels'] = 'false'
            
        self.options['maxitems'] = 'single'
        self.options['items'] = '0'

        node = block(self.options)
        node.html_begin  = BLOCK_HTML_BEGIN
        if self.options['type'] == 'header' :
            node.html_begin  += BLOCK_HTML_HEADER
        else :
            node.html_begin  += BLOCK_HTML_LINK
        node.html_end    = BLOCK_HTML_END
        node.latex_begin = BLOCK_LATEX_BEGIN
        node.latex_end   = BLOCK_LATEX_END

        self.state.nested_parse(self.content, self.content_offset, node)
        return [node]
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# mrv
#------------------------------------------------------------------------------
class mrv(block, nodes.Element):
    def __init__(self,options):
        super(mrv,self).__init__()
        self.options = options

#-----------------------------------------------------
class MRV(Block):

    def run(self):
        if 'title' not in self.options :
            self.options['title'] = u'Démarche MRV'
        if 'collapse' not in self.options :
            self.options['collapse'] = 'false'
        
        return super(MRV,self).run()
#------------------------------------------------------------------------------


