# -*- coding: utf-8 -*-

# mcq.py

__author__ = 'jacques.tisseau@enib.fr'

from docutils import io, nodes, statemachine, utils
from docutils.parsers.rst import Directive
from docutils.parsers.rst import directives, roles

import os, os.path

from enibook import EniBook

#------------------------------------------------------------------------------
# MCQ
#------------------------------------------------------------------------------
MCQ_HTML_BEGIN = u"""
<!-- begin %(id)s -->
<span id="%(id)s-mcq-spanid" name="%(name)s-mcq-spanid"
    onclick="$('#%(id)s-mcq').toggle(); EniBook['%(id)s'].update();" directive="%(directive)s">
    <span class="btn btn-warning glyphicons glyphicons-ok-2"></span>
    <span id="%(id)s-mcq-items" name="%(name)s-mcq-items"
        class="mcq-items %(class)s-mcq-items">%(choices)s/%(qmcqs)s</span>
    <span class="mcq-title %(class)s-mcq-title" id="%(id)s-mcq-title" 
        name="%(name)s-mcq-title">%(title)s</span>
</span>
<div class="mcq %(class)s-mcq" id="%(id)s-mcq" name="%(name)s-mcq" 
    user-class="%(class)s" choices="%(choices)s" title="%(title)s"
    qmcqs="%(qmcqs)s" collapse="%(collapse)s" norandom="%(norandom)s"
    directive="%(directive)s" typeEnibook="%(typeEnibook)s" modeEnibook="%(modeEnibook)s">
"""

MCQ_PYTHON_CONFIG = u"""
pyEniBook['assessing']['%(directive)s']['%(id)s'] = {
    'title'     : u"%(title)s",
    'questions' : %(qmcqs)s,
    'choices'   : %(choices)s,
    'norandom'  : "%(norandom)s",
    'items'     : [],
    'user'      : []
}
"""

MCQ_HTML_END = u"""
    <span class='mcq-btns %(class)s-mcq-btns' id='%(id)s-mcq-btns' name='%(name)s-mcq-btns' 
        data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
        <button class='btn btn-success %(class)s-btn %(class)s-btn-success' id="%(id)s-btn-reset" 
            style="background-color: rgba(234,138,0,0.2); border: 2px solid rgba(234,138,0,0.2);"
            title="initialiser le QCM"
            onclick="EniBook['%(id)s'].update();"><span class="glyphicons glyphicons-refresh" style="color:rgb(234,138,0);"></span></button>
        <button class='btn btn-success %(class)s-btn %(class)s-btn-success' id="%(id)s-btn-play"  
            style="background-color: rgba(234,138,0,0.2); border: 2px solid rgba(234,138,0,0.2);"
            title="bilan du QCM"
            onclick="EniBook['%(id)s'].feedback();"><span class="glyphicons glyphicons-play" style="color:rgb(234,138,0);"></span></button>
    </span>
    <span class="btn btn-warning glyphicons glyphicons-chevron-up" style="float: right; font-size: 90%%; vertical-align: bottom;"
        onclick="$.mobile.silentScroll($('#%(id)s-mcq-title').offset().top);"></span>
    <div class="feedback-warning %(class)s-feedback-info" id="%(id)s-mcq-feedback" name="%(name)s-mcq-feedback">
        <table id="%(id)s-mcq-feedback-table-1" name="%(name)s-mcq-feedback-table-1" data-role="table" 
            class="ui-responsive">
            <thead>
                <tr class="mcq-feedback-tr %(class)s-mcq-feedback-tr">
                    <th>QCM</th>
                    <th>Radio</th>
                    <th>Checkbox</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Nombre de questions</td>
                    <td id="%(id)s-mcq-feedback-all-radio"    name="%(name)s-mcq-feedback-all-radio"></td>
                    <td id="%(id)s-mcq-feedback-all-checkbox" name="%(name)s-mcq-feedback-all-checkbox"></td>
                    <td id="%(id)s-mcq-feedback-all"          name="%(name)s-mcq-feedback-all"></td>
                <tr>
                    <td>Réponses non enregistrées</td>
                    <td id="%(id)s-mcq-feedback-undefined-radio"    name="%(name)s-mcq-feedback-undefined-radio"></td>
                    <td id="%(id)s-mcq-feedback-undefined-checkbox" name="%(name)s-mcq-feedback-undefined-checkbox"></td>
                    <td id="%(id)s-mcq-feedback-undefined"          name="%(name)s-mcq-feedback-undefined"></td>
                </tr>
                <tr>
                    <td>Réponses enregistrées</td>
                    <td id="%(id)s-mcq-feedback-valid-radio"    name="%(name)s-mcq-feedback-valid-radio"></td>
                    <td id="%(id)s-mcq-feedback-valid-checkbox" name="%(name)s-mcq-feedback-valid-checkbox"></td>
                    <td id="%(id)s-mcq-feedback-valid"          name="%(name)s-mcq-feedback-valid"></td>
                </tr>
                <tr class="mcq-feedback-tr %(class)s-mcq-feedback-tr">
                    <td>Taux d'enregistrement</td>
                    <td id="%(id)s-mcq-feedback-valid-percent-radio"    name="%(name)s-mcq-feedback-valid-percent-radio"></td>
                    <td id="%(id)s-mcq-feedback-valid-percent-checkbox" name="%(name)s-mcq-feedback-valid-percent-checkbox"></td>
                    <td id="%(id)s-mcq-feedback-valid-percent"          name="%(name)s-mcq-feedback-valid-percent" style="font-weight: bold;"></td>
                </tr>
                <tr>
                    <td id="%(id)s-mcq-feedback-false-label">Réponses enregistrées non validées</td>
                    <td id="%(id)s-mcq-feedback-false-radio"    name="%(name)s-mcq-feedback-false-radio"></td>
                    <td id="%(id)s-mcq-feedback-false-checkbox" name="%(name)s-mcq-feedback-false-checkbox"></td>
                    <td id="%(id)s-mcq-feedback-false"          name="%(name)s-mcq-feedback-false"></td>
                </tr>
                <tr>
                    <td id="%(id)s-mcq-feedback-true-label">Réponses enregistrées validées</td>
                    <td id="%(id)s-mcq-feedback-true-radio"    name="%(name)s-mcq-feedback-true-radio"></td>
                    <td id="%(id)s-mcq-feedback-true-checkbox" name="%(name)s-mcq-feedback-true-checkbox"></td>
                    <td id="%(id)s-mcq-feedback-true"          name="%(name)s-mcq-feedback-true"></td>
                </tr>
                <tr class="mcq-feedback-tr %(class)s-mcq-feedback-tr">
                    <td id="%(id)s-mcq-feedback-true-percent-label">Taux de réussite partiel</td>
                    <td id="%(id)s-mcq-feedback-true-percent-radio"    name="%(name)s-mcq-feedback-true-percent-radio"></td>
                    <td id="%(id)s-mcq-feedback-true-percent-checkbox" name="%(name)s-mcq-feedback-true-percent-checkbox"></td>
                    <td id="%(id)s-mcq-feedback-true-percent"          name="%(name)s-mcq-feedback-true-percent"></td>
                </tr>
                <tr>
                    <td id="%(id)s-mcq-feedback-all-true-percent-label">Taux de réussite total</td>
                    <td id="%(id)s-mcq-feedback-all-true-percent-radio"    name="%(name)s-mcq-feedback-all-true-percent-radio"></td>
                    <td id="%(id)s-mcq-feedback-all-true-percent-checkbox" name="%(name)s-mcq-feedback-all-true-percent-checkbox"></td>
                    <td id="%(id)s-mcq-feedback-all-true-percent"          name="%(name)s-mcq-feedback-all-true-percent" style="font-weight: bold;"></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<!-- end %(id)s -->
<script type="text/javascript">
    //$(document).ready( function() { EniBook.init.push( function() { EniBook['%(id)s'] = new Mcq('%(id)s'); }) });
    EniBook.init.push( function() { EniBook['%(id)s'] = new Mcq('%(id)s'); } );
</script>
"""

MCQ_LATEX_BEGIN = u"""
"""

MCQ_LATEX_END = u"""
"""

#-----------------------------------------------------
class mcq(nodes.General, nodes.Element):
    def __init__(self,options):
        super(mcq,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_mcq(self, node):
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_mcq(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_mcq(self, node):
    pass

def depart_latex_mcq(self,node):
    pass
#-----------------------------------------------------

#-----------------------------------------------------
class Mcq(EniBook):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'class'     : directives.class_option,
        'name'      : directives.unchanged,
        'title'     : directives.unchanged,
        'collapse'  : directives.flag,
        'norandom'  : directives.flag,
        'choices'   : directives.positive_int
    }
	
    def run(self):
        super(Mcq,self).run()
        
        env = self.state.document.settings.env
        env.mcq_counter = 0
        
        if 'collapse' not in self.options :
            self.options['collapse'] = 'false'
        else :
            self.options['collapse'] = 'true'
            
        if 'norandom' not in self.options :
            self.options['norandom'] = 'false'
        else :
            self.options['norandom'] = 'true'
            
        node = mcq(self.options)
        node.html_begin   = MCQ_HTML_BEGIN
        node.html_end     = MCQ_HTML_END
        node.latex_begin  = MCQ_LATEX_BEGIN
        node.latex_end    = MCQ_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)


        items = 0
        for str in self.content:
            if str.find('.. q-mcq::') != -1 :
                items += 1
        self.options['qmcqs'] = items

        if 'choices' not in self.options :
            self.options['choices'] = self.options['qmcqs']
        else :
            if self.options['choices'] > self.options['qmcqs'] :
                self.options['choices'] = self.options['qmcqs']

        if self.options['modeEnibook'] != "learning" and os.path.exists("pyenibook.cfg") :
            file = open("pyenibook.cfg","a")
            txt = MCQ_PYTHON_CONFIG % self.options
            txt = txt.encode("utf8")
            file.write(txt)
            file.close()

        env.mcq_counter = 0
        
        return [node]
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# QMCQ
#------------------------------------------------------------------------------
QMCQ_HTML_BEGIN = u"""
<!-- begin %(id)s -->
<div class="q-mcq %(class)s-q-mcq" id="%(id)s-q-mcq" name="%(name)s-q-mcq" 
     user-class="%(class)s"
     mcq="%(mcq)s" counter="%(counter)s" ok="undefined"
     type="%(type)s" items="%(items)s" truth="%(truth)s"
     directive="%(directive)s" typeEnibook="%(typeEnibook)s" modeEnibook="%(modeEnibook)s">
     <div class="q-mcq-title %(class)s-q-mcq-title" id="%(id)s-q-mcq-title" 
        name="%(name)s-q-mcq-title">%(title)s</div>
"""

QMCQ_HTML_ITEM_BEGIN = u"""
    <div class="q-mcq-content %(class)s-q-mcq-content" id="%(id)s-q-mcq-content" name="%(name)s-q-mcq-content">
        <fieldset data-role="controlgroup">
"""

QMCQ_HTML_ITEM_CURRENT = """
            <label class="q-mcq-label %(class)s-q-mcq-label" for="%(id)s-%(numero)s" style="font-weight : normal;"></label>
            <input type="%(type)s" name="%(name)s-group" id="%(id)s-%(numero)s">
"""

QMCQ_HTML_ITEM_END = u"""
        </fieldset>
    </div>
"""

QMCQ_PYTHON_CONFIG = u"""
pyEniBook['assessing']['%(directive)s']['%(id)s'] = {
    'title'     : u"%(title)s",
    'questions' : %(items)s,
    'choices'   : %(items)s,
    'items'     : [],
    'user'      : []
}
"""

QMCQ_HTML_END = u"""
    <span class='q-mcq-btns %(class)s-q-mcq-btns' id='%(id)s-btns' data-inline="true" 
        data-role="controlgroup" data-type="horizontal" data-native-menu="false">
        <button class='btn %(class)s-btn' id="%(id)s-btn-reset" title="initialiser le QCM"
            style="background-color: rgba(162,169,63,0.2); border: 2px solid rgba(162,169,63,0.2);"
            onclick="EniBook['%(id)s'].update();"><span class="glyphicons glyphicons-refresh" style="color: rgb(162,169,63);"></span></button>
        <button class='btn %(class)s-btn' id="%(id)s-btn-play"  title="analyser le QCM"
            style="background-color: rgba(162,169,63,0.2); border: 2px solid rgba(162,169,63,0.2);"
            onclick="EniBook['%(id)s'].feedback();"><span class="glyphicons glyphicons-play" style="color: rgb(162,169,63);"></span></button>
    </span>
    <div class="q-mcq-feedback %(class)s-q-mcq-feedback" id="%(id)s-q-mcq-feedback" name="%(name)s-q-mcq-feedback"></div>
</div>
<!-- end %(id)s -->
<script type="text/javascript">
    //$(document).ready( function() { EniBook.init.push( function() { EniBook['%(id)s'] = new QMcq('%(id)s'); }) });
    EniBook.init.push( function() { EniBook['%(id)s'] = new QMcq('%(id)s'); } );
</script>
"""

QMCQ_LATEX_BEGIN = u"""
"""

QMCQ_LATEX_END = u"""
"""

#-----------------------------------------------------
class qmcq(nodes.General, nodes.Element):
    def __init__(self,options):
        super(qmcq,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_qmcq(self, node):
    if isinstance(node.parent.parent.parent,mcq) :
        node.options['mcq'] = node.parent.parent.parent.options['id'];
    else :
        node.options['mcq'] = ''
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_qmcq(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_qmcq(self, node):
    pass

def depart_latex_qmcq(self,node):
    pass
#-----------------------------------------------------

#-----------------------------------------------------
def typeqmcq(argument):
    return directives.choice(argument, ("checkbox","radio"))

class QMcq(EniBook):
    required_arguments = 1
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'class' : directives.class_option,
        'name'  : directives.unchanged,
        'type'  : typeqmcq,
        'title' : directives.unchanged
    }
	
    def run(self):
        super(QMcq,self).run()

        self.options['counter'] = self.getCounter()

        if 'type' not in self.options :
            self.options['type'] = 'radio'

        args = directives.unchanged(self.arguments[0])
        if ',' in args:
            truth = args.split(',')
        else :
            truth = args.split()

        self.options['truth'] = ''
        if self.options['type'] == 'radio' :
            if len(truth) > 1 :
                message = u'type radio : un seul item « vrai » attendu, %d trouvés (' % len(truth)
                for s in range(len(truth)):
                    if s < len(truth)-1 : message += truth[s] + ','
                    else : message += truth[s]
                message += ')'
                comment = u'seul le premier item « vrai » sera conservé (%s)' % truth[0]
                raise self.warning(self.enibook_error(self.name,message,comment))
            self.options['truth'] = truth[0]
        else :
            for t in range(len(truth)):
                if t < len(truth) - 1 : self.options['truth'] += truth[t] + ','
                else : self.options['truth'] += truth[t]

        items = 0
        for str in self.content:
            if str.find('#') == 0 :
                items += 1
        self.options['items'] = items

        node = qmcq(self.options)
        node.html_begin  = QMCQ_HTML_BEGIN
        node.html_end    = QMCQ_HTML_ITEM_BEGIN
        for i in range(items) :
            self.options['numero'] = i
            node.html_end += QMCQ_HTML_ITEM_CURRENT % self.options
        node.html_end    += QMCQ_HTML_ITEM_END
        node.html_end    += QMCQ_HTML_END
        node.latex_begin  = QMCQ_LATEX_BEGIN
        node.latex_end    = QMCQ_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)

        if self.options['modeEnibook'] != "learning" and os.path.exists("pyenibook.cfg") :
            file = open("pyenibook.cfg","a")
            txt = QMCQ_PYTHON_CONFIG % self.options
            txt = txt.encode("utf8")
            file.write(txt)
            file.close()

        return [node]

    def getCounter(self) :
        env = self.state.document.settings.env
        if hasattr(env,'mcq_counter') : 
            counter = env.mcq_counter
            env.mcq_counter += 1
        else :
            counter = ''
        return counter            
#------------------------------------------------------------------------------
