# -*- coding: utf-8 -*-
"""
    sphinxextension.katex
    ~~~~~~~~~~~~~~~~~~~~~

    Allow `KaTeX <https://khan.github.io/KaTeX/>`_ to be used to display math in
    Sphinx's HTML writer -- requires the KaTeX JavaScript library on your
    webserver/computer.
"""

from docutils import nodes

from sphinx.application import ExtensionError
from sphinx.ext.mathbase import setup_math as mathbase_setup


def html_visit_math(self, node):
    self.body.append(self.starttag(node, 'span', '', CLASS='math'))
    self.body.append(self.builder.config.katex_inline[0] +
                     self.encode(node['latex']) +
                     self.builder.config.katex_inline[1] + '</span>')
    raise nodes.SkipNode

def html_visit_displaymath(self, node):
    self.body.append(self.starttag(node, 'div', CLASS='math'))
    if node['nowrap']:
        self.body.append(self.builder.config.katex_display[0] +
                         node['latex'] +
                         self.builder.config.katex_display[1])
        self.body.append('</div>')
        raise nodes.SkipNode

    parts = [prt for prt in node['latex'].split('\n\n') if prt.strip()]
    for i, part in enumerate(parts):
        part = self.encode(part)
        if i == 0:
            # necessary to e.g. set the id property correctly
            if node['number']:
                self.body.append('<span class="eqno">(%s)</span>' %
                                 node['number'])
        if '&' in part or '\\\\' in part:
            self.body.append(self.builder.config.katex_display[0] + part +
                             #'\\begin{split}' + part + '\\end{split}' +
                             self.builder.config.katex_display[1])
        else:
            self.body.append(self.builder.config.katex_display[0] + part +
                             self.builder.config.katex_display[1])
    self.body.append('</div>\n')
    raise nodes.SkipNode

def builder_inited(app):
    if not app.config.katex_path:
        raise ExtensionError('conf.py : katex_path config value must be set for the '
                             'katex extension to work')
    app.add_stylesheet(app.config.katex_path + 'css/katex.min.css')
    app.add_javascript(app.config.katex_path + 'js/katex.min.js')
    app.add_javascript(app.config.katex_path + 'js/auto-render.min.js')
    #app.add_javascript(app.config.katex_path + 'js/katex.min.js')
    #app.add_javascript(app.config.katex_path + 'js/auto-render.min.js')



