# -*- coding: utf-8 -*-

import sys

sys.stderr.write('\t\033[1;36m' + 'KaTeX 0.9.0' + '\033[0m')

from sphinx.ext.mathbase import setup_math as mathbase_setup
from katex import html_visit_math, html_visit_displaymath, builder_inited

def setup(app):
    mathbase_setup(app, (html_visit_math, None), (html_visit_displaymath, None))
    # config
    app.add_config_value('katex_path', 'katex/', 'html')
    app.add_config_value('katex_inline', [r'\(', r'\)'], 'html')
    app.add_config_value('katex_display', [r'\[', r'\]'], 'html')
    app.connect('builder-inited', builder_inited)
    sys.stderr.write(' ... done')
