# -*- coding: utf-8 -*-
from __future__ import unicode_literals


# general
import os, sys

#------------------------------------------------------------------------------
__author__  = 'jacques.tisseau@enib.fr'
__version__ = '2.7'

sys.stderr.write('      \033[1;32m' + 'edit' + '\033[0m\n')
#------------------------------------------------------------------------------

# docutils
from docutils import nodes
from docutils.parsers.rst import Directive, directives, roles
# enibook
from sphinxextension.enibook.base.base import Tool, tool, typetool

#------------------------------------------------------------------------------
EDITICON = 'glyphicons glyphicons-edit'

#------------------------------------------------------------------------------
EDIT_MAIN_HEADER_BODY = """
            <div class="tool-header-btns"  id="%(id)s-header-btns">
                <div class="tool-header-buffer" id="%(id)s-header-buffer">
                    <select class="header-buffer-select" id="%(id)s-buffer-select"></select>
                </div>
                <div class="tool-header-file-btns"  id="%(id)s-header-file-btns">
                    <div class="tool-btn tool-file-new-btn" id="%(id)s-file-new-btn">
                        <span class="tool-file-new-icon" onclick="EniBook['%(id)s'].new_file();">
                            <span id="%(id)s-file-new-icon" class='btn btn-edit glyphicons glyphicons-refresh'></span>
                        </span>
                    </div>
                    <div class="tool-btn tool-file-download-btn" id="%(id)s-file-download-btn">
                        <span class="tool-file-download-icon" onclick="EniBook['%(id)s'].download_file();">
                            <span id="%(id)s-file-download-icon" class='btn btn-edit glyphicons glyphicons-disk-open'></span>
                        </span>
                    </div>
                    <div class="tool-btn tool-file-upload-btn" id="%(id)s-file-upload-btn">
                        <span class="tool-file-upload-icon" onclick="EniBook['%(id)s'].upload_file();">
                            <span id="%(id)s-file-upload-icon" class='btn btn-edit glyphicons glyphicons-disk-save'></span>
                        </span>
                    </div>
                    <div class="tool-btn tool-file-print-btn" id="%(id)s-file-print-btn">
                        <span class="tool-file-print-icon" onclick="EniBook['%(id)s'].print_file();">
                            <span id="%(id)s-file-print-icon" class='btn btn-edit glyphicons glyphicons-print'></span>
                        </span>
                    </div>
                </div>
                <div class="tool-header-edit-btns"  id="%(id)s-header-edit-btns">
                    <div class="tool-btn tool-edit-undo-btn" id="%(id)s-edit-undo-btn">
                        <span class="tool-edit-undo-icon" onclick="EniBook['%(id)s'].undo_edit();">
                            <span id="%(id)s-edit-undo-icon" class='btn btn-edit glyphicons glyphicons-undo'></span>
                        </span>
                    </div>
                    <div class="tool-btn tool-edit-redo-btn" id="%(id)s-edit-redo-btn">
                        <span class="tool-edit-redo-icon" onclick="EniBook['%(id)s'].redo_edit();">
                            <span id="%(id)s-edit-redo-icon" class='btn btn-edit glyphicons glyphicons-redo'></span>
                        </span>
                    </div>
                    <div class="tool-btn tool-edit-search-btn" id="%(id)s-edit-search-btn">
                        <span class="tool-edit-search-icon" onclick="EniBook['%(id)s'].search_edit();">
                            <span id="%(id)s-edit-search-icon" class='btn btn-edit glyphicons glyphicons-search'></span>
                        </span>
                    </div>
                    <div class="tool-btn tool-edit-replace-btn" id="%(id)s-edit-replace-btn">
                        <span class="tool-edit-replace-icon" style="position: relative;" onclick="EniBook['%(id)s'].replace_edit()();">
                            <span id="%(id)s-edit-replace-icon" class='btn btn-edit glyphicons glyphicons-search'
                                style='position: absolute; top: 1px; z-index: 1'></span>
                                <span class='btn glyphicons glyphicons-pencil' style="z-index: 2; color:rgb(234,138,0);"></span>
                        </span>
                    </div>
                </div>
                <div class="tool-header-edit-btns"  id="%(id)s-header-edit-btns">
                    <div class="tool-btn tool-edit-help-btn" id="%(id)s-edit-help-btn">
                        <span class="tool-edit-help-icon" onclick="EniBook['EniBook'].help(EniBook['%(id)s']);">
                            <span id="%(id)s-edit-help-icon" class='btn-single btn-edit glyphicons glyphicons-circle-question-mark'></span>
                        </span>
                    </div>
                </div>
            </div>"""

EDIT_MAIN_BODY_END = """
            <textarea class="edit-code" id="%(id)s-edit-code">%(code)s</textarea>
        </div>"""

#------------------------------------------------------------------------------
# Edit
#------------------------------------------------------------------------------
class Edit(Tool):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True         
    option_spec = {
        'class'      : directives.class_option,
        'name'       : directives.unchanged,
        'title'      : directives.unchanged,
        'subtitle'   : directives.unchanged,
        'file'       : directives.path,
        'open'       : directives.flag,
        'showrst'    : directives.flag
    }
	
	#--------------------------------------------
    def run(self):
        self.options['code'] = ""
        
        if 'language' not in self.options :
            self.options['language']  = 'text'
        if 'extension' not in self.options :
            self.options['extension'] = '.txt'
        if 'mime' not in self.options :
            self.options['mime']      = 'plain/text'
                
        if 'file' in self.options :
            self.content = self.include(self.options['file'])
            if 'subtitle' not in self.options :
                self.options['subtitle'] = os.path.basename(self.options['file'])
        else :
            self.options['file'] = 'essai' + self.options['extension'];
        
        self.options['prefix'], self.options['code'], self.options['suffix'], self.options['comment'] = self.get_codes()
        
        if 'open' in self.options :
            self.options['open'] = True
        if 'showrst' in self.options :
            self.options['showrst'] = True
            
        if 'title' not in self.options :
            self.options['title'] = 'Editeur'
        if 'no_nested_parse' not in self.options :
            self.options['no_nested_parse'] = True        
        if 'interface' not in self.options :
            self.options['interface']  = 'block'
        if 'iconopen' not in self.options :
            self.options['iconopen']   = EDITICON
        if 'iconclose' not in self.options :
            self.options['iconclose']  = EDITICON
        if 'noheader' not in self.options :
            self.options['noheader'] = False
        if 'nofooter' not in self.options :
            self.options['nofooter'] = False
        if 'nohelp' not in self.options :
            self.options['nohelp'] = False
        if 'noupdate' not in self.options :
            self.options['noupdate'] = False
        if 'nofeedback' not in self.options :
            self.options['nofeedback'] = False
        if 'fullscreen' not in self.options :
            self.options['fullscreen'] = True
        if 'jsobj' not in self.options :
            self.options['jsobj'] = 'Edit'
                
        return super(Edit,self).run()  
        
	#--------------------------------------------
    def main_header(self) :
        return EDIT_MAIN_HEADER_BODY

	#--------------------------------------------
    def end_main_body(self) :
        return EDIT_MAIN_BODY_END

	#--------------------------------------------
    def get_comment_prefix(self) :
        return ''
        
	#--------------------------------------------
    def get_comment_suffix(self) :
        return ''
        
	#--------------------------------------------
    def get_codes(self) :
        #source  = ''
        #prefix  = ''
        #suffix  = ''
        #comment = []
        PREFIX  = self.get_comment_prefix() + '----' + self.get_comment_suffix()
        SUFFIX  = self.get_comment_prefix() + '====' + self.get_comment_suffix()
        COMMENT = self.get_comment_prefix() + '++++' + self.get_comment_suffix()

        if self.content :
            if PREFIX in self.content :
                index  = self.content.index(PREFIX)
                prefix = '\n'.join(self.content[:index])
                source = self.content[index+1:]
                if SUFFIX in source :
                    index  = source.index(SUFFIX)
                    suffix = source[index+1:]
                    source = '\n'.join(source[:index])
                    if COMMENT in suffix :
                        index   = suffix.index(COMMENT)
                        comment = suffix[index+1:]
                        suffix  = '\n'.join(suffix[:index])
                    else :
                        suffix  = '\n'.join(suffix)
                        comment = []
                elif COMMENT in source :
                    index   = source.index(COMMENT)
                    comment = source[index+1:]
                    source  = '\n'.join(source[:index])
                    suffix  = '\n'
                else :
                    source  = '\n'.join(source)
                    suffix  = '\n'
                    comment = []
            elif SUFFIX in self.content :
                prefix = ''
                index  = self.content.index(SUFFIX)
                source = '\n'.join(self.content[:index])
                suffix = self.content[index+1:]
                if COMMENT in suffix:
                    index   = suffix.index(COMMENT)
                    comment = suffix[index+1:]
                    suffix  = '\n'.join(suffix[:index])
                else :
                    suffix  = '\n'.join(suffix)
                    comment = []
            elif COMMENT in self.content :
                prefix  = ''
                suffix  = ''
                index   = self.content.index(COMMENT)
                source  = '\n'.join(self.content[:index])
                comment = self.content[index+1:]
            else :
                prefix  = ''
                suffix  = ''
                comment = []
                source  = '\n'.join(self.content)
        return prefix,source,suffix,comment    
#------------------------------------------------------------------------------
        