# -*- coding: utf-8 -*-

# multisort.py

__author__ = 'jacques.tisseau@enib.fr'

from docutils import nodes
from docutils.parsers.rst import directives
from docutils.parsers.rst.directives import tables;

import os, os.path

from enibook import EniBook
from block import collapseblock

#------------------------------------------------------------------------------
# Multisort
#------------------------------------------------------------------------------
MULTISORT_HTML_BEGIN = u"""
<!-- begin %(id)s -->
<div id="%(id)s-multisort" name="%(name)s-multisort" 
    class="ui-grid-%(sorts)s ui-responsive multisort %(class)s-multisort"
    multicol="%(multicol)s" nonumber="%(nonumber)s"  title="%(title)s"
    directive="%(directive)s" typeEnibook="%(typeEnibook)s" modeEnibook="%(modeEnibook)s">
    <h4>%(title)s</h4>
"""

MULTISORT_HTML_END = u"""
</div>
<!-- end %(id)s -->
<span class='multisort-btns' id='%(id)s-btns' data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
    <button class='btn' id="%(id)s-btn-reset" title="initialiser le texte en vrac" style='background-color : rgba(162,169,63,0.2); border: 2px solid rgba(162,169,63,0.2);'
        onclick="EniBook['%(id)s'].update();"><span class="glyphicons glyphicons-refresh" style="color: rgb(162,169,63);"></span></button>
    <button class='btn' id="%(id)s-btn-play"  title='vérifier' style='background-color : rgba(162,169,63,0.2); border: 2px solid rgba(162,169,63,0.2);'
        onclick="EniBook['%(id)s'].feedback(true);"><span class="glyphicons glyphicons-play" style="color: rgb(162,169,63);"></span></button>
</span>
<div id="%(id)s-multisort-feedback" name="%(name)s-multisort-feedback"
    class="feedback %(class)s-feedback"></div>
<div>
    <textarea class="run-textarea" id="%(id)s-multisort-textarea" style="display: none;"></textarea>
    <pre class="run-pre" id="%(id)s-multisort-pre"></pre>
    <div class="run-error %(class)s-run-error" id="%(id)s-multisort-error"></div>
    <div class="run-canvas" id="%(id)s-multisort-canvas"></div>
</div> 

<script type="text/javascript">
    //$(document).ready( function() { EniBook.init.push( function() { EniBook['%(id)s'] = new Multisort("%(id)s"); }) });
    EniBook.init.push( function() { EniBook['%(id)s'] = new Multisort("%(id)s"); } );
</script>
"""

MULTISORT_PYTHON_CONFIG = u"""
pyEniBook['assessing']['%(directive)s']['%(id)s'] = {
    'title'     : u"%(title)s",
    'questions' : 1,
    'choices'   : 1,
    'items'     : [],
    'user'      : []
}
"""

#------------------------------------------------------------------------------

#-----------------------------------------------------
class multisort(nodes.General, nodes.Element):
    def __init__(self,options):
        super(multisort,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_multisort(self, node):
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_multisort(self,node):
    res = node.html_end % node.options
    self.body.append(res)
#-----------------------------------------------------

#-----------------------------------------------------
def nbsort(argument):
    return directives.choice(argument, ("1","2","3","4","5"))

class Multisort(EniBook):
    required_arguments = 1
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'class'    : directives.class_option,
        'name'     : directives.unchanged,
        'title'    : directives.unchanged,
        'nonumber' : directives.flag
    }

    sorts = {"1" : "solo", "2" : "a", "3" : "b", "4" : "c", "5" : "d"}
	
    def run(self):
        super(Multisort,self).run()
        env = self.state.document.settings.env

        if 'nonumber' not in self.options :
            self.options['nonumber'] = 'false'
        else :
            self.options['nonumber'] = 'true'

        nbcols = nbsort(self.arguments[0])
        self.options['sorts']  = self.sorts[nbcols]
        self.options['multicol'] = nbcols
        
        env.sortnumber = -1
        env.multisort  = int(nbcols)
        
        node = multisort(self.options)
        node.html_begin  = MULTISORT_HTML_BEGIN
        node.html_end    = MULTISORT_HTML_END
        self.state.nested_parse(self.content, self.content_offset, node)

        if self.options['modeEnibook'] != "learning" and os.path.exists("pyenibook.cfg") :
            file = open("pyenibook.cfg","a")
            txt = MULTISORT_PYTHON_CONFIG % self.options
            txt = txt.encode("utf8")
            file.write(txt)
            file.close()

        env.sortnumber = -1
        return [node]
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Sort
#------------------------------------------------------------------------------
SORT_HTML_BEGIN = u"""
<!-- begin %(id)s -->
<div id="%(id)s-sort-block" name="%(name)s-sort-block" 
    class="ui-block-%(numero)s sort-block %(class)s-sort-block" title="%(title)s" directive="%(directive)s">
    <div id="%(id)s-sort-%(numero)s" name="%(name)s-sort-%(numero)s" 
        class="sort %(class)s-sort" direction="%(direction)s" code="%(code)s" verif="%(verif)s"
        numero="%(numero)s" number="%(number)s"
        directive="%(directive)s" typeEnibook="%(typeEnibook)s" modeEnibook="%(modeEnibook)s">
        <div style="border-bottom: 1px solid lightgray;">
            <h4 style="direction: %(direction)s;"><span id="%(id)s-sort-%(number)s" name="%(name)s-sort-%(number)s"
                    class="sort-header %(class)s-sort-header">%(number)s. </span>
                    <span>%(title)s</span></h4>
        </div>
"""

SORT_PYTHON_CONFIG = u"""
pyEniBook['assessing']['%(directive)s']['%(id)s'] = {
    'title'     : u"%(title)s",
    'questions' : %(lines)s,
    'choices'   : %(lines)s,
    'items'     : [],
    'user'      : []
}
"""

SORT_HTML_END = u"""
    </div>
</div>
<!-- end %(id)s -->
<script type="text/javascript">
    //$(document).ready( function() { EniBook.init.push( function() { EniBook["%(id)s"] = new Sort("%(id)s","%(numero)s"); }) });
    EniBook.init.push( function() { EniBook["%(id)s"] = new Sort("%(id)s","%(numero)s"); } );
</script>
"""

#------------------------------------------------------------------------------

#-----------------------------------------------------
class sort(nodes.General, nodes.Element):
    def __init__(self,options):
        super(sort,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_sort(self, node):
    if not isinstance(node.parent,multisort) :
        msg = "« sort » doit être une sous-directive de « multisort »."
        raise self.severe(enibook_error(node.options["directive"],msg))
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_sort(self,node):
    res = node.html_end % node.options
    self.body.append(res)
#-----------------------------------------------------

#-----------------------------------------------------
from coderun import language

def sortdirection(argument) :
    return directives.choice(argument,('ltr','rtl'))

class Sort(EniBook):
    required_arguments = 0
    optional_arguments = 1
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'class'    : directives.class_option,
        'name'     : directives.unchanged,
        'direction': sortdirection,
        'code'     : language,
        'verif'    : directives.unchanged
    }

    def run(self):
        super(Sort,self).run()

        if len(self.arguments) > 0 :
            self.options["title"] = self.arguments[0]
        else :
            self.options["title"] = ''

        if 'direction' not in self.options :
            self.options['direction'] = 'ltr'

        if 'code' not in self.options :
            self.options['code'] = 'undefined'

        if 'verif' not in self.options :
            self.options['verif'] = 'undefined'

        numero, number = self.getNumero()
        self.options['numero'] = numero
        self.options['number'] = number + 1
        
        node = sort(self.options)
        node.html_begin = SORT_HTML_BEGIN
        node.html_end   = SORT_HTML_END
        self.state.nested_parse(self.content, self.content_offset, node)

        items = 0
        for str in self.content:
            if str.find('#.') != -1 :
                items += 1
        self.options['lines'] = items

        if self.options['modeEnibook'] != "learning" :
            file = open("pyenibook.cfg","a")
            txt = SORT_PYTHON_CONFIG % self.options
            txt = txt.encode("utf8")
            file.write(txt)
            file.close()

        return [node]

    def getNumero(self) :
        env = self.state.document.settings.env
        env.sortnumber += 1
        numero = chr(ord("a") + env.sortnumber%env.multisort)
        return numero, env.sortnumber
#------------------------------------------------------------------------------


