# -*- coding: utf-8 -*-

# association.py

__author__ = 'jacques.tisseau@enib.fr'

from docutils import io, nodes, statemachine, utils
from docutils.parsers.rst import Directive
from docutils.parsers.rst import directives, roles

from enibook import EniBook

#------------------------------------------------------------------------------
# Inorder
#------------------------------------------------------------------------------
INORDER_HTML_BEGIN = u"""
<div id="%(id)s-inorder" name="%(name)s-inorder" class="inorder %(class)s" 
    directive="inorder" answer="%(answer)s">
"""

INORDER_HTML_END = u"""
</div>
    <span class='inorder-btns' id='%(id)s-btns' data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
        <button class='btn' id="%(id)s-btn-reset" title="(r&eacute;)initialisation" style='background-color : #5C885C;'
            onclick="initInorder('%(id)s');"><span class="glyphicons glyphicons-refresh"></span></button>
        <button class='btn' id="%(id)s-btn-play"  title='vérifier' style='background-color : #5C885C;'
            onclick="runInorder('%(id)s');"><span class="glyphicons glyphicons-play"></span></button>
    </span>
    <div id="%(id)s-inorder-feedback" name="%(name)s-inorder-feedback"></div>
<script type="text/javascript">
    var %(id)s_storage = new Array();
    $(document).ready( function() { initInorder("%(id)s"); } );
</script>
"""

INORDER_LATEX_BEGIN = u"""
"""

INORDER_LATEX_END = u"""
"""
#------------------------------------------------------------------------------

#-----------------------------------------------------
class inorder(nodes.General, nodes.Element):
    def __init__(self,options):
        super(inorder,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_inorder(self, node):
    if isinstance(node.parent,answer) :
        node.options['answer'] = node.parent.options['id'];
    else :
        subdir = 'inorder'
        parent = 'answer'
        eniBookError(subdir,parent)
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_inorder(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_inorder(self, node):
    res = node.latex_begin % node.options
    self.body.append(res)

def depart_latex_inorder(self,node):
    res = node.latex_end % node.options
    self.body.append(res)
#-----------------------------------------------------

#-----------------------------------------------------
class Inorder(EniBook):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
    }
	
    def run(self):
        super(Inorder,self).run()

        node = inorder(self.options)
        node.html_begin  = INORDER_HTML_BEGIN
        node.html_end    = INORDER_HTML_END
        node.latex_begin = INORDER_LATEX_BEGIN
        node.latex_end   = INORDER_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)
        return [node]
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Association
#------------------------------------------------------------------------------
ASSOCIATION_HTML_BEGIN = u"""
<div id="%(id)s-association" name="%(name)s-association" class="ui-grid-a ui-responsive multicolumn association %(class)s" answer="%(answer)s">
"""

ASSOCIATION_HTML_END = u"""
    <div id="%(id)s-association-column-a" name="%(name)s-association-column-a" class="ui-block-a association-column %(class)s"></div>
    <div id="%(id)s-association-column-b" name="%(name)s-association-column-b" class="ui-block-b association-column %(class)s"></div>
</div>
    <span class='association-btns' id='%(id)s-btns' data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
        <button class='btn' id="%(id)s-btn-reset" title="(r&eacute;)initialisation" style='background-color : #5C885C;'
            onclick="initAssociation('%(id)s');"><span class="glyphicons glyphicons-refresh"></span></button>
        <button class='btn' id="%(id)s-btn-play"  title='vérifier' style='background-color : #5C885C;'
            onclick="runAssociation('%(id)s');"><span class="glyphicons glyphicons-play"></span></button>
    </span>
    <div id="%(id)s-association-feedback" name="%(name)s-association-feedback" class="feedback"></div>
<script type="text/javascript">
    var %(id)s_storage_a = new Array();
    var %(id)s_storage_b = new Array();
    $(document).ready( function() { initAssociation("%(id)s"); } );
</script>
"""

ASSOCIATION_LATEX_BEGIN = u"""
"""

ASSOCIATION_LATEX_END = u"""
"""
#------------------------------------------------------------------------------

#-----------------------------------------------------
class association(nodes.General, nodes.Element):
    def __init__(self,options):
        super(association,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_association(self, node):
    if isinstance(node.parent,answer) :
        node.options['answer'] = node.parent.options['id'];
    else :
        subdir = 'association'
        parent = 'answer'
        eniBookError(subdir,parent)
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_association(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_association(self, node):
    res = node.latex_begin % node.options
    self.body.append(res)

def depart_latex_association(self,node):
    res = node.latex_end % node.options
    self.body.append(res)
#-----------------------------------------------------

#-----------------------------------------------------
class Association(EniBook):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
    }
	
    def run(self):
        super(Association,self).run()

        node = association(self.options)
        node.html_begin  = ASSOCIATION_HTML_BEGIN
        node.html_end    = ASSOCIATION_HTML_END
        node.latex_begin = ASSOCIATION_LATEX_BEGIN
        node.latex_end   = ASSOCIATION_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)
        return [node]
#------------------------------------------------------------------------------
