# -*- coding: utf-8 -*-

# input.py

__author__ = 'jacques.tisseau@enib.fr'

from docutils import io, nodes, statemachine, utils
from docutils.parsers.rst import Directive
from docutils.parsers.rst import directives, roles

from enibook import EniBook, ENIBOOKERROR
from question import answer, question

#------------------------------------------------------------------------------
# Input
#------------------------------------------------------------------------------
INPUT_HTML_BEGIN = u"""
<!-- début %(id)s -->
    <div id="%(id)s-input-block" name="%(name)s-input-block"
        class="input-block %(class)s-input-block" 
        directive="%(directive)s" modeEnibook="%(modeEnibook)s" typeEnibook="%(typeEnibook)s"
        solution="%(solution)s" re="%(re)s" answer="%(answer)s" question="%(question)s"       
        nbtry="%(nbtry)s" success="undefined" title="%(title)s">
"""

INPUT_HTML_END = u"""
        <span style="display: inline-block; position: relative;">
            <input type="%(type)s" id="%(id)s-input" name="%(name)s-input" value=""
                class="input %(class)s-input"  title="%(title)s"
                placeholder="%(placeholder)s"  size="%(size)s" data-role="none"
                ondblclick="EniBook['%(id)s'].hint();"
                onkeypress="EniBook['%(id)s'].keypress(event);">
            <span class="input-remove %(class)s-input-remove btn glyphicons glyphicons-circle-remove" 
                onclick="EniBook['%(id)s'].update();"></span>
        </span>
        <span id="%(id)s-hints" name="%(name)s-hints" 
            class="hints %(class)s-hints" onclick="EniBook['%(id)s'].hint();">?</span>
        <span id="%(id)s-roleinput-btns" 
            data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
            <button class='btn' id="%(id)s-roleinput-btn" 
                style="background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2);"
                title="analyser la réponse"
                onclick="EniBook['%(id)s'].feedback();"><span class="glyphicons glyphicons-play" style="color: rgb(162,169,63);"></span></button>
        </span>

        <div id="%(id)s-input-feedback" name="%(name)s-input-feedback"
            class="feedback-assessing %(class)s-feedback-assessing" ></div>
        <div id="%(id)s-input-hint" name="%(name)s-input-hint"
            class="input-hint %(class)s-input-hint">%(hint)s</div>
        <div id="%(id)s-input-help" name="%(name)s-input-help"
            class="input-help %(class)s-input-help">
            <h4>Zone de saisie de texte</h4>
            <table data-role="table" class="ui-responsive ui-shadow" noborder>
                <thead class="fillblank-help-tr"><th>Clavier</th><th>Action</th></thead>
                <tbody>
                    <tr><td><kbd>F1</kbd><td>Afficher une aide technique</td></tr>
                    <tr class="fillblank-help-tr"><td><kbd>F2</kbd></td><td>Afficher une aide pédagogique</td></tr>
                    <tr><td><kbd>Ctrl-A</kbd><td>Tout sélectionner</td></tr>
                    <tr><td><kbd>Ctrl-C</kbd><td>Copier la sélection dans le presse-papier</td></tr>
                    <tr><td><kbd>Ctrl-V</kbd><td>Copier le presse-papier dans la sélection</td></tr>
                    <tr><td><kbd>Ctrl-X</kbd><td>Couper la sélection et la copier dans le presse-papier</td></tr>
                    <tr><td><kbd>Ctrl-Z</kbd><td>Annuler la modification</td></tr>
                    <tr><td><kbd>Maj-Ctrl-Z</kbd><td>Rétablir la modification</td></tr>
                </tbody>
            </table>
            <br />
            <table data-role="table" class="ui-responsive ui-shadow" noborder>
                <thead class="fillblank-help-tr"><th>Menu</th><th>Action</th></thead>
                <tbody>
                    <tr><td><span class="btn btn-success glyphicons glyphicons-play" 
                                  style="color: rgb(162,169,63); background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2);"></span></td><td>Valider la zone de saisie</td></tr> 
                </tbody>
            </table>
        </div>
    </div>
<!-- fin %(id)s -->
<script type="text/javascript">
    //$(document).ready( function() { EniBook.init.push( function() { EniBook["%(id)s"] = new Input("%(id)s"); }) });
    EniBook.init.push( function() { EniBook["%(id)s"] = new Input("%(id)s"); } );
</script>
"""

INPUT_PYTHON_CONFIG = u"""
pyEniBook['assessing']['%(directive)s']['%(id)s'] = {
    'title'     : u"%(title)s",
    'questions' : 1,
    'choices'   : 1,
    'items'     : [],
    'user'      : ""
}
"""

INPUT_LATEX_BEGIN = u"""
"""

INPUT_LATEX_END = u"""
"""

#-----------------------------------------------------
class inputnode(nodes.General, nodes.Element):
    def __init__(self,options):
        super(inputnode,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_input(self, node):
    if isinstance(node.parent,answer) :
        node.options["answer"]   = node.parent.options["id"];
        node.options["question"] = node.parent.parent.options["id"];
    else :
        node.options["answer"]   = "undefined"
        node.options["question"] = "undefined"
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_input(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_input(self, node):
    pass

def depart_latex_input(self,node):
    pass
#-----------------------------------------------------

#-----------------------------------------------------
def inputtype(argument) :
    return directives.choice(argument, ("number","range","text"))

class Input(EniBook):
    required_arguments = 1
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        "class"       : directives.class_option,
        "name"        : directives.unchanged,
        "placeholder" : directives.unchanged,
        "size"        : directives.positive_int,
        "hint"        : directives.unchanged,
        "nbtry"       : directives.nonnegative_int,
        "re"          : directives.unchanged,
        "solution"    : directives.unchanged,
        "title"       : directives.unchanged
    }
	
    def run(self):
        super(Input,self).run()

        arg = self.arguments[0]
        if self.options['modeEnibook'] != "assessing" : 
            if arg[0] == "/" :
                self.options["re"]       = arg
                self.options["solution"] = ""
            else :
                self.options["re"]       = ""
                self.options["solution"] = arg
        else :
            self.options["re"]       = ""
            self.options["solution"] = ""
            
        
        if "type" not in self.options :
            self.options["type"] = "text"
            
        if "placeholder" not in self.options :
            self.options["placeholder"] = u"votre réponse"

        if "size" not in self.options :
            if self.options["re"] != "" : length = len(self.options["re"])
            else                        : length = len(self.options["solution"])
            self.options["size"] = max(length,len(self.options["placeholder"])) + 2

        if "hint" not in self.options :
            self.options["hint"] = ""

        if "nbtry" not in self.options :
            self.options["nbtry"] = 0

        node = inputnode(self.options)
        node.html_begin  = INPUT_HTML_BEGIN
        node.html_end    = INPUT_HTML_END
        node.latex_begin = INPUT_LATEX_BEGIN
        node.latex_end   = INPUT_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)

        if self.options['modeEnibook'] != "learning" :
            file = open("pyenibook.cfg","a")
            txt = INPUT_PYTHON_CONFIG % self.options
            txt = txt.encode("utf8")
            file.write(txt)
            file.close()

        return [node]
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# InputLines
#------------------------------------------------------------------------------
INPUTLINES_HTML_BEGIN = u"""
<!-- début %(id)s -->
<div class="edit-language-editor %(class)s-edit-language-editor" 
    id="%(id)s-edit-language-editor" name="%(name)s-edit-language-editor"
    collapse="%(collapse)s">
    <span class="btn btn-warning glyphicons glyphicons-edit"
        id="%(id)s-edit-language-editor-btn" name="%(id)s-edit-language-editor-btn"
        onclick="EniBook['%(id)s'].collapse();"></span>
    <span id="%(id)s-edit-lang" name="%(name)s-edit-lang" 
        class="edit-lang %(class)s-edit-lang"><b>Texte</b></span> : 
    <span id="%(id)s-edit-file" name="%(name)s-edit-file" 
        class="edit-file %(class)s-edit-file">%(filename)s</span>
</div>
"""

INPUTLINES_BLOCK_BEGIN = u"""
<div id="%(id)s-inputlines-block" name="%(name)s-inputlines-block"
    class="inputlines inputlines-block %(class)s-inputlines-block" 
    directive="%(directive)s" modeEnibook="%(modeEnibook)s" typeEnibook="%(typeEnibook)s"
    answer="%(answer)s" question="%(question)s" collapse="%(collapse)s"    
    title="%(title)s">
"""

INPUTLINES_EDIT_BUTTONS = u"""
    <span id="%(id)s-btns" name="%(name)s-btns">
        <span id="%(id)s-file-btns"
              data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
            <button class='btn btn-warning' id='%(id)s-file-btn-reset'   style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'
                title="nouveau fichier"
                onclick="EniBook['%(id)s'].newFile();"><span class='glyphicons glyphicons-refresh' style='color:rgb(234,138,0);'></span></button>
            <button class='btn btn-warning' id="%(id)s-file-btn-download"  style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'  
                title="ouvrir fichier"
                onclick="EniBook['%(id)s'].openFile();"><span class='glyphicons glyphicons-disk-open' style='color:rgb(234,138,0);'></span></button>
            <button class='btn btn-info' id="%(id)s-file-btn-upload"  style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);' 
                title="sauvegarder éditeur"
                onclick="EniBook['%(id)s'].saveFile();"><span class='glyphicons glyphicons-disk-save' style='color:rgb(234,138,0);'></span></button>
            <button class='btn btn-info' id="%(id)s-file-btn-print"  style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);' 
                title="imprimer éditeur"
                onclick="EniBook['%(id)s'].printEdit();"><span class='glyphicons glyphicons-print' style='color:rgb(234,138,0);'></span></button>
        </span>
    </span>
"""

INPUTLINES_TEXTAREA = u"""
    <textarea id="%(id)s-inputlines" name="%(name)s-inputlines" 
        class="inputlines-textarea %(class)s-inputlines-textarea"  title="%(title)s"
        oninput="EniBook['%(id)s'].refresh();" 
        placeholder="%(placeholder)s" data-role="none">%(initialtext)s</textarea>
"""

INPUTLINES_HTML_END = u"""
    <span id="%(id)s-run-btns"
        data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
        <button class='btn' id="%(id)s-init-btn" 
            style="background-color: rgba(162,169,63,0.2); border: 2px solid rgba(162,169,63,0.2);"
            title="nouveau fichier"
            onclick="EniBook['%(id)s'].update();"><span class="glyphicons glyphicons-refresh" style="color: rgb(162,169,63);"></span></button>
        <button class='btn' id="%(id)s-display-btn-keyboard"
            style="background-color: rgba(162,169,63,0.2); border: 2px solid rgba(162,169,63,0.2);"
            title="aide"
            onclick="EniBook['%(id)s'].help();"><span class='glyphicons glyphicons-circle-question-mark' style="color: rgb(162,169,63);"></span></button>
        <button class='btn' id="%(id)s-run-btn" 
            style="background-color: rgba(162,169,63,0.2); border: 2px solid rgba(162,169,63,0.2);"
            title="interpréter le texte"
            onclick="EniBook['%(id)s'].feedback();"><span class="glyphicons glyphicons-play" style="color: rgb(162,169,63);"></span></button>
    </span>
    <div id="%(id)s-inputlines-feedback" name="%(name)s-inputlines-feedback" class="feedback-info %(class)s-feedback-info"></div>
    <div id="%(id)s-inputlines-help" name="%(name)s-inputlines-help"
        class="input-help %(class)s-input-help">
        <h4>Zone de saisie de texte</h4>
        <table data-role="table" class="ui-responsive ui-shadow" noborder>
            <thead class="fillblank-help-tr"><th>Clavier</th><th>Action</th></thead>
            <tbody>
                <tr><td><kbd>F1</kbd><td>Afficher une aide technique</td></tr>
                <tr class="fillblank-help-tr"><td><kbd>F2</kbd></td><td>Afficher une aide pédagogique</td></tr>
                <tr><td><kbd>Ctrl-A</kbd><td>Tout sélectionner</td></tr>
                <tr><td><kbd>Ctrl-C</kbd><td>Copier la sélection dans le presse-papier</td></tr>
                <tr><td><kbd>Ctrl-V</kbd><td>Copier le presse-papier dans la sélection</td></tr>
                <tr><td><kbd>Ctrl-X</kbd><td>Couper la sélection et la copier dans le presse-papier</td></tr>
                <tr><td><kbd>Ctrl-Z</kbd><td>Annuler la modification</td></tr>
                <tr><td><kbd>Maj-Ctrl-Z</kbd><td>Rétablir la modification</td></tr>
            </tbody>
        </table>
        <br />
        <table data-role="table" class="ui-responsive ui-shadow" noborder>
            <thead class="fillblank-help-tr"><th>Menu</th><th>Action</th></thead>
            <tbody>
                <tr>
                    <td><span class="btn btn-success glyphicons glyphicons-refresh" 
                              style="color: rgb(162,169,63); background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2);"></span></td>
                    <td>Ré-initialiser les sorties</td>
                </tr>
                <tr>
                    <td><span class="btn btn-success glyphicons glyphicons-circle-question-mark" 
                              style="color: rgb(162,169,63); background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2);"></span></td>
                    <td>Faire apparaître le menu d'aide</td>
                </tr>
                <tr>
                    <td><span class="btn btn-success glyphicons glyphicons-play" 
                              style="color: rgb(162,169,63); background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2);"></span></td><td>Valider la zone de saisie</td></tr> 
                <tr>
                    <td><span class='btn btn-info glyphicons glyphicons-refresh'
                               style='color: rgb(234,138,0); background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'></span></td>
                    <td>Initialiser la zone de saisie</td>
                </tr>
                <tr>
                    <td><span class='btn btn-info glyphicons glyphicons-disk-open'
                               style='color: rgb(234,138,0); background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'></span></td>
                    <td>Charger le contenu d'un fichier dans la zone de saisie</td>
                </tr>
                <tr>
                    <td><span class='btn btn-info glyphicons glyphicons-disk-save'
                               style='color: rgb(234,138,0); background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'></span></td>
                    <td>Sauvegarder le contenu de la zone de saisie dans un fichier</td>
                </tr>
                <tr>
                    <td><span class='btn btn-info glyphicons glyphicons-print'
                               style='color: rgb(234,138,0); background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'></span></td>
                    <td>Imprimer le contenu de la zone de saisie</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<!-- fin %(id)s -->
<script type="text/javascript">
    //$(document).ready( function() { EniBook.init.push( function() { EniBook["%(id)s"] = new InputLines("%(id)s"); }) });
    EniBook.init.push( function() { EniBook["%(id)s"] = new InputLines("%(id)s"); } );
</script>
"""

INPUTLINES_PYTHON_CONFIG = u"""
pyEniBook['assessing']['%(directive)s']['%(id)s'] = {
    'title'     : u"%(title)s",
    'questions' : 1,
    'choices'   : 1,
    'items'     : [],
    'user'      : ""
}
"""

INPUTLINES_LATEX_BEGIN = u"""
"""

INPUTLINES_LATEX_END = u"""
"""

#-----------------------------------------------------
class inputlines(nodes.General, nodes.Element):
    def __init__(self,options):
        super(inputlines,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_inputlines(self, node):
    if isinstance(node.parent,answer) :
        node.options["answer"]   = node.parent.options["id"];
        node.options["question"] = node.parent.parent.options["id"];
    elif isinstance(node.parent,question) :
        node.options["answer"]   = "undefined";
        node.options["question"] = node.parent.options["id"];
    else :
        node.options["answer"]   = "undefined"
        node.options["question"] = "undefined"
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_inputlines(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_inputlines(self, node):
    pass

def depart_latex_inputlines(self,node):
    pass
#-----------------------------------------------------

#-----------------------------------------------------
class InputLines(EniBook):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        "class"       : directives.class_option,
        "name"        : directives.unchanged,
        "collapse"    : directives.flag,
        "file"        : directives.path,
        "placeholder" : directives.unchanged,
        "title"       : directives.unchanged,
        "noheader"    : directives.flag
    }
	
    def run(self):
        super(InputLines,self).run()

        self.options['extension'] = '.txt'

        if 'noheader' not in self.options :
            self.options['noheader'] = 'false'
        else :
            self.options['noheader'] = 'true'

        if 'collapse' not in self.options :
            self.options['collapse'] = 'false'
        elif  self.options['noheader'] == 'true' : 
            self.options['collapse'] = 'false'
        else :
            self.options['collapse'] = 'true'

        if "placeholder" not in self.options :
            self.options["placeholder"] = u"« texte libre sur plusieurs lignes »"

        if 'file' not in self.options :
            self.options['file'] = self.options['id'] + self.options['extension']
            source = '\n'.join(self.content)
        else :
            source = self.include(self.options['file'])
            self.content = []

        self.options['initialtext'] = source

        import os.path
        self.options['filename'] = os.path.basename(self.options['file'])

        node = inputlines(self.options)
        if self.options['noheader'] == 'false' :
            node.html_begin  = INPUTLINES_HTML_BEGIN
            node.html_begin += INPUTLINES_BLOCK_BEGIN
            node.html_begin += INPUTLINES_EDIT_BUTTONS
            node.html_begin += INPUTLINES_TEXTAREA
            node.html_end    = INPUTLINES_HTML_END
        else :
            node.html_begin  = INPUTLINES_BLOCK_BEGIN
            node.html_begin += INPUTLINES_TEXTAREA
            node.html_end    = INPUTLINES_HTML_END

        node.latex_begin = INPUTLINES_LATEX_BEGIN
        node.latex_end   = INPUTLINES_LATEX_END

        #self.state.nested_parse(self.content, self.content_offset, node)

        if self.options['modeEnibook'] != "learning" :
            file = open("pyenibook.cfg","a")
            txt = INPUT_PYTHON_CONFIG % self.options
            txt = txt.encode("utf8")
            file.write(txt)
            file.close()

        return [node]
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Fill-blank
#------------------------------------------------------------------------------
FILLBLANK_HTML_BEGIN = u"""
<span id="%(id)s-fillblank-span" name="%(name)s-fillblank-span"
    onclick="EniBook['%(id)s'].collapse();">
    <span class="btn btn-warning glyphicons glyphicons-option-horizontal"></span>
    <span class="fillblank-title %(class)s-fillblank-title" id="%(id)s-fillblank-title" 
        name="%(name)s-fillblank-title">%(title)s</span>
</span>
<div id="%(id)s-fillblank" name="%(name)s-fillblank"
    class="fillblank %(class)s-fillblank" 
    directive="%(directive)s" collapse="%(collapse)s">
"""

FILLBLANK_HTML_END = u"""
    <span class='fillblank-btns %(class)s-fillblank-btns' id='%(id)s-fillblank-btns' name='%(name)s-fillblank-btns' 
        data-inline="true" data-role="controlgroup" data-type="horizontal" data-native-menu="false">
        <button class='btn %(class)s-btn' id="%(id)s-fillblank-btn-reset" style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'
            title="initialiser les zones de saisie"
            onclick="EniBook['%(id)s'].update();"><span class="glyphicons glyphicons-refresh" style="color : rgb(234,138,0);"></span></button>
        <button class='btn %(class)s-btn' id="%(id)s-fillblank-btn-help" style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'
            title="aide"
            onclick="EniBook['%(id)s'].help();"><span class="glyphicons glyphicons-circle-question-mark" style="color : rgb(234,138,0);"></span></button>
        <button class='btn %(class)s-btn' id="%(id)s-fillblank-btn-play" style='background-color : rgba(234,138,0,0.2); border: 1px solid rgba(234,138,0,0.2);'
            title="bilan du questionnaire"
            onclick="EniBook['%(id)s'].feedback();"><span class="glyphicons glyphicons-play" style="color : rgb(234,138,0);"></span></button>
    </span>
    <span class="btn btn-warning glyphicons glyphicons-chevron-up" style="float: right;"
        onclick="$.mobile.silentScroll($('#%(id)s-fillblank-span').offset().top);"></span>
    <div id="%(id)s-fillblank-help" name="%(name)s-fillblank-help"
        class="input-help %(class)s-input-help">
        <p style="border-bottom: 1px solid lightgray;"><b>Indication</b>
            <span class="input-remove %(class)s-input-remove btn glyphicons glyphicons-circle-remove"  
                onclick="$('#%(id)s-fillblank-help').popup('close');"></span>
        </p>          
        <div id="%(id)s-fillblank-help-content" name="%(name)s-fillblank-help-content">
            <h4>Textes à trous</h4>
            <table data-role="table" class="ui-responsive ui-shadow">
                <thead class="fillblank-help-tr"><th>Bouton</th><th>Action</th></thead>
                <tbody>
                    <tr><td><span class="btn btn-info glyphicons glyphicons-refresh"></span><td>Initialiser toutes les zones de saisie</td></tr>
                    <tr><td><span class="btn btn-info glyphicons glyphicons-circle-question-mark"></span><td>Afficher cette aide</td></tr>
                    <tr><td><span class="btn btn-info glyphicons glyphicons-play"></span></td><td>Afficher le bilan de l'exercice</td></tr>
                </tbody>
            </table>
            <br />
            <table data-role="table" class="ui-responsive ui-shadow">
                <thead class="fillblank-help-tr"><th>Clavier</th><th>Action</th></thead>
                <tbody>
                    <tr><td><kbd>Enter</kbd></td><td>Valider la zone de saisie</td></tr>
                    <tr><td><kbd>F1</kbd><td>Afficher une aide technique</td></tr>
                    <tr class="fillblank-help-tr"><td><kbd>F2</kbd></td><td>Afficher une aide pédagogique</td></tr>
                    <tr><td><kbd>Ctrl-A</kbd><td>Tout sélectionner</td></tr>
                    <tr><td><kbd>Ctrl-C</kbd><td>Copier la sélection dans le presse-papier</td></tr>
                    <tr><td><kbd>Ctrl-V</kbd><td>Copier le presse-papier dans la sélection</td></tr>
                    <tr><td><kbd>Ctrl-X</kbd><td>Couper la sélection et la copier dans le presse-papier</td></tr>
                    <tr><td><kbd>Ctrl-Z</kbd><td>Annuler la modification</td></tr>
                    <tr><td><kbd>Maj-Ctrl-Z</kbd><td>Rétablir la modification</td></tr>
                </tbody>
            </table>
        </div>
    </div>
    <div id="%(id)s-fillblank-feedback" name="%(name)s-fillblank-feedback"
        class="feedback-warning %(class)s-feedback-warning">
        <table id="%(id)s-fillblank-feedback-table-1" name="%(name)s-fillblank-feedback-table-1" data-role="table" 
            class="ui-responsive">
            <thead>
                <tr class="fillblank-feedback-tr %(class)s-fillblank-feedback-tr">
                    <th>Question</th>
                    <th>Bilan</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Nombre de trous</td>
                    <td id="%(id)s-fillblank-feedback-all" name="%(name)s-fillblank-feedback-all"></td>
                <tr>
                    <td>Réponses non validées</td>
                    <td id="%(id)s-fillblank-feedback-undefined" name="%(name)s-fillblank-feedback-undefined"></td>
                </tr>
                <tr>
                    <td>Réponses validées</td>
                    <td id="%(id)s-fillblank-feedback-valid" name="%(name)s-fillblank-feedback-valid"></td>
                </tr>
                <tr class="fillblank-feedback-tr %(class)s-qcm-feedback-tr">
                    <td>Taux de validation</td>
                    <td id="%(id)s-fillblank-feedback-valid-percent" name="%(name)s-fillblank-feedback-valid-percent"></td>
                </tr>
                <tr>
                    <td>Réponses validées non attendues</td>
                    <td id="%(id)s-fillblank-feedback-false" name="%(name)s-fillblank-feedback-false"></td>
                </tr>
                <tr>
                    <td>Réponses validées attendues</td>
                    <td id="%(id)s-fillblank-feedback-true" name="%(name)s-fillblank-feedback-true"></td>
                </tr>
                <tr class="fillblank-feedback-tr %(class)s-qcm-feedback-tr">
                    <td>Taux de réussite partiel</td>
                    <td id="%(id)s-fillblank-feedback-true-percent" name="%(name)s-fillblank-feedback-true-percent"></td>
                </tr>
                <tr>
                    <td>Taux de réussite total</td>
                    <td id="%(id)s-fillblank-feedback-all-true-percent" name="%(name)s-fillblank-feedback-all-true-percent"></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<script type="text/javascript">
    //$(document).ready( function() { EniBook.init.push( function() { EniBook["%(id)s"] = new FillBlank("%(id)s"); }) });
    EniBook.init.push( function() { EniBook["%(id)s"] = new FillBlank("%(id)s"); } );
</script>
"""

FILLBLANK_LATEX_BEGIN = u"""
"""

FILLBLANK_LATEX_END = u"""
"""
#-----------------------------------------------------
class fillblank(nodes.General, nodes.Element):
    def __init__(self,options):
        super(fillblank,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_fillblank(self, node):
    if isinstance(node.parent,answer) :
        node.options["answer"]   = node.parent.options["id"];
        node.options["question"] = node.parent.parent.options["id"];
    else :
        node.options["answer"]   = "undefined"
        node.options["question"] = "undefined"
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_fillblank(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_fillblank(self, node):
    pass

def depart_latex_fillblank(self,node):
    pass
#-----------------------------------------------------

#-----------------------------------------------------
class FillBlank(EniBook):
    required_arguments = 0
    optional_arguments = 1
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        "class"     : directives.class_option,
        "name"      : directives.unchanged,
        "collapse"  : directives.flag
    }
	
    def run(self):
        super(FillBlank,self).run()

        if len(self.arguments) > 0 :
            self.options['title'] = self.arguments[0]
        else :
            self.options['title'] = ""
        
        if "collapse" not in self.options :
            self.options['collapse'] = "false"
        else :
            self.options['collapse'] = "true"
            
        node = fillblank(self.options)
        node.html_begin  = FILLBLANK_HTML_BEGIN
        node.html_end    = FILLBLANK_HTML_END
        node.latex_begin = FILLBLANK_LATEX_BEGIN
        node.latex_end   = FILLBLANK_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)

        return [node]
#------------------------------------------------------------------------------


