/******************************************************************************
 *
 * EniBook
 *
 ******************************************************************************/
$.mobile.ignoreContentEnabled = true;

//------------------------------------------------------------------------------
EniBook.tools       = ['mcq','q-mcq','multisort','sort','code-run','edit','input','inputlines','roleinput','graph'];
EniBook.assessing   =         
        {
        'container' : {},
        'mcq'       : {},
        'q-mcq'     : {},
        'exercise'  : {},
        'question'  : {},
        'multisort' : {},
        'sort'      : {},
        'code-run'  : {},
        'input'     : {},
        'inputlines': {},
        'roleinput' : {},
        'graph'     : {},
        'save'      : "false",
        'date'      : "",
        'student'   : "",
        'config'    : "undefined",
        'subject'   : "undefined",
        'answer'    : "undefined",
        'globalcomment': '',
        'timeversion'  : "undefined"
        };
EniBook.configloaded = false;

//------------------------------------------------------------------------------
function refreshEditors(id) { 
    var $editors = $("#" + id).find("div.CodeMirror");
    for (var i = 0; i < $editors.length; i++) {
        var $parents = $($editors[i]).parent('div[id].edit'); 
        for (var j = 0; j < $parents.length; j++) {
            var idparent = $($parents[j]).attr('id').replace('-edit','');
            EniBook[idparent].edit.refresh();
        }
    }
};

//------------------------------------------------------------------------------
function refreshDiagrams(id) { 
    var $editors = $("#" + id).find(".graph");
    for (var i = 0; i < $editors.length; i++) {
        var editorId = $($editors[i]).attr('id').replace('-graph','');
        EniBook[editorId].refresh(); 
    }
};

//------------------------------------------------------------------------------
function enibookConfig(obj) { 
    if (obj) {
        if (!obj['enibook3']) {
            if (EniBook['mode'] === 'training') {
                var msg = "AVERTISSEMENT\n\n"
                msg    += EniBook['assessing']['config'] + " :\n"; 
                msg    += "\nFichier de configuration non conforme au mode Correction !\n\n";
                alert(msg);
            }
            else {
                EniBook['mode'] = 'assessing';
                EniBook['assessing'] = obj; 
                EniBook['assessing']['subject'] = EniBook['assessing']['config'];
                $("#enibook-footer-encours").html("<b>" + EniBook.assessing.student + " : évaluation en cours</b>");
                console.log('\tmode : assessing'); 
            }
        }
        else {
            if (validTraining(obj)) {
                EniBook['mode'] = 'training'; 
                EniBook['assessing'] = obj;
                EniBook['assessing']['answer'] = EniBook['assessing']['config'];
                $("#enibook-footer-encours").html("<b>" + EniBook.assessing.student + " : correction en cours</b>");
                console.log('\tmode : training');
            }
            else { 
                var msg = "AVERTISSEMENT\n\n"
                msg    += EniBook['assessing']['config'] + " :\n";
                msg    += "\nFichier de configuration invalide !\n\n";
                alert(msg);
            }
        }
    }
}

//------------------------------------------------------------------------------
function validTraining(obj) {
    if(obj['enibook1'] && obj['enibook3'] && obj['enibook2']) {
        var enibook1 = obj['enibook1'];
        var enibook2 = obj['enibook2'];
        var enibook3 = obj['enibook3'];
        if (enibook2 !== md5(enibook1+enibook3)) {
            var msg = "ATTENTION :\n\n";
            msg += "Erreur de chiffrage : enibook2 != enibook1 + enibook3\n\n";
            alert(msg);
            return false;
        }     
        else { return true; } 
    } 
}

//------------------------------------------------------------------------------
function showExercises(obj) {
    if (obj) {
        if (typeof obj['container'] != undefined) {
            for (container in obj['container']) { $("#" + container).show(); }
        }
        if(typeof obj['exercise'] != undefined) {
            for (exercise in obj['exercise']) { $("#" + exercise).show(); }
        }
    }
}

//------------------------------------------------------------------------------
function initTools() { 
    if (EniBook.mode === "assessing" || EniBook.mode === "training") { enibookConfig(EniBook.config); }
    //else { EniBook.mode = "learning"; }
    var len = EniBook.init.length;
    console.log('\tinitializing ' + len.toString() + ' tools'); 
    for (var i = 0; i < EniBook.init.length; i++) { 
        EniBook.init[i](); 
    }
    if (EniBook.mode === "assessing" || EniBook.mode === "training") { showExercises(EniBook.assessing); }
    console.log('\t... done');
}

//------------------------------------------------------------------------------
function initEniBook() {    
    console.log(`initializing EniBook in mode ${EniBook.mode}`); 
    enibookContents(); 
    enibookHelp(); 
    enibookHour();
    initTools();

    if (EniBook['mode'] === 'assessing') { 
        $("#enibook-footer-encours").html("<b>" + EniBook.assessing.student + " : évaluation en cours</b>");
    }
    $(".sidebar").addClass('enibook-sidebar');


    $(window).on("resize", function () { 
        var h = (window.innerHeight-120).toString() + "px";
        $("#enibook-help-content").css("max-height",h); 
        $("#enibook-tableofcontent").css("max-height",h); 
    });

    $("#enibook-feedback").draggable({handle: "div.enibook-feedback-header"});
    $("#enibook-hint").draggable({handle: "div.enibook-hint-header"});
    
    var locend = location.hash; 
    var locbegin = location.pathname; 

    enibookSection(); 

    enibookIntRefs(); 
    enibookExtRefs(); 
    enibookIndexRefs();


    if (locend !== "") { enibookLocation(locend); }
    else { $(".section[h2]").css('display','none'); }

    refreshEditors("enibook-main");
    //refreshDiagrams("enibook-main");
    $("#enibook-main-page").css('visibility','visible');
    spinner.stop();

    console.log('... done');
}

//------------------------------------------------------------------------------
function renderKatex(elemId) { // KaTeX
    if (typeof katexDom !== "undefined") { 
        var options = { 
            delimiters: [
                        {left: "$$", right: "$$", display: true},
                        {left: "\\[", right: "\\]", display: true},
                        {left: "\\(", right: "\\)", display: false},
                        {left: "$", right: "$", display: false}
                        ],
            ignoredTags: ["script", "noscript", "style", "textarea", "pre", "code"]
        };
        var elem = document.getElementById(elemId);
        if (elem) { katexDom(elem,options); }
    }
}

//------------------------------------------------------------------------------
function sectionh2_toggle(h2id) { // <h2 id=h2id>Titre</h2>
    if (h2id.search(/h2$/) !== -1) { 
        var divh2id = h2id.replace("h2",""); 
        var divh2   = $("#" + divh2id); 
        var chevronid = h2id + "-btn";
        var chevron = $("#" + chevronid); 
        if ($(divh2).css('display') === 'none') {
            toggleH2(h2id);
            $(divh2).css('display','block');
            if ($(chevron).hasClass("glyphicons-chevron-down")) {
                $(chevron).removeClass("glyphicons-chevron-down");
                $(chevron).addClass("glyphicons-chevron-up");
            }
            refreshEditors(divh2id);
            refreshDiagrams(divh2id);
            renderKatex(divh2id);
        }
        else {
            $(divh2).css('display','none');
            if ($(chevron).hasClass("glyphicons-chevron-up")) {
                $(chevron).removeClass("glyphicons-chevron-up");
                $(chevron).addClass("glyphicons-chevron-down");
            }
        }
    }
    else {
        alert("sectionh2_toggle : " + id + " n'est pas une section <h2>.");
    }
}

//------------------------------------------------------------------------------
function enibookLocation(locend) { // locend commence par # 
    var $elem = $(locend); 

    if (locend.search(/h2$/) !== -1) { 
        var locendDiv = locend.replace("h2","");
        if ($(locendDiv).css('display') === 'none') {
            $(locend).click();
        }
    }
    else {
        var divh2 = $($elem).closest(".section[h2]");
        var divh2id = $(divh2).attr('id'); 
        if ($(divh2).css('display') === 'none') {
            $("#" + divh2id + "h2").click();
        }
        var $gdparent = $($elem).parent().parent();
        if ($($gdparent).attr("directive") === "question") { 
            $($gdparent).css('display','block');
        }
        var $parent = $($elem).parent();
        if ($($parent).attr("directive") === "mcq" && $($parent).attr("collapse") === "true") {
            $($parent).css('display','block');
        }
    }
    $.mobile.silentScroll($($elem).offset().top);
}


//------------------------------------------------------------------------------
function enibookSection() { 
    var $sections = $("h2"); 
    for (var i = 0; i < $sections.length; i++) {
        var section = $sections[i]; 
        var parent = $(section).parent(); 
        if ($(parent).hasClass("section")) { 
            var refs = $(section).prevAll(); // liens internes
            var stack = new Array();
            for (var j = 0; j < refs.length; j++) { 
                var elem = refs[j].cloneNode(true);
                stack.push(elem);
            }
            $(refs).remove(); 
            
            while (stack.length) {
                $(parent).before(stack.pop());
            }

            var id = $(parent).attr("id");
            $(section).attr('id',id + "h2");
            var clone = section.cloneNode(true);
            $(section).remove();
            $(parent).before(clone); 

            $("#" + id + "h2").on("click", function(event) { 
                sectionh2_toggle($(this).attr('id')); 
                /*
                $("#" + $(this).attr('id').replace("h2","")).toggle(); 
                toggleChevron($(this).attr('id') + '-btn'); 
                toggleH2($(this).attr('id')); 
                */
            });

            $("#" + id + "h2").css('cursor','pointer');
            $("#" + id + "h2").html($("#" + id + "h2").html() + '<span id="' + 
                id + 'h2-btn" ' + 'style="float: right; font-size: 90%; color: rgb(234,138,0);" ' +
                'class="btn glyphicons glyphicons-chevron-down"></span>');
            $(parent).css('display','none');
            $(parent).attr("h2", id + "h2");
            $("#" + id + "h2").attr("divH2",id + "h2");
        }
    }

    var $h2s = $("#enibook-tableofcontent").find("li.toctree-l2>a.reference.internal"); 
    for (var i = 0; i < $h2s.length; i++) {
        $($h2s[i]).attr("href",$($h2s[i]).attr("href")+"h2");
    }
    
    var $h2s1 = $("#enibook-main").find("li.toctree-l2>a.reference.internal"); 
    for (var i = 0; i < $h2s1.length; i++) {
        $($h2s1[i]).attr("href",$($h2s1[i]).attr("href")+"h2");
    }
}

//------------------------------------------------------------------------------
function toggleChevron(id) { 
    var elem = $("#" + id);
    if ($(elem).hasClass("glyphicons-chevron-down")) {
        $(elem).removeClass("glyphicons-chevron-down");
        $(elem).addClass("glyphicons-chevron-up");
    }
    else {
        if ($(elem).hasClass("glyphicons-chevron-up")) {
            $(elem).removeClass("glyphicons-chevron-up");
            $(elem).addClass("glyphicons-chevron-down");
        }
    }  
}

//------------------------------------------------------------------------------
function toggleH2(id) { 
    var $h2 = $("#" + id); 
    var $siblings = $($h2).siblings("h2"); 
    for (var i = 0; i < $siblings.length; i++) {
        var $sibling = $siblings[i]; 
        var siblingId = $($sibling).attr('id');
        if (siblingId !== id) {
            var $section = $("#" + siblingId.replace("h2","")); 
            var $chevron = $("#" + siblingId + "-btn");
            $($section).css('display','none');
            if ($($chevron).hasClass("glyphicons-chevron-up")) {
                $($chevron).removeClass("glyphicons-chevron-up");
                $($chevron).addClass("glyphicons-chevron-down");
            }
        }
    }
    
    $.mobile.silentScroll($('#' + id).offset().top);
}

//------------------------------------------------------------------------------
function enibookIntRefs() {
    var $internal_refs = $(".reference.internal"); 
    for (var i = 0; i < $internal_refs.length; i++) {
        var internal_ref = $internal_refs[i];
        $(internal_ref).attr('data-ajax','false');
        $(internal_ref).on("click",{"href": $(internal_ref).attr("href")}, openH2);
    }
}

//------------------------------------------------------------------------------
function openH2(event) { 
    var href = event.data.href; 
    if (href.search(/#/) !== -1) { 
        if (href.search(/h2$/) === -1) {
            var divh2 = $(href).closest(".section[h2]");
            if (divh2.length) {
                if ($(divh2).css('display') === 'none') { 
                    var h2 = "#" + $(divh2).attr('id') + "h2"; 
                    $(h2).click();
                }
            }
        }
        else {
            if ($(href.replace("h2","")).css('display') === 'none') { 
                $(href).click();
            }
            var index = href.indexOf('#');
            if (index !== -1) {
                var div = href.slice(index+1);
                $.mobile.silentScroll($("#" + div).offset().top);
            }
        }
    }
}

//------------------------------------------------------------------------------
function enibookExtRefs() {
    var $external_refs = $(".reference.external");
    for (var i = 0; i < $external_refs.length; i++) {
        $($external_refs[i]).attr('data-ajax','false');
    }
}

//------------------------------------------------------------------------------
function enibookIndexRefs() {
    var $index_refs = $(".indextable.genindextable"); 
    for (var i = 0; i < $index_refs.length; i++) {
        $($index_refs[i]).find("a").attr('data-ajax','false');
    }

    var $jumpbox = $(".genindex-jumpbox");
    for (var i = 0; i < $jumpbox.length; i++) {
        $($jumpbox[i]).find("a").attr('data-ajax','false');
    }
}

//------------------------------------------------------------------------------
function enibookHour() {
    var date = new Date;
    var year = date.getFullYear() - 2000;
    var month = date.getMonth() + 1;
    var day = date.getDate();
    if (month < 10) { month = '0' + month; }
    if (day < 10) { day = '0' + day; }
    var h = date.getHours();
    var m = date.getMinutes();
    var s = date.getSeconds();
    if (h < 10) { h = '0' + h; }
    if (m < 10) { m = '0' + m; }
    if (s < 10) { s = '0' + s; }
    $("#enibook-footer-date").html(day + '/' + month + '/' + year + ' - ' + h +':'+ m + ':' + s);
    setTimeout('enibookHour();','1000');
}

//------------------------------------------------------------------------------
function enibookHelp() { 
    $("#enibook-help-content").html($("#enibook-help-enibook").html());
    var h = (window.innerHeight-120).toString() + "px"; 
    $("#enibook-help-content").css("max-height",h); 
};

//------------------------------------------------------------------------------
function enibookContents() { 
    $("#enibook-version").html(EniBook.version); 
    $toctrees  = $("#enibook-main").find("div.toctree-wrapper.compound");
    if ($toctrees.length == 1) {
        //$($toctrees[0]).css('display','none');
    }
    else {
        $contents = $("#enibook-main").find("div.contents.topic");
        if ($contents.length == 1) {
            var $content = $contents[0];
            var $title = $($content).children("p.topic-title");
            var $ul = $($content).children("ul.simple");

            if ($ul.length == 1) {
                var $section = $($ul).children("li"); 
                var $tableofcontent = $($section).children("ul");
                for (var i = 0; i < $tableofcontent.length; i++) {
                    $("#enibook-tableofcontent-local").append($tableofcontent[i]);
                }
            }
            $("#enibook-tableofcontent-local").append("<a href='genindex.html'>Index</a>");
            $("#enibook-tableofcontent-local").css("font-size","75%");
            $contents.css('display','none');
        }
    }
    var h = (window.innerHeight-120).toString() + "px"; 
    $("#enibook-tableofcontent").css("max-height",h);
};


//------------------------------------------------------------------------------
function drawGrid(canvas,delta,color) { 
    var pen = canvas.getContext("2d");
    pen.strokeStyle = color;

    pen.globalCompositeOperation = 'destination-over';
    // lines
    for(var h = -canvas.height ; h < canvas.height ; h += delta) {
        pen.moveTo(-canvas.width, h); //déplacer le pinceau à (x,y) sans tracer
        pen.lineTo(canvas.width, h); //tracer jusqu'à (x,y)
    }
    // columns
    for(var w = -canvas.width ; w < canvas.width ; w += delta) {
       pen.moveTo(w, -canvas.height);
       pen.lineTo(w, canvas.height);
    }

    pen.moveTo(0,0);
    pen.arc(0,0,5,0,Math.PI*2,true);
    pen.fillStyle = color;
    pen.fill();
    
    pen.stroke();
    pen.globalCompositeOperation = 'source-over';
};

/******************************************************************************
 *
 * MenuProf
 *
 ******************************************************************************/
//------------------------------------------------------------------------------
function MenuProf(id) { // id : HTML identifier
    this.id         = id;
    this.$menuprof  = $("#" + id + "-menuprof");
    this.$svg       = $("#" + id + "-menuprof-svg");
    this.$about     = $("#" + id + "-menuprof-about");

    this.scale();
}

//------------------------------------------------------------------------------
MenuProf.prototype.menu = function() {
    $("#enibook-tableofcontent-btn").click();
    /*
    var $a = $("<a></a>");
    $($a).attr("href","#enibook-tableofcontent");
    $(document.body).append($a); 
    $a.click();
    $($a).remove();
    */
}

//------------------------------------------------------------------------------
MenuProf.prototype.scale = function() {
    var widthDiv = $(this.$menuprof).innerWidth(); 
    var widthSvg = parseInt($(this.$svg).attr("width").replace("px",""));
    var ratio    = widthDiv/widthSvg;
    if (ratio < 1.0) { $(this.$svg).attr("transform","scale(" + ratio.toString() + ")"); }
    else { $(this.$svg).attr("transform","scale(1)"); }
}

//------------------------------------------------------------------------------
MenuProf.prototype.about = function() {
    var msg = $(this.$about).html(); 
    if (msg === "") {
        msg += "<p>Il n'y a pas d'indication particulière pour ce document.</p>";
    }
    $("#enibook-about-main").html(msg);
    $("#enibook-about").popup("open");  
}



/******************************************************************************
 *
 * NotaBene
 *
 ******************************************************************************/
//------------------------------------------------------------------------------
function NotaBene(id) { // id : HTML identifier
    this.id         = id;
    this.$notabene  = $("#" + id + "-notabene");
    this.$content   = $("#" + id + "-notabene-content");

    this.collapse = $(this.$notabene).attr('collapse');
    if (this.collapse === 'false') { $(this.$content).css('display','block'); }
    else { $(this.$content).css('display','none'); }

    renderKatex(this.id + "-notabene");
    //console.log('initializing ',this.id);

}


/******************************************************************************
 *
 * Multisort
 *
 ******************************************************************************/

//------------------------------------------------------------------------------
function Multisort(id) { // id : HTML identifier
    this.id         = id;
    this.tries      = 0;
    this.$multisort = $("#" + id + "-multisort");
    this.$feedback  = $("#" + id + "-multisort-feedback");
    this.$pre       = $("#" + id + "-multisort-pre");
    this.$canvas    = $("#" + id + "-multisort-canvas");
    this.$error     = $("#" + id + "-multisort-error");
    this.$feedbacks = $(this.$multisort).children("div.feedback");
    this.directive  = $(this.$multisort).attr('directive');
    this.title      = $(this.$multisort).attr('title');
    this.modeEnibook= EniBook['mode']; //$(this.$multisort).attr('modeEnibook')
    this.typeEnibook= EniBook['type']; //$(this.$multisort).attr('typeEnibook')

    this.$blocks    = $(this.$multisort).children('.sort-block'); 
    this.$sorts     = [];
    for (var i = 0; i < this.$blocks.length; i++) {
        var sorts = $(this.$blocks[i]).children(".sort"); 
        if (sorts.length === 1) { this.$sorts.push(sorts[0]); }
    }
    
    this.nbsorts    = this.$sorts.length; 

    var nonumber = $(this.$multisort).attr('nonumber');
    if (nonumber == 'true') { $(".sort-header").css('display','none'); }

    $(this.$feedback).attr('class','feedback');
    $(this.$pre).html("");
    $(this.$error).html("");
    $(this.$pre).css('display','none');
    $(this.$canvas).css('display','none');
    $(this.$error).css('display','none');

    //console.log('initializing ',this.id);
    
    //this.update();
}

//------------------------------------------------------------------------------
Multisort.prototype.hide = function() {
    $(this.$multisort).hide();
}

//------------------------------------------------------------------------------
Multisort.prototype.show = function() {
    $(this.$multisort).show();
}

//------------------------------------------------------------------------------
Multisort.prototype.parents = function(selector) {
    return $(this.$multisort).parents(selector);
}

//------------------------------------------------------------------------------
Multisort.prototype.update = function() { 
    var ids = this.sortId(); 
    for (var i = 0; i < ids.length; i++) {
        EniBook[ids[i]].update();
    }
    if (EniBook['mode'] === 'training') { this.feedback(false); }
}

//------------------------------------------------------------------------------
Multisort.prototype.feedbackId = function() { 
    var feedbackId = {};
    if (this.$feedbacks.length <= 2) { 
        for (var i = 0; i < this.$feedbacks.length; i++) { 
            feedbackId[$(this.$feedbacks[i]).attr("type")] = $(this.$feedbacks[i]).attr("id").replace("-feedback","");
        }
    }
    feedbackId.len = this.$feedbacks.length;
    return feedbackId;
}

//------------------------------------------------------------------------------
Multisort.prototype.sortId = function() { 
    var sortId = [];
    for (var i = 0; i < this.$sorts.length; i++) { 
        var id = $(this.$sorts[i]).attr("id");
        var index = id.indexOf("-");
        id = id.slice(0,index); 
        sortId.push(id);
    }
    return sortId; 
}

//------------------------------------------------------------------------------
Multisort.prototype.feedback = function(runCode) { 
    var res = ""; 
    var score = 0;
    var total = 0;
    var ids = this.sortId(); 
    var columns = [];
    var sources = [];
    var uls     = {};
    var lis     = {};

    var user = [];
    this.tries += 1;
    $(this.$feedback).attr('class','feedback-info');
    $(this.$pre).html("");
    $(this.$pre).css('display','none');
    $(this.$canvas).css('display','none');
    
    for (var i = 0; i < ids.length; i++) { 
        EniBook[ids[i]].results = [];
        columns.push(EniBook[ids[i]]);
        sources.push(EniBook[ids[i]].storage.txt);
        uls[ids[i]] = $(this.$sorts[i]).children("ul"); 
        if (uls[ids[i]].length === 1) {
            var $lis = $(uls[ids[i]][0]).children("li");
            $lis.css('background-color','white');
            $lis.css('border-color','rgb(234,138,0)');
            lis[ids[i]] = [];
            for (j = 0; j < $lis.length; j++) {
                var $as = $($lis[j]).find("a"); 
                if ($as.length === 1) {
                    $($as[0]).attr('data-ajax','false');
                }
                lis[ids[i]].push($lis[j]);
            }
        }
    }

    res += "Essai " + this.tries.toString() + " ";

    switch (EniBook['mode']) {
        case 'training' :
        case 'learning' :
            if (ids.length ===  1) { // sort 
                var ul = uls[ids[0]];
                var source = sources[0];
                if (ul.length === 1) {
                    EniBook[ids[0]].results = [];
                    var len = lis[ids[0]].length;
                    total = len;
                    var ok = true;
                    var numero = 0;
                    for (var i = 0; i < len && ok; i++) {
                        score = i;
                        if ($(lis[ids[0]][i]).html() !== source[i]) {
                            ok = false;
                            $(lis[ids[0]][i]).css('background-color','#F2DEDE');
                            $(lis[ids[0]][i]).css('border-color','#F2DEDE');
                        }
                        else { 
                            EniBook[ids[0]].results.push(true);
                            $(lis[ids[0]][i]).css('background-color','#DFF0D8'); 
                            $(lis[ids[0]][i]).css('border-color','#DFF0D8'); 
                        }
                        if (!ok) {
                            for (var k = i; k < len; k++) { EniBook[ids[0]].results.push(false); }
                        }
                    }
                    if (ok) { score = len; }

                    if (ok) { $(this.$feedback).attr('class','feedback-true');  }
                    else    { $(this.$feedback).attr('class','feedback-false'); }

                }
            }
            else { // association 
                var lenuls = uls[ids[0]].length; 
                var lenlis = lis[ids[0]].length;
                var possible = (lenuls == 1 && lenlis > 0);
                for (var i = 1; i < ids.length && possible; i++) {
                    if ( (uls[ids[i]].length !== lenuls) || (lis[ids[i]].length !== lenlis) ) { possible = false; }
                }
                if (possible) { 
                    total = (columns.length - 1)*lenlis;
                    var ok = true; 
                    for (var j = 0; j < lenlis; j++) {
                        var li0  = lis[ids[0]];
                        var item = lis[ids[0]][j]; 
                        var found = false;
                        var index = -1;
                        for (var k = 0; k < sources[0].length && !found; k++) { 
                            if ($(item).html() == sources[0][k]) { 
                                found = true; 
                                index = k;
                            }
                        }
                        if (index !== -1) {
                            for (var i = 1; i < columns.length ; i++) { 
                                if ($(lis[ids[i]][j]).html() !== sources[i][index]) { 
                                    ok = false;
                                    $(lis[ids[i]][j]).css('background-color','#F2DEDE');
                                    $(lis[ids[i]][j]).css('border-color','#F2DEDE');
                                    EniBook[ids[i]].results.push(false);
                                }
                                else { 
                                    score += 1;
                                    EniBook[ids[i]].results.push(true);
                                    $(lis[ids[i]][j]).css('background-color','#DFF0D8');
                                    $(lis[ids[i]][j]).css('border-color','#DFF0D8');
                                }
                            }
                        }
                    }
                    if (ok) { $(this.$feedback).attr('class','feedback-true');  }
                    else    { $(this.$feedback).attr('class','feedback-false'); }
                }
            }
            this.score = score.toString() + "/" + total.toString(); 
            res += "<br />Score : " + this.score + "<br />";
            var feedbacks = this.feedbackId(); 
            if (feedbacks.len != 0) { // feedbacks
                for (f in feedbacks) { 
                    if (f == ok.toString()) { 
                        res += EniBook[feedbacks[f]].feedback(score.toString(),ok,null);
                    }
                }
            }
            if (ids.length === 1) { // sort 
                var code = $(this.$sorts[0]).attr('code'); 
                if (runCode && code === "python") {
                    var prg = "";
                    var $uls = $(this.$sorts[0]).children("ul"); 
                    var $lis = $($uls[0]).children("li");
                    for (var i = 0; i < $lis.length; i++) {
                        prg += '\n' + $($lis[i]).text();
                    }
                    var verif = $(this.$sorts[0]).attr('verif'); 
                    if (verif !== 'undefined') { prg += '\n\n' + verif; }

                    res += "<br /><b>Programme exécuté:</b>" +
                           "<pre style='border-radius: 6px; border:1px solid; padding: 5px;'>" + prg + "</pre>";
                    res += "<b>Résultat:</b><br />";
                    $(this.$feedback).html(res);
                    this.runPython(prg);
                }
            }
            $(this.$feedback).html(res);
            break;
        case 'assessing' :
            var date    = new Date();
            var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
            var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes());
            if (ids.length ==  1) { // sort    
                for (var i = 0; i < lis[ids[0]].length; i++) { 
                    var answer = $(lis[ids[0]][i]).html(); 
                    for (var j = 0; j < sources[0].length; j++) { 
                        var jfound = false;
                        if (answer == sources[0][j]) { 
                            var found = false;
                            for (var k = 0; k < user.length; k++) {
                                if (user[k] === j) { found = true; break; }
                            }
                            if (!found) { user.push(j); jfound = true;}
                        }
                        if (jfound) { break; }
                    }
                }
                EniBook['assessing']['sort'][ids[0]].user = user;
            }
            else { // association  
                for (var s = 0; s < ids.length; s++) {
                    user = [];
                    for (var i = 0; i < lis[ids[s]].length; i++) { 
                        var answer = $(lis[ids[s]][i]).html(); 
                        for (var j = 0; j < sources[s].length; j++) { 
                            var jfound = false;
                            if (answer == sources[s][j]) { 
                                var found = false;
                                for (var k = 0; k < user.length; k++) {
                                    if (user[k] === j) { found = true; break; }
                                }
                                if (!found) { user.push(j); jfound = true;}
                            }
                            if (jfound) { break; }
                        }
                    }
                    //EniBook['assessing']['sort'][ids[0]].user = user;
                    EniBook['assessing']['sort'][ids[s]].user = user; 
                }                 
            }
            res += "mémorisé à " + hour + "h" + minutes + ".<br />"; 
            $(this.$feedback).attr('class','feedback-info');  
            $(this.$feedback).html(res);
            break;
        default:
            break;
    }
}

//------------------------------------------------------------------------------
Multisort.prototype.builtinRead = function(x) {
    if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
        throw "File not found: '" + x + "'";
    return Sk.builtinFiles["files"][x];
}

//------------------------------------------------------------------------------
Multisort.prototype.outf = function(txt) { 
    $(this.$pre).append(txt);
}

//------------------------------------------------------------------------------
Multisort.prototype.runPython = function(prg) { 
    Sk.divid     = this.id + "-multisort-textarea";
    Sk.canvas    = this.id + "-multisort-canvas";
    Sk.pre       = this.id + "-multisort-pre";
    Sk.error     = this.id + "-multisort-error";
    Sk.execLimit = 10000;

    $("#" + Sk.divid).html(prg);    
    $(this.$pre).css('display','block');
    $(this.$error).css('display','block');
    $(this.$canvas).css('display','block');

    var multisortId = this.id;
    Sk.configure({
        output: outf,
        read: builtinRead
    });
    (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = Sk.canvas;
    var width = parseInt($(this.$canvas).css('width'));
    var delta = 10;
    width = width - width%delta; 
    Sk.TurtleGraphics['width']  = width;
    
    if (Math.abs(width - window.innerWidth) < 80) { Sk.TurtleGraphics['height'] = width; }
    else {  Sk.TurtleGraphics['height'] = width/2; }

    var myPromise = Sk.misceval.asyncToPromise(function() { 
        return Sk.importMainWithBody("<stdin>", false, prg, true);
    });
    myPromise.then(
        function(mod) { 
            var canvas = $("#" + Sk.canvas).children("canvas"); 
            if (canvas.length > 0) { drawGrid(canvas[0],delta,'rgba(211,211,211,0.2)'); }
            $("#" + Sk.error).text("");
            $("#" + Sk.error).css('display','none');
        },
        function(err) { $("#" + Sk.error).append("<p style='color: red;'>" + err.toString() + "</p>"); }
    );

}


/******************************************************************************
 *
 * Sort
 *
 ******************************************************************************/

//------------------------------------------------------------------------------
function Sort(id,numero) { // id : HTML identifier
    this.id          = id;
    this.numero      = numero
    this.$sort       = $("#" + id + "-sort-" + numero);
    this.direction   = $(this.$sort).attr("direction"); 
    this.directive   = $(this.$sort).attr('directive'); 
    this.title       = $("#" + id + "-sort-block").attr('title');
    this.storage        = {};
    this.storage.txt    = [];
    this.storage.tirage = [];
    this.results        = [];

    var $ols = $(this.$sort).children('ol'); 
    if ($ols.length == 1) {
        var $lis = $($ols[0]).children('li');
        var dir = (this.direction === 'rtl') ? 'right' : 'left';
        for (var i = 0; i < $lis.length; i++) {
            var $as = $($lis[i]).find("a");
            if ($as.length === 1) {
                $($as[0]).attr('data-ajax','false');
            }
            var txt = '<div class="sort-li" style="direction: ' + this.direction + 
                      '; text-align: ' + dir + ';">' + $($lis[i]).html() +
                      '</div>';
            this.storage.txt.push(txt);
        }
    }

    $($ols).remove();

    var $ul = $("<ul></ul>");
    $(this.$sort).append($ul);
    $($ul).addClass('sort-list');
    $($ul).sortable({placeholder: 'sort-placeholder', forcePlaceholderSize: true});
    $($ul).disableSelection();
    this.$ul = $ul;

    this.update();
};

//------------------------------------------------------------------------------
Sort.prototype.parents = function(selector) {
    return $(this.$sort).parents(selector);
}


//------------------------------------------------------------------------------
Sort.prototype.update = function() {  
    var len = this.storage.txt.length;
    $(this.$ul).html(""); 
    this.storage.tirage = [];
    this.results        = [];

    switch (EniBook['mode']) {
        case 'learning' :
            for (var i = 0; i < len; i++) {
                k = Math.floor(Math.random() * len);
                while (this.storage.tirage.indexOf(k) != -1) { k = Math.floor(Math.random() * len); };
                this.storage.tirage.push(k);
            }
            break;
        case 'training' :
        case 'assessing' : 
            if (EniBook['assessing'][this.directive][this.id].user.length !== 0) { 
                this.storage.tirage = EniBook['assessing'][this.directive][this.id].user; 
            }
            else { 
                this.storage.tirage = EniBook['assessing'][this.directive][this.id].items; 
            }
            break;
        default:
            break;
    }   

    for (var i = 0; i < len; i++) {
        var $li = '<li class="ui-sortable-handle" ' +
                  'onclick="$(this).css(\'background-color\',\'white\');' + 
                  '$(this).css(\'border-color\',\'rgb(234,138,0)\');">' + 
                  this.storage.txt[this.storage.tirage[i]] + 
                  '</li>';
        $(this.$ul).append($li);
    }
};

//------------------------------------------------------------------------------
Sort.prototype.feedback = function() {   
};
  
/******************************************************************************
 *
 * Multicolumn
 *
 ******************************************************************************/

//alert('Multicolumn');
//------------------------------------------------------------------------------
function Multicolumn(id) { // id : HTML identifier
    this.id           = id;
    this.$multicolumn = $("#" + id + "-multicolumn");
    this.$btns        = $("#" + id + "-multicolumn-btns");
    this.$nbcols      = $("#" + id + "-multicolumn-nbcols");
    this.$footer      = $("#" + id + "-multicolumn-footer");
    this.$buttons     = $(this.$btns).find('button');
    this.$columns     = $(this.$multicolumn).children('.column'); 

    var columns = parseInt($(this.$multicolumn).attr('multicol')); 
    if (columns === this.$buttons.length) { 
        for (var i = 0; i < columns; i++) { 
            var collapseColumn = $(this.$columns[i]).attr('collapse'); 
            if (collapseColumn === 'true') {
                $(this.$buttons[i]).removeClass('ui-btn-active');
            }
            else {
                $(this.$buttons[i]).addClass('ui-btn-active');
            }
        }
    }

    var collapse = $(this.$multicolumn).attr('collapse');
    $(this.$btns).css('display','none');
    $(this.$nbcols).css('display','inline-block');
    $(this.$multicolumn).css('display','none');
    $(this.$footer).css('display','none');
    if (collapse === 'false') { this.update(); }
    //console.log('initializing ',this.id);
};

//------------------------------------------------------------------------------
Multicolumn.prototype.update = function() {     
    var columns = parseInt($(this.$multicolumn).attr('multicol')); 

    if ($(this.$btns).css('display') !== 'inline-block') {
        $(this.$btns).css('display','inline-block');
        $(this.$nbcols).css('display','none');
        $(this.$multicolumn).css('display','block');
        $(this.$footer).css('display','block');
        if (columns === this.$buttons.length) { 
            for (var i = 0; i < columns; i++) { 
                if ($(this.$buttons[i]).attr('class').search('ui-btn-active') != -1) {
                    $(this.$columns[i]).css('display','block');
                }
                else {
                    $(this.$columns[i]).css('display','none');
                }
            }
        }
        //$.mobile.silentScroll($("#" + this.id + "-multicolumn-head").offset().top);
    }
    else {
        $(this.$btns).css('display','none');
        $(this.$nbcols).css('display','inline-block');
        for (var i = 0; i < this.$columns.length; i++) { 
            $(this.$columns[i]).css('display','none');
        }
        $(this.$multicolumn).css('display','none');
        $(this.$footer).css('display','none');
    }
};

//------------------------------------------------------------------------------
Multicolumn.prototype.feedback = function(button) {     
    var numero  = parseInt($(button).attr('numero'));
    var column  = String.fromCharCode((numero-1) + 'a'.charCodeAt(0));
   
    var found = false;
    for (var i = 0; i < this.$columns.length; i++) {
        if ($(this.$columns[i]).attr('id').search("-column-" + column) != -1) {
           if ($(button).attr('class').search('ui-btn-active') != -1) {
                $(this.$columns[i]).css('display','block');
            }
            else {
                $(this.$columns[i]).css('display','none');
            }
        }
    }              
};

//------------------------------------------------------------------------------
Multicolumn.prototype.btnActive = function(button) {  
    if ($(button).attr('class').search('ui-btn-active') != -1) {
        $(button).removeClass('ui-btn-active');
    }
    else {
        $(button).addClass('ui-btn-active');
    }
};


//alert('block');
/******************************************************************************
 *
 * Block
 *
 ******************************************************************************/

//------------------------------------------------------------------------------
function Block(id) {
    this.id       = id;
    this.$block   = $("#" + id + "-block");
    this.$btn     = $("#" + id + "-block-btn");
    this.$levels  = $("#" + id + "-block-btn-items");
    this.$content = $("#" + id + "-block-content");

    var $ols     = $(this.$content).children("ol");
    var $uls     = $(this.$content).children("ul");
    var $dls     = $(this.$content).children("dl"); 
    var $tables  = $(this.$content).children("table");
    
    var levels   = $(this.$block).attr('levels');
    if (levels == 'true') { 
        $(this.$levels).css('display','inline');
    }

    if ($ols.length == 1 && $uls.length == 0 && $dls.length == 0 && $tables.length == 0) {       
        var $lis = $($ols[0]).children("li");
        $($ols[0]).css('margin-left','10px');
        //$($lis).css('list-style-position','inside');
        $(this.$block).attr('maxitems',$lis.length.toString());
        $(this.$block).attr('items','0');
        for (var i = 0; i < $lis.length; i++) {
            $($lis[i]).css('display','none');
        }
    }
    else {
        if ($ols.length == 0 && $uls.length == 1 && $dls.length == 0 && $tables.length == 0) {
            $($uls[0]).css('margin-left','10px');
            var $lis = $($uls[0]).children("li");
            //$($lis).css('list-style-position','inside');
            $(this.$block).attr('maxitems',$lis.length.toString());
            $(this.$block).attr('items','0');
            for (var i = 0; i < $lis.length; i++) {
                $($lis[i]).css('display','none');
            }
        }
        else {
            if ($ols.length == 0 && $uls.length == 0 && $dls.length == 1 && $tables.length == 0) {
                var $dts = $($dls[0]).children("dt");
                var $dds = $($dls[0]).children("dd"); 
                $(this.$block).attr('maxitems',$dts.length.toString());
                $(this.$block).attr('items','0');
                for (var i = 0; i < $dts.length; i++) {
                    $($dts[i]).css('display','none');
                    $($dds[i]).css('display','none'); 
                }
            } 
            else {
                if ($ols.length == 0 && $uls.length == 0 && $dls.length == 0 && $tables.length == 1) {
                    var $caption = $($tables[0]).children("caption");
                    if ($caption.length == 1) {
                        $($caption).css('display','none');
                        $("#" + id + "-block-title").html($($caption).html()); 
                    }
                    var $trs = $($tables[0]).find("tr");
                    $(this.$block).attr('maxitems',$trs.length.toString());
                    $(this.$block).attr('items','0');
                    for (var i = 0; i < $trs.length; i++) {
                        $($trs[i]).css('display','none');
                    }
                }
                else {
                    $(this.$block).attr('maxitems','single');
                    $(this.$block).attr('items','0');
                    $(this.$content).css('display','none');
                    $(this.$levels).css('display','none');
                }
            }
        }
    }

    var maxitems = $(this.$block).attr('maxitems');
    if (maxitems != 'single') {
        if (parseInt(maxitems) > 1) {
            $(this.$levels).html(maxitems);
        }
    }
    
    var collapse = $(this.$block).attr('collapse'); 
    if (collapse == 'false') {
        var maxitems = $(this.$block).attr('maxitems');
        if (maxitems == 'single') {
            $(this.$block).attr('collapse','true'); 
            this.feedback();
        }
        else {
            for (var i = 0; i < maxitems; i++) {
                this.feedback();
            }
        }
    }
    //console.log('initializing ',this.id);
    renderKatex(this.id + "-block");
}

//------------------------------------------------------------------------------
Block.prototype.update = function() {
    var maxitems  = $(this.$block).attr('maxitems'); 

    if (maxitems == 'single') {
        $(this.$btn).removeClass("glyphicons glyphicons-chevron-up");
        $(this.$btn).addClass("glyphicons glyphicons-chevron-down");
        $(this.$content).css("display","none"); 
        $(this.$block).attr("collapse","true"); 
    }
    else {
        $(this.$btn).removeClass("glyphicons glyphicons-chevron-up");
        $(this.$btn).addClass("glyphicons glyphicons-chevron-down");
        $(this.$content).css("display","none"); 
        $(this.$block).attr("collapse","true"); 
        $(this.$block).attr('items','0');
        if (parseInt(maxitems) > 1) {
            $(this.$levels).html(maxitems);
        }
    }
}

//------------------------------------------------------------------------------
Block.prototype.feedback = function() {
    var $maxitems = $(this.$block).attr('maxitems'); 
    var $items    = $(this.$block).attr('items');
    var items     = parseInt($items);
    
    if ($maxitems == 'single') {
        if ($(this.$block).attr("collapse") == "true") { 
            $(this.$btn).removeClass("glyphicons glyphicons-chevron-down");
            $(this.$btn).addClass("glyphicons glyphicons-chevron-up");
            $(this.$content).css("display","block");
            $(this.$block).attr("collapse","false");
        }
        else { 
            $(this.$btn).removeClass("glyphicons glyphicons-chevron-up");
            $(this.$btn).addClass("glyphicons glyphicons-chevron-down");
            $(this.$content).css("display","none"); 
            $(this.$block).attr("collapse","true"); 
        }
    }
    else {
        var maxitems = parseInt($maxitems);
        if (items == maxitems) {
            $(this.$btn).removeClass("glyphicons glyphicons-chevron-up");
            $(this.$btn).addClass("glyphicons glyphicons-chevron-down");
            $(this.$content).css("display","none"); 
            $(this.$block).attr("collapse","true"); 
            $(this.$block).attr('items','0');
            $(this.$levels).html($maxitems);
        }
        else {
            if (items == 0) {
                $(this.$content).css("display","block");
                $(this.$block).attr("collapse","false");
            }
            if (items + 1 == maxitems) {
                $(this.$btn).removeClass("glyphicons glyphicons-chevron-down");
                $(this.$btn).addClass("glyphicons glyphicons-chevron-up");            
            }
            var $ols     = $(this.$content).children("ol");
            var $uls     = $(this.$content).children("ul");
            var $dls     = $(this.$content).children("dl");
            var $tables  = $(this.$content).children("table"); 
            if ($ols.length == 1 && $uls.length == 0 && $dls.length == 0 && $tables.length == 0) {
                var $lis = $($ols[0]).children("li");
                for (var i = 0; i < maxitems; i++) {
                    if (i <= items) { $($lis[i]).css('display','list-item'); }
                    else { $($lis[i]).css('display','none'); }
                }
            }
            else {
                if ($ols.length == 0 && $uls.length == 1 && $dls.length == 0 && $tables.length == 0) {
                    var $lis = $($uls[0]).children("li");
                    for (var i = 0; i < maxitems; i++) {
                        if (i <= items) { $($lis[i]).css('display','list-item'); }
                        else { $($lis[i]).css('display','none'); }
                    }
                }
                else {
                    if ($ols.length == 0 && $uls.length == 0 && $dls.length == 1 && $tables.length == 0) {
                        var $dts = $($dls[0]).children("dt"); 
                        var $dds = $($dls[0]).children("dd");
                        for (var i = 0; i < maxitems; i++) {
                            if (i <= items) { 
                                $($dts[i]).css('display','block'); 
                                $($dds[i]).css('display','block');
                            }
                            else { 
                                $($dts[i]).css('display','none');
                                $($dds[i]).css('display','none'); 
                            }
                        }
                    }
                    else {
                        if ($ols.length == 0 && $uls.length == 0 && $dls.length == 0 && $tables.length == 1) {
                            var $trs = $($tables[0]).find("tr"); 
                            for (var i = 0; i < maxitems; i++) {
                                if (i <= items) { $($trs[i]).css('display','table-row'); }
                                else { $($trs[i]).css('display','none'); }
                            }
                        }
                    }
                }
            }
            $(this.$block).attr('items',(items+1).toString());
            var rest = maxitems-(items+1);
            if (rest != 0) { $(this.$levels).html(rest.toString()); }
            else { $(this.$levels).html(''); }
        }
    }
    refreshEditors(this.id + '-block');
    //refreshDiagrams(this.id + '-block');
    var $diagrams = $("#" + this.id + '-block').find(".graph"); 
    for (var i = 0; i < $diagrams.length; i++) { 
        var id = $($diagrams[i]).attr("id").replace("-graph",""); 
        EniBook[id].refresh();
    }
    renderKatex(this.id + '-block');
};


/******************************************************************************
 *
 * MCQ
 *
 ******************************************************************************/

//------------------------------------------------------------------------------
function Mcq(id) { // id : HTML identifier
    this.id        = id;
    this.$mcq      = $("#" + id + "-mcq");
    this.$feedback = $("#" + id + "-mcq-feedback");
    this.$ol       = $(this.$mcq).children("ol"); 
    this.collapse  = $(this.$mcq).attr('collapse');
    this.norandom  = $(this.$mcq).attr('norandom');
    this.choices   = parseInt($(this.$mcq).attr('choices'));
    this.tries     = 0;
    this.storage   = {};
    this.storage.qmcqs = [];   
    this.directive = $(this.$mcq).attr('directive'); 
    this.title     = $(this.$mcq).attr('title'); 
    this.modeEnibook= EniBook['mode']; 
    this.typeEnibook= EniBook['type'];    

    if (this.$ol.length === 1) {
        var $lis = $(this.$ol[0]).children("li"); 
        for (var i = 0; i < $lis.length; i++) {
            this.storage.qmcqs.push($lis[i]);
        }
    }

    $(this.$mcq).css('display',(this.collapse === 'true' ? 'none' : 'block'));

    this.update(); 
    //console.log('initializing ',this.id);
};

//------------------------------------------------------------------------------
Mcq.prototype.hide = function() {
    $(this.$mcq).hide();
}

//------------------------------------------------------------------------------
Mcq.prototype.show = function() {
    $(this.$mcq).show();
}

//------------------------------------------------------------------------------
Mcq.prototype.parents = function(selector) {
    return $(this.$mcq).parents(selector);
}

//------------------------------------------------------------------------------
Mcq.prototype.qmcqId = function() { 
    var ids = [];
    var $qmcqs = $(this.$mcq).find("div.q-mcq");

    for (var i = 0; i < $qmcqs.length; i++) {
        var $qmcq = $qmcqs[i];
        var qmcqid = $($qmcq).attr('id').replace('-q-mcq','');
        ids.push(qmcqid);
    }
    return ids;
}

//------------------------------------------------------------------------------
Mcq.prototype.update = function() { 
    var $qmcqs = $(this.$mcq).find("div.q-mcq");
    var len = $qmcqs.length;
    var k = 0;

    switch (EniBook['mode']) {
        case 'learning' :
            this.storage.tirage = []; 
            for (var j = 0; j < len; j++) {       
                if (this.norandom === 'false') {
                    k = Math.floor(Math.random() * len);
                    while (this.storage.tirage.indexOf(k) != -1) { k = Math.floor(Math.random() * len); };
                }
                else { k = j; }
                this.storage.tirage.push(k);
            }
            break;
        case 'assessing' : 
            this.storage.tirage = EniBook['assessing'][this.directive][this.id].items;
            break;
        case 'training' :
            this.storage.tirage = EniBook['assessing'][this.directive][this.id].items;
            break;
        default:
            break;
    }

    for (var i = 0; i < len; i++) {
        $(this.$ol[0]).append(this.storage.qmcqs[this.storage.tirage[i]]);
    }

    var $lis = $(this.$ol[0]).children("li"); 
    for (var i = 0; i < $lis.length; i++) {
        if (i < this.choices) {
            $($lis[i]).css('display','list-item');
            var $qmcq  = $($lis[i]).children('div.q-mcq'); 
            var qmcqid = $($qmcq).attr('id').replace('-q-mcq',''); 
            EniBook[qmcqid].update(); 
        }
        else {
            $($lis[i]).css('display','none');
        }
    }
    
    if (EniBook['mode'] === 'training') { 
        var parents = $(this.$mcq).parents(".question"); 
        if (parents.length > 0) {
            var parent = parents[0];
            var id = $(parent).attr('id') + "-question-div"; 
        }
        $(this.$feedback).css('display','block');
        //this.feedback(); 
        //$.mobile.silentScroll($("#" + this.id + "-mcq-btns").offset().top); 
    }
    else {
        $(this.$feedback).css('display','none');
        //$.mobile.silentScroll($("#" + this.id + "-mcq-spanid").offset().top); 
    }

};

//------------------------------------------------------------------------------
Mcq.prototype.feedback = function() {
    var $lis = $(this.$ol[0]).children("li");  

    var qcmall       = 0;
    var qcmundefined = 0;
    var qcmtrue      = 0;
    var qcmfalse     = 0;
    var qcmvalid     = qcmtrue + qcmfalse;

    var checkboxUndefined = 0;
    var radioUndefined    = 0;
    var allUndefined      = 0;

    var checkboxTrue  = 0;
    var checkboxFalse = 0;
    var checkboxAll   = 0;

    var radioTrue     = 0;
    var radioFalse    = 0;
    var radioAll      = 0;

    this.tries += 1;

    for (var i = 0; i < $lis.length; i++) {
        if (i < this.choices) {
            var $qmcq = $($lis[i]).children("div.q-mcq");
            var ok = $($qmcq[0]).attr('ok');
            if (ok === 'true')  { 
                if ($($qmcq[0]).attr('type') === 'checkbox') { 
                    var ckbTrue = parseInt($($qmcq[0]).attr('nbTrue'));
                    var ckbFalse= parseInt($($qmcq[0]).attr('nbFalse'));
                    checkboxTrue  += ckbTrue;
                    checkboxFalse += ckbFalse;
                }
                else { 
                    radioTrue += 1; 
                }    
            }
            else {
                if (ok === 'false') { 
                    if ($($qmcq[0]).attr('type') === 'checkbox') {
                        var ckbTrue = parseInt($($qmcq[0]).attr('nbTrue'));
                        var ckbFalse= parseInt($($qmcq[0]).attr('nbFalse'));
                        checkboxTrue  += ckbTrue;
                        checkboxFalse += ckbFalse;
                    }
                    else { 
                        radioFalse += 1; 
                    }    
                }
                else { // ok == 'undefined'
                    if ($($qmcq[0]).attr('type') === 'checkbox') { 
                        checkboxUndefined += parseInt($($qmcq[0]).attr('items'));
                    }
                    else { 
                        radioUndefined += 1; 
                    }    
                }
            }
        }
    }

    allUndefined = radioUndefined + checkboxUndefined;

    var id = this.id;
    $('#' + id + '-mcq-feedback-all-radio').html((radioFalse+radioTrue+radioUndefined).toString());
    $('#' + id + '-mcq-feedback-all-checkbox').html((checkboxFalse+checkboxTrue+checkboxUndefined).toString());
    $('#' + id + '-mcq-feedback-all').html((radioFalse+radioTrue+radioUndefined+checkboxFalse+checkboxTrue+checkboxUndefined).toString());

    $('#' + id + '-mcq-feedback-undefined-radio').html(radioUndefined.toString());
    $('#' + id + '-mcq-feedback-undefined-checkbox').html(checkboxUndefined.toString());
    $('#' + id + '-mcq-feedback-undefined').html(allUndefined.toString());

    $('#' + id + '-mcq-feedback-valid-radio').html((radioFalse+radioTrue).toString());
    $('#' + id + '-mcq-feedback-valid-checkbox').html((checkboxFalse+checkboxTrue).toString());
    $('#' + id + '-mcq-feedback-valid').html((radioFalse+radioTrue+checkboxFalse+checkboxTrue).toString());

    $('#' + id + '-mcq-feedback-valid-percent-radio').html(Math.round(100*(radioFalse+radioTrue)/(radioFalse+radioTrue+radioUndefined)).toString()+'%');
    $('#' + id + '-mcq-feedback-valid-percent-checkbox').html(Math.round(100*(checkboxFalse+checkboxTrue)/(checkboxFalse+checkboxTrue+checkboxUndefined)).toString()+'%');
    $('#' + id + '-mcq-feedback-valid-percent').html(Math.round(100*((radioFalse+radioTrue+checkboxFalse+checkboxTrue)/(radioFalse+radioTrue+radioUndefined+checkboxFalse+checkboxTrue+checkboxUndefined))).toString()+'%');

    if (EniBook['mode'] !== 'assessing') { // learning or training mode
        $('#' + id + '-mcq-feedback-false-radio').html(radioFalse.toString());
        $('#' + id + '-mcq-feedback-false-checkbox').html(checkboxFalse.toString());
        $('#' + id + '-mcq-feedback-false').html((radioFalse + checkboxFalse).toString());

        $('#' + id + '-mcq-feedback-true-radio').html(radioTrue.toString());
        $('#' + id + '-mcq-feedback-true-checkbox').html(checkboxTrue.toString());
        $('#' + id + '-mcq-feedback-true').html((radioTrue + checkboxTrue).toString());
    
        $('#' + id + '-mcq-feedback-true-percent-radio').html(Math.round(100*(radioTrue/(radioTrue+radioFalse))).toString()+'%');
        $('#' + id + '-mcq-feedback-true-percent-checkbox').html(Math.round(100*(checkboxTrue/(checkboxTrue+checkboxFalse))).toString()+'%');
        $('#' + id + '-mcq-feedback-true-percent').html(Math.round(100*(radioTrue + checkboxTrue)/(radioTrue + checkboxTrue + radioFalse + checkboxFalse)).toString()+'%');
    
        $('#' + id + '-mcq-feedback-all-true-percent-radio').html(Math.round(100*(radioTrue/(radioTrue+radioFalse+radioUndefined))).toString()+'%');
        $('#' + id + '-mcq-feedback-all-true-percent-checkbox').html(Math.round(100*(checkboxTrue/(checkboxTrue+checkboxFalse+checkboxUndefined))).toString()+'%');
        $('#' + id + '-mcq-feedback-all-true-percent').html(Math.round(100*((radioTrue+checkboxTrue)/(radioTrue+radioFalse+radioUndefined+checkboxTrue+checkboxFalse+checkboxUndefined))).toString()+'%');
    }
    else { // assessing mode
        $('#' + id + '-mcq-feedback-false-radio').css('display','none');
        $('#' + id + '-mcq-feedback-false-checkbox').css('display','none');
        $('#' + id + '-mcq-feedback-false-label').css('display','none');
        $('#' + id + '-mcq-feedback-false').css('display','none');

        $('#' + id + '-mcq-feedback-true-radio').css('display','none');
        $('#' + id + '-mcq-feedback-true-checkbox').css('display','none');
        $('#' + id + '-mcq-feedback-true-label').css('display','none');
        $('#' + id + '-mcq-feedback-true').css('display','none');
    
        $('#' + id + '-mcq-feedback-true-percent-radio').css('display','none');
        $('#' + id + '-mcq-feedback-true-percent-checkbox').css('display','none');
        $('#' + id + '-mcq-feedback-true-percent-label').css('display','none');
        $('#' + id + '-mcq-feedback-true-percent').css('display','none');
    
        $('#' + id + '-mcq-feedback-all-true-percent-radio').css('display','none');
        $('#' + id + '-mcq-feedback-all-true-percent-checkbox').css('display','none');
        $('#' + id + '-mcq-feedback-all-true-percent-label').css('display','none');
        $('#' + id + '-mcq-feedback-all-true-percent').css('display','none');
    }
    $(this.$feedback).css('display','block');
};

/******************************************************************************
 *
 * QMcq
 *
 ******************************************************************************/
//------------------------------------------------------------------------------
function QMcq(id) { // id : HTML identifier
    this.id         = id;
    this.$qmcq      = $("#" + id + "-q-mcq");
    this.$content   = $("#" + id + "-q-mcq-content");
    this.$feedback  = $("#" + id + "-q-mcq-feedback");
    this.$title     = $("#" + id + "-q-mcq-title");
    this.$feedbacks = $(this.$qmcq).children("div.feedback");
    this.directive  = $(this.$qmcq).attr('directive'); 
    this.modeEnibook= EniBook['mode']; 
    this.typeEnibook= EniBook['type'];    
    this.truth      = $(this.$qmcq).attr('truth'); 
    this.type       = $(this.$qmcq).attr('type');
    this.parent     = $(this.$qmcq).attr('mcq');
    this.items      = $(this.$qmcq).attr('items'); 
    this.tries      = 0;
    this.storage    = {};
    this.storage.items = [];
    this.storage.truth = [];
    this.storage.feedback = {checked : [], unchecked : []};
    this.title = $(this.$title).html();

    //if (EniBook['mode'] === 'learning') {
        var $ols = $(this.$qmcq).children("ol"); 
        if ($ols.length == 1) {
            for (var i = 0; i < $ols.length; i++) {
                $lis = $($ols[i]).children('li');
                for (var j = 0; j < $lis.length; j++) {
                    this.storage.items.push($($lis[j]).html()); 
                    if (this.truth.search((j+1).toString()) != -1) { 
                        this.storage.truth.push(true); 
                    }
                    else { this.storage.truth.push(false); }
                }
            }
        }
        $($ols).remove();
    //}
    this.update();
    //console.log('initializing ',this.id);

};

//------------------------------------------------------------------------------
QMcq.prototype.hide = function() {
    $(this.$content).hide();
}

//------------------------------------------------------------------------------
QMcq.prototype.show = function() {
    $(this.$content).show();
}

//------------------------------------------------------------------------------
QMcq.prototype.parents = function(selector) {
    return $(this.$qmcq).parents(selector);
}

//------------------------------------------------------------------------------
QMcq.prototype.update = function() {    
    var $help     = $(this.$qmcq).find("div.help"); 
    var lgr       = parseInt(this.items); 

    $(this.$feedback).removeClass('feedback-true');
    $(this.$feedback).removeClass('feedback-false');
    $(this.$feedback).removeClass('feedback-info');
    $(this.$feedback).addClass('feedback');

    this.storage.tirage = [];
    switch (EniBook['mode']) {
        case 'learning' :
            for (var j = 0; j < lgr; j++) {
                k = Math.floor(Math.random() * lgr);
                while (this.storage.tirage.indexOf(k) != -1) { k = Math.floor(Math.random() * lgr); };
                this.storage.tirage.push(k);
            }
            break;
        case 'assessing' : 
            this.storage.tirage = EniBook['assessing'][this.directive][this.id].items;
            break;
        case 'training' : 
            this.storage.tirage = EniBook['assessing'][this.directive][this.id].items;
            break;
        default :
            break;
    }
    
    var $labels = $(this.$content).find('label'); 
    var $inputs = $(this.$content).find('input');
    for (var i = 0; i < $labels.length; i++) {
        $($labels[i]).html((i+1).toString() + ': ' + this.storage.items[this.storage.tirage[i]]);
        if (EniBook['mode'] !== 'assessing') { $($labels[i]).attr('actual',this.storage.truth[this.storage.tirage[i]]); }

        if (this.type == 'radio') { 
            switch (EniBook['mode']) {
                case 'assessing' :
                    var user = EniBook['assessing'][this.directive][this.id].user;
                    if (user.length === 1 && user[0] === i) { 
                        $($labels[i]).removeClass('ui-radio-off');
                        $($labels[i]).addClass('ui-radio-on'); 
                        $($inputs[i]).attr('data-cacheval','false');                      
                    }
                    else {
                        $($labels[i]).removeClass('ui-radio-on');
                        $($labels[i]).addClass('ui-radio-off'); 
                        $($inputs[i]).attr('data-cacheval','true');                   
                    }
                    break;
                case 'training' :
                    var user = EniBook['assessing'][this.directive][this.id].user;
                    if (user.length === 1 && user[0] === i) { 
                        $($labels[i]).removeClass('ui-radio-off');
                        $($labels[i]).addClass('ui-radio-on'); 
                        $($inputs[i]).attr('data-cacheval','false');                      
                    }
                    else {
                        $($labels[i]).removeClass('ui-radio-on');
                        $($labels[i]).addClass('ui-radio-off'); 
                        $($inputs[i]).attr('data-cacheval','true');                   
                    }
                    break;
                default :
                    $($labels[i]).removeClass('ui-radio-on');
                    $($labels[i]).addClass('ui-radio-off');
                    $($inputs[i]).attr('data-cacheval','true');
            }
        }
        else { // type == 'checkbox'
            switch (EniBook['mode']) {
                case 'training' :
                    var user = EniBook['assessing'][this.directive][this.id].user;
                    if (user.find(function(val) { return val === i; }) != undefined) {
                        $($labels[i]).removeClass('ui-checkbox-off');
                        $($labels[i]).addClass('ui-checkbox-on');
                        $($inputs[i]).attr('data-cacheval','false'); 
                    }
                    else {
                        $($labels[i]).removeClass('ui-checkbox-on');
                        $($labels[i]).addClass('ui-checkbox-off');
                        $($inputs[i]).attr('data-cacheval','true'); 
                    }
                    break;
                case 'assessing' :
                    var user = EniBook['assessing'][this.directive][this.id].user;
                    if (user.find(function(val) { return val === i; }) != undefined) {
                        $($labels[i]).removeClass('ui-checkbox-off');
                        $($labels[i]).addClass('ui-checkbox-on');
                        $($inputs[i]).attr('data-cacheval','false'); 
                    }
                    else {
                        $($labels[i]).removeClass('ui-checkbox-on');
                        $($labels[i]).addClass('ui-checkbox-off');
                        $($inputs[i]).attr('data-cacheval','true'); 
                    }
                    break;
                default :
                    $($labels[i]).removeClass('ui-checkbox-on');
                    $($labels[i]).addClass('ui-checkbox-off');
                    $($inputs[i]).attr('data-cacheval','true');
            }
        }  
    } 

    for (var i = 0; i < $help.length; i++) {
        var help = $($help[i]);
        updateHelp($(help).attr('id').replace('-help',''));
    }

    if(EniBook['mode'] !== 'training') { $(this.$qmcq).attr('ok','undefined'); }
    if (typeof MathJax != "undefined") { MathJax.Hub.Typeset(this.id + "-q-mcq"); }
    renderKatex(this.id + "-q-mcq");
};

//------------------------------------------------------------------------------
QMcq.prototype.feedbackId = function() {
    var feedbackId = {};
    
    if (this.$feedbacks.length <= 2) { 
        for (var i = 0; i < this.$feedbacks.length; i++) { 
            feedbackId[$(this.$feedbacks[i]).attr("type")] = $(this.$feedbacks[i]).attr("id").replace("-feedback","");
        }
    }
    feedbackId.len = this.$feedbacks.length;
    return feedbackId;
};

//------------------------------------------------------------------------------
QMcq.prototype.feedback = function() { 
    this.answer   = [];
    this.rawanswer= [];
    var comment  = ""; 
    var feedback = "";
    var $labels  = $(this.$content).find('label'); 

    this.tries += 1;

    var len      = parseInt(this.items);
    var radio    = [];
    var checkbox = [];
 
    for (var i = 0; i < len; i++) { this.answer.push('0'); this.rawanswer.push(false); }

    if (this.type == 'radio') {
        var found = false;
        var ok = false;
        var nbTrue = 0;
        var nbFalse = 0;
        for (var i = 0; i < $labels.length && !found; i++) {
            var classes = $($labels[i]).attr('class');
            if (classes.search('ui-radio-on') != -1) {
                found = true;
                radio.push(i); 
                if ($($labels[i]).attr('actual') == 'true') { ok = true; }
                this.answer[this.storage.tirage[i]] = '1';
                this.rawanswer[i] = true;
            }
        }
        if (ok == true)  { nbTrue = 1; nbFalse = 0; }
        if (ok == false) { nbTrue = 0; nbFalse = 1; }
        this.score = nbTrue.toString() + "/1";
        feedback += "Essai " + this.tries.toString() + " ";
        if (EniBook['mode'] !== 'assessing') { // learning or training mode
            feedback += "<br />Score : " + nbTrue.toString() + "/1 <br />"; 
            if (!found) { feedback += "Il faut sélectionner un item !"; }
        }
        else { // assessing mode
            if (!found) { feedback += "non mémorisé. Il faut sélectionner un item !"; }
            else {
                var date    = new Date();
                var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
                var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes()); 
                EniBook['assessing'][this.directive][this.id].user = radio; 
                feedback += "mémorisé à " + hour + "h" + minutes + "."; 
            }
        }
    }
    else { // type == 'checkbox' 
        var ok = true;
        var nbTrue = 0;
        var nbFalse = 0; 
        for (var i = 0; i < $labels.length; i++) {
            var classes = $($labels[i]).attr('class');
            if (classes.search('ui-checkbox-on') != -1) { // checked
                checkbox.push(i);
                if ($($labels[i]).attr('actual') != 'true') { 
                    ok = false; 
                    nbFalse += 1;
                }
                this.answer[this.storage.tirage[i]] = '1'; 
                this.rawanswer[i] = true;
            }
            else { // unchecked
                if ($($labels[i]).attr('actual') != 'false') { 
                    ok = false; 
                    nbFalse += 1;
                }
            } 
        }
        nbTrue = this.items - nbFalse;
        this.score = nbTrue + "/" + this.items;
        feedback += "Essai " + this.tries.toString() + " ";
        if (EniBook['mode'] !== 'assessing') { // learning or training mode
            feedback += "<br />Score : " + nbTrue + "/" + this.items + "<br />";
        }
        else { 
            var date    = new Date();
            var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
            var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes()); 
            EniBook['assessing'][this.directive][this.id].user = checkbox; 
            feedback += "mémorisé à " + hour + "h" + minutes + "."; 
        }
    }


    $(this.$qmcq).attr('ok',ok); 
    $(this.$qmcq).attr('nbTrue',nbTrue.toString());
    $(this.$qmcq).attr('nbFalse',nbFalse.toString());
        
    if (EniBook['mode'] !== 'assessing') { // learning or training mode    
        var feedbacks = this.feedbackId();
        if (feedbacks.len != 0) { // feedbacks 
            for (f in feedbacks) { 
                if (f == ok.toString()) { 
                    feedback += EniBook[feedbacks[f]].feedback(this.answer.join(""),ok,null);
                }
            }
        }
        if(ok) {
            $(this.$feedback).removeClass('feedback-false');
            $(this.$feedback).addClass('feedback-true');
        }
        else {
            $(this.$feedback).removeClass('feedback-true');
            $(this.$feedback).addClass('feedback-false');
        }
    }
    else { // assessing mode
       $(this.$feedback).removeClass('feedback-false');
       $(this.$feedback).removeClass('feedback-true');
       $(this.$feedback).addClass('feedback-info');
    }
    
    $(this.$feedback).html(feedback);
    enibookIntRefs();
    //if (typeof MathJax != "undefined") { MathJax.Hub.Typeset(this.id + "-q-mcq-feedback"); }
    renderKatex(this.id + "-q-mcq-feedback");
}

/******************************************************************************
 *
 * Feedback
 *
 ******************************************************************************/

//------------------------------------------------------------------------------
function Feedback(id) { 
    this.id                 = id;
    this.$feedback          = $("#" + id + "-feedback");
    this.type               = $(this.$feedback).attr("type");
    this.feedbacktrueArray  = new Array();
    this.feedbackfalseArray = new Array();

    this.$parent = $(this.$feedback).parent(); 
    if(this.id.match(/^feedbackfalseroleinput/)) { 
        var parentId = this.id.replace("feedbackfalse","") + "-input-block";
        parentId = parentId.replace("-feedback","");
        this.$parent = $("#" + parentId); 
    }
    if(this.id.match(/^feedbacktrueroleinput/)) { 
        var parentId = this.id.replace("feedbacktrue","") + "-input-block";
        parentId = parentId.replace("-feedback","");
        this.$parent = $("#" + parentId); 
    }

    var $tables = $(this.$feedback).children(".field-list");
    switch (this.type) {
        case "true" :
            switch ($tables.length) {
                case 0 :
                    this.feedbacktrueArray.push(["true",$(this.$feedback).html()]);
                    break;
                case 1 :
                    var $names = $($tables[0]).find(".field-name");
                    var $bodys = $($tables[0]).find(".field-body");
                    if ($names.length == $bodys.length) {
                        for (var i = 0; i < $names.length; i++) {
                            var text = $($names[i]).text();
                            this.feedbacktrueArray.push([text.replace(':',''),$($bodys[i]).html()]);
                        }
                    }
                    break;
                default :
                    break;
            }
            break;
        case "false" :
            switch ($tables.length) {
                case 0 :
                    this.feedbackfalseArray.push(["false",$(this.$feedback).html()]);
                    break;
                case 1 :
                    var $names = $($tables[0]).find(".field-name");
                    var $bodys = $($tables[0]).find(".field-body");
                    if ($names.length == $bodys.length) {
                        for (var i = 0; i < $names.length; i++) {
                            var text = $($names[i]).text();
                            this.feedbackfalseArray.push([text.replace(':',''),$($bodys[i]).html()]);
                        }
                    }
                    break;
                default :
                    break;
            }
            break;
        default :
            break;
    }
    $(this.$feedback).html("");
    //console.log('initializing ',this.id);
};


//------------------------------------------------------------------------------
Feedback.prototype.feedback = function (answer,success,process) {
    var res = "";
    process = null; // oops!
    if (process !== null) { 
        res += process(this);
    }
    else {
        if (success) { 
            var found = false; 
            for (var i = 0; i < this.feedbacktrueArray.length && !found; i++) { 
                if (this.feedbacktrueArray[i][0] == "true") {
                        res += this.feedbacktrueArray[i][1]; 
                        found = true;
                }
                else { // regular expressions
                    var str = this.feedbacktrueArray[i][0].split("/"); 
                    if (str.length == 3) { 
                        var regexp = new RegExp(str[1],str[2]);
                        if (regexp.test(answer)) {
                            res += this.feedbacktrueArray[i][1];
                            found = true;
                        }
                    }
                }
            }
        }
        else { 
            var found = false; 
            for (var i = 0; i < this.feedbackfalseArray.length && !found; i++) { 
                if (this.feedbackfalseArray[i][0] == "false") {
                        res += this.feedbackfalseArray[i][1];
                        found = true;
                }
                else {
                    var str = this.feedbackfalseArray[i][0].split("/"); 
                    if (str.length == 3) { 
                        var regexp = new RegExp(str[1],str[2]);
                        if (regexp.test(answer)) {
                            res += this.feedbackfalseArray[i][1];
                            found = true;
                        }
                    }
                }
            }
        }
    }
    return res;
};


/******************************************************************************
 *
 * Hint
 *
 ******************************************************************************/

//-----------------------------------------------------------------------------
function Hint(id) { // id : HTML identifier
    this.id      = id; 
    this.$hint   = $("#" + id + "-hint"); 
    this.$parent = $(this.$hint).parent(); 
    if(this.id.match(/^hintroleinput/)) {
        var parentId = this.id.replace("hint","") + "-input-block"; 
        this.$parent = $("#" + parentId); 
    }

    this.visited = false;
   
    var $levels = $(this.$parent).find(".hints");
    if ($levels.length == 1) {
        this.$levels = $levels[0];
        var levels   = $(this.$hint).attr('levels');
        if (levels == 'true') { 
            var idParent = $(this.$parent).attr("id");
            $(this.$levels).css('display','inline');
            $(this.$levels).html("?");
        }
    }

    var $ols     = $(this.$hint).children("ol");
    var $uls     = $(this.$hint).children("ul");
    var $dls     = $(this.$hint).children("dl"); 
    var $tables  = $(this.$hint).children("table");

    if ($ols.length == 1 && $uls.length == 0 && $dls.length == 0 && $tables.length == 0) { 
        var $lis = $($ols[0]).children("li");
        $($ols[0]).css('margin-left','10px');
        //$($lis).css('list-style-position','inside');
        $(this.$hint).attr('maxitems',$lis.length.toString());
        $(this.$hint).attr('items','0');
        for (var i = 0; i < $lis.length; i++) {
            $($lis[i]).css('display','none');
        }
    }
    else {
        if ($ols.length == 0 && $uls.length == 1 && $dls.length == 0 && $tables.length == 0) {
            $($uls[0]).css('margin-left','10px');
            var $lis = $($uls[0]).children("li");
            //$($lis).css('list-style-position','inside');
            $(this.$hint).attr('maxitems',$lis.length.toString());
            $(this.$hint).attr('items','0');
            for (var i = 0; i < $lis.length; i++) {
                $($lis[i]).css('display','none');
            }
        }
        else {
            if ($ols.length == 0 && $uls.length == 0 && $dls.length == 1 && $tables.length == 0) {
                var $dts = $($dls[0]).children("dt");
                var $dds = $($dls[0]).children("dd"); 
                $(this.$hint).attr('maxitems',$dts.length.toString());
                $(this.$hint).attr('items','0');
                for (var i = 0; i < $dts.length; i++) {
                    $($dts[i]).css('display','none');
                    $($dds[i]).css('display','none'); 
                }
            } 
            else {
                if ($ols.length == 0 && $uls.length == 0 && $dls.length == 0 && $tables.length == 1) {
                    var $caption = $($tables[0]).children("caption");
                    if ($caption.length == 1) {
                        $($caption).css('display','none');
                        $("#" + id + "-help-title").html($($caption).html()); 
                    }
                    var $trs = $($tables[0]).find("tr");
                    $(this.$hint).attr('maxitems',$trs.length.toString());
                    $(this.$hint).attr('items','0');
                    for (var i = 0; i < $trs.length; i++) {
                        $($trs[i]).css('display','none');
                    }
                }
                else {
                    $(this.$hint).attr('maxitems','single');
                    $(this.$hint).attr('items','0');
                }
            }
        }
    }


    var $maxitems = $(this.$hint).attr('maxitems');
    if ($maxitems != 'single') {
        var maxitems = parseInt($maxitems);
        if (maxitems > 1) {
            $(this.$levels).html($maxitems+"?");
        }
    }
    else {
        $(this.$levels).html("?");
    }
    //console.log('initializing ',this.id);
}

//-----------------------------------------------------------------------------
Hint.prototype.feedback = function() {
    var $maxitems = $(this.$hint).attr('maxitems');
    var $items    = $(this.$hint).attr('items');
    var items     = parseInt($items);

    if ($maxitems != 'single') {
        var maxitems = parseInt($maxitems);
        if (items != 0 || !this.visited) {
            if (items == maxitems) {
                $(this.$hint).attr('items','0');
                $(this.$levels).html("?");
            }
            else {
                var $ols     = $(this.$hint).children("ol");
                var $uls     = $(this.$hint).children("ul");
                var $dls     = $(this.$hint).children("dl");
                var $tables  = $(this.$hint).children("table"); 
                if ($ols.length == 1 && $uls.length == 0 && $dls.length == 0 && $tables.length == 0) {
                    var $lis = $($ols[0]).children("li");
                    for (var i = 0; i < maxitems; i++) {
                        if (i <= items) { $($lis[i]).css('display','list-item'); }
                        else { $($lis[i]).css('display','none'); }
                    }
                }
                else {
                    if ($ols.length == 0 && $uls.length == 1 && $dls.length == 0 && $tables.length == 0) {
                        var $lis = $($uls[0]).children("li");
                        for (var i = 0; i < maxitems; i++) {
                            if (i <= items) { $($lis[i]).css('display','list-item'); }
                            else { $($lis[i]).css('display','none'); }
                        }
                    }
                    else {
                        if ($ols.length == 0 && $uls.length == 0 && $dls.length == 1 && $tables.length == 0) {
                            var $dts = $($dls[0]).children("dt"); 
                            var $dds = $($dls[0]).children("dd");
                            for (var i = 0; i < maxitems; i++) {
                                if (i <= items) { 
                                    $($dts[i]).css('display','block'); 
                                    $($dds[i]).css('display','block');
                                }
                                else { 
                                    $($dts[i]).css('display','none');
                                    $($dds[i]).css('display','none'); 
                                }
                            }
                        }
                        else {
                            if ($ols.length == 0 && $uls.length == 0 && $dls.length == 0 && $tables.length == 1) {
                                var $trs = $($tables[0]).find("tr"); 
                                for (var i = 0; i < maxitems; i++) {
                                    if (i <= items) { $($trs[i]).css('display','table-row'); }
                                    else { $($trs[i]).css('display','none'); }
                                }
                            }
                        }
                    }
                }
                $(this.$hint).attr('items',(items+1).toString());
                var rest = maxitems-(items+1);
                if (rest != 0) { $(this.$levels).html(rest.toString() + "?"); }
                else { $(this.$levels).html("?"); }
            }
        }
    }
    //refreshEditors(this.$hint);
    //refreshDiagrams(this.$hint);
    this.visited = true;
};

//alert('RoleInput')
/******************************************************************************
 *
 * RoleInput
 *
 ******************************************************************************/
function RoleInput(id) { // id : HTML identifier 

    this.hintId          = "hint" + id; 
    this.feedbacktrueId  = "feedbacktrue" + id; 
    this.feedbackfalseId = "feedbackfalse" + id;

    var hint          = $("#" + id + "-input-block").attr("hint"); 
    var feedbackfalse = $("#" + id + "-input-block").attr("feedbackfalse"); 
    var feedbacktrue  = $("#" + id + "-input-block").attr("feedbacktrue"); 

    if (EniBook['mode'] !== 'assessing') { // learning or training mode
        if (feedbacktrue !== "") {
            var $feedback = $("<span></span>");
            $($feedback).attr("id",this.feedbacktrueId + "-feedback");
            $($feedback).attr("name",this.feedbacktrueId + "-feedback");
            $($feedback).attr("class","feedback user-class-feedback");
            $($feedback).attr("type","true");
            $($feedback).attr("directive","feedback");
            $($feedback).html(feedbacktrue);       
            //$(document.body).append($feedback);
            $("#" + id + "-input-block").append($feedback);
            EniBook[this.feedbacktrueId] = new Feedback(this.feedbacktrueId); 
        }
        if (feedbackfalse !== "") {
            var $feedback = $("<span></span>");
            $($feedback).attr("id",this.feedbackfalseId + "-feedback");
            $($feedback).attr("name",this.feedbackfalseId + "-feedback");
            $($feedback).attr("class","feedback user-class-feedback");
            $($feedback).attr("type","false");
            $($feedback).attr("directive","feedback");
            $($feedback).html(feedbackfalse);       
            //$(document.body).append($feedback);
            $("#" + id + "-input-block").append($feedback);
            EniBook[this.feedbackfalseId] = new Feedback(this.feedbackfalseId); 
        }
    }

    
    if (hint !== "") { 
        var $hint = $("<span></span>");
        $($hint).attr("id",id + "-input-hint");
        $($hint).attr("name",id + "-input-hint");
        $($hint).attr("class","input-hint user-class-input-hint");
        $($hint).attr("levels","true");
        $($hint).attr("maxitems","single");
        $($hint).attr("items","0");
        $($hint).html(hint);
        //$(document.body).append($hint);
        $("#" + id + "-input-block").append($hint); 
        this.$hint = $hint;

        
        var $hint = $("<span></span>");
        $($hint).attr("id",this.hintId + "-hint");
        $($hint).attr("name",this.hintId + "-hint");
        $($hint).attr("class","hint user-class-hint");
        $($hint).attr("levels","true");
        $($hint).attr("maxitems","single");
        $($hint).attr("items","0");
        $($hint).attr("directive","hint");
        $($hint).html(hint);
        //$(document.body).append($hint);
        $("#" + id + "-input-block").append($hint); 
        

        EniBook[this.hintId] = new Hint(this.hintId);
        //EniBook[this.hintId].feedback();
    }
    
    var $help = $("<div></div>");
    $($help).attr("id",id + "-input-help");
    $($help).attr("name",id + "-input-help");
    $($help).attr("class","input-hint user-class-input-help");
    var helpContent =
                    '<h4>Zone de saisie de texte</h4>' +
                    '<table data-role="table" class="ui-responsive ui-shadow" noborder>' +
                    '    <thead class="fillblank-help-tr"><th>Clavier</th><th>Action</th></thead>' +
                    '    <tbody>' +
                    '        <tr><td><kbd>F1</kbd><td>Afficher une aide technique</td></tr>' +
                    '        <tr class="fillblank-help-tr"><td><kbd>F2</kbd></td><td>Afficher une aide pédagogique</td></tr>' +
                    '        <tr><td><kbd>Ctrl-A</kbd><td>Tout sélectionner</td></tr>' +
                    '        <tr><td><kbd>Ctrl-C</kbd><td>Copier la sélection dans le presse-papier</td></tr>' +
                    '        <tr><td><kbd>Ctrl-V</kbd><td>Copier le presse-papier dans la sélection</td></tr>' +
                    '        <tr><td><kbd>Ctrl-X</kbd><td>Couper la sélection et la copier dans le presse-papier</td></tr>' +
                    '        <tr><td><kbd>Ctrl-Z</kbd><td>Annuler la modification</td></tr>' +
                    '        <tr><td><kbd>Maj-Ctrl-Z</kbd><td>Rétablir la modification</td></tr>' +
                    '    </tbody>' +
                    '</table>' +
                    '<br />' +
                    '<table data-role="table" class="ui-responsive ui-shadow" noborder>' +
                    '    <thead class="fillblank-help-tr"><th>Menu</th><th>Action</th></thead>' +
                    '    <tbody>' +
                    '        <tr><td><span class="btn btn-success glyphicons glyphicons-play" style="color: rgb(162,169,63); background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2);"></span></td><td>Valider la zone de saisie</td></tr>' +
                    '    </tbody>' +
                    '</table>' ;
    $($help).html(helpContent);
    $(document.body).append($help);
    this.$help = $help; 

    Input.call(this,id); 

};

//-----------------------------------------------------------------------------
RoleInput.prototype = Object.create(Input.prototype);

//-----------------------------------------------------------------------------
RoleInput.prototype.hint = function() { 
    var height = parseInt($(this.$input).css("height").replace("px",""))
    var width  = parseInt($(this.$input).css("width").replace("px",""))/2
    var offset = $(this.$input).offset();
    $x = Math.round(offset.left + width);
    $y = Math.round(offset.top - height);

    var msg = $(this.$hint).html(); 
    if (msg === "") {
        msg += "<p>Il n'y a pas d'indication particulière pour remplir cette zone de saisie.</p>";
        msg += "<p>";
        msg += "Une zone de saisie propose une indication particulière " +
               "lorsqu'elle est suivie d'un <span class='hints' style='display: inline;'>?</span>.<br />" +
               "Le nombre qui précède éventuellement le <span class='hints' style='display: inline;'>?</span> " +
               "précise le nombre d'indications associées qui restent encore à découvrir pour cette zone.";
        msg += "</p>";
    }
    $("#enibook-hint-main").html(msg);
    $("#enibook-hint").popup("open",{ arrow: false, x: $x, y: $y });  
};

//-----------------------------------------------------------------------------
RoleInput.prototype.feedbackId = function() { 
    var feedbackfalse = $("#" + this.id + "-input-block").attr("feedbackfalse"); 
    var feedbacktrue  = $("#" + this.id + "-input-block").attr("feedbacktrue"); 

    var feedbackId = {};
    if (feedbacktrue  !== "") { feedbackId["true"]  = this.feedbacktrueId; }
    if (feedbackfalse !== "") { feedbackId["false"] = this.feedbackfalseId ; }

    return feedbackId;
};

//alert('Input');
/******************************************************************************
 *
 * Input
 *
 ******************************************************************************/

//-----------------------------------------------------------------------------
function Input(id) { // id : HTML identifier 
    this.id        = id;
    this.$input    = $("#" + id + "-input"); 
    this.$block    = $("#" + id + "-input-block");
    this.$help     = $("#" + id + "-input-help"); 
    this.$hint     = $("#" + id + "-input-hint");
    this.title     = $(this.$input).attr('title');
    this.tries     = 0; 
    this.nbtry     = parseInt($(this.$block).attr("nbtry")); 
    this.re        = $(this.$block).attr("re");
    this.solution  = $(this.$block).attr("solution");
    this.isRe      = (this.re != "") && (this.solution == "");
    this.answer    = "$$##~initialisation~##$$";
    this.success    = undefined;

    this.directive  = $(this.$block).attr('directive'); 
    this.modeEnibook= EniBook['mode']; //$(this.$block).attr('modeEnibook');
    this.typeEnibook= EniBook['type']; //$(this.$block).attr('typeEnibook');  

    this.update();
    //console.log('initializing ',this.id);
};

//------------------------------------------------------------------------------
Input.prototype.hide = function() {
    $(this.$block).hide();
}

//------------------------------------------------------------------------------
Input.prototype.show = function() {
    $(this.$block).show();
}

//------------------------------------------------------------------------------
Input.prototype.parents = function(selector) {
    return $(this.$input).parents(selector);
}

//-----------------------------------------------------------------------------
Input.prototype.update = function() { 
    $(this.$input).css("background-color","white");

    switch (EniBook['mode']) {
        case 'training' :
            $(this.$input).val(EniBook['assessing'][this.directive][this.id].user);
            this.feedback();
            break;
        case 'assessing' :
            $(this.$input).val(EniBook['assessing'][this.directive][this.id].user);
            break;
        default :
            $(this.$input).val("");
            $(this.$block).attr("success","undefined");
    }            
}

//-----------------------------------------------------------------------------
Input.prototype.hint = function() { 
    var msg = "";
    var height = parseInt($(this.$input).css("height").replace("px",""))
    var width  = parseInt($(this.$input).css("width").replace("px",""))/2
    var offset = $(this.$input).offset();
    var $x = Math.round(offset.left + width);
    var $y = Math.round(offset.top - height);
    if (this.tries >= this.nbtry) { 
        var $hints = $(this.$block).children(".hint"); 
        if ($hints.length === 1 && $($hints[0]).html() !== "") { 
            var $hint = $hints[0];
            var hintId = $($hint).attr("id").replace("-hint",""); 
            EniBook[hintId].feedback();
            msg += $($hint).html();
        }
        else {
            msg += "<p>Il n'y a pas d'indication particulière pour remplir cette zone de saisie.</p>";
            msg += "<p>";
            msg += "Une zone de saisie propose une indication particulière " +
                   "lorsqu'elle est suivie d'un <span class='hints' style='display: inline;'>?</span>.<br />" +
                   "Le nombre qui précède éventuellement le <span class='hints' style='display: inline;'>?</span> " +
                   "précise le nombre d'indications associées qui restent encore à découvrir pour cette zone.";
            msg += "</p>";
        }
    } 
    else {
        var essai = this.nbtry - this.tries;
        var nbs = "";
        if (essai > 1) { nbs = "s"; }
        msg += "Il vous reste " + essai.toString() + " essai" + nbs + 
               " avant d'avoir accès à l'aide pédagogique.";
    }
    $("#enibook-hint-main").html(msg);
    $("#enibook-hint").popup("open",{ arrow: false, x: $x, y: $y });  
};

//-----------------------------------------------------------------------------
Input.prototype.help = function() {
    $("#enibook-help-content").html($(this.$help).html());
    $("#enibook-help-btn").click();
};

//-----------------------------------------------------------------------------
Input.prototype.keypress = function(event) { 
    var key      = event.key; 
    var ctrlKey  = event.ctrlKey;
    var shiftKey = event.shiftKey;
    var altKey   = event.altKey;
    if (key == "F1") { this.help(); }
    if (key == "F2") { this.hint(); }
    if (key == "Z" && ctrlKey) { this.update(); }
}

//-----------------------------------------------------------------------------
Input.prototype.feedbackId = function() { 
    var feedbackId = {};
    
    var feedbacks = $(this.$block).find(".feedback");  
    if (feedbacks.length <= 2) {
        for (var i = 0; i < feedbacks.length; i++) { 
            feedbackId[$(feedbacks[i]).attr("type")] = $(feedbacks[i]).attr("id").replace("-feedback","");
        }
    }
    return feedbackId;
};

//-----------------------------------------------------------------------------
Input.prototype.feedback = function() { 
    var answer  = $(this.$input).val().trim(); 
    //if (this.answer !== answer) { 
        var res = "";
        this.tries += 1;

        if (EniBook['mode'] === 'assessing') { // assessing mode
            var date    = new Date();
            var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
            var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes());
            EniBook['assessing'][this.directive][this.id].user = answer;
            $(this.$input).css("background-color","rgb(217,237,247)"); 
            $("#" + this.id + "-input-feedback").css('color','blue');
            $("#" + this.id + "-input-feedback").html("Essai " + this.tries.toString() + " mémorisé à " + hour + "h" + minutes + ".");
        }
        else { // learning or training mode
            if (!this.isRe) { success = (answer == this.solution); }
            else {
                var re = eval(this.re);
                var pattern = new RegExp(re);
                var success = pattern.test(answer);
            }
            this.success = success;
            if (success) {
                $(this.$input).css("background-color","#DFF0D8");
            }
            else {
                $(this.$input).css("background-color","#F2DEDE");
            }
            $(this.$block).attr("success",success.toString());

            var feedbacks = this.feedbackId(); 
            var comment = "";
            for (f in feedbacks) {
                if (f === success.toString()) { res += EniBook[feedbacks[f]].feedback(answer,success,comment); }
            }

            if (res !== "") {
                var height = parseInt($(this.$input).css("height").replace("px",""))
                var width  = parseInt($(this.$input).css("width").replace("px",""))/2
                var offset = $(this.$input).offset();
                var $x = Math.round(offset.left + width);
                var $y = Math.round(offset.top - height);
                $("#enibook-feedback-main").html(res);
                if (EniBook['mode'] !== 'training') { $("#enibook-feedback").popup("open",{ arrow: false, x: $x, y: $y }); }
            }
        }
        this.answer = answer;
    //}
}

//alert('InputLines');
/******************************************************************************
 *
 * InputLines
 *
 ******************************************************************************/

//-----------------------------------------------------------------------------
function InputLines(id) { // id : HTML identifier 
    this.id        = id;
    this.$input    = $("#" + id + "-inputlines"); 
    this.$help     = $("#" + id + "-inputlines-help"); 
    this.$block    = $("#" + id + "-inputlines-block");
    this.$feedback = $("#" + id + "-inputlines-feedback");
    this.hidden    = ($(this.$block).attr('collapse') === 'true') ? true : false;
    this.extension = ".txt";
    this.mime      = "text/plain";
    this.title     = $(this.$input).attr('title');
    this.tries     = 0; 
    this.directive = $(this.$block).attr('directive'); 
    this.question  = $(this.$block).attr('question');
    this.answer    = $(this.$block).attr('answer');
    this.modeEnibook= EniBook['mode']; 
    this.typeEnibook= EniBook['type'];   
    this.nblines = 2;

    
    this.update();
    //console.log('initializing ',this.id);

};

//------------------------------------------------------------------------------
InputLines.prototype.hide = function() {
    $(this.$block).hide();
}

//------------------------------------------------------------------------------
InputLines.prototype.show = function() {
    $(this.$block).show();
}

//------------------------------------------------------------------------------
InputLines.prototype.parents = function(selector) {
    return $(this.$input).parents(selector);
}

//-----------------------------------------------------------------------------
InputLines.prototype.update = function() { 
    if (this.hidden) { $(this.$block).css('display','none'); }
    else { $(this.$block).css('display','block'); }
    $(this.$feedback).css('display','none');

    switch (EniBook['mode']) {
        case 'training' :
            var answers = $(this.$input).parents(".answer"); 
            if (answers.length === 1) { 
                $(this.$input).val(EniBook['assessing'][this.directive][this.id].user);
            }
            else {
                var solutions = this.parents(".solution");
                if (solutions.length === 1) {
                    $(this.$input).val($(this.$input).text());
                }
            }
            break;
        case 'assessing' :
            $(this.$input).val(EniBook['assessing'][this.directive][this.id].user);
            break;
        default :
            $(this.$input).val($(this.$input).text());
            break;
    } 
    this.refresh();           
}

//-----------------------------------------------------------------------------
InputLines.prototype.collapse = function() { 
    if ($(this.$block).css('display') ==='none') { $(this.$block).css('display','block'); }
    else { $(this.$block).css('display','none'); }
}

//------------------------------------------------------------------------------
InputLines.prototype.newFile = function () {
    $(this.$input).val("");
    this.refresh();
}

//------------------------------------------------------------------------------
InputLines.prototype.openFile = function() { 
    var input = $("<input></input>");
    $(input).attr('type','file');
    $(input).attr('accept',this.extension);
    $(input).attr('id',this.id + 'uploadInput');
    $(input).attr('name',this.id + '-uploadInput');
    $(input).attr('multiple','multiple');
    $(input).attr('onchange','EniBook["' + this.id + '"].loadFile("' + this.id + '",this.files);');
    $(input).click();
    $(input).remove(); 
}

//------------------------------------------------------------------------------
InputLines.prototype.loadFile = function(id,files) { 
    if (files.length > 0) {
        for (var i = 0; i < files.length; i++) {
            var filetype = files[i].type;
            if (filetype.match(this.mime)) {
                var filereader = new FileReader();
		        filereader.readAsText(files[i]);
                filereader.onloadend = function(e) { 
                    var txt = e.target.result; 
                    var obj = EniBook[id];
                    $(obj.$input).val(txt); 
                    obj.refresh();
                }
            }
        }
    }
}

//------------------------------------------------------------------------------
InputLines.prototype.saveFile = function() {
    var a = document.createElement('a');
    a.href = 'data:application/octet-stream,' + encodeURIComponent($(this.$input).val());
    a.download = this.id + this.extension;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
}

//------------------------------------------------------------------------------
InputLines.prototype.printEdit = function() {
    var lines = new Array();
    lines = $(this.$input).val().split('\n');
    var head = "";

    var content = "<table class='table'>\n";
    for (var i = 0; i < lines.length; i++) {
        content += "<tr><td style='border-right: 1px solid #F5F5F5;'>" +
                   "<pre style='color: gray; font-size: small; text-align: right; margin: 0; padding: 0px 2px 0px 0px;'>" + (i+1).toString() + 
                   "</pre></td><td><pre style='font-size: normal; text-align: left; margin: 0; padding: 0px 0px 0px 5px;'>" + 
                   lines[i].replace('\t','    ').replace(/</g,'&lt;').replace(/>/g,'&gt;') + "</pre></td></tr>\n";
    }
    content += "</table>\n";
    var win = window.open(window.location);
    win.blur(); win.focus(); 
    win.document.title = "EniBook : éditeur Texte";
    win.document.write("<!DOCTYPE html>\n<html>\n<head>\n<title>" + 
                        win.document.title +"</title>\n"+ head + 
                        "\n</head>\n<body>\n" + content +
                        "\n</body>\n</html>\n");
    win.print();
    win.close();
}

//------------------------------------------------------------------------------
InputLines.prototype.refresh = function() {
    var n = $(this.$input).val().split("\n").length; 
    this.nblines = n < 2 ? 1 : n;  
    $(this.$input).attr('rows',this.nblines.toString()); 
}

//-----------------------------------------------------------------------------
InputLines.prototype.help = function() { 
    $("#enibook-help-content").html($(this.$help).html());
    $("#enibook-help-btn").click();
};


//-----------------------------------------------------------------------------
InputLines.prototype.feedback = function() { 
    this.tries += 1;
    $(this.$feedback).css('display','block');

    var res = "";
    if (EniBook['mode'] === 'assessing') { // assessing mode
        var date    = new Date();
        var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
        var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes());
        res += "Essai " + this.tries.toString() + " mémorisé à " + hour + "h" + minutes + ".";
        EniBook['assessing'][this.directive][this.id].user = $(this.$input).val();
        $("#" + this.id + "-inputlines-feedback").css('color','blue');
    }
    else { // learning or training mode
        res += "Pas de retour sur un « texte libre » : consulter la solution."
    }
    $("#" + this.id + "-inputlines-feedback").html(res);
}

//alert('FillBlank');
/******************************************************************************
 *
 * FillBlank
 *
 ******************************************************************************/

function FillBlank(id) { // HTML identifier
    this.id         = id;
    this.$fillblank = $("#" + id + "-fillblank"); 
    this.$feedback  = $("#" + id + "-fillblank-feedback");
    this.$help      = $("#" + id + "-fillblank-help"); 
    this.$collapse   = $(this.$fillblank).attr("collapse");
    this.$inputs    = {};

    $(this.$help).popup();

    var $inputs = $(this.$fillblank).find("input.input");
    this.inputs = $inputs.length;
    for (var i = 0; i < this.inputs; i++) {
        var inputId = $($inputs[i]).attr("id").replace("-input","");
        this.$inputs[inputId] = EniBook[inputId];
    }
    
    if (this.$collapse !== "false") { $(this.$fillblank).css("display","none"); }
    else { $(this.$fillblank).css("display","block"); }
    
    this.update();
    //console.log('initializing ',this.id);

};

//------------------------------------------------------------------------------
FillBlank.prototype.update = function() {
    for (inputId in this.$inputs) { this.$inputs[inputId].update(); }
    $(this.$feedback).css('display','none');
}


//------------------------------------------------------------------------------
FillBlank.prototype.collapse = function() { 
    if ($(this.$fillblank).css("display") === "none") {
        $(this.$fillblank).css("display","block");
    }
    else {
        $(this.$fillblank).css("display","none");
    }
}

//------------------------------------------------------------------------------
FillBlank.prototype.help = function() {
    var html = $("#" + this.id + "-fillblank-help-content").html();
    $("#enibook-help-content").html(html);
    var $a = $("<a>");
    $($a).attr("href","#enibook-help");
    $(document.body).append($a);
    $($a).click();
    $($a).remove();
}

//------------------------------------------------------------------------------
FillBlank.prototype.feedback = function() {
    var input_all       = this.inputs
    var input_false     = 0;
    var input_true      = 0;
    var input_valid     = input_false + input_true;
    var input_undefined = 0;

   
    for (inputId in this.$inputs) {
        var input = this.$inputs[inputId]; 
        var success = $(input.$block).attr("success"); 
        if (success == "true")      { input_true  += 1; input_valid += 1; }
        if (success == "false")     { input_false += 1; input_valid += 1; }
        if (success == "undefined") { input_undefined += 1; }
    }

    $('#' + this.id + '-fillblank-feedback-all').html(input_all.toString());
    $('#' + this.id + '-fillblank-feedback-undefined').html(input_undefined.toString());
    $('#' + this.id + '-fillblank-feedback-valid').html((input_false+input_true).toString());
    $('#' + this.id + '-fillblank-feedback-valid-percent').html(Math.round(100*(input_false+input_true)/input_all).toString()+'%');
    $('#' + this.id + '-fillblank-feedback-false').html(input_false.toString());
    $('#' + this.id + '-fillblank-feedback-true').html(input_true.toString());
    $('#' + this.id + '-fillblank-feedback-true-percent').html(Math.round(100*input_true/input_valid).toString()+'%');
    $('#' + this.id + '-fillblank-feedback-all-true-percent').html(Math.round(100*input_true/input_all).toString()+'%');

    $(this.$feedback).css('display','block');
};

/******************************************************************************
 *
 * Container
 *
 ******************************************************************************/
//------------------------------------------------------------------------------
function Container(id) { // id : HTML identifier
    this.id         = id;
    this.$container = $("#" + id + "-container");
    this.$btn       = $("#" + id + "-container-btn");
    this.$ol        = $(this.$container).children("ol"); 
    this.type       = $(this.$container).attr('type');
    this.norandom   = $(this.$container).attr('norandom');
    this.collapse   = $(this.$container).attr('collapse');
    this.choices    = parseInt($(this.$container).attr('choices'));
    this.tries      = 0;
    this.storage    = {};
    this.storage.questions = []; 
    this.storage.tirage    = []; 
    this.config     = {};
    this.directive  = $(this.$container).attr('directive');
    //this.criteria   = $(this.$container).attr('criteria');
    this.title      = $("#" + id + "-container-title").html();
    this.modeEnibook= EniBook['mode']; //$(this.$exercise).attr('modeEnibook');
    this.typeEnibook= EniBook['type']; //$(this.$exercise).attr('typeEnibook');    

    if (this.$ol.length === 1) {
        var $lis = $(this.$ol[0]).children("li"); 
        for (var i = 0; i < $lis.length; i++) {
            this.storage.questions.push($lis[i]);
        }
    }

    $(this.$container).css('display',(this.collapse === 'true' ? 'none' : 'block'));
    
    this.update(); 
    //console.log('initializing ',this.id);

};

//------------------------------------------------------------------------------
Container.prototype.update = function() { 
    var $questions = $(this.$container).find("div." + this.type);
    var len = $questions.length; 
    var k = 0;

    switch (EniBook['mode']) {
        case 'learning' :
            this.storage.tirage = []; 
            for (var j = 0; j < len; j++) {       
                if (this.norandom === 'false') {
                    k = Math.floor(Math.random() * len);
                    while (this.storage.tirage.indexOf(k) != -1) { k = Math.floor(Math.random() * len); };
                }
                else { k = j; }
                this.storage.tirage.push(k);
            }
            $("#" + this.id).css('display','block');
            break;
        case 'assessing' : 
            this.storage.tirage = EniBook['assessing'][this.directive][this.id].items; 
            break;
        case 'training' :
            this.storage.tirage = EniBook['assessing'][this.directive][this.id].items; 
            break;
        default :
            break;
    }

    for (var i = 0; i < len; i++) {
        $(this.$ol[0]).append(this.storage.questions[this.storage.tirage[i]]);
    }

    var $lis = $(this.$ol[0]).children("li"); 
    for (var i = 0; i < $lis.length; i++) {
        if (i < this.choices) {
            $($lis[i]).css('display','list-item');
            var $question  = $($lis[i]).find('div.' + this.type);
            var questionid = $($question[0]).attr('id').replace('-' + this.type,''); 
            EniBook[questionid].update(); 
        }
        else {
            $($lis[i]).css('display','none');
        }
    }
    
    //$.mobile.silentScroll($("#" + this.id + "-container-spanid").offset().top); 
};


//------------------------------------------------------------------------------
Container.prototype.toggle_container = function() {
    if ($(this.$container).css('display') === 'none') {
        $(this.$btn).removeClass('glyphicons-folder-closed');
        $(this.$btn).addClass('glyphicons-folder-open');
        $(this.$container).show();
    }
    else {
        $(this.$btn).removeClass('glyphicons-folder-open');
        $(this.$btn).addClass('glyphicons-folder-closed');
        $(this.$container).hide();
    }
}

//------------------------------------------------------------------------------
Container.prototype.feedback = function() {
}


/******************************************************************************
 *
 * Exercise
 *
 ******************************************************************************/
//------------------------------------------------------------------------------
function Exercise(id) { // id : HTML identifier
    this.id        = id;
    this.$exercise = $("#" + id + "-exercise");
    this.norandom  = $(this.$exercise).attr('norandom');
    this.collapse  = $(this.$exercise).attr('collapse');
    this.choices   = parseInt($(this.$exercise).attr('choices'));
    this.tries     = 0;
    this.storage   = {};
    this.storage.questions = []; 
    this.storage.tirage    = []; 
    this.config    = {};
    this.directive  = $(this.$exercise).attr('directive');
    this.criteria  = $(this.$exercise).attr('criteria');
    this.title     = $("#" + id + "-exercise-title").html();
    this.modeEnibook= EniBook['mode']; //$(this.$exercise).attr('modeEnibook');
    this.typeEnibook= EniBook['type']; //$(this.$exercise).attr('typeEnibook');    

    var $ols = $(this.$exercise).children("ol"); 

    if ($ols.length === 1) {
        this.$ol = $ols[0];
        var $lis = $(this.$ol).children("li"); 
        for (var i = 0; i < $lis.length; i++) {
            this.storage.questions.push($lis[i]);
        }
    }
    else { this.$ol = null; }

    $(this.$exercise).css('display',(this.collapse === 'true' ? 'none' : 'block'));
    
    this.update(); 
    //console.log('initializing ',this.id);

};

//------------------------------------------------------------------------------
Exercise.prototype.update = function() { 
    var $questions = $(this.$exercise).find("div.question");
    var len = $questions.length; 
    var k = 0;

    switch (EniBook['mode']) {
        case 'learning' :
            this.storage.tirage = []; 
            for (var j = 0; j < len; j++) {       
                if (this.norandom === 'false') {
                    k = Math.floor(Math.random() * len);
                    while (this.storage.tirage.indexOf(k) != -1) { k = Math.floor(Math.random() * len); };
                }
                else { k = j; }
                this.storage.tirage.push(k);
            }
            $("#" + this.id).css('display','block');
            break;
        case 'assessing' :
            this.storage.tirage = EniBook['assessing'][this.directive][this.id].items; 
            break;
        case 'training' :
            this.storage.tirage = EniBook['assessing'][this.directive][this.id].items; 
            $("#" + this.id).css('display','block');
            break;
        default :
            break;
    }


    for (var i = 0; i < len; i++) {
        $(this.$ol).append(this.storage.questions[this.storage.tirage[i]]);
    }

    var $lis = $(this.$ol).children("li"); 
    for (var i = 0; i < $lis.length; i++) {
        if (i < this.choices) { 
            $($lis[i]).css('display','list-item');
            var $question  = $($lis[i]).children('div.question'); 
            var questionid = $($question[0]).attr('id').replace('-question',''); 
            EniBook[questionid].update();
        }
        else { $($lis[i]).css('display','none'); }
    }
    
    //$.mobile.silentScroll($("#" + this.id + "-exercise-spanid").offset().top); 
};

//------------------------------------------------------------------------------
Exercise.prototype.feedback = function() {
}

/******************************************************************************
 *
 * Save
 *
 ******************************************************************************/
//------------------------------------------------------------------------------
function Save(id) { // id : HTML identifier
    this.id         = id;
    this.tries      = 0;
    this.$save      = $('#' + id + '-save');
    this.$replay    = $('#' + id + '-replay');
    this.$replayhtml= $('#' + id + '-replay-html');
    this.$feedback  = $('#' + id + '-save-feedback');
    this.$notes     = $('#' + id + '-save-feedback-notes');
    this.$transit   = $('#' + id + '-save-feedback-transit');
    this.$comment   = $('#' + id + '-save-feedback-comments');
    this.configfile = "undefined";
    this.savefile   = $('#' + id).attr('file'); 
    this.modeEnibook= EniBook['mode']; 
    this.checklist  = $(this.$feedback).html();
    this.precomment = $(this.$comment).html();
    this.note       = $('#' + id).attr('note'); 
    this.valid      = $('#' + id).attr('valid'); 
    this.isSaved    = true;
    this.allnotes   = false;

    switch (EniBook['mode']) {
        case "assessing" :
            $("#" + this.id + "-mode").html('Evaluation');
            $("#" + this.id + "-table-evaluation").css('display','none');
            $(this.$save).css('display','table'); 
            $(this.$replay).css('display','table'); 
            $(this.$replayhtml).css('display','none'); 
            $(this.$feedback).css('display','block'); 
            $(".answer, input, textarea, ul.sort-list").on('change',
                function() { 
                    EniBook[id].isSaved = false; 
                    $('#' + id + '-save-label').html('! Sauvegarde !');
                    $('#' + id + '-save-label').css('font-weight','bold');
                    $('#' + id + '-save-label').css('color','white');
                    $('#' + id + '-save-label').css('background-color','rgb(234,138,0)');
                } );
            $(".exercise-block").hide();
            break;
        case "training" :
            $("#" + this.id + "-mode").html('Correction'); 
            $("#" + this.id + "-table-evaluation").css('display','table');
            $("#" + this.id + "-table-evaluation-evaluation").val("");

            var spans = $("#" + this.id + "-table-evaluation-validation").find("span:first");
            if (spans.length > 0) { $(spans[0]).html("-----"); }

            $(this.$save).css('display','none'); 
            $("#" + this.id + "-load-label").html("Charger<br />copie");
            $(this.$replay).css('display','table'); 
            $(this.$replayhtml).css('display','table'); 
            $(this.$feedback).css('display','block'); 
            $(this.$feedback).on('change',
                function() { 
                    EniBook[id].isSaved = false; 
                    $('#' + id + '-save-label').html('! Sauvegarder<br />copie !');
                    $('#' + id + '-save-label').css('font-weight','bold');
                    $('#' + id + '-save-label').css('color','white');
                    $('#' + id + '-save-label').css('background-color','rgb(234,138,0)');
                } );
            break;
        default :
            $(this.$save).css('display','none'); 
            $(this.$replay).css('display','none'); 
            $(this.$replayhtml).css('display','none'); 
            $(this.$feedback).css('display','none'); 
    } 
}

//------------------------------------------------------------------------------
Save.prototype.update = function() {
    switch (EniBook['mode']) {
        case 'assessing' :
            this.replay();
            break;
        case 'training' :
            if (typeof EniBook['assessing']['eval'] !== "undefined") { $("#" + this.id + "-table-evaluation-evaluation").val(EniBook['assessing']['eval']); }
            else { $("#" + this.id + "-table-evaluation-evaluation").val(""); }
            var spans = $("#" + this.id + "-table-evaluation-validation").find("span:first");
            if (spans.length > 0) {
                if (typeof EniBook['assessing']['valid'] !== 'undefined') { $(spans[0]).html(EniBook['assessing']['valid']); }
                else { $(spans[0]).html("-----"); }
            }
            this.replay();
            break;
        default :
            break;
    }
}

//------------------------------------------------------------------------------
Save.prototype.feedback = function() { 
    this.tries += 1;
    switch (EniBook['mode']) {
        case 'training' :
            EniBook['assessing']['save'] = "true"
            EniBook['assessing']['eval'] = $("#" + this.id + "-table-evaluation-evaluation").val();
            var spans = $("#" + this.id + "-table-evaluation-validation").find("span:first");
            if (spans.length > 0) { EniBook['assessing']['valid'] = $(spans[0]).html(); }
            else { EniBook['assessing']['valid'] = '-----'; }

            var comments = $("#" + this.id + "-save-feedback-notes").find('.commentreplay'); 
            for (var i = 0; i < comments.length; i++) { 
                var comment = comments[i]; 
                if ($(comment).attr('id') === this.id + "-globalcomment") { 
                    EniBook['assessing']['globalcomment'] = $(comment).html();
                }
                else {
                    var commentid = $(comment).attr('tool');
                    var directive = $(comment).attr('directive');
                    EniBook['assessing'][directive][commentid]['commentreplay'] = $(comment).html();
                }
            }

            var filename = EniBook['assessing']['subject'].replace('.json','') + '-replay.json';
            var txt = JSON.stringify(EniBook['assessing']);
    
            var a = document.createElement('a');
            a.href = 'data:application/json,' + encodeURIComponent(txt);
            a.download = filename;
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a); 

            this.showResults();
            break;
        case 'assessing' :
            EniBook['assessing']['save'] = "true"
            var filename = EniBook['assessing']['subject'].replace('.json','') + '-save.json';
            var txt = JSON.stringify(EniBook['assessing']);
    
            var a = document.createElement('a');
            a.href = 'data:application/json,' + encodeURIComponent(txt);
            a.download = filename;
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a); 

            this.showResults();
            break;
        default:
            break;
    }
    var date    = new Date();
    var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
    var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes());
    var msg = EniBook['assessing']["student"] + ' - ' + "Sauvegarde " + this.tries.toString() + " à " + hour + "h" + minutes + ".<br />";
    $("#" + this.id + "-save-date").append(msg);
    $('#' + this.id + '-save-label').html('Sauvegarder<br />copie');
    $('#' + this.id + '-save-label').css('font-weight','normal');
    $('#' + this.id + '-save-label').css('color','black');
    $('#' + this.id + '-save-label').css('background-color','transparent');
    this.isSaved = true;
}

//------------------------------------------------------------------------------
Save.prototype.toHtml = function() { 
    switch (EniBook['mode']) {
        case 'training' :
            var filename = EniBook['assessing']['answer']; 
            if (!this.allnotes) { alert('\nATTENTION\n\nLes notes intermédiaires ne sont pas toutes renseignées !\n'); }
            var element = document.getElementById(this.id + "-save-feedback");
            var txt = ''
            txt += '<!DOCTYPE html>\n';
            txt += '<html class="ui-mobile">\n';
            txt += '<head>\n';
            txt += '    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />\n';
            txt += '    <meta name="apple-mobile-web-app-capable" content="yes" />\n';
            txt += '    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent" />\n';
            txt += '    <meta name="viewport" content="width=device-width, initial-scale=1" />\n';
            txt += '\n';
            txt += '    <link rel="stylesheet" href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css">\n';
            txt += '    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/9.8.0/styles/default.min.css">\n';
            txt += '    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/KaTeX/0.8.3/katex.min.css">\n';
            txt += '    <style type="text/css">body {color: black; font-size: 16px; font-weight: normal; display: block; margin: 0px; padding-left: 20px; padding-right: 20px; z-index: -10; }</style>\n';
            txt += '    <style type="text/css">.save-feedback {border: 1px solid rgb(234,138,0); border-radius: 6px; padding: 5px;}</style>\n';
            txt += '    <style type="text/css">.ul-questions, .ul-solutions {display: inline-block; width: 48%; vertical-align: top; padding-right: 10px; } .ul-solutions {background-color: rgba(162,169,63,0.3); }</style>\n';
            txt += '    <style type="text/css">.notes-banner {cursor: pointer; font-weight: normal; font-variant: small-caps; background-color: rgb(234,138,0); color: white;}</style>\n';
            txt += '    <style type="text/css">.commentreplay {background-color: rgba(234,138,0,0.1); border: 1px solid rgb(234,138,0); padding: 5px; margin: 5px;}</style>\n';
            txt += '    <style type="text/css">.commentreplay-legend {background-color: rgb(234,138,0); color: white; font-variant: small-caps;}</style>\n';
            txt += '    <style type="text/css">.highlight {background-color:#eeffcc;}</style>\n';
            txt += '\n';        
            txt += '    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>\n';
            txt += '    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>\n';
            //txt += '    <script type="text/javascript" src="https://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS_HTML-full"></script>\n';
            txt += '    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/KaTeX/0.8.3/katex.min.js"></script>\n';
            txt += '    <script src="https://cdnjs.cloudflare.com/ajax/libs/KaTeX/0.8.3/contrib/auto-render.min.js" integrity="sha384-RkgGHBDdR8eyBOoWeZ/vpGg1cOvSAJRflCUDACusAAIVwkwPrOUYykglPeqWakZu" crossorigin="anonymous"></script>\n';
            txt += '    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/9.8.0/highlight.min.js"></script>\n';
            txt += '\n';
            txt += '</head>\n';
            txt += '<body>\n';
            txt += '<!-- begin ' + this.id + "-save-feedback" + '-->\n\n';
            txt += this.processElement(element) + "\n\n";
            txt += '<!-- end ' + this.id + "-save-feedback" + '-->\n';
            txt += '<div style="margin:10px;">\n';
            txt += '    <table style="font-size: 75%; width: 100%;">\n';
            txt += '        <tr>\n';
            txt += '            <td style="text-align: left;">Sujet : '     + EniBook['assessing']['subject'] + '</td>\n';
            txt += '            <td style="text-align: center;">Réponse : ' + EniBook['assessing']['answer'] + '</td>\n';
            txt += '            <td style="text-align: right;">Corrigé : '  + EniBook['assessing']['answer'].replace('.json','.html') + '</td>\n';
            txt += '        </tr>\n';
            txt += '    </table>\n';
            txt += '</div>\n';
            txt += '<script type="text/javascript">\n';
            txt += '    $(document).ready(function() {\n';
            txt += '        var span = $("#' + this.id + '-table-evaluation-validation").find("span:first");\n';
            txt += '        if (span.length > 0) {\n';
            txt += '            var color = $(span[0]).text() === "Non" ? "red" : "green";\n';
            txt += '            $(span[0]).css("color",color);\n';
            txt += '            $(span[0]).css("font-weight","bold");\n';
            txt += '        }\n';
            txt += '        $("pre code").each(function(i, block) { hljs.highlightBlock(block); });\n';
            txt += '        var coms = $("div.commentreplay");\n';
            txt += '        for (var i = 0; i < coms.length; i++) { $(coms[i]).removeAttr("contenteditable"); $(coms[i]).html($(coms[i]).html().replace(/\&lt\;/g,"<").replace(/\&gt\;/g,">")); }\n';
            txt += '        $(".notes-banner").click();\n';
            txt += '        renderMathInElement(document.body);\n';
            txt += '    });\n';
            txt += '</script>\n';
            txt += '</body>\n';
            txt += '</html>';

            var a = document.createElement('a');
            a.href = 'data:application/html,' + encodeURIComponent(txt);
            a.download = filename.replace('.json','.html');
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a); 
            break;
        default : 
            break;
    }
}


//------------------------------------------------------------------------------
Save.prototype.showResults = function() { 
    $(this.$transit).html("");
    $(this.$notes).html("");
    $(this.$comment).html("");

    var contains = $("#enibook-main").find(".container");
    if (contains.length > 0) {
        var containers = EniBook['assessing']['container'];
        for (var j = 0; j < contains.length; j++) {
            var contain = contains[j];
            var idcontain = $(contain).attr('id');
            var idref = idcontain.split('-')[0];
            if (Object.keys(containers).indexOf(idref) !== -1) {
                //EniBook[idref].update();
                var exos = $(contain).find(".exercise"); 
                var items = EniBook['assessing']['container'][idref]['items']; 
                if (items.length === exos.length) {
                    var choicesCont = parseInt($(contain).attr('choices'));
                    var exercises = EniBook['assessing']['exercise']; 
                    for (var k = 0; k < exos.length && k < choicesCont; k++) {
                        var exo = exos[k];
                        var idexo = $(exo).attr('id');
                        var id = idexo.split('-')[0]; 
                        if (Object.keys(exercises).indexOf(id) !== -1) {
                            if (EniBook[id]) { 
                                this.processCriteria(id);
                                var choices = parseInt($('#' + id + '-exercise').attr('choices'));
                                var $questions = $('#' + id).find(".question");  
                                for (var i = 0; i < $questions.length && i < choices; i++) {
                                    var question = $($questions[i]).attr('id');
                                    if (EniBook['assessing']['question'][question]) { 
                                        this.processQuestion(id,question);
                                        var $tools = $('#' + question).find(".mcq,.run,.input,.inputlines,.multisort,.q-mcq,.graph");
                                        for (var m = 0; m < $tools.length; m++) {
                                            var toolid = $($tools[m]).attr('id'); 
                                            var tool = toolid.split("-");
                                            var idtool = tool[0]; 
                                            //if (EniBook[idtool] && $("#" + idtool).parents(".solution").length === 0) {
                                            if (EniBook[idtool] && 
                                                EniBook[idtool].parents(".solution").length === 0 &&
                                                EniBook[idtool].parents(".answer").length > 0) {
                                                    this.processTool(question,idtool);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    else {
        var exos = $("#enibook-main").find(".exercise"); 
        var exercises = EniBook['assessing']['exercise']; 
        for (var k = 0; k < exos.length; k++) {
            var exo = exos[k];
            var idexo = $(exo).attr('id');
            var id = idexo.split('-')[0]; 
            if (Object.keys(exercises).indexOf(id) !== -1) {
                if (EniBook[id]) { 
                    this.processCriteria(id);
                    var choices = parseInt($('#' + id + '-exercise').attr('choices'));
                    var $questions = $('#' + id).find(".question");  
                    for (var i = 0; i < $questions.length && i < choices; i++) {
                        var question = $($questions[i]).attr('id');
                        if (EniBook['assessing']['question'][question]) {
                            this.processQuestion(id,question);
                            var $tools = $('#' + question).find(".mcq,.run,.input,.inputlines,.multisort,.sort,.q-mcq,.graph");
                            for (var j = 0; j < $tools.length; j++) {
                                var toolid = $($tools[j]).attr('id'); 
                                var tool = toolid.split("-");
                                var idtool = tool[0];
                                if (EniBook[idtool] && 
                                    EniBook[idtool].parents(".solution").length === 0 &&
                                    EniBook[idtool].parents(".answer").length > 0) {
                                        this.processTool(question,idtool); 
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (EniBook.mode === "training") {
        var globalcomment = `<div id="${this.id}-globalcomment-div"><p class="commentreplay-legend">Commentaire global</p><div class="commentreplay" id="${this.id}-globalcomment" contenteditable="true"></div></div>`;
        $("#" + this.id + "-save-feedback-notes").append(globalcomment); 
        if (typeof EniBook['assessing']['globalcomment'] != "undefined") { 
            $("#" + this.id + '-globalcomment').html(EniBook['assessing']['globalcomment']);
        }
        else { EniBook['assessing']['globalcomment'] = ""; }
    }
}

//------------------------------------------------------------------------------
Save.prototype.replay = function() { 
    $(this.$transit).html("");
    $(this.$notes).html("");
    $(this.$comment).html("");
    $("#" + this.id + '-save-feedback-student').html(EniBook['assessing']["student"]);

    var $welcome = $("#enibook-main").find(".notabene-subtitle[directive='welcome']");
    if ($welcome.length === 1) { $($welcome[0]).html(EniBook['assessing']["student"]); }

    var date  = new Date();
    var year  = date.getFullYear().toString();
    var month = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMonth() + 1);
    var day   = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getDate());

    if (EniBook["mode"] === 'training') { 
        $("#" + this.id + '-save-feedback-date').html(EniBook['assessing']["date"]);
        $("#" + this.id + '-mode').html("Correction"); 
        $("#" + this.id + "-table-evaluation-date").html(day + "/" + month + "/" + year);
    }
    else {
        EniBook['assessing']['date'] = day + "/" + month + "/" + year;
        $("#" + this.id + '-save-feedback-date').html(EniBook['assessing']['date']);
        $("#" + this.id + '-mode').html("Evaluation"); 
    }

    $(".exercise-block").show();

    // questions

    var containers = EniBook['assessing']['container'];
    var exercises  = EniBook['assessing']['exercise'];
    var questions  = EniBook['assessing']['question'];
    if (JSON.stringify(containers) !== "{}") { 
        for (var c in containers) { EniBook[c].update(); }
    }
    else {
        if (JSON.stringify(exercises) !== "{}") { 
            for (var e in exercises) { EniBook[e].update(); }
        }
        else { 
            for (var q in questions) { EniBook[q].update(); }
        }
    }

               
    switch (EniBook['mode']) {
        case 'training' :
            this.showResults();
            $.mobile.silentScroll($("#" + this.id + "-save-feedback").offset().top);
            break;
        default :
            $.mobile.silentScroll(0);
    }
}

//------------------------------------------------------------------------------
Save.prototype.retrieveQuestions = function(exercise) {
    var choices = parseInt($('#' + exercise + '-exercise').attr('choices'));
    var $questions = $('#' + exercise).find(".question");

    for (var i = 0; i < $questions.length && i < choices; i++) {
        var question = $($questions[i]).attr('id');
        if (EniBook['assessing']['question'][question]) {
            EniBook[question].update();
            this.processQuestion(exercise,question); // JT !
            this.retrieveTools(question);
            EniBook[question].close(); 

        }
    }
}

//------------------------------------------------------------------------------
Save.prototype.retrieveTools = function(question) {
    var $tools = $('#' + question).find(".mcq,.run,.input,.inputlines,.multisort,.q-mcq,.graph");
    for (var i = 0; i < $tools.length; i++) {
        
        var toolid = $($tools[i]).attr('id'); 
        var tool = toolid.split("-");
        var id = tool[0];
        if (EniBook[id] && EniBook[id].parents(".solution").length === 0) {
            //EniBook[id].update(); 
            this.processTool(question,id);
        }
    }
}

//------------------------------------------------------------------------------
Save.prototype.changeEval = function() { 
    this.allnotes = true;
    var $inputs = $("#" + this.id + "-save-feedback-notes").find(".changeEval");
    for (var i = 0; i < $inputs.length; i++) {
        var exerciseid  = $($inputs[i]).attr('exercise');
        var criterianum = $($inputs[i]).attr('criteria');
        if (typeof EniBook['assessing']['exercise'][exerciseid]['criteria'] == "undefined") {
            EniBook['assessing']['exercise'][exerciseid]['criteria'] = {};
        }
        EniBook['assessing']['exercise'][exerciseid]['criteria'][criterianum] = $($inputs[i]).val();
    }
 
    switch (this.note) {
        case 'sum' :
            var note = 0;
            for (var i = 0; i < $inputs.length; i++) {
                var v = $($inputs[i]).val(); 
                var coefs = $($inputs[i]).attr('placeholder').split("*");
                var coef = coefs.length == 2 ? coefs[1] : "1";
                if (v) { note += parseFloat(v) *  parseFloat(coef); }
                else { this.allnotes = false; }
            }
            $("#" + this.id + "-table-evaluation-evaluation").val(note.toString());
            break;
        case 'avg' :
            var note = 0;
            var sumcoef = 0;
            for (var i = 0; i < $inputs.length; i++) {
                var v = $($inputs[i]).val();
                var coefs = $($inputs[i]).attr('placeholder').split("*");
                var coef = coefs.length == 2 ? coefs[1] : "1";
                sumcoef += parseFloat(coef);
                if (v) { note += parseFloat(v) *  parseFloat(coef); }
                else { this.allnotes = false; }
            }
            note = (note/sumcoef).toFixed(2);
            $("#" + this.id + "-table-evaluation-evaluation").val(note);
            break;
        case 'min' :
            var note = 1000;
            for (var i = 0; i < $inputs.length; i++) {
                var v = $($inputs[i]).val();
                var coefs = $($inputs[i]).attr('placeholder').split("*");
                var coef = coefs.length == 2 ? coefs[1] : "1";
                if (v) { note = Math.min(note,parseFloat(v) *  parseFloat(coef)); }
                else { this.allnotes = false; }
            }
            $("#" + this.id + "-table-evaluation-evaluation").val(note);
            break;
        case 'max' :
            var note = -1000;
            for (var i = 0; i < $inputs.length; i++) {
                var v = $($inputs[i]).val();
                var coefs = $($inputs[i]).attr('placeholder').split("*");
                var coef = coefs.length == 2 ? coefs[1] : "1";
                if (v) { note = Math.max(note,parseFloat(v) *  parseFloat(coef)); }
                else { this.allnotes = false; }
            }
            $("#" + this.id + "-table-evaluation-evaluation").val(note);
            break;
        default :
            $("#" + this.id + "-table-evaluation-evaluation").val("-----");
            break;
    }
    this.changeValid();

}

//------------------------------------------------------------------------------
Save.prototype.changeValid = function() {
    var note  = parseInt($("#" + this.id + "-table-evaluation-evaluation").val());
    var valid = eval(this.valid);

    var spans = $("#" + this.id + "-table-evaluation-validation").find("span");
    if (spans.length > 0) {
        if (typeof valid === "boolean") { txt = valid ? "Oui" : "Non"; }
        else { txt = "-----"; }
        $(spans[0]).html(txt);
    }
}

//------------------------------------------------------------------------------
Save.prototype.processCriteria = function(id) {
    var exercise = EniBook[id];
    var criteria = exercise.criteria ? exercise.criteria.split(",") : []; 

    var placeholder = '';
    var size = 5;
    var value = '';
    var title = exercise.title;

    var span = "<span>";
    for (var i = 0; i < criteria.length; i++) {
        criterion = criteria[i].split(":");
        span += criterion[0] + ": ";

        var type  = 'text';
        if (criterion[1]) {           
            placeholder = criterion[1].split("*").length === 2 ? criterion[1] : criterion[1] + "*1";
            size = criterion[1].length.toString();
        }
        else {
             placeholder = 'texte';
             size = '10';
        }
        span += "<input class='changeEval' exercise='" + id + "' criteria='" + i + "' onchange='EniBook[\"" + this.id + 
                "\"].changeEval();' type='" + type + "' size='" + size + "' placeholder='" + placeholder + "' value='" + value + "'";
        span += (EniBook['mode'] === 'assessing') ? " readonly" : "";
        span += "></input>" + "&nbsp;&nbsp;"; 
    }
    span += "</span>";

    var table = "<table width='100%'><tr><td id='" + id + "-notes-banner-title' onclick='$(\"#" + id + "-div-notes-questions\").toggle();'>" + title + "</td><td style='text-align:right;'>" + span + "</td></tr></table>";

    var $h3 = "<h3 id='" + id + "-notes-banner' class='notes-banner'>" + table + "</h3>";
    $(this.$notes).append($h3);

    var $div_question = $("<div></div>");
    $($div_question).attr('id',id + '-div-notes-questions');
    $($div_question).attr('class','div-notes-questions user-class-div-notes-questions');
    var $ol = $("<ol></ol>");
    $($ol).attr('id',id + '-ol-questions');
    $($div_question).append($ol);
    $($div_question).css('display','block');
    $(this.$notes).append($div_question);

    if (EniBook['mode'] === 'training') {
        if (typeof EniBook['assessing']['exercise'][id]['criteria'] != "undefined") {
            for (var i = 0; i < criteria.length; i++) {
                if (typeof EniBook['assessing']['exercise'][id]['criteria'][i.toString()] != "undefined") {
                    var crits = $("#" + id + "-notes-banner").find(".changeEval[exercise=" + id + "]");
                    if (crits.length === criteria.length) {
                        $(crits[i]).val(EniBook['assessing']['exercise'][id]['criteria'][i.toString()]);
                    }
                }
            }
        }
    }

    //$("#" + id + "-notes-banner-title").on('click', function() { $('#' + id + '-div-notes-questions').toggle(); } );
}

//------------------------------------------------------------------------------
Save.prototype.processQuestion = function(exercise,question) {
    var title = $("#" + question + '-question-title').html();

    var $li = $("<li></li>");
    $($li).attr('id',question + '-li-question');
    $($li).html('<span style="font-weight:bolder;">' + title + '</span>');
    $($li).css('font-variant','small-caps');
    $('#' + exercise + '-ol-questions').append($li);

    var $p  = $("<div></div>");
    $($p).css('font-style','normal');
    $($p).css('font-variant','normal');
    $($p).css('width','100%');
    $($li).append($p);

    var $ul = $("<ul></ul>");
    $($ul).attr('id',question + '-ul-question');
    $($ul).attr('class','ul-questions user-class-ul-questions');
    $($ul).css('display','inline-block');
    $($ul).css('width','48%');
    $($ul).css('vertical-align','top');
    $($ul).css('list-style-position','outside');
    $($p).append($ul);

    if (EniBook['mode'] === 'training') { 
        var solutions = $("#" + question).find(".solution[question='" + question + "']");
        if (solutions.length === 1) {
            var $div_solution = $("<div></div>");
            $($div_solution).attr('id',question + '-ul-solutions');
            $($div_solution).attr('class','ul-solutions user-class-ul-solutions');
            $($div_solution).css('display','inline-block');
            $($div_solution).css('width','48%');
            $($div_solution).css('padding','5px');
            $($div_solution).css('vertical-align','top');
            $($div_solution).html("<h4>Solution</h4>");
            
            var clone = $(solutions[0]).clone(true); 
            
            var elems = $(clone).find(".mcq,.run,.input,.inputlines,.multisort,.q-mcq,.graph");
            var elemArray = {}
            for (var i = 0; i < elems.length; i++) {
                if (elems[i].hasAttribute('id')) { 
                    var elemId = elems[i].getAttribute('id');
                    var prefixId = elemId.split('-')[0];
                    var re = new RegExp(prefixId,'g');
                    elemArray[elemId] =  prefixId;
                    var scripts = $(elems[i]).nextAll("script");
                    for (var j = 0; j < scripts.length; j++) {
                        var scriptTxt = $(scripts[j]).text();
                        scriptTxt = scriptTxt.replace(re,prefixId + '-clone');
                        $(scripts[j]).text(scriptTxt);
                    }
                    if ($(elems[i]).hasClass('run')) {
                        var cms = $(elems[i]).find('.CodeMirror');
                        for (var i = 0; i < cms.length; i++) { $(cms[i]).remove(); }
                    }
                 }
            }

            var allElems = $(clone).find("*");
            for (var i = 0; i < allElems.length; i++) {
                var e = allElems[i];      
                var eAttrs = e.attributes;
                for (var k = 0; k < eAttrs.length; k++) {
                    var attr = eAttrs[k];
                    var val = attr.value;
                    var name = attr.name;
                    for (var r in elemArray) { 
                        var prefixId = elemArray[r];
                        var regexp = new RegExp(prefixId,'g');
                        val = val.replace(regexp,prefixId + '-clone');
                        e.setAttribute(name,val);
                    }
                }
            }

            var h5s = $(clone).children("h5");
            if (h5s.length === 1) { $(h5s[0]).remove(); }

            $($div_solution).append($(clone).html());
            $($p).append($div_solution);
            renderKatex($($div_solution).attr('id'));
        }
    }         
}

//------------------------------------------------------------------------------
Save.prototype.processTool = function(question,id) { 
    var obj = EniBook[id];
    var title = EniBook[id].title; 
    var directive = obj.directive;

    var parents = [];
    switch (directive) {
        case 'q-mcq' :
            if ($("#" + id + "-q-mcq").parents("[directive='mcq']").length == 0) {
                parents = $("#" + id + "-q-mcq").parents(".answer,.question");
            }
            break;
        case 'mcq' :
            parents = $("#" + id + "-mcq").parents(".answer,.question"); 
            break;
        case 'input' :
        case 'roleinput' :
            parents = $("#" + id + "-input").parents(".answer,.question"); 
            break;
        case 'inputlines' :
            parents = $("#" + id + "-inputlines").parents(".answer,.question"); 
            break;            
        case 'code-run' :
            parents = $("#" + id + "-edit").parents(".answer,.question"); 
            break;  
        case 'sort' :
            if ($("#" + id + "-sort-block").parents("[directive='multisort']").length == 0) {
                parents = $("#" + id + "-sort-block").parents(".answer,.question");
            }
            break;          
        case 'multisort' : 
            parents = $("#" + id + "-multisort").parents(".answer,.question"); 
            break; 
        case 'graph' :
            parents = $("#" + id + "-graph").parents(".answer,.question"); 
            break;          
        default:
            parents = [];
    }


    if (parents.length > 0) { 
        var $li = $("<li></li>");
        $($li).attr('id',question + '-li-question');
        $($li).css('font-style','normal');
        $($li).css('font-variant','normal');
        $($li).css('min-width','100%');
        $($li).append(title);
        $('#' + question + '-ul-question').append($li);

        var spanSaved = "<span style='color: blue; padding: 2px; border: 1px solid rgba(162,169,63,0.1); background-color: rgba(144,209,223,0.1); font-size: 120%'>&#9997;</span>";
        var spanYes = "<span style='color: green; padding: 2px; border: 1px solid rgba(162,169,63,0.1); background-color: rgba(162,169,63,0.1); font-size: 120%'>&#10004;</span>";
        var spanNo  = "<span style='color: red; padding: 2px; border: 1px solid rgba(233,96,124,0.1); background-color: rgba(233,96,124,0.1);   font-size: 120%'>&#10006;</span>"; 
        var spanSpace  = "<span style='color: white; padding: 2px; border: 1px solid white; background-color: white;   font-size: 120%'>&nbsp;</span>"; 

        var txt = '';
        switch (directive) {
            case 'q-mcq' : 
                if ($("#" + id + "-q-mcq").parents("[directive='mcq']").length == 0) {
                    if (title) { $($li).append("<br />"); }
                    var $ps = $("#" + obj.id + "-q-mcq").children("p:first");
                    if ($ps.length > 0) {
                        var $p = $ps[0];
                        var txt = EniBook['mode'] !== 'assessing' ? "<span style='color: blue; background-color:rgba(144,209,223,0.1);'>" + obj.score + "</span>&nbsp;&nbsp;" : "";
                        $($li).append("<em>" + $($p).html() + " ...</em><br />" + txt);
                    }
                    var $labels  = $(obj.$content).find('label');
                    var user = EniBook['assessing']['q-mcq'][id]['user']; 
                    if (user.length === 0) {
                        if (EniBook['mode'] !== 'assessing') { var litxt = spanNo; $($li).append(litxt); }
                    }
                    for (var j = 0; j < user.length; j++) {
                        var span = "";
                        if (EniBook['mode'] !== 'assessing') { span = $($labels[user[j]]).attr('actual') === 'true' ? spanYes : spanNo; }
                        var litxt = span + "<pre style='margin-right: 15px; padding: 5px;margin-left: 5px;display:inline;background-color:rgba(211,211,211,0.2);'>" + (user[j]+1).toString() + " : " + obj.storage.items[obj.storage.tirage[user[j]]] + "</pre>";
                        $($li).append(litxt);
                    }  
                }
                break;
            case 'mcq' :
                var $ulmcq = $("<ul></ul>");
                $($ulmcq).attr('id',question + '-ul-mulmcq');

                var ids = obj.qmcqId(); 
                for (var i = 0; i < ids.length && i < obj.choices; i++) {
                    var idqmcq = ids[i];                  
                    if (EniBook[idqmcq]) {
                        var qmcqObj = EniBook[idqmcq];
                        var $liqmcq = $("<li></li>");
                        $($liqmcq).html("<b>" + qmcqObj.title + "</b><br />");
                        var $ps = $("#" + qmcqObj.id + "-q-mcq").children("p:first");
                        if ($ps.length > 0) {
                            var $p = $ps[0];
                            var txt = EniBook['mode'] !== 'assessing' ? "<span style='color: blue; background-color:rgba(144,209,223,0.1);'>" + qmcqObj.score + "</span>&nbsp;&nbsp;" : "";
                            $($liqmcq).append("<small><em>" + $($p).html() + "...</em></small><br />" + txt);
                        }
                        var $labels  = $(qmcqObj.$content).find('label');
                        var user = EniBook['assessing']['q-mcq'][idqmcq]['user']; 
                        if (user.length === 0) {
                            if (EniBook['mode'] !== 'assessing') { var litxt = spanNo; $($liqmcq).append(litxt); }
                        }
                        for (var j = 0; j < user.length; j++) {
                            var span = "";
                            if (EniBook['mode'] !== 'assessing') { span = $($labels[user[j]]).attr('actual') === 'true' ? spanYes : spanNo; }
                            var litxt = span + "<pre style='margin-right: 15px; padding: 5px;margin-left: 5px;display:inline;background-color:rgba(211,211,211,0.2);'>" + (user[j]+1).toString() + " : " + qmcqObj.storage.items[qmcqObj.storage.tirage[user[j]]] + "</pre>";
                            $($liqmcq).append(litxt);
                        }                       
                        $($ulmcq).append($liqmcq);
                    }
                }
                $($li).append($ulmcq);
                break;
            case 'input' :
                var user = EniBook['assessing']['input'][id]['user']; 
                $(obj.$input).val(user);
                txt += $(obj.$input).val().replace(/</g,'&lt;').replace(/>/g,'&gt;'); 
                var span = "<br />";
                if (EniBook['mode'] !== 'assessing') { 
                    span += ($(obj.$block).attr("success") == 'true') ? spanYes : spanNo; 
                }
                var litxt = span + "<pre style='padding: 5px;margin-left: 5px;display:inline;background-color:rgba(211,211,211,0.2);'>" + txt + "</pre>";
                $($li).append(litxt);
                break;
            case 'roleinput' :
                var user = EniBook['assessing']['roleinput'][id]['user']; 
                $(obj.$input).val(user);
                txt += $(obj.$input).val().replace(/</g,'&lt;').replace(/>/g,'&gt;'); 
                var span = "<br />";
                if (EniBook['mode'] !== 'assessing') { 
                    span += ($(obj.$block).attr("success") == 'true') ? spanYes : spanNo; 
                }
                var litxt = span + "<pre style='padding: 5px;margin-left: 5px;display:inline;background-color:rgba(211,211,211,0.2);'>" + txt + "</pre>";
                $($li).append(litxt);
                break;
            case 'inputlines' : 
                var user = EniBook['assessing']['inputlines'][id]['user']; 
                $(obj.$input).val(user);
                txt += $(obj.$input).val().replace(/</g,'&lt;').replace(/>/g,'&gt;'); 
                var $pre = $("<pre></pre>");
                $($pre).css('background-color','rgba(211,211,211,0.2)');
                $($pre).css('margin','5px');
                $($pre).css('padding','5px');
                $($pre).css('border-radius','4px');
                $($pre).append(txt);
                $($li).append($pre);
                break;
            case 'code-run' : 
                var user = EniBook['assessing']['code-run'][id]['user']; 
                obj.edit.setValue(user);
                txt += obj.edit.getValue().replace(/</g,'&lt;').replace(/>/g,'&gt;');
                var $pre = $("<pre></pre>");
                $($pre).css('background-color','rgba(211,211,211,0.2)');
                $($pre).css('margin','5px');
                $($pre).css('padding','5px');
                $($pre).css('border-radius','4px');
                var $code = $("<code></code>");
                $($code).attr('class',obj.edit.language)
                $($code).append(txt);
                $($pre).append($code);
                $($li).append($pre);
                break;
            case 'graph' :
                var user = EniBook['assessing']['graph'][id]['user']['code']; 
                $(obj.$code).val(user);
                txt += $(obj.$code).val().replace(/</g,'&lt;').replace(/>/g,'&gt;');
                var $pre = $("<pre></pre>");
                $($pre).css('background-color','rgba(211,211,211,0.2)');
                $($pre).css('margin','5px');
                $($pre).css('padding','5px');
                $($pre).css('border-radius','4px');
                $($pre).css('overflow-x','auto');
                $($pre).append(txt);
                $($li).append("<div style='width:100%'><img src='" + EniBook['assessing'][obj.directive][obj.id].user.png + "' style='width:100%;'></img></div>");
                $($li).append($pre);
                break;
            case 'multisort' :
                var $ulmultisort = $("<ul></ul>");
                $($ulmultisort).attr('id',question + '-ul-multisort');
                var ids = obj.sortId(); 
                var $ultable = $("<table></table>");
                var $tabletr = $("<tr></tr>");
                for (var i = 0; i < ids.length; i++) {
                    var idsort = ids[i];        
                    if (EniBook[idsort]) {
                        var sortObj = EniBook[idsort];
                        var $lisort = $("<li></li>");
                        $($lisort).append(sortObj.title); 
                        var litxt = '';
                        if (EniBook['assessing']['sort'][idsort]['user'].length !== 0) {
                            var len = sortObj.storage.txt.length;
                            for (var j = 0; j < len; j++) {
                                var str = sortObj.storage.txt[EniBook['assessing']['sort'][idsort]['user'][j]];
                                var index = str.indexOf('>'); 
                                if (index !== -1 && index !== litxt.length - 1) {
                                    var prefix = str.substring(0,index+1);
                                    var suffix = str.substring(index+1);
                                    str  = prefix;
                                    if (EniBook['mode'] !== 'assessing') {
                                        if (ids.length === 1) { // sort
                                            str +=  (sortObj.results[j] ? spanYes : spanNo) + "&nbsp;";
                                        }
                                        else { // association
                                            if (i !== 0) { str += (sortObj.results[j] ? spanYes : spanNo) + "&nbsp;"; }
                                            else { str += spanSpace + "&nbsp;"; }
                                        } 
                                    }                                 
                                    str += suffix;
                                }
                                litxt += str;
                            }
                        }
                        else { litxt += ''; } 
                        var txt = EniBook['mode'] !== 'assessing' ? "&nbsp;&nbsp;<span style='color: blue; background-color:rgba(144,209,223,0.1);'>" + obj.score + "</span>&nbsp;&nbsp;" : "";                        
                        var $lipre = $("<pre></pre>");
                        $($lipre).css('background-color','rgba(211,211,211,0.2)');
                        $($lipre).css('display','inline');
                        $($lipre).css('margin','5px');
                        $($lipre).css('padding','5px');
                        $($lipre).css('border-radius','4px');
                        if ($(obj.$sorts[0]).attr('code') !== "undefined") {
                            var $code = $("<code></code>");
                            $($code).attr('class',$(obj.$sorts[0]).attr('code'));
                            $($code).append(litxt);
                            $($lipre).append($code);
                        }
                        else {
                            $($lipre).append(litxt);
                        }
                        $($lisort).append(txt);
                        $($lisort).append($lipre);

                        var $td = $("<td></td>");
                        $($td).attr('id', question + "-td-" + i.toString());
                        $($td).append($lisort);
                        $($tabletr).append($td);
                    }
                }
                $($ultable).append($tabletr);
                $($ulmultisort).append($ultable);
                $($li).append($ulmultisort);
                break;
            default :
                txt += 'directive « ' + directive + ' » non traitée dans « Save.prototype.processTool » !';
                var $pre = $("<pre></pre>");
                $($pre).css('background-color','rgba(211,211,211,0.2)');
                $($pre).css('margin','5px');
                $($pre).css('padding','5px');
                $($pre).css('border-radius','4px');
                $($pre).append(txt);
                $($li).append($pre);
        }

        if (EniBook['mode'] === 'training') {
            var localcomment = '<div class="commentreplay" id="' + id + '-commentreplay" ' +
                               'contenteditable="true" directive="' + directive + '" tool="' + id + '" ' +
                               '></div>';
            $($li).append(localcomment);
            if (typeof EniBook['assessing'][directive][id]['commentreplay'] != "undefined") { 
                $("#" + id + '-commentreplay').html(EniBook['assessing'][directive][id]['commentreplay']);
            }
            else { EniBook['assessing'][directive][id]['commentreplay'] = ""; }
        }
    }
}

//------------------------------------------------------------------------------
Save.prototype.processComment = function() { 
    var saveid = this.id;
    $(this.$comment).html("");
    var comment = EniBook[this.id + '-comment'].edit.getValue(); 
    $h3 = "<h3 id='" + this.id + "-notes-banner-comment' style='cursor: pointer; font-weight: normal; font-variant:small-caps; background-color: rgb(234,138,0); color: white;'>Commentaires</h3>";
    $(this.$comment).append($h3); 
    $div = $("<div></div>");
    $($div).attr('id',this.id + '-div-comment');
    var spanYes = "<span style='color: green; padding: 2px; border: 1px solid rgba(162,169,63,0.1); background-color: rgba(162,169,63,0.1); font-size: 120%'>&#10004;</span>";
    var spanNo  = "<span style='color: red; padding: 2px; border: 1px solid rgba(233,96,124,0.1); background-color: rgba(233,96,124,0.1);   font-size: 120%'>&#10006;</span>"; 
    var remark  = "<p><b>Remarque : </b> A titre indicatif, les coches " + spanYes + " et " + spanNo + " ont été introduites automatiquement par le système";
    remark     += " en comparant la réponse de l'étudiant avec une solution proposée par l'auteur du contrôle;";
    remark     += " c'est toujours au correcteur qu'il revient de décider en dernier ressort.";
    $($div).html(remark + comment);
    $($div).css('display','none');
    $(this.$comment).append($div); 
    $("#" + this.id + "-notes-banner-comment").on('click', function() { $('#' + saveid + '-div-comment').toggle(); } );   
}

//------------------------------------------------------------------------------
Save.prototype.processElement = function(element) { 
    if ($("#" + this.id + "-div-comment").css('display') === 'none') { $("#" + this.id + "-div-comment").show(); }

    var $localcomments = $(element).find("div.commentreplay");
    for (var i = 0; i < $localcomments.length; i++) {
        if ($($localcomments[i]).html() === "") { $($localcomments[i]).hide(); }
        else { $($localcomments[i]).show(); }
    }

    var $notes = $(element).find(".div-notes-questions");
    for (var i = 0; i < $notes.length; i++) {
        $($notes[i]).show();
    }
    var tabPlaceHolder = [];
    var $inputs = $(element).find("input");
    for (var i = 0; i < $inputs.length; i++) {
        var $input = $inputs[i];
        $($input).attr('value',$($input).val().toString());
        $($input).attr('readonly','readonly');
        tabPlaceHolder.push($($input).attr('placeholder'));
        $($input).attr('placeholder','');
    }
    var $selects = $(element).find("select");
    for (var i = 0; i < $selects.length; i++) {
        var $select = $selects[i];
        $($select).attr('value',$($select).val().toString());
        $($select).css('display','none');
    }

    var $tools = $(element).find(".mcq,.run,.input,.inputlines,.multisort,.q-mcq,.graph"); 
    for (var i = 0; i < $tools.length; i++) {
        var $tool = $tools[i];
        if ($tool.hasAttribute('id')) { 
            var toolId = $tool.getAttribute('id');
            var toolIdArray = toolId.split('-');
            if (toolIdArray.length >= 2 && toolIdArray[1] == 'clone') { EniBook[toolIdArray[0] + '-clone'].hide(); }
         }
    }

    var txt = element.outerHTML;

    for (var i = 0; i < $selects.length; i++) {
        var $select = $selects[i];
        $($select).attr('value','-----');
        $($select).css('display','block');
    }
    for (var i = 0; i < $inputs.length; i++) {
        var $input = $inputs[i];
        $($input).attr('value','');
        $($input).removeAttr('readonly');
        $($input).attr('placeholder',tabPlaceHolder[i]);
    } 

    if ($("#" + this.id + "-div-comment").css('display') === 'block') { $("#" + this.id + "-div-comment").hide(); }

    for (var i = 0; i < $localcomments.length; i++) {
        $($localcomments[i]).show();
    }

    return txt;      
}

//------------------------------------------------------------------------------
Save.prototype.loadConfigFile = function() { 
    if (!this.isSaved) { 
        var msg = "AVERTISSEMENT\n\n"
        msg    += this.savefile + " :\n";
        msg    += "\nLes dernières modifications\nn'ont pas été enregistrées !\n\n";
        msg    += "\nOK pour sauvegarder\n";
        var res = confirm(msg);
        if (res === true) { this.feedback(this.savefile); }
        this.isSaved = true;
    }
    else {
        var input = $("<input></input>");
        $(input).attr('type','file');
        $(input).attr('accept','.json');
        $(input).attr('id',this.id + '-uploadInput');
        $(input).attr('name',this.id + '-uploadInput');
        $(input).attr('onchange','EniBook["' + this.id + '"].loadFile("' + this.id + '",this.files);');
        $(input).click();
        $(input).remove();
    }
}


//------------------------------------------------------------------------------
Save.prototype.loadFile = function(id,files) { 
    var saveid = this.id;
    if (files.length > 0) { 
        for (var i = 0; i < files.length; i++) {
            var filetype = files[i].type; 
            var filename = files[i].name;
            this.configfile = filename; 
            if (filetype === '' || filetype.match('text/json') || filetype.match('text/x-json') || filetype.match('application/json')) {
                var filereader = new FileReader();
		        filereader.readAsText(files[i]);
                filereader.onloadend = function(e) { 
                    var txt = e.target.result; 
                    console.log('loading ' + filename + ' ...');
                    var obj = JSON.parse(txt);
                    obj.config = filename; 
                    if (!obj['timeversion'] || (obj['timeversion'] !== EniBook['timeversion'])) {
                        var msg = "ATTENTION :\n\n";
                        msg += "Les versions de la configuration et de l'EniBook sont incompatibles.\n\n";
                        msg += "Utiliser l'EniBook généré en même temps que le sujet\n";
                        msg += "version du " + obj['timeversion'] + '\n\n';
                        alert(msg);
                    }
                    else { 
                        enibookConfig(obj);
                        EniBook.configloaded = true;
                        EniBook[saveid].update();
                    }
                }
            $("#" + this.id + "-save-filename").html("<strong>Fichier de configuration : </strong>" + this.configfile);
            }
            else {
                alert(filename + ' : configuration incorrecte !');
            }
        }
    }
    else {
        alert('Aucun fichier de configuration sélectionné !');
    }
}

/******************************************************************************
 *
 * Question
 *
 ******************************************************************************/
//------------------------------------------------------------------------------
function Question(id) { // id : HTML identifier
    this.id           = id;
    this.$question    = $('#' + id + '-question');
    this.$questiondiv = $('#' + id + '-question-div');
    this.$footer      = $('#' + id + '-question-footer'); 
    this.title        = $('#' + id + '-question-title').html();
    this.collapse     = ($('#' + id + '-question').attr('collapse') === 'false') ? false : true;

    this.modeEnibook  = EniBook['mode']; 
    this.tools = {}

    var $answer   = $(this.$question).children(".answer[question=" + id + "]"); 
    if ($answer.length == 1) { 
        this.$answer = $answer[0];
        $(this.$answer).css('display','block');
        $(this.$answer).css('width','100%'); 
    }
    else { this.$answer = undefined; }
    
    var $solution = $(this.$question).children(".solution[question=" + id + "]");
    if ($solution.length == 1) { 
        this.$solution = $solution[0]; 
        $(this.$solution).hide();
    }
    else { 
        this.$solution = undefined;
        $("#" + this.id + "-solution-title").html("Pas de solution"); 
    }

    for (var i = 0; i < EniBook['tools'].length; i++) {
        this.tools[EniBook['tools'][i]] = [];
        var tools = $(this.$question).find("." + EniBook['tools'][i]); 
        for (var j = 0; j < tools.length; j++) { 
            var toolid = $(tools[j]).attr('id').replace('-' + EniBook['tools'][i],''); 
            this.tools[EniBook['tools'][i]].push(toolid);
        }
    }

    if (this.collapse) { $("#" + this.id).hide(); }

    else { $("#" + this.id).show(); }

    this.update();
    //console.log('initializing ',this.id);

};

//------------------------------------------------------------------------------
Question.prototype.update = function() {
    if (this.$answer != undefined) {
        $(this.$answer).css('display','block');
        $(this.$answer).css('width','100%'); 
    }
    if (this.$solution != undefined) {
        $(this.$solution).hide();
    }
  

    switch (EniBook['mode']) {
        case 'training' :
            $("#" + this.id + "-solution-title").html("Solution");
            format_template(this.$question,EniBook['assessing']['question'][this.id].aleadico);
            for (var i = 0; i < EniBook['tools'].length; i++) {
                var toolids = this.tools[EniBook['tools'][i]];
                for (var j = 0; j < toolids.length; j++) { 
                    if (EniBook.hasOwnProperty(toolids[j])) { 
                        EniBook[toolids[j]].update();
                        if (toolids[j].indexOf('mcq') != 0 && toolids[j].indexOf('multisort') != 0 ) { EniBook[toolids[j]].feedback(); } // pb JT
                    }
                }
            }
            if (!EniBook.configloaded) { $(this.$questiondiv).hide(); }
            else { $(this.$questiondiv).show(); }
            break;
        case 'assessing' :
            $("#" + this.id + "-solution-title").html("Pas de solution en mode évaluation");
            format_template(this.$question,EniBook['assessing']['question'][this.id].aleadico);
            for (var i = 0; i < EniBook['tools'].length; i++) {
                var toolids = this.tools[EniBook['tools'][i]];
                for (var j = 0; j < toolids.length; j++) { 
                    if (EniBook.hasOwnProperty(toolids[j])) { EniBook[toolids[j]].update(); }
                }
            }
            if (!EniBook.configloaded) { $(this.$questiondiv).hide(); }
            else { $(this.$questiondiv).show(); }
            break;
        default :
            break;
    }

    refreshEditors(this.id);
    renderKatex(this.id + '-question');
    //$.mobile.silentScroll($("#" + this.id + "-question-div").offset().top); 
};

//------------------------------------------------------------------------------
function format_template() { 
    var theElement = arguments[0];
    var theDico    = arguments[1];
    if (theElement !== undefined && theDico !== undefined) {
        var $ps = $(theElement).find('p,pre,span,textarea,label'); 
        var $qmcqs = $(theElement).find('div.q-mcq');
        var $roleinputs = $(theElement).find('span.role-input-block'); 

        for (key in theDico) {
            var  regEx = new RegExp("¿" + key + "¿","gm");  
            for (var i = 0; i < $roleinputs.length; i++) {
                var roleid = $($roleinputs[i]).attr('id').replace('-input-block','');
                EniBook[roleid].solution = EniBook[roleid].solution.replace(regEx,theDico[key]);
                EniBook[roleid].re = EniBook[roleid].re.replace(regEx,theDico[key]);
            }       
            for (var i = 0; i < $qmcqs.length; i++) {
                var qmcqid = $($qmcqs[i]).attr('id').replace('-q-mcq','');
                var lgr = EniBook[qmcqid].storage.items.length; 
                for (var j = 0; j < lgr; j++) { 
                    EniBook[qmcqid].storage.items[j] = EniBook[qmcqid].storage.items[j].replace(regEx,theDico[key]);
                }
                //EniBook[qmcqid].update();
            }
            for (var i = 0; i < $ps.length; i++) { 
                if ($($ps[i]).html().indexOf('<script type="text/javascript">') === -1 &&
                    $($ps[i]).html().indexOf('<input ') === -1) { 
                    if ( $($ps[i]).html().match(regEx) ) { 
                        $($ps[i]).html($($ps[i]).html().replace(regEx,theDico[key]));
                    }
                }
            }
        }
    }
}

//------------------------------------------------------------------------------
Question.prototype.toggle = function() { 
    if ($("#" + this.id).css('display') === 'none') { this.open(); }
    else { this.close(); }
}

//------------------------------------------------------------------------------
Question.prototype.open = function() { 
    $("#" + this.id).show(); 
    refreshEditors(this.id); 
    renderKatex(this.id + '-question');
}

//------------------------------------------------------------------------------
Question.prototype.close = function() {
    $("#" + this.id).hide();
}

//------------------------------------------------------------------------------
Question.prototype.answer = function() { 
    refreshEditors($(this.$answer).attr('id')); 
    var $diagrams = $("#" + this.id).find(".graph"); 
    for (var i = 0; i < $diagrams.length; i++) { 
        var id = $($diagrams[i]).attr("id").replace("-graph",""); 
        EniBook[id].refresh();
    }
    //$.mobile.silentScroll($("#" + this.id + "-question-div").offset().top); 
};

//------------------------------------------------------------------------------
Question.prototype.solution = function() { 
    switch (EniBook['mode']) {
        case "learning" :
        case "training" :
            if (this.$solution != undefined) {
                if (this.$answer != undefined) {
                    $(this.$answer).css('display','inline-block');
                    $(this.$answer).css('width','48%'); 
                    $(this.$solution).css('display','inline-block');
                    $(this.$solution).css('width','48%'); 
                }
                else {
                    $(this.$solution).css('display','block');
                    $(this.$solution).css('width','100%'); 
                }
                refreshEditors($(this.$solution).attr('id')); 
                var $diagrams = $("#" + this.id).find(".graph"); 
                for (var i = 0; i < $diagrams.length; i++) { 
                    var id = $($diagrams[i]).attr("id").replace("-graph",""); 
                    EniBook[id].refresh();
                }
            }
            else {
                if (this.$answer != undefined) {
                    $(this.$answer).css('display','block');
                    $(this.$answer).css('width','100%'); 
                }                
            }
            
            //$.mobile.silentScroll($("#" + this.id + "-question-div").offset().top); 
            break;
        default :
            break;
    }
}

/******************************************************************************
 *
 * CodeRun
 *
 ******************************************************************************/

//------------------------------------------------------------------------------
function CodeRun(id) { // id : HTML identifier
    this.id          = id;
    this.$block      = $('#' + id + '-run-block');
    this.$help       = $('#' + id + '-edit-help');
    this.$comment    = $('#' + id + '-edit-comment');
    this.$savebtn    = $('#' + id + '-run-save-btn');
    this.$input      = $('#' + id + '-input');
    this.$output     = $('#' + id + '-output');
    this.$div        = $('#' + id + '-run-div');
    this.$pre        = $('#' + id + '-run-pre');
    this.$canvas     = $('#' + id + '-run-canvas');
    this.$error      = $('#' + id + '-run-error');
    this.$iframe     = $('#' + id + '-run-iframe');
    this.$textarea   = document.getElementById(id); // Pb jQuery/CodeMirror ?
    this.$inputQuery = $('#' + id + '-input-query');
    
    this.errorMsg  = {};
    this.initErrorMsg();
    this.execLimit = parseInt($(this.$block).attr('execlimit'));
    this.title  = $(this.$textarea).attr('title');

    this.program = "";
    this.query = "";
    this.queries = [""];
    this.queryStack = 0;
    this.session = null;

    this.directive  = $(this.$block).attr('directive');
    this.modeEnibook= EniBook['mode']; //$(this.$block).attr('modeEnibook');
    this.typeEnibook= EniBook['type']; //$(this.$block).attr('typeEnibook');
    this.tries = 0;

    $(this.$div).html("");
    $(this.$pre).html("");
    $(this.$comment).html("");
    $(this.$canvas).css('display','none'); 
    $(this.$error).css('display','none'); 
    $(this.$div).css('display','none'); 
    $(this.$pre).css('display','none'); 
    $(this.$iframe).css('display','none'); 

    var content     = $("#" + id).text();
    var prefix      = $("#" + id + "-prefix").val(); 
    var suffix      = $("#" + id + "-suffix").val();
    var language    = this.$textarea.getAttribute('language'); 
    var mime        = this.$textarea.getAttribute('mime');
    var extension   = this.$textarea.getAttribute('extension');
    var site        = this.$textarea.getAttribute('site');
    var keymap      = this.$textarea.getAttribute('keymap'); 
    var colors      = this.$textarea.getAttribute('theme'); 
    var tabsize     = parseInt(this.$textarea.getAttribute('tabsize')); 
    var linenumbers = (this.$textarea.getAttribute('linenumbers') === 'true') ? true : false;

    if (language === 'css' || language === 'html') { language = 'htmlmixed'; }
    if (language === 'prolog') { $(this.$textarea).attr('placeholder','code « Prolog »'); }
    if (language === 'python') { $(this.$textarea).attr('placeholder','code « Python 2.7 »'); }
    if (language === 'javascript') { $(this.$textarea).attr('placeholder','code « Javascript »'); }
    if (language === 'txt') { $(this.$textarea).attr('placeholder','texte libre'); }

    var prefixlines = 0;
    if (prefix) { prefixlines = prefix.split('\n').length; }
    var firstline = parseInt(this.$textarea.getAttribute('firstline')) + prefixlines;

    this.edit = CodeMirror.fromTextArea( this.$textarea , 
        {
        mode             : mime,
        keyMap           : keymap,
        theme            : colors,
        lineNumbers      : linenumbers,
        firstLineNumber  : firstline,
        indentUnit       : tabsize,
        tabMode          : 'spaces',
        matchTags        : { bothTags: true },
        extraKeys        : {
                            "F1"  : function(cm) { EniBook[id].help(); },
                            "F10" : function(cm) { EniBook[id].doc(language,site); },
                            "F11" : function(cm) { cm.setOption("fullScreen", !cm.getOption("fullScreen")); },
                            "Tab" : function(cm) {
                                        var spaces = Array(cm.getOption("indentUnit") + 1).join(" ");
                                        cm.replaceSelection(spaces);
                                     },
                            "Ctrl-J": "toMatchingTag"
                           },
        styleActiveLine  : true,        
        styleSelectedText: true,
        matchBrackets    : true,
        autoRefresh      : true,
        autoMatchParens  : true,
        autofocus        : true
        });
    
    this.edit.id        = id;
    this.edit.prefix    = prefix;
    this.edit.suffix    = suffix;
    this.edit.language  = language;
    this.edit.mime      = mime;
    this.edit.extension = extension; 
    this.edit.site      = site;
    this.edit.file      = 'stdin';
    this.edit.setValue(content); 
    this.edit.initialcode = content;
    this.edit.setSize("100%","auto");

    if ($(this.$block).attr('collapse') === 'false') {
        $(this.$block).css('display','block');
        this.edit.refresh();
    }
    else {
        $(this.$block).css('display','none');
    }
    this.update();
    //console.log('initializing ',this.id);
}

//------------------------------------------------------------------------------
CodeRun.prototype.parents = function(selector) {
    return $(this.$block).parents(selector);
}

//------------------------------------------------------------------------------
CodeRun.prototype.update = function() { 
    this.edit.refresh();
}

//------------------------------------------------------------------------------
CodeRun.prototype.doc = function(lang,site) { 
    if (lang !== 'txt') {
        var a = document.createElement('a');
        a.href = site;
        a.target = "_blank";
        a['data-ajax'] = "false";
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a); 
    }
}

//------------------------------------------------------------------------------
CodeRun.prototype.hide = function() {
    $(this.$block).hide();
}

//------------------------------------------------------------------------------
CodeRun.prototype.show = function() {
    $(this.$block).show();
}

//------------------------------------------------------------------------------
CodeRun.prototype.collapse = function() { 
    if ($(this.$block).css('display') === 'none') {
        $(this.$block).css('display','block');
        this.edit.refresh();
    }
    else {
        $(this.$block).css('display','none');
    }

}

//------------------------------------------------------------------------------
CodeRun.prototype.initErrorMsg = function() {
}

//------------------------------------------------------------------------------
CodeRun.prototype.addErrorMessage = function(err) {
    alert("EniBook[" + this.id + "].addErrorMessage(" + err + ")");
}

//------------------------------------------------------------------------------
CodeRun.prototype.newFile = function () {
    this.edit.setValue("");
}

//------------------------------------------------------------------------------
CodeRun.prototype.openFile = function() {
    var input = $("<input></input>");
    $(input).attr('type','file');
    $(input).attr('accept',this.edit.extension);
    $(input).attr('id',this.id + 'uploadInput');
    $(input).attr('name',this.id + '-uploadInput');
    $(input).attr('multiple','multiple');
    $(input).attr('onchange','EniBook["' + this.edit.id + '"].loadFile("' + this.edit.id + '",this.files);');
    $(input).click();
    $(input).remove(); 
}

//------------------------------------------------------------------------------
CodeRun.prototype.loadFile = function(id,files) {
    if (files.length > 0) {
        for (var i = 0; i < files.length; i++) {
            var filetype = files[i].type;
            //if (filetype.match(this.edit.mime)) {
                var filereader = new FileReader();
		        filereader.readAsText(files[i]);
                filereader.onloadend = function(e) { 
                    var txt = e.target.result;
                    var obj = EniBook[id].edit;
                    obj.setValue(obj.getValue()+txt);
                    obj.refresh();
                }
            //}
        }
    }
}

//------------------------------------------------------------------------------
CodeRun.prototype.saveFile = function() {
    var a = document.createElement('a');
    a.href = 'data:application/octet-stream,' + encodeURIComponent(this.edit.getValue());
    a.download = this.edit.id + this.edit.extension;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
}

//------------------------------------------------------------------------------
CodeRun.prototype.saveOutput = function() {
    alert("EniBook[" + this.id + "].saveOutput()");
}

//------------------------------------------------------------------------------
CodeRun.prototype.printEdit = function() {
    var lines = new Array();
    lines = this.edit.getValue().split('\n');
    var head = "";

    var content = "<table class='table'>\n";
    for (var i = 0; i < lines.length; i++) {
        content += "<tr><td style='border-right: 1px solid #F5F5F5;'>" +
                   "<pre style='color: gray; font-size: small; text-align: right; margin: 0; padding: 0px 2px 0px 0px;'>" + (i+1).toString() + 
                   "</pre></td><td><pre style='font-size: normal; text-align: left; margin: 0; padding: 0px 0px 0px 5px;'>" + 
                   lines[i].replace('\t','    ').replace(/</g,'&lt;').replace(/>/g,'&gt;') + "</pre></td></tr>\n";
    }
    content += "</table>\n";
    var win = window.open(window.location);
    win.blur(); win.focus(); 
    win.document.title = "EniBook : éditeur " + this.edit.language;
    win.document.write("<!DOCTYPE html>\n<html>\n<head>\n<title>" + 
                        win.document.title +"</title>\n"+ head + 
                        "\n</head>\n<body>\n" + content +
                        "\n</body>\n</html>\n");
    win.print();
    win.close();
}

//------------------------------------------------------------------------------
CodeRun.prototype.help = function() {
    $("#enibook-help-content").html($(this.$help).html());
    $('#enibook-help-btn').click();
}

//------------------------------------------------------------------------------
CodeRun.prototype.clearInput = function() {
    $(this.$inputQuery).val("");
}

//------------------------------------------------------------------------------
CodeRun.prototype.clearOutput = function() {
    this.session = null;
    $(this.$canvas).css('display','none');
    $(this.$error).css('display','none');
    $(this.$pre).css('display','none');    
    $(this.$div).css('display','none');    
    $(this.$pre).html("");
    $(this.$div).html("");
    $(this.$error).html("");
    var iframeBody = window.frames[this.id + '-run-iframe']; 
    //if (iframeBody != null) { iframeBody.document.body.innerHTML = ""; }
}

//------------------------------------------------------------------------------
CodeRun.prototype.feedback = function() {
    alert("EniBook[" + this.id + "].feedback()");
}

//------------------------------------------------------------------------------
CodeRun.prototype.processQuery = function(event) {
	// Down
	if( event.keyCode === 40 ) {
		this.queryStack++;
		if( this.queryStack >= this.queries.length ) this.queryStack = 0;
		$(this.$inputQuery).val(this.queries[this.queryStack]);
	// Up
	} else if( event.keyCode === 38 ) {
		this.queryStack--;
		if( this.queryStack < 0 ) this.queryStack = this.queries.length - 1;
		$(this.$inputQuery).val(this.queries[this.queryStack]);
	// Enter
	} else if( event.keyCode === 13 ) {
        this.feedback();
	}
}

//------------------------------------------------------------------------------
CodeRun.prototype.processLanguageQuery = function() {
    alert("EniBook[" + this.id + "].processLanguageQuery()");    
}

//alert('Txt');
/******************************************************************************
 *
 * Txt
 *
 ******************************************************************************/
function Txt(id) { // id : HTML identifier
    CodeRun.call(this,id); // inherits from CodeRun

    $(this.$pre).css('display','none');
    $(this.$canvas).css('display','none');
    $(this.$canvas).css('background-color','white');
    $(this.$savebtn).css('display','none');
    $("#" + this.id + "-display-btn-help").css('display','none');
}

//-----------------------------------------------------------------------------
Txt.prototype = Object.create(CodeRun.prototype); // inherits from CodeRun

//------------------------------------------------------------------------------
Txt.prototype.update = function() {
    var parents = $("#" + this.id).parents(".answer"); 
    if(parents.length === 1 && EniBook['mode'] !== 'learning') { 
        $(this.$block).css('display','block');
        var questions = $("#" + this.id).parents(".question"); 
        if(questions.length !== 0) {
            this.edit.setValue(EniBook['assessing'][this.directive][this.id].user);
        }
    }
    this.edit.refresh();
}

//------------------------------------------------------------------------------
Txt.prototype.feedback = function() {
    this.tries += 1;
    var language = this.$textarea.getAttribute('language');
    var filename = this.$textarea.getAttribute('file');
    if (EniBook['mode'] === 'assessing') { // assessing mode
        var date    = new Date();
        var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
        var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes());
        $("#" + this.id + "-pre-comment").css('display','block');
        $("#" + this.id + "-pre-comment").html("Essai " + this.tries.toString() + " mémorisé à " + hour + "h" + minutes + ".<br />");
        EniBook['assessing'][this.directive][this.id].user = this.edit.getValue(); 
        EniBook['assessing'][this.directive][this.id].title = language + ":" + filename;
    } 
    $(this.$pre).css('display','block');
    $(this.$pre).html("Pas d'interprétation du « texte libre ».<br />");
}

/******************************************************************************
 *
 * Prolog
 *
 ******************************************************************************/
function Prolog(id) { // id : HTML identifier
    CodeRun.call(this,id); // inherits from CodeRun
    this.session = null;
}

//-----------------------------------------------------------------------------
Prolog.prototype = Object.create(CodeRun.prototype); // inherits from CodeRun

//------------------------------------------------------------------------------
Prolog.prototype.update = function() {
    $(this.$input).show();
    this.edit.refresh();
}

//------------------------------------------------------------------------------
Prolog.prototype.processLanguageQuery = function() {
    $(this.$pre).show();
    pl.stdout = this.id + "-run-pre";
    pl.stderr = this.id + "-run-error";
    var newProgram = this.edit.getValue();
    var newQuery = $(this.$inputQuery).val();
    if( this.session == null || this.program !== newProgram || this.query !== newQuery ) {
        this.clearOutput();
        this.queries.push( newQuery );
        this.queryStack = this.queries.length - 1;
        this.session = pl.create(10000);
        var c = this.session.consult( newProgram );
        var q = this.session.query( newQuery );
        if( c !== true ) {
            var msg = '<b>Error parsing program:</b><br>'
            processError( msg + c.args[0], true );
            return;
        }
        if( q !== true ) {
            var msg = '<b>Error parsing query:</b></br>'
            processError( msg + q.args[0], true );
            return;
        }
    }
    this.session.answer( processAnswer );
	this.program = newProgram;
	this.query = newQuery;    
}

//------------------------------------------------------------------------------
function processAnswer( answer, format ) {
    var msg = (format ? answer : pl.format_answer( answer )) + "\n";
    $("#" + pl.stdout).show(); 
	$("#" + pl.stdout).append(msg); 
}

//------------------------------------------------------------------------------
function processError( answer, format ) {
    var msg = (format ? answer : pl.format_answer( answer )) + "\n"; 
	$("#" + pl.stderr).show(); 
	$("#" + pl.stderr).append(msg); 
}

//------------------------------------------------------------------------------
Prolog.prototype.feedback = function() {
    this.tries += 1;
    var language = this.$textarea.getAttribute('language');
    var filename = this.$textarea.getAttribute('file');

    if (EniBook['mode'] === 'assessing') { // assessing mode
        var date    = new Date(); 
        var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
        var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes());
        $("#" + this.id + "-pre-comment").css('display','block');
        $("#" + this.id + "-pre-comment").html("Essai " + this.tries.toString() + " mémorisé à " + hour + "h" + minutes + ".<br />");
        EniBook['assessing'][this.directive][this.id].user = this.edit.getValue();
        EniBook['assessing'][this.directive][this.id].title = language + ":" + filename;
    }

    this.processLanguageQuery();
}

/******************************************************************************
 *
 * Python
 *
 ******************************************************************************/
function Python(id) { // id : HTML identifier
    CodeRun.call(this,id); // inherits from CodeRun
}

//-----------------------------------------------------------------------------
Python.prototype = Object.create(CodeRun.prototype); // inherits from CodeRun

//------------------------------------------------------------------------------
Python.prototype.initErrorMsg = function() {
    this.errorMsg.ParseError = "A parse error means that Python does not understand the syntax on the line the error message points out.  Common examples are forgetting commas between arguments or forgetting a : on a for statement";
    this.errorMsg.ParseErrorFix = "To fix a parse error you just need to look carefully at the line with the error and possibly the line before it.  Make sure it conforms to all of Python's rules.";
    this.errorMsg.TypeError = "Type errors most often occur when an expression tries to combine two objects with types that should not be combined.  Like raising a string to a power";
    this.errorMsg.TypeErrorFix = "To fix a type error you will most likely need to trace through your code and make sure the variables have the types you expect them to have.  It may be helpful to print out each variable along the way to be sure its value is what you think it should be.";
    this.errorMsg.NameError = "A name error almost always means that you have used a variable before it has a value.  Often this may be a simple typo, so check the spelling carefully.";
    this.errorMsg.NameErrorFix = "Check the right hand side of assignment statements and your function calls, this is the most likely place for a NameError to be found.";
    this.errorMsg.ValueError = "A ValueError most often occurs when you pass a parameter to a function and the function is expecting one type and you pass another.";
    this.errorMsg.ValueErrorFix = "The error message gives you a pretty good hint about the name of the function as well as the value that is incorrect.  Look at the error message closely and then trace back to the variable containing the problematic value.";
    this.errorMsg.AttributeError = "This error message is telling you that the object on the left hand side of the dot, does not have the attribute or method on the right hand side.";
    this.errorMsg.AttributeErrorFix = "The most common variant of this message is that the object undefined does not have attribute X.  This tells you that the object on the left hand side of the dot is not what you think. Trace the variable back and print it out in various places until you discover where it becomes undefined.  Otherwise check the attribute on the right hand side of the dot for a typo.";
    this.errorMsg.TokenError = "Most of the time this error indicates that you have forgotten a right parenthesis or have forgotten to close a pair of quotes.";
    this.errorMsg.TokenErrorFix = "Check each line of your program and make sure that your parenthesis are balanced.";
    this.errorMsg.TimeLimitError = "Your program is running too long.  Most programs in this book should run in less than 10 seconds easily. This probably indicates your program is in an infinite loop.";
    this.errorMsg.TimeLimitErrorFix = "Add some print statements to figure out if your program is in an infinte loop.  If it is not you can increase the run time with sys.setExecutionLimit(msecs)";
    this.errorMsg.Error = "Your program is running for too long.  Most programs in this book should run in less than 30 seconds easily. This probably indicates your program is in an infinite loop.";
    this.errorMsg.ErrorFix = "Add some print statements to figure out if your program is in an infinte loop.  If it is not you can increase the run time with sys.setExecutionLimit(msecs)";
    this.errorMsg.SyntaxError = "This message indicates that Python can't figure out the syntax of a particular statement.  Some examples are assigning to a literal, or a function call";
    this.errorMsg.SyntaxErrorFix = "Check your assignment statments and make sure that the left hand side of the assignment is a variable, not a literal or a function.";
    this.errorMsg.IndexError = "This message means that you are trying to index past the end of a string or a list.  For example if your list has 3 things in it and you try to access the item at position 3 or more.";
    this.errorMsg.IndexErrorFix = "Remember that the first item in a list or string is at index position 0, quite often this message comes about because you are off by one.  Remember in a list of length 3 the last legal index is 2";
    this.errorMsg.URIError = "";
    this.errorMsg.URIErrorFix = "";
    this.errorMsg.ImportError = "This error message indicates that you are trying to import a module that does not exist";
    this.errorMsg.ImportErrorFix = "One problem may simply be that you have a typo.  It may also be that you are trying to import a module that exists in 'real' Python, but does not exist in this book.  If this is the case, please submit a feature request to have the module added.";
    this.errorMsg.ReferenceError = "This is most likely an internal error, particularly if the message references the console.";
    this.errorMsg.ReferenceErrorFix = "Try refreshing the webpage, and if the error continues, submit a bug report along with your code";
    this.errorMsg.ZeroDivisionError = "This tells you that you are trying to divide by 0. Typically this is because the value of the variable in the denominator of a division expression has the value 0";
    this.errorMsg.ZeroDivisionErrorFix = "You may need to protect against dividing by 0 with an if statment, or you may need to rexamine your assumptions about the legal values of variables, it could be an earlier statment that is unexpectedly assigning a value of zero to the variable in question.";
    this.errorMsg.RangeError = "This message almost always shows up in the form of Maximum call stack size exceeded.";
    this.errorMsg.RangeErrorFix = "This always occurs when a function calls itself.  Its pretty likely that you are not doing this on purpose. Except in the chapter on recursion.  If you are in that chapter then its likely you haven't identified a good base case.";
    this.errorMsg.InternalError = "An Internal error may mean that you've triggered a bug in our Python";
    this.errorMsg.InternalErrorFix = "Report this error, along with your code as a bug.";
    this.errorMsg.IndentationError = "This error occurs when you have not indented your code properly.  This is most likely to happen as part of an if, for, while or def statement.";
    this.errorMsg.IndentationErrorFix = "Check your if, def, for, and while statements to be sure the lines are properly indented beneath them.  Another source of this error comes from copying and pasting code where you have accidentally left some bits of code lying around that don't belong there anymore.";
    this.errorMsg.NotImplementedError = "This error occurs when you try to use a builtin function of Python that has not been implemented in this in-browser version of Python.";
    this.errorMsg.NotImplementedErrorFix = "For now the only way to fix this is to not use the function.  There may be workarounds.  If you really need this builtin function then file a bug report and tell us how you are trying to use the function.";
}

//------------------------------------------------------------------------------
Python.prototype.update = function() { 
    var parents = $("#" + this.id).parents(".answer"); 
    if(parents.length === 1 && EniBook['mode'] !== 'learning') { 
        $(this.$block).css('display','block');
        this.edit.setValue(EniBook['assessing'][this.directive][this.id].user);
    }
    this.edit.refresh();
}

//------------------------------------------------------------------------------
Python.prototype.feedback = function() {
    this.tries += 1;
    var language = this.$textarea.getAttribute('language');
    var filename = this.$textarea.getAttribute('file');

    this.clearOutput();
    $(this.$pre).css('display','block');
    $(this.$canvas).css('display','block');

    if (EniBook['mode'] === 'assessing') { // assessing mode
        var date    = new Date(); 
        var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
        var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes());
        $("#" + this.id + "-pre-comment").css('display','block');
        $("#" + this.id + "-pre-comment").html("Essai " + this.tries.toString() + " mémorisé à " + hour + "h" + minutes + ".<br />");
        EniBook['assessing'][this.directive][this.id].user = this.edit.getValue();
        EniBook['assessing'][this.directive][this.id].title = language + ":" + filename;
    }

    var res = undefined;
    
    Sk.divid     = this.id;
    Sk.canvas    = this.id + "-run-canvas";
    Sk.pre       = this.id + '-run-pre';
    Sk.error     = this.id + '-run-error';
    Sk.execLimit = 1000*this.execLimit;
    Sk.configure({
        output: outf,
        read  : builtinRead 
    });
    (Sk.TurtleGraphics || (Sk.TurtleGraphics = {})).target = Sk.canvas;
    var width = parseInt($(this.$canvas).css('width'));
    var delta = 10;
    width = width - width%delta; 
    Sk.TurtleGraphics['width']  = width;
    
    if (Math.abs(width - window.innerWidth) < 80) { Sk.TurtleGraphics['height'] = width; }
    else {  Sk.TurtleGraphics['height'] = width/2; }
    
    var prg = this.edit.prefix + this.edit.getValue() + this.edit.suffix;
    var myPromise = Sk.misceval.asyncToPromise( function() { 
        $("#" + Sk.pre).text(""); 
        return Sk.importMainWithBody("<stdin>", false, prg, true); 
   });
   myPromise.then(function(mod) {
        var canvas = $("#" + Sk.canvas).children("canvas"); 
        if (canvas.length > 0) { drawGrid(canvas[0],delta,'rgba(211,211,211,0.2)'); }
        $("#" + Sk.error).text("");
        $("#" + Sk.error).css('display','none');
   },
       function(err) { 
        //$("#" + Sk.pre).html("<span style='color: red;'>" + err.toString() + "</span>");+
        $("#" + Sk.error).html("<span style='color: red;'>" + err.toString() + "</span>");        
        $("#" + Sk.error).css('display','block');
        EniBook[Sk.divid].addErrorMessage(err);
   });

}

//------------------------------------------------------------------------------
var builtinRead = function(x) {
    if (Sk.builtinFiles === undefined || Sk.builtinFiles["files"][x] === undefined)
        throw "File not found: '" + x + "'";
    return Sk.builtinFiles["files"][x];
}

//------------------------------------------------------------------------------
var outf = function(txt) { 
    $("#" + Sk.pre).append(txt);
}

//------------------------------------------------------------------------------
var pyStr = function(x) {
    if (x instanceof Array) { return '[' + x.join(", ") + ']'; }
    else { return x; }
}

//------------------------------------------------------------------------------
Python.prototype.addErrorMessage = function(err) {
    var errString = err.toString()
    var to = errString.indexOf(":")
    var errName = errString.substring(0, to);
    var errURL = "https://docs.python.org/2/library/exceptions.html"

    if (errName != 'ParseError') { errURL += "#exceptions." + errName; }

    var errLink = $('<a></a>');
    $(errLink).attr('href',errURL);
    $(errLink).attr('target','_blank');
    $(errLink).html(errName);
    $(this.$error).append('<br>');
    $(this.$error).append(errLink);

    $(this.$error).append('<h4>Description</h4>');
    var errDesc = $('<p></p>');
    $(errDesc).html(this.errorMsg[errName]); 
    $(this.$error).append(errDesc);

    $(this.$error).append('<h4>To Fix</h4>');
    var errFix = $('<p></p>');
    $(errFix).html(this.errorMsg[errName + 'Fix']);
    $(this.$error).append(errFix);
}

//alert('Dot');
/******************************************************************************
 *
 * Dot
 *
 ******************************************************************************/
function Dot(id) { // id : HTML identifier
    CodeRun.call(this,id); // inherits from CodeRun
    
    $(this.$pre).css('display','none');
    $(this.$canvas).css('display','block');
    $(this.$canvas).css('background-color','white');
    $(this.$savebtn).css('display','inline-block')
}

//-----------------------------------------------------------------------------
Dot.prototype = Object.create(CodeRun.prototype); // inherits from CodeRun

//------------------------------------------------------------------------------
Dot.prototype.saveOutput = function() {
    var txt    = this.edit.getValue();
    try {
        var res = Viz(txt, { format: "svg" }); 
        var a = document.createElement('a');
        a.href = 'data:image/svg+xml,' + encodeURIComponent(res);
        a.download = this.file + '.svg';
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        $(this.$error).text('');
        $(this.$error).css('display','none');
    }
    catch (err) {
        $(this.$error).css('display','block');
        $(this.$error).text(err);
    } 
};

//------------------------------------------------------------------------------
Dot.prototype.feedback = function() {
    var content = this.edit.getValue();
    var prefix  = this.edit.prefix;
    var suffix  = this.edit.suffix;
    $(this.$canvas).html('');
    $(this.$canvas).css('display','block');
    try {
        var prg = prefix + content + suffix;
        var res = Viz(prg); 
        $(this.$canvas).html(res); 
        $(this.$error).text('');
        $(this.$error).css('display','none');
    }
    catch (err) {
        $(this.$error).css('display','block');
        $(this.$error).text(err);
    } 
}

/******************************************************************************
 *
 * Javascript
 *
 ******************************************************************************/
function Javascript(id) { // id : HTML identifier
    CodeRun.call(this,id); // inherits from CodeRun
    
    $(this.$pre).css('display','block');
    $(this.$canvas).css('display','block');
    $(this.$canvas).css('background-color','white');
    $(this.$savebtn).css('display','none');

    this.edit.refresh();
}

//-----------------------------------------------------------------------------
Javascript.prototype = Object.create(CodeRun.prototype); // inherits from CodeRun

//------------------------------------------------------------------------------
Javascript.prototype.update = function() { 
    var parents = $("#" + this.id).parents(".answer"); 
    if(parents.length === 1 && EniBook['mode'] !== 'learning') { 
        $(this.$block).css('display','block');
        this.edit.setValue(EniBook['assessing'][this.directive][this.id].user);
    }
    this.edit.refresh();
}

//------------------------------------------------------------------------------
Javascript.prototype.feedback = function() {
    var content = this.edit.getValue();
    var prefix  = this.edit.prefix;
    var suffix  = this.edit.suffix;
    $(this.$canvas).html('');
    $(this.$canvas).css('display','block');
    var language = this.$textarea.getAttribute('language');
    var filename = this.$textarea.getAttribute('file');

    this.tries += 1;

    if (EniBook['mode'] === 'assessing') { // assessing mode
        var date    = new Date(); 
        var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
        var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes());
        $("#" + this.id + "-pre-comment").css('display','block');
        $("#" + this.id + "-pre-comment").html("Essai " + this.tries.toString() + " mémorisé à " + hour + "h" + minutes + ".<br />");
        EniBook['assessing'][this.directive][this.id].user = this.edit.getValue();
        EniBook['assessing'][this.directive][this.id].title = language + ":" + filename;
    }

    try {
        var prg = prefix + content + suffix;
        res = eval(prg);
        $(this.$pre).html(res);
        $(this.$error).text('');
        $(this.$error).css('display','none');
    }
    catch (err) {
        $(this.$error).css('display','block');
        $(this.$error).text(err);
    } 
}

/******************************************************************************
 *
 * Html
 *
 ******************************************************************************/
function Html(id) { // id : HTML identifier
    CodeRun.call(this,id); // inherits from CodeRun
    
    $(this.$pre).css('display','block');
    $(this.$canvas).css('display','none');

    this.edit.refresh();
}

//-----------------------------------------------------------------------------
Html.prototype = Object.create(CodeRun.prototype); // inherits from CodeRun

//------------------------------------------------------------------------------
Html.prototype.update = function() { 
    var parents = $("#" + this.id).parents(".answer"); 
    if(parents.length === 1 && EniBook['mode'] !== 'learning') { 
        $(this.$block).css('display','block');
        this.edit.setValue(EniBook['assessing'][this.directive][this.id].user);
    }
    this.edit.refresh();
}

//------------------------------------------------------------------------------
Html.prototype.feedback = function() {
    var content = this.edit.getValue();
    var prefix  = this.edit.prefix; 
    var suffix  = this.edit.suffix;
    $(this.$canvas).css('display','none');
    var language = this.$textarea.getAttribute('language');
    var filename = this.$textarea.getAttribute('file');

    this.tries += 1;

    if (EniBook['mode'] === 'assessing') { // assessing mode
        var date    = new Date(); 
        var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
        var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes());
        $("#" + this.id + "-pre-comment").css('display','block');
        $("#" + this.id + "-pre-comment").html("Essai " + this.tries.toString() + " mémorisé à " + hour + "h" + minutes + ".<br />");
        EniBook['assessing'][this.directive][this.id].user = this.edit.getValue();
        EniBook['assessing'][this.directive][this.id].title = language + ":" + filename;
    }

    try {
        var prg = prefix + content + suffix;
        $(this.$iframe).css('display','block');
        $(this.$iframe).attr('srcdoc',prg);
        $(this.$pre).html('');
        $(this.$error).text('');
        $(this.$error).css('display','none');
        var $body = $(this.$iframe).contents().find('body');
        if ($body.length === 1) { 
            $(this.$iframe).height(($($body[0]).height() + 50).toString() + "px");           
        }
    }
    catch (err) {
        $(this.$error).css('display','block');
        $(this.$error).text(err);
    } 
}

/******************************************************************************
 *
 * Sql
 *
 ******************************************************************************/
//if (!window.performance || !performance.now) {window.performance = {now:Date.now}}

function Sql(id) { // id : HTML identifier
    CodeRun.call(this,id); // inherits from CodeRun
    
    $(this.$div).css('display','none');
    $(this.$pre).css('display','none');
    $(this.$error).css('display','none');
    $(this.$canvas).css('display','none');
    $(this.$savebtn).css('display','block');

    this.tictime = 0;
    var obj = this;

    this.edit.refresh();
}

//-----------------------------------------------------------------------------
Sql.prototype = Object.create(CodeRun.prototype); // inherits from CodeRun

//------------------------------------------------------------------------------
Sql.prototype.update = function() { 
    var parents = $("#" + this.id).parents(".answer"); 
    if(parents.length === 1 && EniBook['mode'] !== 'learning') { 
        $(this.$block).css('display','block');
        this.edit.setValue(EniBook['assessing'][this.directive][this.id].user);
    }
    this.edit.refresh();
}

//------------------------------------------------------------------------------
Sql.prototype.feedback = function() {
    var content = this.edit.getValue();
    var prefix  = this.edit.prefix; 
    var suffix  = this.edit.suffix;
    var language = this.$textarea.getAttribute('language');
    var filename = this.$textarea.getAttribute('file');

    $(this.$div).css('display','block');
    $(this.$error).css('display','none');
    $(this.$div).html('');
    $(this.$error).html('');

    this.tries += 1;

    if (EniBook['mode'] === 'assessing') { // assessing mode
        var date    = new Date(); 
        var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
        var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes());
        $("#" + this.id + "-pre-comment").css('display','block');
        $("#" + this.id + "-pre-comment").html("Essai " + this.tries.toString() + " mémorisé à " + hour + "h" + minutes + ".<br />");
        EniBook['assessing'][this.directive][this.id].user = this.edit.getValue();
        EniBook['assessing'][this.directive][this.id].title = language + ":" + filename;
    }

    var db = new SQL.Database();
    var prg = prefix + content + suffix;   
    try {
        this.noerror();
        var results = db.exec(prg);
        if (typeof results !== "undefined") {
            $(this.$div).html('');
            for (var i = 0; i < results.length; i++) {
                $(this.$div).append(this.tableCreate(results[i].columns, results[i].values));
            }
        }
        db.close();
    }
    catch (err) { 
        $(this.$error).css('display','block');
        $(this.$error).html(err);
        db.close();
    } 
    
}

//------------------------------------------------------------------------------
Sql.prototype.tableCreate = function () { 
  function valconcat(vals, tagName) {
    if (vals.length === 0) return '';
    var open = '<' + tagName + '>';
    var close='</' + tagName + ((tagName === 'tr') ? '>\n' : '>');
    return open + vals.join(close + open) + close ;
  }
  return function (columns, values){ 
    var tbl = $("<table></table>");
    var html = '\n<thead>\n<tr>' + valconcat(columns, 'th') + '</tr>\n</thead>\n';
    var rows = values.map(function(v){ return valconcat(v, 'td'); });
    html += '<tbody>\n' + valconcat(rows, 'tr') + '</tbody>\n';
    $(tbl).append(html);
    $(tbl).addClass('sql-table');
    //$(tbl).basictable();
    return tbl;
  }
}();

//------------------------------------------------------------------------------
Sql.prototype.tic = function() {
    this.tictime = performance.now(); 
}

//------------------------------------------------------------------------------
Sql.prototype.toc = function(msg) { 
	var dt = performance.now()-this.tictime;
    dt = new Intl.NumberFormat("fr-FR", {minimumFractionDigits: 3,maximumFractionDigits: 3}).format(dt);
	$(this.$error).append('<p>' + (msg||'toc') + ": " + dt + " ms</p>");
};

//------------------------------------------------------------------------------
Sql.prototype.error = function(e) { 
    $(this.$error).css('display','block');
    var p = $("<p></p>");
    $(p).text(e.message);
	$(this.$error).append(p);
}

//------------------------------------------------------------------------------
Sql.prototype.noerror = function() {
	$(this.$error).html('');
	$(this.$error).css('display','none');
};

//------------------------------------------------------------------------------
Sql.prototype.saveOutput = function() { 
    var tables = $(this.$div).html();
    tables = tables.replace(/<\/table>/g,"</table>\n\n");

    var a = document.createElement('a');
    a.href = 'data:application/octet-stream,' + encodeURIComponent(tables);
    a.download = this.edit.id + ".html";
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
}

//alert('graph');
/******************************************************************************
 *
 * Graph
 *
 ******************************************************************************/

//------------------------------------------------------------------------------
function Graph(id) { // id : HTML identifier
    this.id         = id; 
    this.tries      = 0;
    this.$graph     = $("#" + id + "-graph");
    this.$diagram   = $("#" + id + "-graph-diagram");
    this.$palette   = $("#" + id + "-graph-palette");
    this.$overview  = $("#" + id + "-graph-overview");
    this.$code      = $("#" + id + "-graph-code");
    this.$fileref   = $("#" + id + "-graph-fileref");
    this.$filecode  = $("#" + id + "-graph-filecode");
    this.$filename  = $("#" + id + "-graph-filename");
    this.$feedback  = $("#" + id + "-graph-feedback");
    this.$div       = $("#" + id + "-graph-div");
    this.$modal     = $("#" + id + "-graph-modal");

    this.$feedbacks = $(this.$graph).children("div.feedback");

    this.file       = $(this.$graph).attr('file');
    this.version    = $(this.$graph).attr('version');
    this.diagramid  = $(this.$diagram).attr('id'); 
    this.paletteid  = $(this.$palette).attr('id'); 
    this.overviewid = $(this.$overview).attr('id'); 
    this.tocode = ($(this.$graph).attr('tocode') === 'true') ? true : false;

    this.graph            = {};
    this.graph['id']      = this.id;
    this.graph['file']    = this.file;
    this.graph['version'] = this.version;

    this.title       = $(this.$graph).attr('title');
    this.directive   = $(this.$graph).attr('directive');
    this.initialCode = $(this.$code).val();
    this.modeEnibook = EniBook['mode'];
    this.typeEnibook = EniBook['type'];

    var $go = go.GraphObject.make;    

    var showLinkLabel = this.showLinkLabel;

    // Diagram
    this.graph.diagram =
        $go(go.Diagram, this.diagramid,
            {
                initialContentAlignment: go.Spot.Center,
                allowDrop: true,  
                mouseDrop: function(e) { finishDrop(e, null); }, 
                "LinkDrawn": showLinkLabel, 
                "LinkRelinked": showLinkLabel,
                "draggingTool.isGridSnapEnabled": true,
                "draggingTool.gridSnapCellSize": new go.Size(25, 25),
                "resizingTool.isGridSnapEnabled": true,
                "undoManager.isEnabled": true
            }
        );

    this.graph.diagram.toolManager.mouseMoveTools.insertAt(0, new PortShiftingTool());

    this.graph.diagram.addDiagramListener("Modified", function(e) {});
    
    this.graph.diagram.grid =
        $go(go.Panel, go.Panel.Grid,
            { visible: true, gridCellSize: new go.Size(50, 50) },
            $go(go.Shape, "LineH", { stroke: "lightgray" }),
            $go(go.Shape, "LineV", { stroke: "lightgray" })
        );

    this.graph.diagram.model =
        $go(go.GraphLinksModel,
            { 
                copiesArrays: true,
                copiesArrayObjects: true,
                linkFromPortIdProperty: "fromPort",
                linkToPortIdProperty  : "toPort",
                nodeDataArray: [],
                linkDataArray: []
            }
        );

    this.graph.diagram.linkTemplate =
        $go(go.Link,
            { 
                routing: go.Link.AvoidsNodes,
                curve: go.Link.JumpOver,
                corner: 3,
                relinkableFrom: true, 
                relinkableTo: true,
                selectionAdorned: false,
                shadowOffset: new go.Point(0,0), 
                shadowBlur: 5, 
                shadowColor: "blue"
            },
            new go.Binding("isShadowed", "isSelected").ofObject(),
            $go(go.Shape,
                { name: "SHAPE", strokeWidth: 2, stroke: "black" }
            )
        );


    // Palette
    this.graph.palette = new Array();

    // Overview
    this.graph.overview =
        $go(go.Overview, this.overviewid,
            { 
                observed: this.graph.diagram, 
                maxScale: 0.5, 
                contentAlignment: go.Spot.Center 
            }
        );

    // Version
    if (this.graph['version'] == 'light') {
        var $colons = $(this.$graph).find("th:nth-child(1), td:nth-child(1)");
        $($colons).css('display','none');
    }

    // load the diagram from this.$code
    // this.load();
    
    if ($(this.$graph).attr("collapse") === "true") {
        $(this.$graph).css("display","none");
    }
    else{ $(this.$graph).css("display","block"); }
    //console.log('initializing ',this.id);
};

//------------------------------------------------------------------------------
Graph.prototype.hide = function() {
    $(this.$graph).hide();
}

//------------------------------------------------------------------------------
Graph.prototype.show = function() {
    $(this.$graph).show();
}

//------------------------------------------------------------------------------
Graph.prototype.parents = function(selector) {
    return $(this.$graph).parents(selector);
}

//------------------------------------------------------------------------------
Graph.prototype.showLinkLabel = function(e) {
    var label = e.subject.findObject("LINKLABEL");
    if (label !== null) { label.visible = false; }
}

//------------------------------------------------------------------------------
Graph.prototype.load = function() {
    var code = $(this.$code).val(); 
    if (code != "") { this.graph.diagram.model = go.Model.fromJson(code); this.refresh(); }
};

//------------------------------------------------------------------------------
Graph.prototype.save = function() {
    $(this.$code).val(this.graph.diagram.model.toJson());
    this.graph.diagram.isModified = false;
};

//------------------------------------------------------------------------------
Graph.prototype.collapse = function() {
    this.toggle();
}

//------------------------------------------------------------------------------
Graph.prototype.toggle = function() {
    if ($(this.$graph).css("display") === "none") { 
        $(this.$graph).css("display","block");
        this.refresh();
    }
    else { 
        $(this.$graph).css("display","none");
    }
};

//------------------------------------------------------------------------------
Graph.prototype.toggleGrid = function() {
    if (this.graph.diagram.grid.visible == true) { 
        this.graph.diagram.grid.visible = false; 
    }
    else { 
        this.graph.diagram.grid.visible = true; 
    }
};

//------------------------------------------------------------------------------
Graph.prototype.togglePalette = function() {
    var $colons = $(this.$graph).find("th:nth-child(1), td:nth-child(1)"); 

    for (var i = 0; i < $colons.length; i++) {
        var col = $colons[i];
        if ( $(col).css('display') == 'none' ) {
            $(col).css('display','block');
        }
        else {
            $(col).css('display','none');
        }
    }
};

//------------------------------------------------------------------------------
Graph.prototype.updateOutput = function() {
    $(this.$feedback).css('display','none');
}
//------------------------------------------------------------------------------
Graph.prototype.update = function() {
    var $go = go.GraphObject.make;
    this.graph.diagram.model =         
        $go(go.GraphLinksModel,
            { 
                linkFromPortIdProperty: "fromPort",
                linkToPortIdProperty  : "toPort",
                nodeDataArray: [],
                linkDataArray: [] 
            }
        );

    switch (EniBook['mode']) {
        case 'assessing' :
            $(this.$code).val(this.initialCode);
            this.load();
            break;
        case 'training' :
            var answers = this.parents(".answer"); 
            if(answers.length === 1) { 
                $(this.$code).val(EniBook['assessing'][this.directive][this.id].user.code);
                this.load();
            }
            else {
                var solutions = this.parents(".solution"); 
                if(solutions.length === 1) { 
                    $(this.$code).val(this.initialCode);
                    this.load();
                }
            }
            //this.load();
            //this.feedback();
            break;
        default :
            this.graph['file'] = "newdiagram.json"; 
            $(this.$filename).html(this.graph['file']);
            $(this.$feedback).html("");
            $(this.$feedback).css("display","block");
            break;
    }   
    this.refresh();
};

//------------------------------------------------------------------------------
Graph.prototype.saveJSONDiagram = function() {
    var jsondata = this.graph.diagram.model.toJson(); 
    var download = "";
    if (this.graph.file !== "") { download = this.graph.file; }
    else { download = this.id + ".json"; }

    var a = document.createElement("a");
    a.href = 'data:application/json,' + encodeURIComponent(jsondata);
    a.download = download;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
};

//------------------------------------------------------------------------------
Graph.prototype.saveSVGDiagram = function() {
    var svgdata = this.graph.diagram.makeSvg(); 

    var element = document.body.appendChild(svgdata);
    var svgcode = element.outerHTML;
    document.body.removeChild(element);

    var download = ""
    if (this.graph.file !== "") { download = this.graph.file.replace(".json",".svg"); }
    else { download = this.id + ".svg"; }

    var a = document.createElement("a");
    a.href = "data:application/svg+xml," + encodeURIComponent(svgcode);
    a.download = download;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
};

//------------------------------------------------------------------------------
Graph.prototype.savePNGDiagram = function() {
    var pngdata  = this.graph.diagram.makeImageData( { type: 'image/png' } );

    var download = ""
    if (this.graph.file !== "") { download = this.graph.file.replace(".json",".png"); }
    else { download = this.id + ".png"; }

    var a = document.createElement("a");
    a.href = pngdata;
    a.download = download;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
};

//------------------------------------------------------------------------------
Graph.prototype.openJSONDiagram = function() { 
    var input = $("<input></input>");
    $(input).attr('type','file');
    $(input).attr('accept','.json');
    $(input).attr('id',this.id + '-uploadInput');
    $(input).attr('name',this.id + '-uploadInput');
    $(input).attr('onchange','EniBook["' + this.id + '"].loadJSONDiagram("' + this.id + '",this.files,true);');
    $(input).click();
    $(input).remove();
};

//------------------------------------------------------------------------------
Graph.prototype.loadJSONDiagram = function(id,files,force) { 
    if (files.length == 1) {
        var file = files[0]; 
        var filetype = file.type;
        if (filetype.match('text/json') || filetype == "application/json" || force) {
            var filereader = new FileReader();
		    filereader.readAsText(file);
            filereader.onloadend = function(e) { 
                var txt = e.target.result; 
                var obj = EniBook[id];
                obj.graph.diagram.model = go.Model.fromJson(txt);
                obj.graph.diagram.model.undoManager.isEnabled = true;
                obj.graph.diagram.isModified = false;
                obj.graph.file = file.name;
                $(obj.$filename).html(obj.graph.file);
                $(obj.$palette).accordion("refresh");
            }
        }  
    }
    this.refresh();
};

//------------------------------------------------------------------------------
Graph.prototype.printDiagram = function() {
    var svgdata = this.graph.diagram.makeSvg(); 

    var element = document.body.appendChild(svgdata);
    var svgcode = element.outerHTML;
    document.body.removeChild(element);

    var head = "";
    var content = svgcode;
    var win = window.open(window.location);
    win.blur(); window.focus(); 
    win.document.title = "EniBook : diagramme ";
    win.document.write("<!DOCTYPE html>\n<html>\n<head>\n<title>" + 
                        win.document.title +"</title>\n"+ head + 
                        "\n</head>\n<body>\n" + content +
                        "\n</body>\n</html>\n");
    win.print();
    win.close();
}

//------------------------------------------------------------------------------
Graph.prototype.refresh = function() { 
    this.graph.diagram.requestUpdate();
    this.graph.overview.requestUpdate();
    var palette = this.graph.palette;
    for (var i = 0; i < palette.length; i++) {
        palette[i].requestUpdate();
    }
}

//------------------------------------------------------------------------------
Graph.prototype.feedbackId = function() { 
    var feedbackId = {}; 
    if (this.$feedbacks.length <= 2) { 
        for (var i = 0; i < this.$feedbacks.length; i++) { 
            feedbackId[$(this.$feedbacks[i]).attr("type")] = $(this.$feedbacks[i]).attr("id").replace("-feedback","");
        }
    }
    feedbackId.len = this.$feedbacks.length;
    return feedbackId;
}

//------------------------------------------------------------------------------
Graph.prototype.feedback = function() { 
    alert(this.id + ' : feedback non implémenté !');
}

// alert('StateChart')
/******************************************************************************
 *
 * StateChart
 *
 ******************************************************************************/
//------------------------------------------------------------------------------
function StateChart(id) { // id : HTML identifier 
    Graph.call(this,id); // inherits from Graph
    
    var $go = go.GraphObject.make;

/*
    this.graph.diagram =
        $go(go.Diagram, this.diagramid,  // must name or refer to the DIV HTML element
            {
            // start everything in the middle of the viewport
            initialContentAlignment: go.Spot.Center,
            // have mouse wheel events zoom in and out instead of scroll up and down
            "toolManager.mouseWheelBehavior": go.ToolManager.WheelZoom,
            // support double-click in background creating a new node
            "clickCreatingTool.archetypeNodeData": { text: "new node" },
            // enable undo & redo
            "undoManager.isEnabled": true
            }
        );

    this.graph.diagram.addDiagramListener("Modified", function(e) {});
    

    this.graph.diagram.grid =
        $go(go.Panel, go.Panel.Grid,
            { visible: true, gridCellSize: new go.Size(50, 50) },
            $go(go.Shape, "LineH", { stroke: "lightgray" }),
            $go(go.Shape, "LineV", { stroke: "lightgray" })
        );

*/
    //--------------------------------------------------------------------------
    this.graph.diagram.linkTemplate =
        $go(go.Link,  // the whole link panel
            { curve: go.Link.Bezier, adjusting: go.Link.Stretch, reshapable: true },
            new go.Binding("curviness", "curviness"),
            new go.Binding("points").makeTwoWay(),
            $go(go.Shape, { strokeWidth: 1.5 } ),
            $go(go.Shape, { toArrow: "standard", stroke: null } ),
            $go(go.Panel, "Auto",
                $go(go.Shape,  // the link shape
                    {
                    fill: $go(go.Brush, "Radial", { 0: "rgb(240, 240, 240)", 0.3: "rgb(240, 240, 240)", 1: "rgba(240, 240, 240, 0)" }),
                    stroke: null
                    }
                ),
                $go(go.TextBlock, "transition",  // the label
                    {
                    textAlign: "center",
                    font: "10pt helvetica, arial, sans-serif",
                    stroke: "black",
                    margin: 4,
                    editable: true  // editing the text automatically updates the model data
                    },
                    new go.Binding("text", "text").makeTwoWay()
                )
            )
        );

    //--------------------------------------------------------------------------

    var nodeTemplate =
        $go(go.Node, "Auto",
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            // define the node's outer shape, which will surround the TextBlock
            $go(go.Shape, "RoundedRectangle",
                {
                parameter1: 20,  // the corner has a large radius
                fill: $go(go.Brush, "Linear", { 0: "rgb(254, 201, 0)", 1: "rgb(254, 162, 0)" }),
                stroke: "black",
                portId: "",
                fromLinkable: true,
                fromLinkableSelfNode: true,
                fromLinkableDuplicates: true,
                toLinkable: true,
                toLinkableSelfNode: true,
                toLinkableDuplicates: true,
                cursor: "pointer"
                }
            ),
            $go(go.TextBlock,
                {
                font: "bold 11pt helvetica, bold arial, sans-serif",
                editable: true  // editing the text automatically updates the model data
                },
                new go.Binding("text", "name").makeTwoWay()
            )
        );

/*
    //--------------------------------------------------------------------------
    // unlike the normal selection Adornment, this one includes a Button
    nodeTemplate.selectionAdornmentTemplate =
        $go(go.Adornment, "Spot",
            $go(go.Panel, "Auto",
                $go(go.Shape, { fill: null, stroke: "blue", strokeWidth: 2 }),
                $go(go.Placeholder)  // this represents the selected Node
            ),
            // the button to create a "next" node, at the top-right corner
            $go("Button",
                {
                alignment: go.Spot.TopRight,
                click: addNodeAndLink  // this function is defined below
                },
                $go(go.Shape, "PlusLine", { desiredSize: new go.Size(6, 6) })
            ) // end button
        ); // end Adornment

    //--------------------------------------------------------------------------
    // clicking the button inserts a new node to the right of the selected node,
    // and adds a link to that new node
    function addNodeAndLink(e, obj) {
        var adorn = obj.part;
        e.handled = true;
        var diagram = adorn.diagram;
        diagram.startTransaction("Add State");

        // get the node data for which the user clicked the button
        var fromNode = adorn.adornedPart;
        var fromData = fromNode.data;
        // create a new "State" data object, positioned off to the right of the adorned Node
        var toData = { text: "new" };
        var p = fromNode.location.copy();
        p.x += 200;
        toData.loc = go.Point.stringify(p);  // the "loc" property is a string, not a Point object
        // add the new node data to the model
        var model = diagram.model;
        model.addNodeData(toData);

        // create a link data from the old node data to the new node data
        var linkdata = 
            {
            from: model.getKeyForNodeData(fromData),  // or just: fromData.id
            to: model.getKeyForNodeData(toData),
            text: "transition"
            };
        // and add the link data to the model
        model.addLinkData(linkdata);

        // select the new Node
        var newnode = diagram.findNodeForData(toData);
        diagram.select(newnode);

        diagram.commitTransaction("Add State");

        // if the new node is off-screen, scroll the diagram to show the new node
        diagram.scrollToRect(newnode.actualBounds);
    }
*/
    //--------------------------------------------------------------------------
    //this.graph.diagram.groupTemplateMap.add("zone", zoneTemplate);

    this.graph.diagram.nodeTemplateMap.add("node", nodeTemplate);

    //--------------------------------------------------------------------------
    // Palette
    var pal0 = $go(go.Palette,this.paletteid + "-0");

    this.graph.palette.push(pal0);

    for (var i = 0; i < this.graph.palette.length; i++) {
        var palette = this.graph.palette[i];
        palette.nodeTemplateMap  = this.graph.diagram.nodeTemplateMap;
        palette.groupTemplateMap  = this.graph.diagram.groupTemplateMap;
    }

    this.graph.palette[0].model.nodeDataArray = [  
        { category: "node", name: "N"}
    ];

    $(this.$palette).accordion(
        {
            heightStyle: "content",
            activate: function(event, ui) { EniBook[id].refresh(); }
        });


    this.load();

}

//-----------------------------------------------------------------------------
StateChart.prototype = Object.create(Graph.prototype); // inherits from Graph


//alert('QueryTree');
/******************************************************************************
 *
 * QueryTree
 *
 ******************************************************************************/
//------------------------------------------------------------------------------
function QueryTree(id) { // id : HTML identifier 
    Graph.call(this,id); // inherits from Graph

    var $go = go.GraphObject.make;
    //--------------------------------------------------------------------------
    this.graph.diagram.linkTemplate =
        $go(go.Link,
            {
                routing: go.Link.AvoidsNodes,
                curve: go.Link.JumpOver,
                corner: 4,
                relinkableFrom: true,
                relinkableTo: true,
                reshapable: true,
                fromEndSegmentLength: 0,
                toEndSegmentLength: 15,
                mouseEnter: function(e, link) { link.findObject("HIGHLIGHT").stroke = "rgba(30,144,255,0.2)"; },
                mouseLeave: function(e, link) { link.findObject("HIGHLIGHT").stroke = "transparent"; }
            },
            new go.Binding("points").makeTwoWay(),
            $go(go.Shape,
                { isPanelMain: true, strokeWidth: 8, stroke: "transparent", name: "HIGHLIGHT" }),
            $go(go.Shape,
                { isPanelMain: true, stroke: "gray", strokeWidth: 2 }),
            $go(go.Shape,
                { toArrow: "standard", stroke: null, fill: "gray"}),
            $go(go.Panel, "Auto",  
                { visible: false, name: "LINKLABEL", segmentIndex: 2, segmentFraction: 0.5},
                new go.Binding("visible", "visible").makeTwoWay(),
                $go(go.Shape, "RoundedRectangle", 
                    { fill: "#F8F8F8", stroke: null }),
                $go(go.TextBlock, "",
                    {
                        textAlign: "center",
                        font: "bold 11pt Monospace",
                        stroke: "black",
                        editable: true
                    },
                    new go.Binding("text", "label").makeTwoWay()
                )
            )
        );

    //--------------------------------------------------------------------------
    function makePort(name, spot, output, input, maxOutput, maxInput) { 
        var shape = 
            $go(go.Shape, "Circle",
                {
                    fill: "transparent",
                    stroke: null,
                    desiredSize: new go.Size(8, 8),
                    alignment: spot, alignmentFocus: spot, 
                    portId: name,
                    fromSpot: spot, toSpot: spot, 
                    fromLinkable: output, toLinkable: input, 
                    fromMaxLinks: maxOutput, toMaxLinks: maxInput,
                    cursor: "pointer"
                });
        return shape;
    }

    //--------------------------------------------------------------------------
    function showPorts(node, show) {
        var diagram = node.diagram;
        if (!diagram || diagram.isReadOnly || !diagram.allowLink) return;
        node.ports.each(function(port) { port.stroke = (show ? "lightgray" : null); });
    }

    //--------------------------------------------------------------------------
    function nodeStyle() { 
      return [
        new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
        //new go.Binding("info","").ofObject(),
            {
                locationSpot: go.Spot.Center,
                mouseEnter: function (e, obj) { showPorts(obj.part, true); },
                mouseLeave: function (e, obj) { showPorts(obj.part, false); },
                toolTip:  
                    $go(go.Adornment, "Auto",
                        $go(go.Shape, "RoundedRectangle", { fill: "black", stroke: "black" }),
                        $go(go.TextBlock, { font: "10pt Monospace", margin: 4, stroke: "white" }, 
                            new go.Binding("text", "", infoNode).ofObject()
                        )
                    )
            }
      ];
    }

    //--------------------------------------------------------------------------
    function infoNode(obj) {
        var part = obj.part;
        if (part instanceof go.Adornment) { part = part.adornedPart; }
        var msg = "";
        if (part instanceof go.Node) { 
            var node = part;
            msg = node.data.info;
        } 
        else if (part instanceof go.Group) {
            var group = part;
            msg = group.data.info;
        }
        return msg;
    }
    
    //--------------------------------------------------------------------------
    var divrelNodeTemplate = 
        $go(go.Node, "Auto", nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Panel, "Vertical",
                $go(go.Panel,"Auto", 
                    $go(go.Shape, "Rectangle", {fill: "transparent", stroke: null }),
                    $go(go.Shape, "Circle", { fill: "transparent", stroke: "black", desiredSize: new go.Size(50,50) }),
                    makePort("T", go.Spot.Top, true,  false, 1, 0),
                    makePort("L", new go.Spot(0, 0.5), false, true,  0, 1),
                    makePort("R", new go.Spot(1, 0.5), false, true,  0, 1),
                    $go(go.Shape, "LineH", 
                        {
                            stroke: "black",                    
                            desiredSize: new go.Size(25,25)
                        }
                    ),
                    $go(go.Shape, "CircleLine", 
                        {
                            alignment: new go.Spot(0.5,0.5,0,5),
                            stroke: "black",                    
                            desiredSize: new go.Size(5,5)
                        }
                    ),
                    $go(go.Shape, "CircleLine", 
                        {
                            alignment: new go.Spot(0.5,0.5,0,-5),
                            stroke: "black",                    
                            desiredSize: new go.Size(5,5)
                        }
                    )
                ),
                $go(go.TextBlock, "D",
                    {
                        textAlign: "center",
                        font: "bold 11pt Monospace",
                        stroke: "black",
                        margin: new go.Margin(15,4),
                        isMultiline: true, 
                        editable: true
                    },
                    new go.Binding("text", "name").makeTwoWay()
                )
            )
        );

    //--------------------------------------------------------------------------
    var minusNodeTemplate = 
        $go(go.Node, "Auto", nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Panel, "Vertical",
                $go(go.Panel,"Auto", 
                    $go(go.Shape, "Rectangle", {fill: "transparent", stroke: null }),
                    $go(go.Shape, "Circle", { fill: "transparent", stroke: "black", desiredSize: new go.Size(50,50) }),
                    makePort("T", go.Spot.Top, true,  false, 1, 0),
                    makePort("L", new go.Spot(0, 0.5), false, true,  0, 1),
                    makePort("R", new go.Spot(1, 0.5), false, true,  0, 1),
                    $go(go.Shape, "Line1", 
                        {
                            stroke: "black",                    
                            desiredSize: new go.Size(25,25)
                        }
                    )
                ),
                $go(go.TextBlock, "E",
                    {
                        textAlign: "center",
                        font: "bold 11pt Monospace",
                        stroke: "black",
                        margin: new go.Margin(15,4),
                        isMultiline: true, 
                        editable: true
                    },
                    new go.Binding("text", "name").makeTwoWay()
                )
            )
        );

    //--------------------------------------------------------------------------
    var unionNodeTemplate = 
        $go(go.Node, "Auto", nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Panel, "Vertical",
                $go(go.Panel,"Auto", 
                    $go(go.Shape, "Rectangle", {fill: "transparent", stroke: null}),
                    $go(go.Shape, "Circle", { fill: "transparent", stroke: "black", desiredSize: new go.Size(50,50) }),
                    makePort("T", go.Spot.Top, true,  false, 1, 0),
                    makePort("L", new go.Spot(0, 0.5), false, true,  0, 1),
                    makePort("R", new go.Spot(1, 0.5), false, true,  0, 1),
                    $go(go.Shape, "LogicUnion", 
                        {
                            stroke: "black",                    
                            desiredSize: new go.Size(25,25)
                        }
                    )
                ),
                $go(go.TextBlock, "U",
                    {
                        textAlign: "center",
                        font: "bold 11pt Monospace",
                        stroke: "black",
                        margin: new go.Margin(15,4),
                        isMultiline: true, 
                        editable: true
                    },
                    new go.Binding("text", "name").makeTwoWay()
                )
            )
        );

    //--------------------------------------------------------------------------
    var interNodeTemplate = 
        $go(go.Node, "Auto", nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Panel, "Vertical",
                $go(go.Panel,"Auto", 
                    $go(go.Shape, "Rectangle", {fill: "transparent", stroke: null}),
                    $go(go.Shape, "Circle", { fill: "transparent", stroke: "black", desiredSize: new go.Size(50,50) }),
                    makePort("T", go.Spot.Top, true,  false, 1, 0),
                    makePort("L", new go.Spot(0, 0.5), false, true,  0, 1),
                    makePort("R", new go.Spot(1, 0.5), false, true,  0, 1),
                    $go(go.Shape, "LogicIntersect", 
                        {
                            stroke: "black",                    
                            desiredSize: new go.Size(25,25)
                        }
                    )
                ),
                $go(go.TextBlock, "I",
                    {
                        textAlign: "center",
                        font: "bold 11pt Monospace",
                        stroke: "black",
                        margin: new go.Margin(15,4),
                        isMultiline: true, 
                        editable: true
                    },
                    new go.Binding("text", "name").makeTwoWay()
                )
            )
        );

    //--------------------------------------------------------------------------
    var timesNodeTemplate = 
        $go(go.Node, "Auto", nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Panel, "Vertical",
                $go(go.Panel,"Auto", 
                    $go(go.Shape, "Rectangle", {fill: "transparent", stroke: null}),
                    $go(go.Shape, "Circle", { fill: "transparent", stroke: "black", desiredSize: new go.Size(50,50) }),
                    makePort("T", go.Spot.Top, true,  false, 1, 0),
                    makePort("L", new go.Spot(0, 0.5), false, true,  0, 1),
                    makePort("R", new go.Spot(1, 0.5), false, true,  0, 1),
                    $go(go.Shape, "XLine", 
                        {
                            stroke: "black",                    
                            desiredSize: new go.Size(25,25)
                        }
                    )
                ),
                $go(go.TextBlock, "V",
                    {
                        textAlign: "center",
                        font: "bold 11pt Monospace",
                        stroke: "black",
                        margin: new go.Margin(15,4),
                        isMultiline: true, 
                        editable: true
                    },
                    new go.Binding("text", "name").makeTwoWay()
                )
            )
        );

    //--------------------------------------------------------------------------
    var innerJoinNodeTemplate = 
        $go(go.Node, "Spot", nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Panel,"Horizontal",
                $go(go.Panel,"Vertical",
                    $go(go.Panel,"Auto", 
                        $go(go.Shape, 
                            {
                                geometryString: "F M 0 0 L 50 50 50 0 0 50 0 0 Z",
                                fill: "transparent",
                                stroke: "black",
                                desiredSize: new go.Size(50,50)
                            }
                        ),
                        makePort("L", new go.Spot(0.01,1,-0.1,0), false, true, 0, 1),
                        makePort("R", new go.Spot(0.99,1,0.1,0), false, true, 0, 1),
                        makePort("T", new go.Spot(0.5,0.499), true, false, 1, 0)
                    ),
                    $go(go.TextBlock, "[cond]",
                        {
                            textAlign: "center",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: true, 
                            editable: true
                        },
                        new go.Binding("text", "condition").makeTwoWay()
                    )
                ),
                $go(go.Panel,"Vertical",
                    $go(go.TextBlock, "IJ",
                        {
                            textAlign: "left",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: true, 
                            editable: true
                        },
                        new go.Binding("text", "name").makeTwoWay()
                    ),
                    $go(go.TextBlock, "",
                        {
                            textAlign: "left",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: false, 
                            editable: false
                        }
                    )
                )
            )
        );

    //--------------------------------------------------------------------------
    var leftOuterJoinNodeTemplate = 
        $go(go.Node, "Spot", nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Panel,"Horizontal",
                $go(go.Panel,"Vertical",
                    $go(go.Panel,"Auto", 
                        $go(go.Shape, 
                            {
                                geometryString: "F M -10 0 L 0 0 50 50 50 0 0 50 -10 50 0 50 0 0 Z",
                                fill: "transparent",
                                stroke: "black",
                                desiredSize: new go.Size(50,50)
                            }
                        ),
                        makePort("L", new go.Spot(0.01,1,-0.1,0), false, true, 0, 1),
                        makePort("R", new go.Spot(0.99,1,0.1,0), false, true, 0, 1),
                        makePort("T", new go.Spot(0.5,0.499), true, false, 1, 0)
                    ),
                    $go(go.TextBlock, "[cond]",
                        {
                            textAlign: "center",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: true, 
                            editable: true
                        },
                        new go.Binding("text", "condition").makeTwoWay()
                    )
                ),
                $go(go.Panel,"Vertical",
                    $go(go.TextBlock, "LJ",
                        {
                            textAlign: "left",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: true, 
                            editable: true
                        },
                        new go.Binding("text", "name").makeTwoWay()
                    ),
                    $go(go.TextBlock, "",
                        {
                            textAlign: "left",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: false, 
                            editable: false
                        }
                    )
                )
            )
        );

    //--------------------------------------------------------------------------
    var rightOuterJoinNodeTemplate = 
        $go(go.Node, "Spot", nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Panel,"Horizontal",
                $go(go.Panel,"Vertical",
                    $go(go.Panel,"Auto", 
                        $go(go.Shape, 
                            {
                                geometryString: "F M 0 0 L 50 50 60 50 50 50 50 0 60 0 50 0 0 50 0 0 Z",
                                fill: "transparent",
                                stroke: "black",
                                desiredSize: new go.Size(50,50)
                            }
                        ),
                        makePort("L", new go.Spot(0.01,1,-0.1,0), false, true, 0, 1),
                        makePort("R", new go.Spot(0.99,1,0.1,0), false, true, 0, 1),
                        makePort("T", new go.Spot(0.5,0.499), true, false, 1, 0)
                    ),
                    $go(go.TextBlock, "[cond]",
                        {
                            textAlign: "center",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: true, 
                            editable: true
                        },
                        new go.Binding("text", "condition").makeTwoWay()
                    )
                ),
                $go(go.Panel,"Vertical",
                    $go(go.TextBlock, "RJ",
                        {
                            textAlign: "left",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: true, 
                            editable: true
                        },
                        new go.Binding("text", "name").makeTwoWay()
                    ),
                    $go(go.TextBlock, "",
                        {
                            textAlign: "left",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: false, 
                            editable: false
                        }
                    )
                )
            )
        );


    //--------------------------------------------------------------------------
    var fullOuterJoinNodeTemplate = 
        $go(go.Node, "Spot", nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Panel,"Horizontal",
                $go(go.Panel,"Vertical",
                    $go(go.Panel,"Auto", 
                        $go(go.Shape, 
                            {
                                geometryString: "F M -10 0 L 0 0 50 50 60 50 50 50 50 0 60 0 50 0 0 50 -10 50 0 50 0 0 Z",
                                fill: "transparent",
                                stroke: "black",
                                desiredSize: new go.Size(50,50)
                            }
                        ),
                        makePort("L", new go.Spot(0.01,1,-0.1,0), false, true, 0, 1),
                        makePort("R", new go.Spot(0.99,1,0.1,0), false, true, 0, 1),
                        makePort("T", new go.Spot(0.5,0.499), true, false, 1, 0)
                    ),
                    $go(go.TextBlock, "[cond]",
                        {
                            textAlign: "center",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: true, 
                            editable: true
                        },
                        new go.Binding("text", "condition").makeTwoWay()
                    )
                ),
                $go(go.Panel,"Vertical",
                    $go(go.TextBlock, "FJ",
                        {
                            textAlign: "left",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: true, 
                            editable: true
                        },
                        new go.Binding("text", "name").makeTwoWay()
                    ),
                    $go(go.TextBlock, "",
                        {
                            textAlign: "left",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: false, 
                            editable: false
                        }
                    )
                )
            )
        );

    //--------------------------------------------------------------------------
    var restrictNodeTemplate = 
        $go(go.Node, "Spot", nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Panel, "Vertical",
                $go(go.Panel,"Spot", 
                    $go(go.Shape, "Trapezoid", 
                        {
                            fill: "transparent",
                            stroke: "black", 
                            angle: 90, 
                            desiredSize: new go.Size(50,50)
                        }
                    ),
                    $go(go.TextBlock, "R", 
                        {
                            textAlign: "center",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: true, 
                            editable: true
                        },
                        new go.Binding("text", "name").makeTwoWay()
                    ),
                    makePort("B", go.Spot.Bottom, false, true, 0, 1),
                    makePort("T", go.Spot.Top, true, false, 1, 0)
                ),
                $go(go.TextBlock, "[cond]",
                    {
                        textAlign: "center",
                        font: "bold 11pt Monospace",
                        stroke: "black",
                        margin: new go.Margin(15,4),
                        isMultiline: true, 
                        editable: true
                    },
                    new go.Binding("text", "condition").makeTwoWay()
                )
            )
        );

    //--------------------------------------------------------------------------
    var projectNodeTemplate = 
        $go(go.Node, "Spot",nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Panel, "Vertical",
                $go(go.TextBlock, "(attrs)",
                    {
                        textAlign: "center",
                        font: "bold 11pt Monospace",
                        stroke: "black",
                        margin: new go.Margin(15,4),
                        isMultiline: true, 
                        editable: true
                    },
                    new go.Binding("text", "attributes").makeTwoWay()
                ),
                $go(go.Panel,"Spot", 
                    $go(go.Shape, "Trapezoid", 
                        {
                            fill: "transparent",
                            stroke: "black", 
                            desiredSize: new go.Size(50,50)
                        }
                    ),
                    $go(go.TextBlock, "P", 
                        {
                            textAlign: "center",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: true, 
                            editable: true
                        },
                        new go.Binding("text", "name").makeTwoWay()
                    ),
                    makePort("B", go.Spot.Bottom, false, true, 0, 1),
                    makePort("T", go.Spot.Top, true, false, 1, 0)
                )
            )
        );

    //--------------------------------------------------------------------------
    var sortNodeTemplate = 
        $go(go.Node, "Spot",nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Panel, "Vertical",
                $go(go.TextBlock, "(attrs)",
                    {
                        textAlign: "center",
                        font: "bold 11pt Monospace",
                        stroke: "black",
                        margin: new go.Margin(15,4),
                        isMultiline: true, 
                        editable: true
                    },
                    new go.Binding("text", "attributes").makeTwoWay()
                ),
                $go(go.Panel, "Spot",
                    $go(go.Shape, "Rectangle", 
                        {
                            fill: "transparent",
                            stroke: "black", 
                            desiredSize: new go.Size(50,50)
                        }
                    ),
                    $go(go.TextBlock, "S",
                        {
                            textAlign: "center",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: true,  
                            editable: true
                        },
                        new go.Binding("text", "name").makeTwoWay()
                    ),
                    makePort("B", go.Spot.Bottom, false, true, 0, 1),
                    makePort("T", go.Spot.Top, true, false, 1, 0)
                )
            )
        );

    //--------------------------------------------------------------------------
    var agregNodeTemplate = 
        $go(go.Node, "Spot",nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Panel,"Horizontal",
                $go(go.Panel,"Vertical",
                    /*$go(go.Panel, "Auto",
                        $go(go.Shape, "Rectangle", 
                            {
                                fill: "transparent",
                                stroke: "black", 
                                minSize: new go.Size(40,25)
                            }
                        ),
                        makePort("T", go.Spot.Top, true, false, 1, 0),
                        $go(go.TextBlock, "fct(A)",
                            {
                                textAlign: "center",
                                font: "bold 11pt Monospace",
                                stroke: "black",
                                margin: 4,
                                isMultiline: true, 
                                editable: true
                            },
                            new go.Binding("text", "function").makeTwoWay()
                        )
                    ),
                    $go(go.Panel, "Auto",
                        $go(go.Shape, "Rectangle", 
                            {
                                fill: "transparent",
                                stroke: "black", 
                                minSize: new go.Size(40,25)
                            }
                        ),
                        //makePort("B", go.Spot.Bottom, false, true, 0, 1),
                        $go(go.TextBlock, "[where]",
                            {
                                textAlign: "center",
                                font: "bold 11pt Monospace",
                                stroke: "black",
                                margin: 4,
                                isMultiline: true, 
                                editable: true
                            },
                            new go.Binding("text", "where").makeTwoWay()
                        )
                    ),*/
                    $go(go.Panel, "Auto",
                        $go(go.Shape, "Rectangle", 
                            {
                                fill: "transparent",
                                stroke: "black", 
                                minSize: new go.Size(40,25)
                            }
                        ),
                        makePort("T", go.Spot.Top, true, false, 1, 0),
                        $go(go.TextBlock, "(fct(attr))",
                            {
                                textAlign: "center",
                                font: "bold 11pt Monospace",
                                stroke: "black",
                                margin: 4,
                                isMultiline: true, 
                                editable: true
                            },
                            new go.Binding("text", "functions").makeTwoWay()
                        )
                    ),
                    $go(go.Panel, "Auto",
                        $go(go.Shape, "Rectangle", 
                            {
                                fill: "transparent",
                                stroke: "black", 
                                minSize: new go.Size(40,25)
                            }
                        ),
                        //makePort("T", go.Spot.Top, true, false, 1, 0),
                        $go(go.TextBlock, "(attrs)",
                            {
                                textAlign: "center",
                                font: "bold 11pt Monospace",
                                stroke: "black",
                                margin: 4,
                                isMultiline: true, 
                                editable: true
                            },
                            new go.Binding("text", "attributes").makeTwoWay()
                        )
                    ),
                    $go(go.Panel, "Auto",
                        $go(go.Shape, "Rectangle", 
                            {
                                fill: "transparent",
                                stroke: "black", 
                                minSize: new go.Size(40,25)
                            }
                        ),
                        makePort("B", go.Spot.Bottom, false, true, 0, 1),
                        $go(go.TextBlock, "[having]",
                            {
                                textAlign: "center",
                                font: "bold 11pt Monospace",
                                stroke: "black",
                                margin: 4,
                                isMultiline: true, 
                                editable: true
                            },
                            new go.Binding("text", "having").makeTwoWay()
                        )
                    )
                ),
                $go(go.Panel,"Vertical",
                    $go(go.TextBlock, "G",
                        {
                            textAlign: "left",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: true, 
                            editable: true
                        },
                        new go.Binding("text", "name").makeTwoWay()
                    ),
                    $go(go.TextBlock, "",
                        {
                            textAlign: "left",
                            font: "bold 11pt Monospace",
                            stroke: "black",
                            margin: new go.Margin(15,4),
                            isMultiline: false, 
                            editable: false
                        }
                    )
                )
            )
        );

    //--------------------------------------------------------------------------
    var resultTemplate =
        $go(go.Node,"Auto",nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Shape, "Rectangle", 
                {
                    fill: "transparent",
                    stroke: "rgb(234,138,0)",
                    background: "rgba(234,138,0,0.2)",
                    portId: "R", fromLinkable: false, toLinkable: true, toMaxLinks: 1,
                    minSize: new go.Size(100,NaN)
                }
            ),
            $go(go.TextBlock,"Résultat",
                {
                    textAlign: "center",
                    font: "bold 11pt Monospace",
                    stroke: "black",
                    margin: 10,
                    isMultiline: true, 
                    editable: true
                },
                new go.Binding("text","name").makeTwoWay()
            )
        );
        
    //--------------------------------------------------------------------------
    var tableTemplate =
        $go(go.Node,"Auto",nodeStyle(),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Shape, "Rectangle", 
                {
                    fill: "transparent",
                    stroke: "rgb(234,138,0)",
                    background: "rgb(234,138,0)",
                    portId: "", fromLinkable: true, toLinkable: false, 
                    minSize: new go.Size(100,NaN)
                }
            ),
            $go(go.TextBlock,"Table",
                {
                    textAlign: "center",
                    font: "bold 11pt Monospace",
                    stroke: "black",
                    margin: 10,
                    isMultiline: true, 
                    editable: true
                },
                new go.Binding("text","name").makeTwoWay()
            )
        );

    var findAllInto = function(node,model) { 
        var objects = [node];
        for (var i = 0; i < objects.length; i++) {
            if (model.findNodeDataForKey(objects[i].data.key) != null) {
                var itnodes = objects[i].findNodesInto();
                var itlinks = objects[i].findLinksInto();
                while (itnodes.next()) {
                    if (objects.indexOf(itnodes.value) === -1) { objects.push(itnodes.value); }
                }
                while (itlinks.next()) {
                    if (objects.indexOf(itlinks.value) === -1) { objects.push(itlinks.value); }
                }   
            }
        }
        return objects;
    };
        
    //--------------------------------------------------------------------------
    //this.graph.diagram.groupTemplateMap.add("zone", zoneTemplate);

    this.graph.diagram.nodeTemplateMap.add("minus",     minusNodeTemplate);
    this.graph.diagram.nodeTemplateMap.add("divrel",    divrelNodeTemplate);
    this.graph.diagram.nodeTemplateMap.add("union",     unionNodeTemplate);
    this.graph.diagram.nodeTemplateMap.add("inter",     interNodeTemplate);
    this.graph.diagram.nodeTemplateMap.add("times",     timesNodeTemplate);
    this.graph.diagram.nodeTemplateMap.add("innerjoin", innerJoinNodeTemplate);
    this.graph.diagram.nodeTemplateMap.add("leftouterjoin",  leftOuterJoinNodeTemplate);
    this.graph.diagram.nodeTemplateMap.add("rightouterjoin", rightOuterJoinNodeTemplate);
    this.graph.diagram.nodeTemplateMap.add("fullouterjoin",  fullOuterJoinNodeTemplate);
    this.graph.diagram.nodeTemplateMap.add("restrict",  restrictNodeTemplate);
    this.graph.diagram.nodeTemplateMap.add("project",   projectNodeTemplate);
    this.graph.diagram.nodeTemplateMap.add("sort",      sortNodeTemplate);
    this.graph.diagram.nodeTemplateMap.add("agreg",     agregNodeTemplate);
    this.graph.diagram.nodeTemplateMap.add("table",     tableTemplate);
    this.graph.diagram.nodeTemplateMap.add("query",     resultTemplate);

    //--------------------------------------------------------------------------
    // Palette
    var pal0 = $go(go.Palette,this.paletteid + "-0");
    var pal1 = $go(go.Palette,this.paletteid + "-1");
    var pal2 = $go(go.Palette,this.paletteid + "-2");

    this.graph.palette.push(pal0);
    this.graph.palette.push(pal1);
    this.graph.palette.push(pal2);

    for (var i = 0; i < this.graph.palette.length; i++) {
        var palette = this.graph.palette[i];
        palette.nodeTemplateMap  = this.graph.diagram.nodeTemplateMap;
        palette.groupTemplateMap  = this.graph.diagram.groupTemplateMap;
    }

    this.graph.palette[0].model.nodeDataArray = [  
        { category: "table",  name: "T", info: "TABLE" },
        { category: "query",  name: "Q", info: "QUERY" }
    ];

    this.graph.palette[1].model.nodeDataArray = [    
        { category: "restrict", name: "R", condition: "[cond]",   info: "RESTRICTION" },
        { category: "project",  name: "P", attributes: "(attrs)", info: "PROJECTION" },
        { category: "sort",     name: "S", attributes: "(attrs)", info: "SORT" },
        { category: "agreg",    name: "G", attributes: "(attrs)", having: "[having]", functions: "(functions)", info: "AGGREGATION" }
    ];

    this.graph.palette[2].model.nodeDataArray = [    
        { category: "minus",            name: "E",  info: "EXCEPT" },
        { category: "union",            name: "U",  info: "UNION" },
        { category: "inter",            name: "I",  info: "INTERSECTION" },
        { category: "times",            name: "V",  info: "PRODUCT" },
        { category: "divrel",           name: "D",  info: "DIVISION" },
        { category: "innerjoin",        name: "IJ", condition: "[cond]", info: "INNER JOIN" },
        { category: "leftouterjoin",    name: "LJ", condition: "[cond]", info: "LEFT OUTER JOIN" },
        { category: "rightouterjoin",   name: "RJ", condition: "[cond]", info: "RIGHT OUTER JOIN" },
        { category: "fullouterjoin",    name: "FJ", condition: "[cond]", info: "FULL JOIN" }
    ];

    $(this.$palette).accordion(
        {
            heightStyle: "content",
            activate: function(event, ui) { EniBook[id].refresh(); }
        });


    this.graph.diagram.addDiagramListener("ObjectContextClicked",
        function(e) { 
            var node = e.diagram.selection.first();
            var model = e.diagram.model;
            var objects = findAllInto(node,model);
            e.diagram.selectCollection(objects);
        });

    //--------------------------------------------------------------------------
    // load the diagram from this.$code
    this.load();
}

//-----------------------------------------------------------------------------
QueryTree.prototype = Object.create(Graph.prototype); // inherits from Graph

//-----------------------------------------------------------------------------
QueryTree.prototype.initTable = function() {
    this.graph.diagram.model.addNodeData({});
}

//-----------------------------------------------------------------------------
QueryTree.prototype.feedback = function() {
    var links = this.graph.diagram.links;
    var nodes = this.graph.diagram.nodes;
    
    $(this.$feedback).html("");
    $(this.$feedback).css('display','block');
    $(this.$div).css('display','block');
    $(this.$error).css('display','none');
    $(this.$div).html('');
    $(this.$error).html('');

    this.tries += 1;
    var res = "Essai " + this.tries.toString();
    var presql = "";
    var error = "";
    var prg = "";
    var comment = "";

    switch (EniBook['mode']) {
        case 'assessing' :
            var date    = new Date();
            var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
            var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes()); 
            res += " mémorisé à " + hour + "h" + minutes + "."; 
            var jsondata = this.graph.diagram.model.toJson();
            var pngdata = this.graph.diagram.makeImageData( { type: 'image/png' } );
            var basename = $("#" + this.id + "-graph-filename").html().replace(".json","");
            EniBook['assessing'][this.directive][this.id].user = {}
            EniBook['assessing'][this.directive][this.id].user.code = jsondata; //$(this.$code).val();
            EniBook['assessing'][this.directive][this.id].user.png = pngdata;
            this.saveJSONDiagram();
            this.savePNGDiagram();
            this.saveSVGDiagram()
            res += "<br />Sauvegarde fichiers <t>" + basename + ".json</t>, <t>" + basename + ".png</t> et <t>" + basename + ".svg</t>."
            $(this.$feedback).addClass('feedback-info');
            break;
        default :
            res += "<br />";
            break;
    }

    var nbres = 0;
    var cptres = 0;
    var results = [];
    var nameresults = [];
    var nbtab = 0;
    var cpttab = 0;
    var tables = [];
    var nametables = [];
    var theNodes = {
        agreg:[],
        divrel:[], 
        fullouterjoin:[],
        innerjoin:[], 
        inter:[], 
        leftouterjoin:[], 
        minus:[], 
        naturaljoin:[], 
        project:[],
        query:[],
        restrict:[],
        rightouterjoin:[],
        sort:[],
        table:[], 
        times:[], 
        union:[],
        ops:[]
        };


    var errortab = [];
    var ok = true;

    var iterator = nodes.iterator;
    while(iterator.next()) {
        var theNode = iterator.value; 
        switch (theNode.category) { 
            case "query" : 
                var name = theNode.data.name;                
                if (name === undefined || name === "") { 
                    ok = false;
                    error += "Une requête doit être nommée explicitement.<br />";
                    errortab.push(theNode.data.key);
                }
                if (theNode.findLinksInto().count !== 1) {
                    ok = false;
                    error += "Requête (" + name + ") : l'entrée d'une requête doit être connectée.<br />";
                    errortab.push(theNode.data.key);
                }
                if (ok) { theNodes.query.push(theNode); }
                break;
            case "table" :
                var name = theNode.data.name; 
                if (name === undefined || name === "") { 
                    ok = false;
                    error += "Une table doit être nommée explicitement.<br />";
                    errortab.push(theNode.data.key);
                }
                if (ok) { theNodes.table.push(theNode); }
                break;
            case "divrel" :
                var name = theNode.data.name; 
                if (name === undefined || name === "") { 
                    ok = false;
                    error += "Opérateur « " + theNode.data.info + " » (" + name + ") : un opérateur doit être nommé explicitement.<br />";
                    errortab.push(theNode.data.key);
                }
                var it = theNode.findNodesInto(); 
                var size = it.count; 
                if (size !== 2) {
                    ok = false;
                    error += "Opérateur « " + theNode.data.info + " » (" + name + ") : les deux entrées d'un opérateur binaire doivent être connectées.<br />";
                    errortab.push(theNode.data.key);
                }
                else {
                    it.next();
                    var dividend = it.value;
                    it.next();
                    var divider = it.value;
                    if (dividend.category !== 'project' || divider.category !== 'project') {
                        ok = false;
                        error += "Opérateur « "  + theNode.data.info + " » (" + name + ") : les deux entrées doivent être des projections.<br />";
                        errortab.push(theNode.data.key);
                    }
                    else {
                        var attrs_dividend = dividend.data.attributes;
                        var attrs_divider = divider.data.attributes;
                        if (!this.subset(attrs_dividend,attrs_divider)) {
                            ok = false;
                            error += "Opérateur « "  + theNode.data.info + " » (" + name + ") : les attributs " +
                                        divider.data.attributes + " du diviseur (" +
                                        divider.data.name + ") doivent former un sous-ensemble des attributs " +
                                        dividend.data.attributes + " du dividende (" +
                                        dividend.data.name + ").<br />";
                            errortab.push(theNode.data.key);
                        }
                    }
                }
                if (ok) { theNodes.ops.push(theNode); }
                break;
            case "minus" :
            case "union" :
            case "inter" :
            case "times" :
            case "naturaljoin"   :
            case "innerjoin"     :
            case "leftouterjoin" :
            case "rightouterjoin":
            case "fullouterjoin" :
                var name = theNode.data.name; 
                if (name === undefined || name === "") { 
                    ok = false;
                    error += "Opérateur « " + theNode.data.info + " » (" + name + ") : un opérateur doit être nommé explicitement.<br />";
                    errortab.push(theNode.data.key);
                }
                if (theNode.findLinksInto().count !== 2) {
                    ok = false;
                    error += "Opérateur « " + theNode.data.info + " » (" + name + ") : les deux entrées d'un opérateur binaire doivent être connectées.<br />";
                    errortab.push(theNode.data.key);
                }
                if (ok) { theNodes.ops.push(theNode); }
                break;
            case "agreg":
                var name1 = theNode.data.name; 
                var attrs = theNode.data.attributes;
                var having = theNode.data.having;
                if (attrs === '()' || attrs === '') {
                    ok = false;
                    error += "Opérateur « " + theNode.data.info + " » (" + name1 + ") : les attributs de groupement doivent être définis.<br />";
                    errortab.push(theNode.data.key);
                }
            case "restrict":
            case "project" :
            case "sort":                
                var name = theNode.data.name; 
                if (name === undefined || name === "") { 
                    ok = false;
                    error += "Opérateur « " + theNode.data.info + " » (" + name + ") : un opérateur doit être nommé explicitement.<br />";
                    errortab.push(theNode.data.key);
                }
                var it = theNode.findLinksInto();
                if (it.count !== 1) {
                    ok = false;
                    error += "Opérateur « " + theNode.data.info + " » (" + name + ") : l'entrée d'un opérateur unaire doit être connectée.<br />";
                    errortab.push(theNode.data.key);
                }
                if (ok) { theNodes.ops.push(theNode); }
                break;
            default:
                break;
        }
    }
    iterator.reset();

    if (ok) { 
        prg = "";
        var searchNodes = this.searchWidth(theNodes);

        res += "<div><table class='query-table'>";
        res += "<thead><tr><th>Opération</th><th style='display:none;'>Algèbre relationnelle</th><th>Requête SQL</th></tr></thead>";
        res += "<tbody>";
        for (var i = 0; i < searchNodes.length; i++) {
            var node = searchNodes[i];
            if (node.category !== 'table') { 
                res += "<tr><td>" + node.data.info + "</td><td class='query-table-latex' style='display:none;'>\\(\\displaystyle " + node.data.name + " = ";
                res += this.toLatex(node);
                res += this.searchLatexNodesTo(node);
                res += "\\)</td>";
                var sql = this.searchSQLNodesTo(node) + " ;\n\n";
                if (node.category !== 'query') { prg += sql; }
                res += "<td class='query-table-sql'>" + sql.replace(/\n/g,'<br />') + "</td></tr>";
            }
        }
        res += "</tbody></table></div>";
    }
    else { 
        res += `<div class='feedback-false'> ${error} </div>`

        var nodes = [];
        for (var i = 0; i < errortab.length; i++) {
            nodes.push(this.graph.diagram.findNodeForKey(errortab[i]));
        }
        this.graph.diagram.selectCollection(nodes); 
        this.graph.diagram.focus();
    } 
    
    $(this.$feedback).append(res);
    var tds = $(this.$feedback).find(".query-table-sql"); 
    var id = this.id;
    for (var i = 0; i < tds.length; i++) {
        $(tds[i]).on('click',function(e) { EniBook[id].showSQL(this,prg); } ); 
    }

    //if (typeof MathJax != "undefined") { MathJax.Hub.Typeset($(this.$feedback).attr("id")); }
    renderKatex(this.id + "-graph-feedback");
}

//------------------------------------------------------------------------------
QueryTree.prototype.searchWidth = function(theNodes) {
    var searchNodes = [];
    var initNodes   = theNodes.table; 
    while (initNodes.length > 0) {
        var node = initNodes.shift(); 
        if (searchNodes.indexOf(node) === -1) { 
            searchNodes.push(node); 
            var nextNodes = this.next(node); 
            initNodes = initNodes.concat(nextNodes); 
        }
    }
    return searchNodes;
}

//------------------------------------------------------------------------------
QueryTree.prototype.next = function(node) {
    var nextNodes = [];
    var it = node.findNodesOutOf();
    while (it.next()) {
        nextNodes.push(it.value);
    }
    return nextNodes;
}
//------------------------------------------------------------------------------
QueryTree.prototype.showSQL = function(cell,prg) {
    var html  = $(cell).html(); 
    var sql = html.replace(/<br>/g, '\n'); 
    var index = sql.match(/CREATE VIEW (.*)/); 
    if(index != null) { 
        sql  = "\n-- QUERY\nSELECT * FROM " + index[1] + " ;\n";
        sql += "SELECT COUNT(*) AS Records FROM " + index[1] + " ;"; 
        this.runSQL(index[1],html,sql,prg); 
    }
    else {
        index = sql.match(/-- QUERY (.*)/);
        if (index != null) { 
            this.runSQL(index[1],html,sql,prg); 
        }
    }
}

//------------------------------------------------------------------------------
QueryTree.prototype.runSQL = function(thename,html,sqlquery,prg) { 
    var prefix = $(this.$filecode).val() + "\n\n"; 
    var height = parseInt($(this.$feedback).css("height").replace("px",""))
    var width  = parseInt($(this.$feedback).css("width").replace("px",""))/2
    var offset = $(this.$feedback).offset();
    var $x = Math.round(offset.left + width);
    var $y = Math.round(offset.top - height);
    var res = html + "<br>";

    var program = prefix + prg + sqlquery; 
    var db = new SQL.Database();
        
    try {
        this.noerrorSQL();
        var results = db.exec(program); 
        if (typeof results !== "undefined") {
            $(this.$modal).html('');
            for (var i = 0; i < results.length; i++) {
                $(this.$modal).append(this.tableCreate(thename, results[i].columns, results[i].values));
            }
            res += $(this.$modal).html();
            res += this.verifyTable();

            res += `<button class='btn' id="%(id)s-feedback-save-btn" 
                    style="margin-top: 10px; display: block; background-color: rgba(162,169,63,0.2); border: 1px solid rgba(162,169,63,0.2);"
                    title="sauvegarder le résultat"
                    onclick="EniBook['`;
            res += this.id;
            res += `'].saveTable('`;
            res += thename;
            res += `');"><span class="glyphicons glyphicons-disk-save" 
                    style="color:rgb(162,169,63);"></span></button>`;

            $("#enibook-feedback-main").html(res);
            $("#enibook-feedback-title").html("Requête SQL");
            $("#enibook-feedback").popup("open",{ arrow: false, x: $x, y: $y });  
        }
        db.close();
    }
    catch (err) { 
        $(this.$modal).html(err);
        res += $(this.$modal).html();
        $("#enibook-feedback-main").html(res);
        $("#enibook-feedback-title").html("Erreur SQL");
        $("#enibook-feedback").popup("open",{ arrow: false, x: $x, y: $y }); 
        db.close(); 
    }   
}

//------------------------------------------------------------------------------
QueryTree.prototype.verifyTable = function() { 
    var comment = "";
    if (EniBook['mode'] !== 'assessing') {        
        var feedbacks = this.feedbackId(); 
        if (feedbacks.len != 0) { // feedbacks
            for (f in feedbacks) { 
                if (f == "true") { 
                    comment += this.compareTable(EniBook[feedbacks[f]]); 
                }
            }
        }       
    }
    return comment;
}

//------------------------------------------------------------------------------
QueryTree.prototype.saveTable = function(name) { 
    var tables = $("#enibook-feedback-main").find("table");

    if (tables.length > 0) {
        var table = tables[0];
        //var html = "<table class='sql-table' query='" + name + "'>" + $(table).html() + "</table>"
        var a = document.createElement('a');
        a.href = 'data:application/octet-stream,' + encodeURIComponent(table.outerHTML);
        a.download = name + ".html";
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }
}

//------------------------------------------------------------------------------
QueryTree.prototype.tableCreate = function () { 
  function valconcat(vals, tagName) {
    if (vals.length === 0) return '';
    var open = '<' + tagName + '>';
    var close='</' + tagName + ((tagName === 'tr') ? '>\n' : '>');
    return open + vals.join(close + open) + close ;
  }
  return function (name, columns, values){ 
    var tbl = $("<table></table>");
    var html = '\n<thead>\n<tr>' + valconcat(columns, 'th') + '</tr>\n</thead>\n';
    var rows = values.map(function(v){ return valconcat(v, 'td'); });
    html += '<tbody>\n' + valconcat(rows, 'tr') + '</tbody>\n';
    $(tbl).append(html);
    $(tbl).addClass('sql-table');
    $(tbl).attr('query',name);
    //$(tbl).basictable();
    return tbl;
  }
}();

//------------------------------------------------------------------------------
QueryTree.prototype.errorSQL = function(e) { 
    var res = "<p>\n" + e.message + "\n</p>"
    var height = parseInt($(this.$feedback).css("height").replace("px",""))
    var width  = parseInt($(this.$feedback).css("width").replace("px",""))/2
    var offset = $(this.$feedback).offset();
    var $x = Math.round(offset.left + width);
    var $y = Math.round(offset.top - height);

    $("#enibook-feedback-main").html(res);
    $("#enibook-feedback-title").html("Erreur SQL");
    $("#enibook-feedback").popup("open",{ arrow: false, x: $x, y: $y });   
    //$("#enibook-feedback").popup('option','dismissible',false); 
}

//------------------------------------------------------------------------------
QueryTree.prototype.noerrorSQL = function() {
    $(this.$modal).html('');
};

//------------------------------------------------------------------------------
QueryTree.prototype.searchSQLNodesTo = function(node) {  
    var sql = "";

    switch (node.category) {
        case "table" :
            break;
        case "query" : // SELECT * FROM T
            sql += "-- QUERY " + node.data.name + "\n";
            sql += "SELECT * FROM ";
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 1) {
                it.next();
                sql += it.value.data.name;
            }
            else {
                sql += "query unknown";
            }
            break;
        case "project" : // SELECT V.NV, V.CRU FROM V
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 1) {
                it.next();
                sql += "-- PROJECTION " + node.data.name + "\n";
                sql += "CREATE VIEW " + node.data.name + "\nAS\n";
                sql += "SELECT " + this.toSQLAttributes(node.data.attributes) + " FROM " + it.value.data.name;
            }
            else { sql += "projection unknown"; }
            break;
        case "restrict" : // SELECT * FROM V WHERE V.CRU=value
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 1) {
                it.next();
                sql += "-- RESTRICTION " + node.data.name + "\n";
                sql += "CREATE VIEW " + node.data.name + "\nAS\n";
                sql += "SELECT * FROM " + it.value.data.name;
                sql += " WHERE (" + node.data.condition.replace("[",'').replace("]",'') + ")";
            }
            else { sql += "restriction unknown"; }            
            break;
        case "sort": //SELECT * FROM V ORDER BY V.CRU,V.MILL
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 1) {
                it.next();
                sql += "-- SORT " + node.data.name + "\n";
                sql += "CREATE VIEW " + node.data.name + "\nAS\n";
                sql += "SELECT * FROM " + it.value.data.name;
                sql += " ORDER BY " + node.data.attributes.trim().replace(/\(/g,'').replace(/\)/g,'');
            }
            else { sql += "sort unknown"; }            
            break;
        case "agreg": // SELECT V.CRU,V.MILL,COUNT(*) FROM V GROUP BY V.CRU,V.MILL
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 1) {
                it.next();
                sql += "-- AGGREGATION " + node.data.name + "\n";
                sql += "CREATE VIEW " + node.data.name + "\nAS\n";

                var opts = {
                    /*fct    : node.data.function, 
                    where  : node.data.where.trim(),*/
                    fcts   : node.data.functions.trim().replace(/^\(/,'').replace(/\)$/,''),
                    attrs  : node.data.attributes.trim().replace(/\(/g,'').replace(/\)/g,''),
                    having : node.data.having.trim(),
                    from   : it.value.data.name
                };
                sql += this.requestAgreg(opts);
            }
            else { sql += "aggregation unknown"; }    
            break;
        case "innerjoin" : // SELECT * FROM A INNER JOIN V ON (A.NV=V.NV)
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 2) {
                sql += "-- " + ((node.data.condition === '[]') ? " NATURAL JOIN " : " INNER JOIN ");
                sql += node.data.name + "\n";
                sql += "CREATE VIEW " + node.data.name + "\nAS\n";
                sql += "SELECT * FROM ";
                it.next();
                sql += it.value.data.name
                sql += (node.data.condition === '[]') ? " NATURAL JOIN " : " INNER JOIN ";
                it.next();
                sql += it.value.data.name
                if (node.data.condition !== '[]') {
                    sql += " ON ";
                    sql += this.toSQLCondition(node.data.condition);
                }
            }
            else { sql += "jointure unknown"; }
            break;
        case "times" :
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 2) {
                it.next();
                var n1 = it.value;
                it.next();
                var n2 = it.value;
                sql += "-- PRODUCT " + node.data.name + "\n";
                sql += "CREATE VIEW " + node.data.name + "\nAS\n";
                sql += "SELECT * FROM " + n1.data.name + "," + n2.data.name;                
            }
            else { sql += "product unknown"; }
            break;            
        case "inter" : // SELECT A.NV FROM A INTERSECT SELECT V.NV FROM V
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 2) {
                it.next();
                sql += "-- INTERSECT " + node.data.name + "\n";
                sql += "CREATE VIEW " + node.data.name + "\nAS\n";
                sql += "SELECT * FROM " + it.value.data.name;
                sql += " INTERSECT ";
                it.next();
                sql += "SELECT * FROM " + it.value.data.name;
            }
            else { sql += "intersection unknown"; }
            break;
        case "union" : // SELECT A.NV FROM A UNION SELECT V.NV FROM V
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 2) {
                sql += "-- UNION " + node.data.name + "\n";
                sql += "CREATE VIEW " + node.data.name + "\nAS\n";
                it.next();
                sql += "SELECT * FROM " + it.value.data.name;
                sql += " UNION ";
                it.next();
                sql += "SELECT * FROM " + it.value.data.name;
            }
            else { sql += "union unknown"; }
            break;
        case "minus" : // SELECT A.NV FROM A EXCEPT SELECT V.NV FROM V
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 2) {
                sql += "-- EXCEPT " + node.data.name + "\n";
                sql += "CREATE VIEW " + node.data.name + "\nAS\n";
                it.next();
                sql += "SELECT * FROM " + it.value.data.name;
                sql += " EXCEPT ";
                it.next();
                sql += "SELECT * FROM " + it.value.data.name;
            }
            else { sql += "difference unknown"; }
            break;
        case "divrel" : // SELECT R.X FROM R WHERE NOT EXISTS (SELECT Y FROM S) EXCEPT (SELECT Y FROM R WHERE X=R.X)
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 2) {
                it.next();
                var dividend = it.value;
                var it_parent = dividend.findNodesInto();
                var size_parent = it_parent.count;
                if (size_parent === 1) {
                    it_parent.next();
                    var parent = it_parent.value;
                    var attrDividende = dividend.data.attributes.replace(/\(/g,'').replace(/\)/g,'');
                    it.next();
                    var divider = it.value;
                    var attrDivider = divider.data.attributes.replace(/\(/g,'').replace(/\)/g,'');
                    var attrs = this.divrel(attrDividende,attrDivider);
                    sql += "-- DIVISION " + node.data.name + "\n";
                    sql += "CREATE VIEW " + node.data.name + "\nAS\n";
                    sql += "SELECT DISTINCT " + attrs + " FROM " + parent.data.name + " " + parent.data.name + "_1\n";
                    sql += "WHERE NOT EXISTS (\n";
                    sql += "SELECT * FROM " + divider.data.name;
                    sql += " EXCEPT ";
                    sql += "SELECT " + attrDivider + " FROM " + parent.data.name + " " + parent.data.name + "_2\n";
                    sql += " WHERE " + this.divrelCond(attrs, parent.data.name) + ")";
                }
                else { sql += "parent unknown"; }
            }
            else { sql += "division unknown"; }
            break;           
        default :
            sql += "unknown";
            break;            
    }
    return sql;
}

//------------------------------------------------------------------------------
QueryTree.prototype.requestAgreg = function(opts) {
    /*var where = opts.where !== '[]';*/
    var fcts   = opts.fcts !== '';
    var attrs  = opts.attrs !== '';
    var having = opts.having !== '[]';
    var sql = "";

    /*if (!attrs && !having) {
        sql += "SELECT * " + opts.fct + "\n";
        sql += "FROM " + opts.from;
    }*/
    if (attrs && !having && !fcts) { 
        sql += "SELECT " + opts.attrs /*+ ", " + opts.fct*/ + "\n";
        sql += "FROM " + opts.from + "\n";
        sql += "GROUP BY " + opts.attrs;
    }
    if (attrs && having && !fcts) {
        sql += "SELECT " + opts.attrs /*+ ", " + opts.fct*/ + "\n";
        sql += "FROM " + opts.from + "\n";
        sql += "GROUP BY " + opts.attrs + "\n";
        sql += "HAVING " + opts.having.replace('[','(').replace(']',')');
    }
    if (attrs && !having && fcts) { 
        sql += "SELECT " + opts.attrs /*+ ", " + opts.fct*/ + "," + opts.fcts + "\n";
        sql += "FROM " + opts.from + "\n";
        sql += "GROUP BY " + opts.attrs;
    }
    if (attrs && having && fcts) {
        sql += "SELECT " + opts.attrs /*+ ", " + opts.fct*/ + "," + opts.fcts + "\n";
        sql += "FROM " + opts.from + "\n";
        sql += "GROUP BY " + opts.attrs + "\n";
        sql += "HAVING " + opts.having.replace('[','(').replace(']',')');
    }
    /*if (where && !attrs && !having) {
        sql += "SELECT " + opts.function + "\n";
        sql += "FROM " + opts.from + "\n";
        sql += "WHERE " + opts.where.replace('[','(').replace(']',')');
    }
    if (where && attrs && !having) {
        sql += "SELECT " + opts.attrs + ", " + opts.fct + "\n";
        sql += "FROM " + opts.from + "\n";
        sql += "WHERE " + opts.where.replace('[','(').replace(']',')') + "\n";
        sql += "GROUP BY " + opts.attrs;
    }
    if (where && attrs && having) {
        sql += "SELECT " + opts.attrs + ", " + opts.fct + "\n";
        sql += "FROM " + opts.from + "\n";
        sql += "WHERE " + opts.where.replace('[','(').replace(']',')') + "\n";
        sql += "GROUP BY " + opts.attrs + "\n";
        sql += "HAVING " + opts.having.replace('[','(').replace(']',')');
    }*/
    return sql;        
}

//------------------------------------------------------------------------------
QueryTree.prototype.subset = function(attrDividend,attrDivider) {
    var attrNum = attrDividend.trim().replace(/\(/g,'').replace(/\)/g,'').split(',');
    var attrDen = attrDivider.trim().replace(/\(/g,'').replace(/\)/g,'').split(',');

    for (var i = 0; i < attrDen.length; i++) {
        if (attrNum.indexOf(attrDen[i]) === -1) { return false; }
    }
    return true;
}

//------------------------------------------------------------------------------
QueryTree.prototype.divrelCond = function(attrs,parent) {
    var array = attrs.split(',');
    var cond = ""
    for (var i = 0; i < array.length; i++) {
        cond += parent + "_1." + array[i] + " = " + parent + "_2." + array[i];
        if (i < array.length - 1) { cond += " AND "; }
    }
    return cond;
}

//------------------------------------------------------------------------------
QueryTree.prototype.divrel = function(attrDividend,attrDivider) {
    var attrs = [];
    var attrNum = attrDividend.trim().replace(/^\(/,'').replace(/\)$/,'').split(',');
    var attrDen = attrDivider.trim().replace(/^\(/,'').replace(/\)$/,'').split(',');
    for (var i = 0; i < attrNum.length; i++) {
        if (attrDen.indexOf(attrNum[i]) === -1) { attrs.push(attrNum[i]); }
    } 
    return attrs.toString(); 
}

//------------------------------------------------------------------------------
QueryTree.prototype.toSQLCondition = function(condition) {
    sql = condition.trim();
    sql = sql.replace(/^\[/,'(');
    sql = sql.replace(/\]$/,')');
    return sql;
}

//------------------------------------------------------------------------------
QueryTree.prototype.toSQLAttributes = function(attributes) {
    return attributes.trim().replace(/^\(/,'').replace(/\)$/,'');
}

//------------------------------------------------------------------------------
QueryTree.prototype.searchLatexNodesTo = function(node) {
    var res = "";

    switch (node.category) {
        case 'table':
            break;
        case 'query':
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 1) {
                it.next();
                res += it.value.data.name;
            }
            break;
        case 'restrict':
        case 'project':
        case 'sort':
        case 'agreg':
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 1) {
                res += '\\left(';
                it.next();
                res += it.value.data.name;
                res += '\\right)'; 
            }
            break;
        case 'leftouterjoin':
        case 'rightouterjoin':
        case 'fullouterjoin':
        case 'innerjoin':
        case 'times':
        case 'minus':
        case 'inter':
        case 'union':
        case 'divrel':
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 2) {
                res += '\\left(';
                it.next();
                res += it.value.data.name;
                res += ', ';
                it.next();
                res += it.value.data.name;
                res += '\\right)'; 
            }
            break;
        default:
            break;
    }
    return res;
}

//------------------------------------------------------------------------------
QueryTree.prototype.toLatex = function(node) {
    var latex = "";
    switch (node.category) {
        case 'query' :
            break;
        case 'restrict' :
            latex += "{\\LARGE\\sigma}_{" + this.opLatex(node.data.condition) + "}";
            break;
        case 'project' :
            latex += "\\prod_{" + node.data.attributes + "}";
            break;
        case 'sort' :
            latex += "{\\Large S}_{" + node.data.attributes + "}";
            break;
        case 'agreg':
            var attrs = node.data.attributes.replace('(','').replace(')','');
            var fcts  = node.data.functions.replace(/^\(/,'').replace(/\)$/,'');
            latex += "{\\Large G}_{" + /*node.data.where + "," +*/ node.data.having + "}";
            latex += "^{" + (attrs ? attrs + ","/*+ ","*/ : "") /*+ node.data.function*/ + (fcts ? fcts : "") + "}";
            break;
        case 'leftouterjoin' :
        case 'rightouterjoin' :
        case 'fullouterjoin' :
        case 'innerjoin' :
            latex += "{\\LARGE\\Join}_{" + this.opLatex(node.data.condition) + "}";
            break;
        case 'times' :
            latex += "{\\Large\\times}";
            break;
        case 'minus' :
            latex += "{\\LARGE\\backslash}";
            break;
        case 'inter' :
            latex += "\\bigcap ";
            break;
        case 'union' :
            latex += "\\bigcup ";
            break;
        case 'divrel' :
            var attrs = "()";
            var it = node.findNodesInto(); 
            var size = it.count; 
            if (size === 2) {
                it.next();
                var dividend = it.value;
                it.next();
                var divider = it.value;
                attrs = "(" + this.divrel(dividend.data.attributes,divider.data.attributes) + ")";
            }
            latex += "{\\LARGE\\div}_{" + attrs + "}";
            break;
        case 'table' :
            latex += node.data.name + " ";
            break;
        default :
            latex += "unknown";
            break;            
    }
    return latex;
}

//------------------------------------------------------------------------------
QueryTree.prototype.opLatex = function(str) {
    str = str.replace(/<=/g,'\\leq ');
    str = str.replace(/>=/g,'\\geq ');
    str = str.replace(/<>/g,'\\neq ');
    str = str.replace(/ or /g,'\\ \\lor\\ ');
    str = str.replace(/ and /g,'\\ \\land\\ ');
    return str;
}

//------------------------------------------------------------------------------
QueryTree.prototype.compareTable = function(feedback) { // feedback : Javascript object
    var res = "";
    var comment = "";

    var $div = $("<div></div>");
    $($div).attr("id",this.id + "-solTable"); 
    $($div).html(feedback.feedbacktrueArray[0][1].replace(/&gt;/g,'>').replace(/&lt;/g,'<'));
    var $solutions = $($div).children("table"); 

    if ($solutions.length === 1) { 
        var $solution = $solutions[0]; 
        var query = $($solution).attr('query'); 
        var $tables = $(this.$modal).find(".sql-table");
        if ($tables.length >= 1) {
            var $table = $tables[0];
            var user_query = $($table).attr('query');
            if (user_query === query) {
                var table_array    = this.table2array($table); 
                var solution_array = this.table2array($solution); 
                if (table_array.length > 0) {
                    var thead = table_array[0];
                    for (var i = 0; i < thead.length; i++) {
                        thead[i] = thead[i].replace('\\(','');
                        thead[i] = thead[i].replace('\\)','');
                        table_array[0] = thead;
                    }
                }
                        
                var ok = true;
                if (table_array.length != solution_array.length) {
                    ok = false;
                    if (table_array.length > 1 && solution_array.length > 1) {
                        var ins_table    = table_array.length - 1;
                        var ins_solution = solution_array.length - 1;
                        var diff = ins_table - ins_solution;
                        var nbIn = (ins_table > 1) ? " entrées " : " entrée ";
                        comment += "La table a " + ins_table.toString() + nbIn +
                                   ": soit " + Math.abs(diff).toString();
                        if (diff > 0) { comment +=  " de trop que prévu."; }
                        else { comment += " de moins que prévu."; }
                    }
                }
                else {
                    for (var i = 0; i < table_array.length && ok; i++) {
                        if (table_array[i].length != solution_array[i].length) { 
                            ok = false; 
                            var ins_table = table_array.length - 1;
                            var diff = table_array[i].length - solution_array[i].length;
                            var nbOut = (table_array[i].length - ins_table > 1) ? " sorties " : " sortie ";
                            comment += "La table a " + (table_array[i].length - ins_table).toString() + 
                                       nbOut + ": soit " + Math.abs(diff).toString();
                            if (diff > 0) { comment +=  " de trop que prévu."; }
                            else { comment += " de moins que prévu."; }
                        }
                        else {
                            for (var j = 0; j < table_array[i].length && ok; j++) {
                                if (table_array[i][j] != solution_array[i][j]) {
                                    ok = false;
                                    if (i == 0) { 
                                        comment += "Colonne " + (j+1).toString() + ": " +
                                                   solution_array[i][j] + 
                                                    " attendu, " + 
                                                    table_array[i][j] + 
                                                    " trouvé."   
                                    }
                                    else {
                                        comment += "Ligne " + (i+1).toString() + 
                                                   ": problème avec la valeur de " + 
                                                   table_array[0][j] + ".";
                                    }
                                }
                            }
                        }
                    }
                }        
                if (ok) { 
                    res += "<div class='feedback-true'>C'est bien la table " + query + " attendue.<br />" 
                        +  comment 
                        +  "</div>"; 
                }
                else {
                    res += "<div class='feedback-false'>" +
                           "Ce n'est pas la table " + query + " attendue.<br />" 
                        +  comment 
                        +  "</div>";
                }
            }
            else {
                res += "<div class='feedback-info'>";
                res += "Table " + query + " attendue. Table " + user_query + " proposée."; 
                res += "</div>";
            }
        }
    }
    return res; 
}

//------------------------------------------------------------------------------
QueryTree.prototype.table2array = function(table) {
    var table_array = new Array();

    var $theads = $(table).children("thead");
    if ($theads.length === 1) {
        var $thead = $theads[0]; 
        var $trs = $($thead).children("tr");
        for (var i = 0; i < $trs.length; i++) {
            var $ths = $($trs[i]).children("th");
            var row = new Array();
            for (var j = 0; j < $ths.length; j++) {
                row.push($($ths[j]).text());
            }
            table_array.push(row);     
        }
    }

    var $tbodies = $(table).children("tbody");
    if ($tbodies.length === 1) {
        var $tbody = $tbodies[0];
        var $trs = $($tbody).children("tr");
        for (var i = 0; i < $trs.length; i++) {
            var $tds = $($trs[i]).children("td");
            var row = new Array();
            for (var j = 0; j < $tds.length; j++) {
                row.push($($tds[j]).text());
            }
            table_array.push(row);     
        }
    }

    return table_array;
}

//alert('DataTree');
/******************************************************************************
 *
 * DataTree
 *
 ******************************************************************************/
//------------------------------------------------------------------------------
function DataTree(id) { // id : HTML identifier 
    Graph.call(this,id); // inherits from Graph

    var $go = go.GraphObject.make;

    //--------------------------------------------------------------------------
    this.graph.diagram.linkTemplate =
        $go(go.Link,
            {
                routing: go.Link.Normal,
                curve: go.Link.JumpOver,
                //corner: 5, toShortLength: 4,
                relinkableFrom: true,
                relinkableTo: true,
                reshapable: true,
                resegmentable: true,
                mouseEnter: function(e, link) { link.findObject("HIGHLIGHT").stroke = "rgba(30,144,255,0.2)"; },
                mouseLeave: function(e, link) { link.findObject("HIGHLIGHT").stroke = "transparent"; }
            },
            new go.Binding("points").makeTwoWay(),
            $go(go.Shape,
                { isPanelMain: true, strokeWidth: 8, stroke: "transparent", name: "HIGHLIGHT" }),
            $go(go.Shape,
                { isPanelMain: true, stroke: "gray", strokeWidth: 2 }),
            $go(go.Shape,
                { toArrow: "standard", stroke: null, fill: "gray"}),
            $go(go.Panel, "Auto",  
                { visible: false, name: "LINKLABEL", segmentIndex: 2, segmentFraction: 0.5},
                new go.Binding("visible", "visible").makeTwoWay(),
                $go(go.Shape, "RoundedRectangle", 
                    { fill: "#F8F8F8", stroke: null }),
                $go(go.TextBlock, "CLEF",
                    {
                        textAlign: "center",
                        font: "bold 11pt Monospace",
                        stroke: "black",
                        editable: true
                    },
                    new go.Binding("text", "text").makeTwoWay()
                )
            )
        );

    //--------------------------------------------------------------------------
    function infoNode(obj) {
        var part = obj.part;
        if (part instanceof go.Adornment) { part = part.adornedPart; }
        var msg = "";
        if (part instanceof go.Node) {
            var node = part;
            msg = node.data.info;
        } 
        else if (part instanceof go.Group) {
            var group = part;
            msg = group.data.info;
        }
        return msg;
    }

    //--------------------------------------------------------------------------
    var nodeTemplate = 
        $go(go.Node, "Auto", 
            { 
                locationSpot: go.Spot.Center,
                toolTip:  
                    $go(go.Adornment, "Auto",
                        $go(go.Shape, { fill: "black", stroke: "black" }),
                        $go(go.TextBlock, { font: "8pt Monospace", margin: 4, stroke: "white" }, new go.Binding("text", "", infoNode).ofObject())
                    )
            },
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Shape, "Rectangle",
                { 
                    fill: "transparent",  
                    stroke: "black",
                    portId: "", fromLinkable: true, toLinkable: true//, toMaxLinks  : 1
                }
            ),
            $go(go.Panel, "Table", 
                {
                    defaultRowSeparatorStroke: "black",margin: 4
                    
                },
                $go(go.Panel, "Table", {row:0, defaultColumnSeparatorStroke: "black"},
                    $go(go.TextBlock,
                        {
                            row : 0, column : 1,
                            font: "11pt Monospace",
                            stroke: "black",
                            margin: 4,
                            textAlign: "left",
                            editable: true
                        },
                        new go.Binding("text","name").makeTwoWay()
                    ),
                    $go(go.TextBlock,
                        {
                            row : 0, column : 0,
                            font: "11pt Monospace",
                            stroke: "black",
                            margin: 4,
                            textAlign: "left",
                            editable: true
                        },
                        new go.Binding("text","type").makeTwoWay()
                    )
                )
            )
        );

    //--------------------------------------------------------------------------
    var leafTemplate = 
        $go(go.Node, "Auto", 
            { 
                locationSpot: go.Spot.Center,
                toolTip:  
                    $go(go.Adornment, "Auto",
                        $go(go.Shape, { fill: "black", stroke: "black" }),
                        $go(go.TextBlock, { font: "8pt Monospace", margin: 4, stroke: "white" }, new go.Binding("text", "", infoNode).ofObject())
                    )
            },
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            $go(go.Shape, "Rectangle",
                { 
                    fill: "transparent",  
                    stroke: "black",
                    portId: "", fromLinkable: false, toLinkable: true//, toMaxLinks  : 1
                }
            ),
            $go(go.TextBlock,
                {
                    font: "11pt Monospace",
                    stroke: "black",
                    margin: 4,
                    textAlign: "center",
                    editable: true
                },
                new go.Binding("text", "value").makeTwoWay()
            )
        );

    //--------------------------------------------------------------------------
    this.graph.diagram.nodeTemplateMap.add("node", nodeTemplate);
    this.graph.diagram.nodeTemplateMap.add("leaf", leafTemplate);

    //--------------------------------------------------------------------------
    // Palette
    var pal0 = $go(go.Palette,this.paletteid + "-0");

    this.graph.palette.push(pal0);

    for (var i = 0; i < this.graph.palette.length; i++) {
        var palette = this.graph.palette[i];
        palette.nodeTemplateMap  = this.graph.diagram.nodeTemplateMap;
    }

    this.graph.palette[0].model.nodeDataArray = [    
        { category: "node" , type: "dict {}",  name: "nom", info: "dictionnaire {clef: valeur, …}" },
        { category: "node" , type: "list []",  name: "nom", info: "liste [t[0], t[1], …]" },
        { category: "node" , type: "tuple ()", name: "nom", info: "n-uplets (t[0], t[1], …)" },
        { category: "leaf" , value: "valeur", info: "valeur (pas de fils)" }
    ];

    $(this.$palette).accordion(
        {
            heightStyle: "content",
            activate: function(event, ui) { EniBook[id].refresh(); }
        });

    //--------------------------------------------------------------------------
    // load the diagram from this.$code
    this.load();
}

//-----------------------------------------------------------------------------
DataTree.prototype = Object.create(Graph.prototype); // inherits from Graph

//------------------------------------------------------------------------------
DataTree.prototype.showLinkLabel = function(e) {
    var label = e.subject.findObject("LINKLABEL");
    if (label !== null) { label.visible = true; }
}

//alert('Memory');
/******************************************************************************
 *
 * Memory
 *
 ******************************************************************************/
//------------------------------------------------------------------------------
function Memory(id) { // id : HTML identifier 
    Graph.call(this,id); // inherits from Graph

    $(this.$feedback).removeClass('feedback-true');
    $(this.$feedback).removeClass('feedback-false');
    $(this.$feedback).addClass('feedback');

    this.errorMsg  = {};
    this.initErrorMsg();

    var $go = go.GraphObject.make;
    theDiagram = this.graph.diagram;

    //--------------------------------------------------------------------------
    theDiagram.linkTemplate =
        $go(go.Link,
            {
                routing: go.Link.AvoidsNodes,
                curve: go.Link.JumpOver,
                corner: 4,
                relinkableFrom: true,
                relinkableTo: true, 
                reshapable: true,
                resegmentable: true,
                mouseEnter: function(e, link) { link.findObject("HIGHLIGHT").stroke = "rgba(30,144,255,0.2)"; },
                mouseLeave: function(e, link) { link.findObject("HIGHLIGHT").stroke = "transparent"; }
            },
            new go.Binding("points").makeTwoWay(),
            new go.Binding("relinkableTo","", arrayPtrLink),
            $go(go.Shape,
                { isPanelMain: true, strokeWidth: 8, stroke: "transparent", name: "HIGHLIGHT" }),
            $go(go.Shape,
                { isPanelMain: true, stroke: "gray", strokeWidth: 2 }),
            $go(go.Shape,
                { toArrow: "standard", stroke: null, fill: "gray"}),
            $go(go.Panel, "Auto",  
                { visible: false, name: "LINKLABEL", segmentIndex: 2, segmentFraction: 0.5},
                new go.Binding("visible", "visible").makeTwoWay(),
                $go(go.Shape, "RoundedRectangle", 
                    { fill: "#F8F8F8", stroke: null }),
                $go(go.TextBlock, "True/False",
                    {
                        textAlign: "center",
                        font: "bold 11pt Monospace",
                        stroke: "black",
                        editable: true
                    },
                    new go.Binding("text", "text").makeTwoWay()
                )
            )
        );

    //--------------------------------------------------------------------------
    function arrayPtrLink(data, element) {
        var link = element.part;
        if (!link) return true;
        var node = link.fromNode;
        if (!node || node.category !== "array") { return true; }
        return false;
    }

    //--------------------------------------------------------------------------
    function nodeStyle() { 
      return [
        $go(go.Shape, { fill: "white", stroke: "black" }),
        new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
        {
          locationSpot: go.Spot.Center,
          mouseEnter: function (e, obj) { showPorts(obj.part, true); },
          mouseLeave: function (e, obj) { showPorts(obj.part, false); },
          mouseDrop : function (e, nod) { finishDrop(e, nod.containingGroup); }
        }
      ];
    }

    //--------------------------------------------------------------------------
    function nodePtrStyle() { 
      return [
        $go(go.Shape, { fill: "white", stroke: "black" }),
        new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
        {
          locationSpot: go.Spot.Center,
          mouseEnter: function (e, obj) { showPorts(obj.part, true); },
          mouseLeave: function (e, obj) { showPorts(obj.part, false); },
          mouseDrop : function (e, nod) { finishDrop(e, nod.containingGroup); }
        }
      ];
    }

    //--------------------------------------------------------------------------
    function nullPtrStyle() { 
      return [
        $go(go.Shape, { fill: "white", stroke: "black" }),
        new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
        {
          locationSpot: go.Spot.Center,
          mouseDrop: function(e, nod) { finishDrop(e, nod.containingGroup); }
        }
      ];
    }

    //--------------------------------------------------------------------------
    function makePort(name, spot, output, input) { 
        var shape = 
            $go(go.Shape, "Circle",
                {
                    fill: "transparent",
                    stroke: null,
                    desiredSize: new go.Size(8, 8),
                    alignment: spot, alignmentFocus: spot, 
                    portId: name,
                    fromSpot: spot, toSpot: spot, 
                    fromLinkable: output, toLinkable: input, 
                    cursor: "pointer" 
                });
        return shape;
    }

    //--------------------------------------------------------------------------
    function makePointer(name) { 
        var shape = 
            $go(go.Shape, "Circle",
                {
                    fill: "black",
                    stroke: null,
                    desiredSize: new go.Size(10,10),
                    portId: name,
                    fromLinkable: true, toLinkable: false, 
                    fromMaxLinks  : 1,
                    cursor: "pointer" 
                });
        return shape;
    }

    
    //--------------------------------------------------------------------------
    function showPorts(node, show) {
        var diagram = node.diagram;
        if (!diagram || diagram.isReadOnly || !diagram.allowLink) return;
        node.ports.each(function(port) { port.stroke = (show ? "white" : null); });
    }

    //--------------------------------------------------------------------------
    function highlightGroup(e, grp, show) {
        if (!grp) return;
        e.handled = true;
        if (show) {
            var tool = grp.diagram.toolManager.draggingTool;
            var map = tool.draggedParts || tool.copiedParts; 
            if (grp.canAddMembers(map.toKeySet())) {
                grp.isHighlighted = true;
                return;
            }
        }
        grp.isHighlighted = false;
    }

    //--------------------------------------------------------------------------
    var zoneTemplate =
        $go(go.Group, "Auto",
            {
                background: "transparent",
                mouseDragEnter: function(e, grp, prev) { highlightGroup(e, grp, true); },
                mouseDragLeave: function(e, grp, next) { highlightGroup(e, grp, false); },
                computesBoundsAfterDrag: true,
                mouseDrop: finishDrop,
                handlesDragDropForMembers: true,
                layout:
                    $go(go.GridLayout,
                        { 
                            wrappingColumn: 1, alignment: go.GridLayout.Position,
                            cellSize: new go.Size(1, 1), spacing: new go.Size(4, 4) 
                        }
                    )
            },
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            new go.Binding("background", "isHighlighted", function(h) { return h ? "rgba(255,0,0,0.2)" : "transparent"; }).ofObject(),
            $go(go.Shape, "Rectangle", { fill: null, stroke: "rgb(234,138,0)", strokeWidth: 2 }  ),
            $go(go.Panel, go.Panel.Vertical, {stretch: go.GraphObject.Horizontal, alignment: go.Spot.Top },
                $go(go.Panel, go.Panel.Horizontal,
                    { stretch: go.GraphObject.Horizontal, background: "rgb(234,138,0)", margin: 1 },
                    $go("SubGraphExpanderButton", { alignment: go.Spot.Right, margin: 4 }),
                    $go(go.TextBlock,
                        {
                            alignment: go.Spot.Left,
                            editable: false,
                            margin: 4,
                            font: "bold 14pt Monospace"
                        },
                        new go.Binding("text", "name").makeTwoWay()
                    )
                ),
                $go(go.Placeholder, { padding: 5, alignment: go.Spot.TopLeft })
            )
        );

    //--------------------------------------------------------------------------
    var contextTemplate =
        $go(go.Group, "Auto",
            {
                background: "transparent",
                mouseDragEnter: function(e, grp, prev) { highlightGroup(e, grp, true); },
                mouseDragLeave: function(e, grp, next) { highlightGroup(e, grp, false); },
                computesBoundsAfterDrag: true,
                mouseDrop: finishDrop,
                handlesDragDropForMembers: true,
                layout:
                    $go(go.GridLayout,
                        { 
                            wrappingColumn: 1, alignment: go.GridLayout.Position,
                            cellSize: new go.Size(1, 1), spacing: new go.Size(4, 4) 
                        }
                    )
            },
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            new go.Binding("background", "isHighlighted", function(h) { return h ? "rgba(255,0,0,0.2)" : "transparent"; }).ofObject(),
            $go(go.Shape, "Rectangle", { fill: null, stroke: "rgb(144,209,223)", strokeWidth: 2 }  ),
            $go(go.Panel, go.Panel.Vertical, {stretch: go.GraphObject.Horizontal, alignment: go.Spot.Top },
                $go(go.Panel, go.Panel.Horizontal,
                    { stretch: go.GraphObject.Horizontal, background: "rgb(144,209,223)", margin: 1 },
                    $go("SubGraphExpanderButton", { alignment: go.Spot.Right, margin: 5 }),
                    $go(go.TextBlock,
                        {
                            alignment: go.Spot.Left,
                            editable: true,
                            margin: 4,
                            font: "bold 14pt Monospace"
                        },
                        new go.Binding("text", "name").makeTwoWay(),
                        new go.Binding("editable", "editable").makeTwoWay()
                    ),
                    $go(go.TextBlock,
                        {
                            alignment: go.Spot.Left,
                            editable: false,
                            margin: 4,
                            font: "14pt Monospace",
                            text: "()"
                        }
                    )
                ),
                $go(go.Placeholder, { padding: 5, alignment: go.Spot.TopLeft })
            )
        );


    //--------------------------------------------------------------------------
    var buttonPlusTemplate = 
        $go(go.Adornment, "Spot",
            $go(go.Panel, "Auto",
                $go(go.Shape, { fill: null, stroke: "blue", strokeWidth: 2 }),
                $go(go.Placeholder) 
            ),
            $go("Button",
                {
                    alignment: go.Spot.TopLeft,
                    click: addArrayNode,
                    visible: false
                },
                $go(go.Shape, "PlusLine", { desiredSize: new go.Size(6, 6) }),
                new go.Binding("visible","",function(e,obj) {
                            var adornment = obj.part;
                            e.handled = true;
                            var diagram = adornment.diagram;
                            var array = adornment.adornedPart;
                            return array.findSubGraphParts().count ? true : false ;
                        }
                )
            ),
            $go("Button",
                {
                    alignment: go.Spot.BottomLeft,
                    click: delArrayNode
                },
                $go(go.Shape, "MinusLine", { desiredSize: new go.Size(6, 6) })
            ),
            $go("Button",
                {
                    alignment: go.Spot.BottomRight,
                    click: delAllArrayNode
                },
                $go(go.Shape, "BpmnActivityLoop", { desiredSize: new go.Size(6, 6) })
            ),
            $go("Button",
                {
                    alignment: go.Spot.TopRight,
                },
                $go(go.TextBlock,"", { font: "5pt Monospace", textAlign: "center" },
                    new go.Binding("text","",function(e,obj) {
                            var adornment = obj.part;
                            e.handled = true;
                            var diagram = adornment.diagram;
                            var model = diagram.model;
                            var array = adornment.adornedPart; 
                            var n = array.findSubGraphParts().count;
                            return  n > 0 ? n-1 : 0;
                        }
                    )
                )
            )
        );   

    //--------------------------------------------------------------------------
    function delAllArrayNode(e, obj) { 
        var adornment = obj.part;
        e.handled = true;
        var diagram = adornment.diagram;

        diagram.startTransaction("Del AllArrayNode");

        var array = adornment.adornedPart; 
        var parts = array.findSubGraphParts().toArray();
        var n = parts.length;
        for (var i = n-1; i >= 0; i--) { diagram.remove(parts[i]); }

        diagram.commitTransaction("Del AllArrayNode");
        diagram.select(array);
    }

    //--------------------------------------------------------------------------
    function delArrayNode(e, obj) {
        var adornment = obj.part;
        e.handled = true;
        var diagram = adornment.diagram;

        diagram.startTransaction("Del arrayNode");

        var array = adornment.adornedPart; 
        var it = array.findSubGraphParts().iterator; 
        var item = null;
        while (it.next()) { var item = it.value; }
        if (item) { diagram.remove(item); }
        
        diagram.commitTransaction("Del arrayNode");
        diagram.select(array);
    }

    //--------------------------------------------------------------------------
    function addArrayNode(e, obj) {
        var adornment = obj.part;
        e.handled = true;
        var diagram = adornment.diagram;

        diagram.startTransaction("Add arrayNode");

        var array = adornment.adornedPart; 
        var iter = array.memberParts; 
        
        var firstNode = iter.first();
        diagram.select(firstNode);
        diagram.commandHandler.copySelection();
        diagram.commandHandler.pasteSelection();

        var ok = (array !== null
                  ? array.addMembers(array.diagram.selection,true)
                  : e.diagram.commandHandler.addTopLevelParts(e.diagram.selection, true));
        if (!ok) { e.diagram.currentTool.doCancel(); }
        
        diagram.commitTransaction("Add arrayNode");
        diagram.select(array);
    }

    //--------------------------------------------------------------------------
    var memoryTemplate =
        $go(go.Group, "Auto",
            {
                background: "transparent",
                selectionAdornmentTemplate : buttonPlusTemplate, 
                mouseDragEnter: function(e, grp, prev) { highlightGroup(e, grp, true); },
                mouseDragLeave: function(e, grp, next) { highlightGroup(e, grp, false); },
                mouseDrop: finishDrop,
                computesBoundsAfterDrag: true,
                handlesDragDropForMembers: true,
                memberAdded: addNodeToMemory,
                memberRemoved: delNodeFromMemory,
                layout: $go(go.GridLayout, 
                    { 
                        wrappingColumn: Infinity, alignment: go.GridLayout.Position,                
                        spacing: new go.Size(0.5, 0) 
                    })
            },
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            new go.Binding("background", "isHighlighted", function(h) { return h ? "rgba(255,0,0,0.2)" : "transparent"; }).ofObject(),
            $go(go.Shape, "Rectangle", { fill: null, stroke: "black", strokeWidth: 1, strokeDashArray: [5,2], minSize: new go.Size(100,40) }  ),
            $go(go.Placeholder, { alignment: go.Spot.Left, padding: new go.Margin(5,15) }),
            $go(go.TextBlock,"",{font: "10pt Monospace"},new go.Binding("text","",dynamicAlloc))
        );

    //--------------------------------------------------------------------------
    function addNodeToMemory(grp,part) {
        var diagram = grp.diagram;
        var model   = diagram.model;
        var iter    = grp.memberParts;

        diagram.startTransaction("Add NodeToMemory");
        
        var i = 0;
        while(iter.next()) { 
            if (model.nodeDataArray.indexOf(iter.value.data) !== -1) {
                model.setDataProperty(iter.value.data,"name","[" + i.toString() + "]"); 
                i++;
            } 
        }
        
        diagram.commitTransaction("Add NodeToMemory");
    }

    //--------------------------------------------------------------------------
    function addNodeToArray(grp,part) {
        var diagram = grp.diagram;
        diagram.startTransaction("Add NodeToArray");

        var model   = grp.diagram.model; 
        if (grp.findSubGraphParts().count === 1) { 
            var linkdata =  { 
                from: model.getKeyForNodeData(grp.data),
                fromPort: "C",
                to: model.getKeyForNodeData(part.data),
                toPort: "L",
                corner: 4,
                category: "linkArray",
                selectable: false
            };       
            model.addLinkData(linkdata);
            var link = diagram.findLinkForData(linkdata); 
            if (link) { link.selectable = false; }    
        }
        
        var i = 0;
        var iter = grp.memberParts;
        while(iter.next()) { 
            if (model.nodeDataArray.indexOf(iter.value.data) !== -1) {
                model.setDataProperty(iter.value.data,"name",grp.data.name + "[" + i.toString() + "]"); 
                i++; 
            }
        }
        
        var firstNode = iter.first();
        switch (firstNode.data.category) {
            case "pointer"  : model.setDataProperty(grp.data,"type",firstNode.data.type + "*"); break;
            case "struct"   : model.setDataProperty(grp.data,"type",firstNode.data.type + "{}"); break;
            case "array"    : model.setDataProperty(grp.data,"type",firstNode.data.type + "[]"); break;
            default         : model.setDataProperty(grp.data,"type",firstNode.data.type);
        }
        
        diagram.commitTransaction("Add NodeToArray");
    }

    //--------------------------------------------------------------------------
    function delNodeFromMemory(grp,part) {
        var diagram = grp.diagram;
        diagram.startTransaction("Del NodeFromMemory");
        
        var model   = grp.diagram.model;
        var i = 0;
        var iter = grp.memberParts;
        while(iter.next()) { 
            if (model.nodeDataArray.indexOf(iter.value.data) !== -1) {
                model.setDataProperty(iter.value.data,"name","[" + i.toString() + "]"); 
                i++; 
            }
        }
        diagram.commitTransaction("Del NodeFromMemory");
    }

    //--------------------------------------------------------------------------
    function delNodeFromArray(grp,part) {
        var diagram = grp.diagram;
        diagram.startTransaction("Del NodeFromArray");
        
        var model   = grp.diagram.model;
        var name    = part.data.name;
        
        if (grp.findSubGraphParts().count === 0) { model.setDataProperty(grp.data,"type","type"); }
        else {
            if (name && name.match(/0.$/)) { 
                var iter = grp.memberParts;
                var firstNode = iter.next() ? iter.first() : null; 
                if (firstNode != null) { 
                    var linkdata =  { 
                        from: model.getKeyForNodeData(grp.data),
                        fromPort: "C",
                        to: model.getKeyForNodeData(firstNode.data),
                        toPort: "L",
                        corner: 4,
                        category: "linkArray"
                    };       
                    model.addLinkData(linkdata); 
                    var link = diagram.findLinkForData(linkdata); 
                    if (link) { link.selectable = false; }    
                }
            }

            var i = 0;
            var iter = grp.memberParts;
            while(iter.next()) { 
                if (model.nodeDataArray.indexOf(iter.value.data) != -1) {
                    model.setDataProperty(iter.value.data,"name",grp.data.name + "[" + i.toString() + "]"); 
                    i++; 
                }
            }
        }
        diagram.commitTransaction("Del NodeFromArray");
    }
    
    //--------------------------------------------------------------------------
    function dynamicAlloc(data, element) {
        var node = element.part; 
        if (node && node.category === "memory" && node.memberParts.count) { return ""; }
        return "dynamic";
    }

    //--------------------------------------------------------------------------
    var arrayTemplate =
        $go(go.Group, "Auto",
            {
                background: "transparent",
                selectionAdornmentTemplate : buttonPlusTemplate, 
                mouseDragEnter: function(e, grp, prev) { highlightGroup(e, grp, true);  },
                mouseDragLeave: function(e, grp, next) { highlightGroup(e, grp, false); },
                mouseDrop: finishDrop,
                computesBoundsAfterDrag: true,
                handlesDragDropForMembers: true,
                memberAdded: addNodeToArray,
                memberRemoved: delNodeFromArray,
                layout: $go(go.GridLayout, 
                    { 
                        wrappingColumn: Infinity, alignment: go.GridLayout.Position,                
                        spacing: new go.Size(0.5, 0) 
                    })
            },
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            new go.Binding("background", "isHighlighted", function(h) { return h ? "rgba(255,0,0,0.2)" : "transparent"; }).ofObject(),
            $go(go.Shape, "Rectangle", { fill: null, stroke: "black", strokeWidth: 1, strokeDashArray: [5,2] }  ),
            $go(go.Panel, go.Panel.Vertical,
                $go(go.Panel, "Table",
                    { 
                        defaultRowSeparatorStroke: "black", 
                        margin: 1 
                    },
                    $go(go.Panel,"Table",
                        {
                            row: 0, alignment: go.Spot.Left
                        },
                        $go(go.RowColumnDefinition,
                            { column: 3, separatorStrokeWidth: 1, separatorStroke: "black" }),
                        $go(go.Shape, "Circle",
                            {      
                                row: 0, column: 0, margin: 0,  
                                fill: "gray",
                                stroke: null,
                                desiredSize: new go.Size(10,10),
                                portId: "C",
                                fromLinkable: true, toLinkable: true,
                                fromMaxLinks: 1,
                                cursor: "pointer"
                            }
                        ),
                        $go(go.TextBlock,
                            {
                                row: 0, column: 1, 
                                editable: false,
                                margin: 4,
                                font: "11pt Monospace",
                            },
                            new go.Binding("text", "type").makeTwoWay()
                        ),
                        $go(go.TextBlock,
                            {
                                row: 0, column: 2, 
                                editable: false,
                                margin: 4,
                                font: "11pt Monospace",
                                text: "[]"
                            }
                        ),
                        $go(go.TextBlock,
                            {
                                row: 0, column: 3, 
                                editable: true,
                                margin: 4,
                                font: "11pt Monospace",
                            },
                            new go.Binding("text", "name").makeTwoWay()
                        )
                    ),
                    $go(go.Placeholder, { row: 1, alignment: go.Spot.Left, padding: new go.Margin(5,15) })
                )
            )
        );
    
    //--------------------------------------------------------------------------
    var structTemplate =
        $go(go.Group, "Auto",
            {
                background: "transparent",
                mouseDragEnter: function(e, grp, prev) { highlightGroup(e, grp, true); },
                mouseDragLeave: function(e, grp, next) { highlightGroup(e, grp, false); },
                mouseDrop: finishDrop,
                computesBoundsAfterDrag: true,
                handlesDragDropForMembers: true,
                layout: $go(go.GridLayout,
                            { 
                            wrappingColumn: 1, alignment: go.GridLayout.Position,
                            cellSize: new go.Size(1,1), spacing: new go.Size(1,4)
                            }
                         )
            },
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
            new go.Binding("background", "isHighlighted", function(h) { return h ? "rgba(255,0,0,0.2)" : "transparent"; }).ofObject(),
            $go(go.Shape, "Rectangle", { fill: null, stroke: "rgb(162,169,63)", strokeWidth: 2 }  ),
            $go(go.Panel, go.Panel.Vertical,
                $go(go.Panel, go.Panel.Horizontal,
                    { stretch: go.GraphObject.Horizontal, background: "rgb(162,169,63)", margin: 1 },
                    $go("SubGraphExpanderButton", { alignment: go.Spot.Right, margin: 5 }),
                    $go(go.TextBlock,
                        {
                            alignment: go.Spot.Left,
                            editable: true,
                            margin: 4,
                            font: "bold 14pt Monospace"
                        },
                        new go.Binding("text", "type").makeTwoWay()
                    ),
                    $go(go.TextBlock,
                        {
                            alignment: go.Spot.Right,
                            editable: false,
                            margin: 4,
                            font: "14pt Monospace",
                            text: "{}"
                        }
                    ),
                    $go(go.TextBlock,
                        {
                            alignment: go.Spot.Right,
                            editable: true,
                            margin: 4,
                            font: "14pt Monospace"
                        },
                        new go.Binding("text", "name").makeTwoWay()
                    )
                ),
                $go(go.Placeholder, { padding: 5, alignment: go.Spot.TopLeft })
            ),
            makePort("T", go.Spot.Top,    false, true),
            makePort("L", go.Spot.Left,   false, true),
            makePort("B", go.Spot.Bottom, false, true)
        );

    //--------------------------------------------------------------------------
    var simpleTemplate = 
        $go(go.Node, "Auto", nodeStyle(),
            $go(go.Panel, "Table",
                {
                    defaultRowSeparatorStroke: "black"
                },
                $go(go.Panel, "Table", {row:0, defaultColumnSeparatorStroke: "black"},
                    $go(go.TextBlock,
                        {
                            row : 0, column : 1,
                            font: "11pt Monospace",
                            stroke: "black",
                            margin: 4,
                            textAlign: "left",
                            wrap: go.TextBlock.WrapFit,
                            editable: true
                        },
                        new go.Binding("text","name").makeTwoWay()),
                    $go(go.TextBlock,
                        {
                            row : 0, column : 0,
                            font: "11pt Monospace",
                            stroke: "black",
                            margin: 4,
                            textAlign: "left",
                            wrap: go.TextBlock.WrapFit,
                            editable: true
                        },
                        new go.Binding("text","type").makeTwoWay())
                    ),
                $go(go.TextBlock,
                    {
                        row : 1,
                        font: "11pt Monospace",
                        stroke: "black",
                        margin: 4,
                        textAlign: "left",
                        wrap: go.TextBlock.WrapFit,
                        editable: true
                    },
                    new go.Binding("text","value").makeTwoWay())
            ),
            makePort("T", go.Spot.Top,    false, true),
            makePort("L", go.Spot.Left,   false, true),
            makePort("B", go.Spot.Bottom, false, true)
        );

    //--------------------------------------------------------------------------
    var pointerTemplate = 
        $go(go.Node, "Auto", nodePtrStyle(),
            $go(go.Panel, "Table",
                {
                    defaultRowSeparatorStroke: "black"
                },
                $go(go.Panel, "Table", 
                    $go(go.RowColumnDefinition,
                        { column: 2, separatorStrokeWidth: 1, separatorStroke: "black" }),
                    $go(go.TextBlock,
                        {
                            row : 0, column : 2,
                            font: "11pt Monospace",
                            stroke: "black",
                            margin: 4,
                            textAlign: "left",
                            wrap: go.TextBlock.WrapFit,
                            editable: true
                        },
                        new go.Binding("text","name").makeTwoWay()
                    ),
                    $go(go.TextBlock,
                        {
                            row : 0, column : 1,
                            font: "11pt Monospace",
                            stroke: "black",
                            margin: 2,
                            textAlign: "left",
                            wrap: go.TextBlock.WrapFit,
                            editable: false,
                            text: '*'
                        }
                    ),
                    $go(go.TextBlock,
                        {
                            row : 0, column : 0,
                            font: "11pt Monospace",
                            stroke: "black",
                            margin: 4,
                            textAlign: "left",
                            wrap: go.TextBlock.WrapFit,
                            editable: true
                        },
                        new go.Binding("text","type").makeTwoWay()
                    )
                ),
                $go(go.Shape, "Circle",
                    {
                        row: 1, margin: 4,
                        fill: "black",
                        stroke: null,
                        desiredSize: new go.Size(10,10),
                        alignment: go.Spot.Center, 
                        portId: "C",
                        //fromSpot: spot, toSpot: spot, 
                        fromLinkable: true, toLinkable: false, 
                        fromMaxLinks  : 1,
                        cursor: "pointer" 
                    }
                )
            ),
            makePort("T", go.Spot.Top,    false, true),
            makePort("L", go.Spot.Left,   false,  true),
            makePort("B", go.Spot.Bottom, false,  true)
        );

    //--------------------------------------------------------------------------
    var nullPtrTemplate =
        $go(go.Node, "Auto", 
            [
            $go(go.Shape, { fill: "white", stroke: "black" }),
            new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
                {
                  locationSpot: go.Spot.Center,
                  mouseEnter: function (e, obj) { showPorts(obj.part, true); },
                  mouseLeave: function (e, obj) { showPorts(obj.part, false); },
                  mouseDrop: function(e, nod) { finishDrop(e, nod.containingGroup); }
                }
            ],
            $go(go.Panel, "Vertical",
                $go(go.Shape, "ThinX", 
                    { 
                        desiredSize:  new go.Size(25,25), 
                        fill: "black", 
                        stroke: null,
                        alignment: go.Spot.Center, 
                        //fromLinkable: false, toLinkable: true, 
                        cursor: "pointer" 
                    }
                ),
                $go(go.TextBlock,
                        {
                            font: "11pt Monospace",
                            stroke: "black",
                            margin: 2,
                            textAlign: "center",
                            alignment: go.Spot.Bottom, 
                            editable: false
                        },
                        new go.Binding("text","value").makeTwoWay()
                )
            ),
            makePort("T", go.Spot.Top,          false,  true),
            makePort("TL", go.Spot.TopLeft,     false,  true),
            makePort("TR", go.Spot.TopRight,    false,  true),
            makePort("L", go.Spot.Left,         false,  true),
            makePort("R", go.Spot.Right,        false,  true),
            makePort("B", go.Spot.Bottom,       false,  true),
            makePort("BL", go.Spot.BottomLeft,  false,  true),
            makePort("BR", go.Spot.BottomRight, false,  true)
        );

    //--------------------------------------------------------------------------
    this.graph.diagram.groupTemplateMap.add("zone",     zoneTemplate);
    this.graph.diagram.groupTemplateMap.add("context", contextTemplate);
    this.graph.diagram.groupTemplateMap.add("struct",   structTemplate);
    this.graph.diagram.groupTemplateMap.add("memory",   memoryTemplate);
    this.graph.diagram.groupTemplateMap.add("array",    arrayTemplate);

    this.graph.diagram.nodeTemplateMap.add("nullPtr", nullPtrTemplate);
    this.graph.diagram.nodeTemplateMap.add("simple",  simpleTemplate);
    this.graph.diagram.nodeTemplateMap.add("pointer", pointerTemplate);



    //--------------------------------------------------------------------------
    // Palette
    var pal0 = $go(go.Palette,this.paletteid + "-0");
    var pal1 = $go(go.Palette,this.paletteid + "-1");
    var pal2 = $go(go.Palette,this.paletteid + "-2");
    var pal3 = $go(go.Palette,this.paletteid + "-3");

    this.graph.palette.push(pal0);
    this.graph.palette.push(pal1);
    this.graph.palette.push(pal2);
    this.graph.palette.push(pal3);

    for (var i = 0; i < this.graph.palette.length; i++) {
        var palette = this.graph.palette[i];
        palette.nodeTemplateMap  = this.graph.diagram.nodeTemplateMap;
        palette.groupTemplateMap = this.graph.diagram.groupTemplateMap;
    }

    this.graph.palette[0].model.nodeDataArray = [    
        { category: "zone" , isGroup: true, name: "Constant" },
        { category: "zone" , isGroup: true, name: "Global" },
        { category: "zone" , isGroup: true, name: "Pile" },
        { category: "zone" , isGroup: true, name: "Tas" }
    ];

    this.graph.palette[1].model.nodeDataArray = [    
        { category: "context" , isGroup: true, name: "main", editable: false },
        { category: "context" , isGroup: true, name: "f" }
    ];

    this.graph.palette[2].model.nodeDataArray = [
        { category: "simple",  type: "type", name: "nom", value: "valeur" },
        { category: "pointer", type: 'type', name: 'nom'},    
        { category: "nullPtr", type: "NULL", name: "NULL", value: "NULL" }
    ];
   
    this.graph.palette[3].model.nodeDataArray = [    
        { category: "struct", isGroup: true, type: 'struct', name: 'nom' },
        { category: "array",  isGroup: true, type: 'type',   name: 'nom'},    
        { category: "memory", isGroup: true                                  }    
    ];

    $(this.$palette).accordion(
        {
            heightStyle: "content",
            activate: function(event, ui) { EniBook[id].refresh(); }
        });

    //--------------------------------------------------------------------------
    // load the diagram from this.$code
    this.load();
}

//-----------------------------------------------------------------------------
Memory.prototype = Object.create(Graph.prototype); // inherits from Graph

//------------------------------------------------------------------------------
Memory.prototype.addErrorMessage = function(errorName) { 
    $(this.$feedback).append("<span>" + errorName + "</span>");

    $(this.$feedback).append('<h4>Description</h4>');
    var errDesc = $('<p></p>');
    $(errDesc).html(this.errorMsg[errorName]); 
    $(this.$feedback).append(errDesc);

    $(this.$feedback).append('<h4>To Fix</h4>');
    var errFix = $('<p></p>');
    $(errFix).html(this.errorMsg[errorName + 'Fix']);
    $(this.$feedback).append(errFix);
}

//------------------------------------------------------------------------------
Memory.prototype.initErrorMsg = function() {
    this.errorMsg.UniqueZoneError = "Il ne peut y avoir qu'une seule zone d'un type donné par programme.";
    this.errorMsg.UniqueZoneErrorFix = "Supprimer les doublons.";
    this.errorMsg.ZoneInGroupError = "Une zone ne peut pas être à l'intérieur d'un autre groupe (zone, contexte, tableau, structure...).";
    this.errorMsg.ZoneInGroupErrorFix = "Déplacer la zone hors de tout autre groupe.";
    this.errorMsg.EmptyZoneError = "Une zone (« Constant », « Global », « Pile » ou « Tas ») ne peut être vide.";
    this.errorMsg.EmptyZoneErrorFix = "Ajouter un objet dans la zone ou supprimer la zone.";
    this.errorMsg.NoStackError = "Un programme doit contenir une zone « Pile ».";
    this.errorMsg.NoStackErrorFix = "Créer une zone « Pile ».";
    this.errorMsg.ObjectInStackError = "Un objet ne peut être créé directement dans la zone « Pile ».";
    this.errorMsg.ObjectInStackErrorFix = "Déplacer l'objet dans un contexte ou dans une autre zone.";
    this.errorMsg.ContextInStackError = "Un contexte ne peut être créé ailleurs que dans la zone « Pile »";
    this.errorMsg.ContextInStackErrorFix = "Déplacer le contexte concerné dans la zone « Pile » ou supprimer le contexte.";
    this.errorMsg.NoMainError = "Un programme doit contenir un contexte « main() ».";
    this.errorMsg.NoMainErrorFix = "Ajouter le contexte « main() » à la zone « Pile ».";
    this.errorMsg.UniqueMainError = "Il ne peut y avoir qu'un seul contexte « main() » par programme.";
    this.errorMsg.UniqueMainErrorFix = "Ne conserver qu'un seul contexte « main() » dans la zone « Pile ».";
    this.errorMsg.ArrayInGroupError = "Un tableau doit être dans un groupe; ce groupe ne peut pas être le groupe « Tas ».";
    this.errorMsg.ArrayInGroupErrorFix = "Déplacer le tableau dans un groupe adéquat.";
    this.errorMsg.EmptyArrayError = "Un tableau ne peut être vide.";
    this.errorMsg.EmptyArrayErrorFix = "Ajouter au moins un objet dans le tableau ou supprimer le tableau.";
    this.errorMsg.MemoryInGroupError = "Un bloc mémoire est soit dans le groupe « Tas », soit à l'extérieur de tout groupe (« hors programme »).";
    this.errorMsg.MemoryInGroupErrorFix = "Déplacer le bloc mémoire dans un lieu adéquat ou supprimer le bloc mémoire.";
    this.errorMsg.EmptyMemoryError = "Un bloc mémoire ne peut être vide.";
    this.errorMsg.EmptyMemoryErrorFix = "Ajouter un objet dans le bloc mémoire ou supprimer le bloc mémoire.";
    this.errorMsg.HomogeneousArrayError = "Les éléments d'un tableau doivent être de même type; par construction, celui du premier élément.";
    this.errorMsg.HomogeneousArrayErrorFix = "Changer le type des éléments en défaut ou supprimer ces éléments du tableau.";
    this.errorMsg.HomogeneousMemoryError = "Les éléments d'un bloc mémoire doivent être de même type; par construction, celui du premier élément.";
    this.errorMsg.HomogeneousMemoryErrorFix = "Changer le type des éléments en défaut ou supprimer ces éléments du bloc mémoire.";
    this.errorMsg.StructInGroupError = "Une structure doit être dans un groupe qui ne peut être le groupe « Tas ».";
    this.errorMsg.StructInGroupErrorFix = "Déplacer la structure dans un groupe adéquat.";
    this.errorMsg.EmptyStructError = "Une structure ne peut être vide.";
    this.errorMsg.EmptyStructErrorFix = "Ajouter au moins un objet dans la structure ou supprimer la structure.";
    this.errorMsg.ObjectInGroupError = "Un objet simple doit être dans un groupe; ce groupe ne peut pas être le groupe « Tas ».";
    this.errorMsg.ObjectInGroupErrorFix = "Déplacer l'objet simple dans un groupe adéquat.";
    this.errorMsg.PointerInGroupError = "Un pointeur doit être dans un groupe; ce groupe ne peut pas être le groupe « Tas ».";
    this.errorMsg.PointerInGroupErrorFix = "Déplacer le pointeur dans un groupe adéquat.";
    this.errorMsg.EmptyPointerError = "Un pointeur doit pointer sur un objet ou sur le pointeur NULL.";
    this.errorMsg.EmptyPointerErrorFix = "Créer un lien entre le pointeur et un objet adéquat.";
    this.errorMsg.PointerTypeError = "Un pointeur doit pointer sur un objet de type compatible ou sur le pointeur NULL.";
    this.errorMsg.PointerTypeErrorFix = "Vérifier l'adéquation entre le type du pointeur et le type de l'objet pointé.";    
    this.errorMsg.NameError = "Des variables d'un même contexte ou d'une même zone mémoire ne peuvent avoir le même nom.";
    this.errorMsg.NameErrorFix = "Distinguer les variables d'un même contexte ou d'une même zone mémoire par des noms différents.";    
    this.errorMsg.EmptyContextError = "Un contexte (« main() », « f() »...) ne peut être vide.";
    this.errorMsg.EmptyContextErrorFix = "Ajouter un objet dans le contexte ou supprimer le contexte.";
}

//------------------------------------------------------------------------------
Memory.prototype.feedback = function() { 
    $(this.$feedback).html("");
    $(this.$feedback).css('display','none');
    $(this.$feedback).removeClass('feedback-false');
    $(this.$feedback).removeClass('feedback-true');
    $(this.$feedback).addClass('feedback');
    $(this.$feedback).css('display','block');

    this.tries += 1;
    var res = "Essai " + this.tries.toString();

    switch (EniBook['mode']) {
        case 'assessing' :
            var date    = new Date();
            var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
            var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes()); 
            res += " mémorisé à " + hour + "h" + minutes + "."; 
            this.save();
            EniBook['assessing'][this.directive][this.id].user = $(this.$code).val();
            break;
        default :
            res += "<br />";
            break;
    }
    $(this.$feedback).append(res);

    if (Enibook['mode'] !== 'assessing') {
        var txtModel = $(this.$fileref).val();
        var refModel = JSON.parse(txtModel);
        var useModel = this.graph.diagram.model;       
        var refAugmentedModel = this.augmentedModel(refModel);
        var useAugmentedModel = this.augmentedModel(useModel);

        // analyse de la cohérence interne
        var error = this.modelAnalysis(useAugmentedModel);
        $(this.$feedback).css('display','block');
        $(this.$feedback).append("<span style='font-weight: bold;'>" + "Cohérence interne : " + "</span>");

        if (error.type !== "NoError") {
            $(this.$feedback).addClass('feedback-false');
            this.addErrorMessage(error.type);
            var nodes = [];
            for (var i = 0; i < error.keys.length; i++) {
                nodes.push(this.graph.diagram.findNodeForKey(error.keys[i]));
            }
            this.graph.diagram.selectCollection(nodes); 
            this.graph.diagram.focus();
        }
        else {
            var refTrees = this.treeModel(refAugmentedModel);
            var useTrees = this.treeModel(useAugmentedModel);

            // print memory
            var refMemory = this.printMemory(refTrees);
            var useMemory = this.printMemory(useTrees);

            $(this.$feedback).append("<span>" + "ok" + "</span><br/>");
            //$(this.$feedback).append("<p>" + refMemory + "</p>");
            $(this.$feedback).append("<p>" + useMemory + "</p>");

            $(this.$feedback).append("<span style='font-weight: bold;'>" + "Conformité avec le programme C : " + "</span>");
            // trees comparison
            error = this.treesComparison(useTrees,refTrees); 
            if (error.msg !== "NoError") {
                $(this.$feedback).addClass('feedback-false');
                $(this.$feedback).append("<br/><span>" + error.msg + "</span>");
                var nodes = [];
                for (var i = 0; i < error.keys.length; i++) {
                    nodes.push(this.graph.diagram.findNodeForKey(error.keys[i]));
                }
                this.graph.diagram.selectCollection(nodes); 
                this.graph.diagram.focus();
            }
            else {
                error = this.verifTrees(useTrees);
                if (error.msg !== "NoError") {
                    $(this.$feedback).addClass('feedback-false');
                    $(this.$feedback).append(error.msg);
                    this.graph.diagram.selectCollection(error.keys);
                    this.graph.diagram.focus();
                }
                else {
                    $(this.$feedback).addClass('feedback-true');
                    $(this.$feedback).append("<span>" + "C'est la réponse attendue. Bravo." + "</span><br/>");
                }
            }
        }
    }
}

//------------------------------------------------------------------------------
Memory.prototype.treeModel = function(augmentedModel) {
    var trees = [];
    var zones = augmentedModel.zones; 
    for (var i = 0; i < zones.length; i++) {
        var augmentedNode = zones[i]; 
        var newTree = this.treeNode(augmentedModel,augmentedNode);
        trees.push(newTree);
    }
    return trees;
}

//------------------------------------------------------------------------------
Memory.prototype.treeNode = function(augmentedModel,augmentedNode) { 
    var node = augmentedNode.node; 
    var data = augmentedNode.data;
    var tree = {root: {key: node.key, category: node.category, type: node.type, name: node.name, value: data.value, verif: false}, trees: []};    

    
    if (node.isGroup === true) { 
        for (var i = 0; i < data.children.length; i++) { 
            var childNode = data.children[i];
            var newTree = this.treeNode(augmentedModel,childNode);
            tree.trees.push(newTree);
        }
    }
    
    return tree;
}

//------------------------------------------------------------------------------
Memory.prototype.verifTrees = function(trees) {
    var error = {msg: "NoError", keys: []};
    for (var i = 0; i < trees.length; i++) {
        var tree = trees[i];
        var root = tree.root;
        var children = tree.trees;
        if (root.verif) {
            error = this.verifTrees(children);
            if (error.msg !== "NoError") { return error; }
        }
        else {
            error = {msg: "«" + root.category + " " + root.name + "» est en surnombre.", keys: [root.key]};
            return error;
        }
    }
    return error;
}

//------------------------------------------------------------------------------
Memory.prototype.printMemory = function(trees) {
    var str = "<table style='border: 1px solid;'><tbody><tr>";
    for (var i = 0; i < trees.length; i++) {
        var tree = trees[i]; 
        str += "<td width='" + Math.floor(100.0/trees.length).toString() + "%'>" +
            this.printTreeMemory(tree,0) + "</td>";
    }
    str += "</tbody></tr></table>";
    return str;        
}

//------------------------------------------------------------------------------
Memory.prototype.printTreeMemory = function(tree,indent) {
    var root     = tree.root; 
    var subtrees = tree.trees;
    var str = "";

    var prompt1 = "";
    var prompt2 = "&nbsp;&nbsp;&nbsp;|";
    var prompt3 = "-&nbsp;";
    var branch = "";

    if (indent > 0) {
        branch = prompt1;
        for (var i = 0; i < indent; i++) { branch += prompt2; }
        branch += prompt3;
        str += branch;
    }

    switch (root.category) { 
        case "zone"   : str += root.name; break;
        case "context": str += root.name + " () "; break;
        case "struct" : str += root.type + " {} " + root.name; break;
        case "array"  : str += root.type + " [] " + root.name; break;
        case "memory" : str += "[] "; break;
        case "pointer": str += root.type + " * " + root.name + " -> " + root.value.name; break;
        case "nullPtr": str += root.name; break;
        default       : str += root.type + " " + root.name + " = " + root.value; break;
    }
    str += "<br/>"; 

    for (var i = 0; i < subtrees.length; i++) {
        var subtree = subtrees[i];
        str += this.printTreeMemory(subtree,indent+1);
    }

    return str;        
}

/*
//------------------------------------------------------------------------------
Memory.prototype.printTreeModel = function(augmentedModel) {
    var trees = "";
    trees = "<table style='border: 1px solid;'><tbody><tr>";
    var zones = augmentedModel.zones; 
    for (var i = 0; i < zones.length; i++) {
        var augmentedNode = zones[i]; 
        trees += "<td width='" + Math.floor(100.0/zones.length).toString() + "%'>" + this.printTreeNode(augmentedModel,augmentedNode,0) + "</td>"; 
    }
    trees += "</tbody></tr></table>";
    return trees;
}

//------------------------------------------------------------------------------
Memory.prototype.printTreeNode = function(augmentedModel,augmentedNode,indent) { 
    var prompt1 = "";
    var prompt2 = "&nbsp;&nbsp;&nbsp;|";
    var prompt3 = "-&nbsp;";
    var branch = "";
    var tree = "";

    if (indent > 0) {
        branch = prompt1;
        for (var i = 0; i < indent; i++) { branch += prompt2; }
        branch += prompt3;
        tree += branch;
    }

    var node = augmentedNode.node; 
    var data = augmentedNode.data;
    switch (node.category) { 
        case "zone"   : tree += node.name; break;
        case "context": tree += node.name + " () "; break;
        case "struct" : tree += node.type + " {} " + node.name; break;
        case "array"  : tree += node.type + " [] " + node.name; break;
        case "memory" : tree += "[] "; break;
        case "pointer": tree += node.type + " * " + node.name + " -> " + data.value.name; break;
        case "nullPtr": tree += node.name; break;
        default       : tree += node.type + " " + node.name + " = " + node.value; break;
    }
    tree += "<br/>"; 

    if (node.isGroup === true) { 
        for (var i = 0; i < data.children.length; i++) { 
            var childNode = data.children[i];
            tree += this.printTreeNode(augmentedModel,childNode,indent+1);
        }
    }
    return tree;
}
*/

//------------------------------------------------------------------------------
Memory.prototype.treesComparison = function(useTrees,refTrees) {
    var error = {msg: "NoError", keys: []} ;
    for (var i = 0; i < refTrees.length; i++) {
        var refTree = refTrees[i]; 
        if (i >= useTrees.length) { return {msg: "«" + refTree.root.name + "» attendu et non trouvé.", keys: []}; }
        var useTree = useTrees[i]; 
        error = this.rootComparison(useTree.root,refTree.root);
        if (error.msg === "NoError") {
            useTree.root.verif = true;
            refTree.root.verif = true; 
            error = this.treesComparison(useTree.trees,refTree.trees);
            if (error.msg !== "NoError") { return error; }
        }
        else { return error; }
    }
    return error;
}

//------------------------------------------------------------------------------
Memory.prototype.rootComparison = function(useRoot,refRoot) {
    var msg = "NoError"; 
    var keys = [];

    if (useRoot.category !== refRoot.category) { 
        msg = " «" + refRoot.category + " " + refRoot.name + "» attendu : «" + useRoot.category + " " + useRoot.name + "» trouvé.";
        keys = [useRoot.key]; 
        return {msg: msg, keys: keys};
    }
    if (useRoot.name !== refRoot.name) { 
        switch (useRoot.category) {
            case "simple" : 
                msg = " «" + refRoot.type + " " + refRoot.name + "» attendu : «" + useRoot.type + " " + useRoot.name + "» trouvé.";
                keys = [useRoot.key];
                return {msg: msg, keys: keys};
                break;
            case "pointer":
                msg = " «" + refRoot.type + " * " + refRoot.name + "» attendu : «" + useRoot.type + " * " + useRoot.name + "» trouvé.";
                keys = [useRoot.key];
                return {msg: msg, keys: keys};
                break;
            case "ptrNull":
                msg = " «" + refRoot.name + "» attendu : «" + useRoot.name + "» trouvé.";
                keys = [useRoot.key];
                return {msg: msg, keys: keys};
                break;
            case "array"  :
                msg = " «" + refRoot.type + " [] " + refRoot.name + "» attendu : «" + useRoot.type + " [] " + useRoot.name + "» trouvé.";
                keys = [useRoot.key];
                return {msg: msg, keys: keys};
                break;
            case "memory" :
                msg = " «" + refRoot.type + " [] " + "» attendu : «" + useRoot.type + " [] " + "» trouvé.";
                keys = [useRoot.key];
                return {msg: msg, keys: keys};
                break;
            case "struct" :
                msg = " «" + refRoot.type + " {} " + refRoot.name + "» attendu : «" + useRoot.type + " {} " + useRoot.name + "» trouvé.";
                keys = [useRoot.key];
                return {msg: msg, keys: keys};
                break;  
            default :
                msg = " «" + refRoot.category + " " + refRoot.name + "» attendu : «" + useRoot.category + " " + useRoot.name + "» trouvé.";
                keys = [useRoot.key];
                return {msg: msg, keys: keys};
                break;              
        }
    }
    if (useRoot.type !== refRoot.type) { 
        switch (useRoot.category) {
            case "pointer":
                msg = " «" + refRoot.type + " * " + refRoot.name + "» attendu : «" + useRoot.type + " * " + useRoot.name + "» trouvé.";
                keys = [useRoot.key];
                return {msg: msg, keys: keys};
                break;
            case "array"  :
                msg = " «" + refRoot.type + " [] " + refRoot.name + "» attendu : «" + useRoot.type + " [] " + useRoot.name + "» trouvé.";
                keys = [useRoot.key];
                return {msg: msg, keys: keys};
                break;
            case "memory" :
                msg = " «" + refRoot.type + " [] " + "» attendu : «" + useRoot.type + " [] " + "» trouvé.";
                keys = [useRoot.key];
                return {msg: msg, keys: keys};
                break;
            case "struct" :
                msg = " «" + refRoot.type + " {} " + refRoot.name + "» attendu : «" + useRoot.type + " {} " + useRoot.name + "» trouvé.";
                keys = [useRoot.key];
                return {msg: msg, keys: keys};
                break;  
            default :
                msg = " «" + refRoot.type + " " + refRoot.name + "» attendu : «" + useRoot.type + " " + useRoot.name + "» trouvé."; 
                keys = [useRoot.key];
                return {msg: msg, keys: keys};
        }
    }
    switch (useRoot.category) {
        case "pointer" :
            if (useRoot.value.name !== refRoot.value.name) { 
                msg = " «" + refRoot.type + " * " + refRoot.name + " -> " + refRoot.value.name + "» attendu : «" +
                             useRoot.type + " * " + useRoot.name + " -> " + useRoot.value.name + "» trouvé.";
                keys = [useRoot.key]; 
            }
            break;
        default:
            if (useRoot.value !== refRoot.value) { 
                msg = " «" + refRoot.type + " " + refRoot.name + " = " + refRoot.value + "» attendu : «" +
                             useRoot.type + " " + useRoot.name + " = " + useRoot.value + "» trouvé.";
                keys = [useRoot.key]; 
            }
    }
    if (useRoot.verif !== refRoot.verif) { 
        return {msg: " «" + refRoot.verif + "» attendu : «" + useRoot.verif + "» trouvé.", keys: [useRoot.key]}; 
    }
    return {msg: msg, keys: keys};
}

/*
//------------------------------------------------------------------------------
Memory.prototype.modelsComparison = function(useParent,useAugmentedNodes,refAugmentedNodes) {

    for(var i = 0; i < refAugmentedNodes.length; i++) {
        var refAugmentedNode = refAugmentedNodes[i];
        var refNode = refAugmentedNode.node;
        var nameRefNode = refNode.name;
        var keyFound = this.findNodeForName(useAugmentedNodes,nameRefNode); 
        if (keyFound === -1) { return useParent.name !== "" ? 
            { msg: " «" + refNode.type + " " + refNode.name + "» attendu(e) dans «" + useParent.name + "».", keys: [useParent.key] } :
            { msg: " «" + refNode.type + " " + refNode.name + "» attendu(e) dans «" + useParent.type + " []».", keys: [useParent.key] };
        }
        var useAugmentedNode = useAugmentedNodes[keyFound];
        var useNode = useAugmentedNode.node;
        var useData = useAugmentedNode.data;
        var error = this.simpleNodesComparaison(useAugmentedNode,refAugmentedNode); 
        if (error.msg === "NoError") { 
            if (refNode.isGroup) { 
                error = this.modelsComparison(useNode,useAugmentedNode.data.children,refAugmentedNode.data.children); 
                if (error.msg !== "NoError") { return error; }
            }
        }
        else { return error; }  
    }
    return {msg: "NoError", keys: []};
}

//------------------------------------------------------------------------------
Memory.prototype.simpleNodesComparaison = function(useAugmentedNode,refAugmentedNode) {
    var refNode = refAugmentedNode.node;
    var refData = refAugmentedNode.data;
    var useNode = useAugmentedNode.node;
    var useData = useAugmentedNode.data;
    if (useNode.type != refNode.type) { return {msg: useNode.type + " " + useNode.name + " : type «" + useNode.type + "» erroné.", keys: [useNode.key] } ; }
    if (useNode.category === "simple" || useNode.category === "nullPtr") { 
        if (useData.value != refData.value) { return {msg: useNode.type + " " + useNode.name + " = " + useData.value + " : valeur «" + useData.value + "» erronée.", keys: [useNode.key] } ; }
    }
    else {
        if (useNode.category === "pointer") { 
            var useToName = useData.value.name; 
            var refToName = refData.value.name; 
            if (useToName != refToName) {
                return {msg: useNode.type + " * " + useNode.name + " -> " + useToName + " : destination incorrecte", keys: [useNode.key]};
            }
        }
    }
    useAugmentedNode.data.verif = true;
    refAugmentedNode.data.verif = true;
    return { msg: "NoError", keys: [] };
}
*/

//------------------------------------------------------------------------------
Memory.prototype.findNodeForName = function(augmentedNodes,name) {
    for (var i = 0; i < augmentedNodes.length; i++) {
        if (augmentedNodes[i].node.name === name) { return i; }
    }
    return -1;
}

//------------------------------------------------------------------------------
Memory.prototype.modelAnalysis = function(model) {
    //--- zone analysis
    var zones = model.zones;
    var typesZone = {constant: [], global: [], pile: [], tas : []};
    var groupZone = [];
    var emptyZone = [];
    for (var i = 0; i < zones.length; i++) {
        var zoneNode = zones[i].node; 
        var zoneData = zones[i].data;
        if (zoneNode.group) { groupZone.push(zoneNode.key) }; 
        if (zoneData.children.length === 0) { emptyZone.push(zoneNode.key); }
        switch (zoneNode.name) {
            case "Constant" : typesZone.constant.push(zoneNode.key); break;
            case "Global"   : typesZone.global.push(zoneNode.key); break;
            case "Pile"     : typesZone.pile.push(zoneNode.key); break;
            case "Tas"      : typesZone.tas.push(zoneNode.key); break;
            default         : break;  
        }        
    }
    // UniqueZoneError
    for (category in typesZone) {
        if (typesZone[category].length > 1) { return {type: "UniqueZoneError", keys: typesZone[category]}; }
    }

    // ZoneInGroupError
    if (groupZone.length > 0) { return {type: "ZoneInGroupError", keys: groupZone}; }
        
    // EmptyZoneError
    if (emptyZone.length > 0) { return {type: "EmptyZoneError", keys: emptyZone}; }

    // NoStackError
    if (typesZone.pile.length == 0) { return {type: "NoStackError", keys: []}; }

    // ObjectInStackError
    var pile = null;
    for (var i = 0; i < zones.length; i++) {
        var zoneNode = zones[i].node;
        var zoneData = zones[i].data;
        if (zoneNode.name === "Pile") { pile = zoneNode; break; }
    }
    var objectsPile = [];
    for (var i = 0; i < zoneData.children.length; i++) {
        var childNode = zoneData.children[i].node; 
        if (childNode.category !== "context") { objectsPile.push(childNode.key); }
    }
    if (objectsPile.length !== 0) { return {type: "ObjectInStackError", keys: objectsPile}; }

    //--- context analysis
    var contexts = model.contexts;
    var typesContext   = {}
    var noGroupContext = [];
    var groupStack     = [];
    var emptyContext   = [];
    for (var i = 0; i < contexts.length; i++) {
        var contextNode = contexts[i].node; 
        var contextData = contexts[i].data; 
        if (contextData.children.length === 0) { emptyContext.push(contextNode.key); }
        if (typesContext[contextNode.name] == undefined) { typesContext[contextNode.name] = [contextNode.key]; }
        else { typesContext[contextNode.name].push(contextNode.key); }
        if (contextNode.group == undefined || contextNode.group !== typesZone.pile[0]) { groupStack.push(contextNode.key); }
    }

    // EmptyContextError
    if (emptyContext.length > 0) { return {type: "EmptyContextError", keys: emptyContext}; }

    // ContextInStackError
    if (groupStack.length > 0) { return {type: "ContextInStackError", keys: groupStack}; }

    // NoMainError
    if (typesContext["main"] == undefined) { return {type: "NoMainError", keys:[]}; }
    else {
        // UniqueMainError
        if (typesContext["main"].length > 1) { return {type: "UniqueMainError", keys: typesContext["main"]}; }
    }
    
    //--- array analysis  
    var arrays = model.arrays;
    var objectsArray      = [];
    var groupArray        = [];
    var typeChildrenArray = [];
    for (var i = 0; i < arrays.length; i++) {
        var arrayNode = arrays[i].node;
        var arrayData = arrays[i].data;
        var type = arrayNode.type;
        if (arrayData.children.length === 0) { objectsArray.push(arrayNode.key); }
        if (arrayNode.group == undefined) { groupArray.push(arrayNode.key); }
        else { if (typesZone.tas && typesZone.tas[0] === arrayNode.group) { groupArray.push(arrayNode.key); } }
        for (var j = 0; j < arrayData.children.length; j++) {
            var childArrayNode = arrayData.children[j].node; 
            if (childArrayNode.category === "pointer") { if (childArrayNode.type + "*" !== type) { typeChildrenArray.push(childArrayNode.key); } }
            else { if (childArrayNode.type !== type) { typeChildrenArray.push(childArrayNode.key); } }
        }
    }

    // ArrayInGroupError
    if (groupArray.length > 0) { return {type: "ArrayInGroupError", keys: groupArray}; }

    // EmptyArrayError
    if (objectsArray.length > 0) { return {type: "EmptyArrayError", keys: objectsArray}; }

    // HomogeneousArrayError
    if (typeChildrenArray.length > 0) { return {type: "HomogeneousArrayError", keys: typeChildrenArray}; }

    //--- memory analysis  
    var memories = model.memories;
    var objectsMemory      = [];
    var groupsMemory       = [];
    var typeChildrenMemory = [];
    for (var i = 0; i < memories.length; i++) {
        var memoryNode = memories[i].node;
        var memoryData = memories[i].data;
        if (memoryNode.group !== undefined) { 
            if ((typesZone.tas && typesZone.tas[0] !== memoryNode.group) && 
                (typesZone.constant && typesZone.constant[0] !== memoryNode.group)) { groupsMemory.push(memoryNode.key); }
        }
        if (memoryData.children.length === 0) { objectsMemory.push(memoryNode.key); }
        for (var j = 0; j < memoryData.children.length; j++) {
            var firstChildNode = memoryData.children[0].node;
            var childNode = memoryData.children[j].node; 
            if (childNode.type !== firstChildNode.type) { typeChildrenMemory.push(childNode.key); }   
        }
    }

    // MemoryInGroupError
    if (groupsMemory.length > 0) { return {type: "MemoryInGroupError", keys: groupsMemory}; }

    // EmptyMemoryError
    if (objectsMemory.length > 0) { return {type: "EmptyMemoryError", keys: objectsMemory}; }

    // HomogeneousMemoryError
    if (typeChildrenMemory.length > 0) { return {type: "HomogeneousMemoryError", keys: typeChildrenMemory}; }

    //--- struct analysis
    var structs = model.structs;
    var objectsStruct = [];
    var groupStruct   = [];
    for (var i = 0; i < structs.length; i++) {
        var structNode = structs[i].node;
        var structData = structs[i].data;
        if (structData.children.length === 0) { objectsStruct.push(structNode.key); }
        if (structNode.group == undefined) { groupStruct.push(structNode.key); }
        else { if (typesZone.tas && typesZone.tas[0] === structNode.group) { groupStruct.push(structNode.key); } }
    }

    // StructInGroupError
    if (groupStruct.length > 0) { return {type: "StructInGroupError", keys: groupStruct}; }

    // EmptyStructError
    if (objectsStruct.length > 0) { return {type: "EmptyStructError", keys: objectsStruct}; }

    //--- simple object analysis
    var simples = model.simples;
    var groupSimple = [];

    for (var i = 0; i < simples.length; i++) {
        var simpleNode = simples[i].node;
        if (simpleNode.group == undefined) { groupSimple.push(simpleNode.key); }
        else { if (typesZone.tas && typesZone.tas[0] === simpleNode.group) { groupSimple.push(simpleNode.key); } }
    }

    // ObjectInGroupError
    if (groupSimple.length > 0) { return {type: "ObjectInGroupError", keys: groupSimple}; }
    
    //--- pointer analysis
    var pointers = model.pointers;
    var groupPointer = [];
    var nullPointer  = [];
    var typePointer  = [];

    for (var i = 0; i < pointers.length; i++) {
        var pointerNode = pointers[i].node;
        var pointerData = pointers[i].data;
        if (pointerNode.group == undefined) { groupPointer.push(pointerNode.key); }
        else { if (typesZone.tas && typesZone.tas[0] === pointerNode.group) { groupPointer.push(pointerNode.key); } }
        if (pointerData.value == null) { nullPointer.push(pointerNode.key); }
        else { if ((pointerData.value.type !== pointerNode.type) && (pointerData.value.type !== "NULL")) { typePointer.push(pointerNode.key); } }
    }

    // PointerInGroupError
    if (groupPointer.length > 0) { return {type: "PointerInGroupError", keys: groupPointer}; }
    
    // PointerNullError
    if (nullPointer.length > 0) { return {type: "EmptyPointerError", keys: nullPointer}; }

    // PointerTypeError
    if (typePointer.length > 0) { return {type: "PointerTypeError", keys: typePointer}; }

    // NameError
    var nameObjects = [];
    for (var i = 0; i < model.model.nodeDataArray.length; i++) {
        node1 = model.model.nodeDataArray[i];
        if (node1.name && node1.group) {
            for (var j = 0; j < model.model.nodeDataArray.length; j++) {
                var node2 = model.model.nodeDataArray[j];
                if (node1.key !== node2.key && node1.name === node2.name && node1.group === node2.group) { 
                    nameObjects.push(node2.key); 
                }
            }
        }
    }

    if (nameObjects.length > 0) { return {type: "NameError", keys: nameObjects}; } 

    //--- NoError
    return {type: "NoError", keys: []};
}


//------------------------------------------------------------------------------
Memory.prototype.augmentedModel = function(model) {
    var theAugmentedModel = {};
    theAugmentedModel.model    = model;
    theAugmentedModel.zones    = this.findNodesForCategory(model,"zone").sort(this.sortZones);
    theAugmentedModel.contexts = this.findNodesForCategory(model,"context").sort(this.sortContexts);
    theAugmentedModel.arrays   = this.findNodesForCategory(model,"array").sort(this.sortByName);
    theAugmentedModel.memories = this.findNodesForCategory(model,"memory");
    theAugmentedModel.structs  = this.findNodesForCategory(model,"struct").sort(this.sortByName);
    theAugmentedModel.simples  = this.findNodesForCategory(model,"simple").sort(this.sortByName);
    theAugmentedModel.pointers = this.findNodesForCategory(model,"pointer").sort(this.sortByName);
    theAugmentedModel.nullPtrs = this.findNodesForCategory(model,"nullPtr");
    theAugmentedModel.nodes    = this.findNodesForModel(model);
    return theAugmentedModel;
}

//------------------------------------------------------------------------------
Memory.prototype.sortByName = function(node1,node2) {
    return node1.node.name < node2.node.name ? -1 : 1;
}
//------------------------------------------------------------------------------
Memory.prototype.sortZones = function(node1,node2) {
    var name1 = node1.node.name === "Pile" ? "!!!Pile" : node1.node.name;
    var name2 = node2.node.name === "Pile" ? "!!!Pile" : node2.node.name; 
    return name1 < name2 ? -1 : 1;
}

//------------------------------------------------------------------------------
Memory.prototype.sortContexts = function(node1,node2) {
    var name1 = node1.node.name === "main" ? "!!!main" : node1.node.name;
    var name2 = node2.node.name === "main" ? "!!!main" : node2.node.name;
    return name1 < name2 ? -1 : 1;
}

//------------------------------------------------------------------------------
Memory.prototype.findToNodeFromPointer = function(model,key) {
    var value = null;
    for (var i = 0; i < model.linkDataArray.length; i++) {
        var link = model.linkDataArray[i];
        if (link.from === key) { 
            for (var j = 0; j < model.nodeDataArray.length; j++) {
                var node = model.nodeDataArray[j]; 
                if (node.key === link.to) { value = {to: link.to, type: node.type, name: node.name }; break; }
            }
        }
    }
    return value;
}


//------------------------------------------------------------------------------
Memory.prototype.findNodeForKey = function(model,key) {
    var theNode = null;
    for (var i = 0; i < model.nodeDataArray.length; i++) {
        var node = model.nodeDataArray[i];
        if (node.key === key) { theNode = node; break; }
    }
    return theNode;
}


//------------------------------------------------------------------------------
Memory.prototype.findComponentsForKey = function(model,key) {
    var componentsArray = [];
    for (var i = 0; i < model.nodeDataArray.length; i++) {
        var node = model.nodeDataArray[i];
        if (node.group === key) { 
            var data = {};
            data.index = i;
            data.verif = false
            data.parent = node.group ? this.findNodeForKey(model,node.group) : null;
            data.children = this.findComponentsForKey(model,model.nodeDataArray[i].key);
            if (node.category === "pointer") { data.value = this.findToNodeFromPointer(model,node.key); } 
            else { data.value = node.value; }
            componentsArray.push({node: node, data: data}); 
        }
    }
    return componentsArray.sort(this.sortByName);
}


//------------------------------------------------------------------------------
Memory.prototype.findNodesForCategory = function(model,category) {
    var nodesArray = [];
    for (var i = 0; i < model.nodeDataArray.length; i++) {
        var node = model.nodeDataArray[i]; 
        if (node.category === category) { 
            var data = {};
            data.index = i;
            data.verif = false
            data.parent = node.group ? this.findNodeForKey(model,node.group) : null;
            if (category === "zone") { data.children = this.findComponentsForKey(model,model.nodeDataArray[i].key).sort(this.sortContexts); }
            else { data.children = this.findComponentsForKey(model,model.nodeDataArray[i].key); }
            if (category === "pointer") { data.value = this.findToNodeFromPointer(model,node.key); } 
            else { data.value = node.value; }
            nodesArray.push({node: node, data: data});
        }
    }
    return nodesArray;
}

//------------------------------------------------------------------------------
Memory.prototype.findNodesForModel = function(model) {
    var nodes = [];
    for (var i = 0; i < model.nodeDataArray.length; i++) {
        var node = model.nodeDataArray[i]; 
        var data = {};
        data.index = i;
        data.verif = false
        data.parent = node.group ? this.findNodeForKey(model,node.group) : null;
        data.children = this.findComponentsForKey(model,model.nodeDataArray[i].key);
        if (node.category === "pointer") { data.value = this.findToNodeFromPointer(model,node.key); } 
        else { data.value = node.value; }
        nodes.push({node: node, data: data});
    } 
    return nodes;  
}

//alert('FlowChart');
/******************************************************************************
 *
 * FlowChart
 *
 ******************************************************************************/
//------------------------------------------------------------------------------
function FlowChart(id) { // id : HTML identifier 
    Graph.call(this,id); // inherits from Graph

    var $go = go.GraphObject.make;

    theDiagram = this.graph.diagram;

    this.graph.diagram.linkTemplate =
        $go(go.Link,
            {
                routing: go.Link.AvoidsNodes,
                curve: go.Link.JumpOver,
                corner: 5, toShortLength: 4,
                relinkableFrom: true,
                relinkableTo: true,
                reshapable: true,
                resegmentable: true,
                mouseEnter: function(e, link) { link.findObject("HIGHLIGHT").stroke = "rgba(30,144,255,0.2)"; },
                mouseLeave: function(e, link) { link.findObject("HIGHLIGHT").stroke = "transparent"; }
            },
            new go.Binding("points").makeTwoWay(),
            $go(go.Shape,
                { isPanelMain: true, strokeWidth: 8, stroke: "transparent", name: "HIGHLIGHT" }),
            $go(go.Shape,
                { isPanelMain: true, stroke: "gray", strokeWidth: 2 }),
            $go(go.Shape,
                { toArrow: "standard", stroke: null, fill: "gray"}),
            $go(go.Panel, "Auto",  
                { visible: false, name: "LINKLABEL", segmentIndex: 2, segmentFraction: 0.5},
                new go.Binding("visible", "visible").makeTwoWay(),
                $go(go.Shape, "RoundedRectangle", 
                    { fill: "#F8F8F8", stroke: null }),
                $go(go.TextBlock, "True/False",
                    {
                        textAlign: "center",
                        font: "bold 11pt Monospace",
                        stroke: "black",
                        editable: true
                    },
                    new go.Binding("text", "text").makeTwoWay()
                )
            )
        );

    // Make link labels visible if coming out of a "conditional" node.
    // This listener is called by the "LinkDrawn" and "LinkRelinked" DiagramEvents.
    function showLinkLabel(e) {
        var label = e.subject.findObject("LINKLABEL");
        if (label !== null) { label.visible = (e.subject.fromNode.data.figure === "Diamond"); }
    }

    this.graph.diagram.linkTemplateMap.add("comment",
      // if the BalloonLink class has been loaded from the Extensions directory, use it
      $go((typeof BalloonLink === "function" ? BalloonLink : go.Link),
        $go(go.Shape,  // the Shape.geometry will be computed to surround the comment node and
                     // point all the way to the commented node
          { stroke: "brown", strokeWidth: 1, fill: "lightyellow" })
      ));


    function nodeStyle() { 
      return [
        new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
        {
          resizable: true, resizeObjectName: "SHAPE",
          locationSpot: go.Spot.Center,
          mouseEnter: function (e, obj) { showPorts(obj.part, true); },
          mouseLeave: function (e, obj) { showPorts(obj.part, false); },
          mouseDrop: function(e, nod) { finishDrop(e, nod.containingGroup); }
        }
      ];
    }

    function makePort(name, spot, output, input) { 
        var shape = 
            $go(go.Shape, "Circle",
                {
                    fill: "transparent",
                    stroke: null,
                    desiredSize: new go.Size(8, 8),
                    alignment: spot, alignmentFocus: spot, 
                    portId: name,
                    fromSpot: spot, toSpot: spot, 
                    fromLinkable: output, toLinkable: input, 
                    cursor: "pointer" 
                });
        return shape;
    }

    
    function showPorts(node, show) {
        var diagram = node.diagram;
        if (!diagram || diagram.isReadOnly || !diagram.allowLink) return;
        node.ports.each(function(port) { port.stroke = (show ? "white" : null); });
    }


    var beginTemplate = 
        $go(go.Node, "Spot", nodeStyle(),
            $go(go.Panel, "Auto",
                $go(go.Shape, "Circle", { desiredSize:  new go.Size(25, 25), fill: "black", stroke: null })
            ),
            makePort("L", go.Spot.Left,   true, false),
            makePort("R", go.Spot.Right,  true, false),
            makePort("B", go.Spot.Bottom, true, false)
        );

    var hubTemplate =
        $go(go.Node, "Spot", nodeStyle(),
            $go(go.Panel, "Auto",
                $go(go.Shape, "Circle", { desiredSize:  new go.Size(20,20), fill: "gray", stroke: null })
            ),
            makePort("L", go.Spot.Left,   false, true),
            makePort("R", go.Spot.Right,  true,  false),
            makePort("B", go.Spot.Bottom, false, true),
            makePort("T", go.Spot.Top, false, true)
        );


    var endTemplate =
        $go(go.Node, "Spot", nodeStyle(), 
            $go(go.Panel, "Auto",
                $go(go.Shape, "Circle",
                    { 
                        fill       : "white", 
                        stroke     : "black",
                        desiredSize: new go.Size(25,25) 
                    }), 
                $go(go.Shape, "Circle", 
                    { 
                        fill       : "black", 
                        stroke     : null,
                        desiredSize: new go.Size(15,15) 
                    })
                ), 
                makePort("T", go.Spot.Top,   false, true),
                makePort("L", go.Spot.Left,  false, true),
                makePort("R", go.Spot.Right, false, true)
           );

    var commentTemplate =
        $go(go.Node, "Auto", nodeStyle(),
            $go(go.Shape, "Card", { fill: "lightyellow", stroke: null }),
            $go(go.TextBlock,
                {
                    margin: 5,
                    //maxSize: new go.Size(200, NaN),
                    wrap: go.TextBlock.WrapFit,
                    textAlign: "left",
                    editable: true,
                    font: "12pt Helvetica, Arial, sans-serif",
                    stroke: 'brown'
                },
                new go.Binding("text").makeTwoWay()),
                makePort("T", go.Spot.Top,    false, true),
                makePort("L", go.Spot.Left,   true,  true),
                makePort("R", go.Spot.Right,  true,  true),
                makePort("B", go.Spot.Bottom, true,  false)
        );

    var instructionTemplate = 
        $go(go.Node, "Spot", nodeStyle(),
            $go(go.Panel, "Auto",
                $go(go.Shape, "RoundedRectangle", { name: "SHAPE", fill: "white", stroke: "black" }, new go.Binding("figure", "figure")),
                $go(go.TextBlock,
                    {
                        font: "11pt Monospace",
                        stroke: "black",
                        margin: 8,
                        textAlign: "left",
                        wrap: go.TextBlock.WrapFit,
                        editable: true
                    },
                    new go.Binding("text","text").makeTwoWay())
            ),
            makePort("T", go.Spot.Top,    false, true),
            makePort("L", go.Spot.Left,   true,  true),
            makePort("R", go.Spot.Right,  true,  true),
            makePort("B", go.Spot.Bottom, true,  false)
        );

    var conditionTemplate = 
        $go(go.Node, "Spot", nodeStyle(),
            $go(go.Panel, "Auto",
                $go(go.Shape, "Diamond", { name: "SHAPE", fill: "white", stroke: "black" }, new go.Binding("figure", "figure")),
                $go(go.TextBlock,
                    {
                        font: "11pt Monospace",
                        stroke: "black",
                        margin: 8,
                        wrap: go.TextBlock.WrapFit,
                        editable: true
                    },
                    new go.Binding("text").makeTwoWay())
            ),
            makePort("T", go.Spot.Top,    false, true),
            makePort("L", go.Spot.Left,   true,  true),
            makePort("R", go.Spot.Right,  true,  true),
            makePort("B", go.Spot.Bottom, true,  false)
        );

    //this.graph.diagram.groupTemplateMap.add("function",     functionTemplate);

    this.graph.diagram.nodeTemplateMap.add("begin",         beginTemplate);
    this.graph.diagram.nodeTemplateMap.add("hub",           hubTemplate);
    this.graph.diagram.nodeTemplateMap.add("end",           endTemplate);
    this.graph.diagram.nodeTemplateMap.add("condition",     conditionTemplate);
    this.graph.diagram.nodeTemplateMap.add("instruction",   instructionTemplate);
    this.graph.diagram.nodeTemplateMap.add("comment",       commentTemplate);


    // Palette
    this.graph.palette.push(new go.Palette(this.paletteid + "-0"));
    this.graph.palette.push(new go.Palette(this.paletteid + "-1"));
    this.graph.palette.push(new go.Palette(this.paletteid + "-2")); 
    //this.graph.palette.push(new go.Palette(this.paletteid + "-3")); 

    for (var i = 0; i < this.graph.palette.length; i++) {
        var palette = this.graph.palette[i];
        palette.nodeTemplateMap = this.graph.diagram.nodeTemplateMap;
        palette.groupTemplateMap = this.graph.diagram.groupTemplateMap;
    }

    this.graph.palette[0].model.nodeDataArray = [
        { category: "begin"    },
        { category: "end"      },     
        { category: "hub"      }     
    ];
   
    this.graph.palette[1].model.nodeDataArray = [
        { category: "condition" , text: 'cond' , figure: "Diamond"},
        { category: "instruction" , text: 'instruction' }
    ];
    
/*
    this.graph.palette[2].model.nodeDataArray = [    
         { category: "function" , isGroup: true , text: "fonction", desc: "description de la fonction", cond: "préconditions" } 
    ];
*/
    this.graph.palette[2].model.nodeDataArray = [    
        { category: "comment" , text: 'commentaire'  }
    ];

    $(this.$palette).accordion(
        {
            heightStyle: "content",
            activate: function(event, ui) { EniBook[id].refresh(); }
        });

    // load the diagram from this.$code
    this.load();
}

//-----------------------------------------------------------------------------
FlowChart.prototype = Object.create(Graph.prototype); // inherits from Graph

    function finishDrop(e, grp) {
      var ok = (grp !== null
                ? grp.addMembers(grp.diagram.selection, true)
                : e.diagram.commandHandler.addTopLevelParts(e.diagram.selection, true));
      if (!ok) e.diagram.currentTool.doCancel();
    }


/******************************************************************************
 *
 * Logic
 *
 ******************************************************************************/

//------------------------------------------------------------------------------
function Logic(id) { // id : HTML identifier
    Graph.call(this,id); // inherits from Graph

    this.red   = "red";
    this.green = "green";
    
    var $go = go.GraphObject.make;

    this.graph.diagram.linkTemplate =
        $go(go.Link,
            { 
                routing         : go.Link.AvoidsNodes,
                curve           : go.Link.JumpOver,
                corner          : 3,
                relinkableFrom  : true, 
                relinkableTo    : true,
                selectionAdorned: false,
                shadowOffset    : new go.Point(0,0), 
                shadowBlur      : 5, 
                shadowColor     : "blue"
            },
            new go.Binding("isShadowed", "isSelected").ofObject(),
            $go(go.Shape,
                { name: "SHAPE", strokeWidth: 2, stroke: this.red }
            ));

    var sharedToolTip =
        $go(go.Adornment, "Auto",
            $go(go.Shape, "RoundedRectangle", { fill: "lightyellow" }),
            $go(go.TextBlock, { margin: 2 },
                new go.Binding("text",  "" , function(d) { return d.category; })
            ));


    function gateStyle() {
        return [new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
                new go.Binding("angle").makeTwoWay(),
                new go.Binding("isShadowed", "isSelected").ofObject(),
                {
                    selectionAdorned: false,
                    shadowOffset    : new go.Point(0, 0),
                    shadowBlur      : 15,
                    shadowColor     : "blue",
                    toolTip         : sharedToolTip,
                    rotatable       : true, 
                    locationSpot    : go.Spot.Center
                }];
    }

    function inoutStyle() {
        return [new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
                new go.Binding("isShadowed", "isSelected").ofObject(),
                {
                    selectionAdorned: false,
                    shadowOffset    : new go.Point(0, 0),
                    shadowBlur      : 15,
                    shadowColor     : "blue",
                    toolTip         : sharedToolTip,
                    rotatable       : true, 
                    locationSpot    : go.Spot.Center
                }];
    }

    function shapeStyle() {
        return {
            name       : "NODESHAPE",
            fill       : "lightgray",
            stroke     : "darkslategray",
            desiredSize: new go.Size(50,50),
            strokeWidth: 2
        };
    }

    function portStyle(input) {
        return {
            desiredSize : new go.Size(6,6),
            fill        : "black",
            fromSpot    : go.Spot.Right,
            fromLinkable: !input,
            toSpot      : go.Spot.Left,
            toLinkable  : input,
            toMaxLinks  : 1,
            cursor      : "pointer"
        };
    }

    var inputTemplate =
        $go(go.Node, "Spot", inoutStyle(),
            $go(go.Panel, "Spot",
                {name: "INPUT"},
                $go(go.Shape, "Circle", shapeStyle(), { fill: this.red } ),  
                $go(go.Shape, "Rectangle", portStyle(false),
                    { portId: "out", alignment: new go.Spot(1,0.5) }
                ),
                new go.Binding("angle").makeTwoWay()
            ),
            $go(go.TextBlock, 
                { 
                    text     : "" ,
                    font     : "bold 18px sans-serif",
                    stroke   : "white",
                    alignment: go.Spot.Center, 
                    angle    : 0,
                    editable : true 
                },
                new go.Binding("text").makeTwoWay()
            ),
            { 
                rotateObjectName: "INPUT",
                doubleClick: function (e, obj) { 
                    e.diagram.startTransaction("Toggle Input");
                    var shp = obj.findObject("NODESHAPE"); 
                    shp.fill = (shp.fill === EniBook[id].green) ? EniBook[id].red : EniBook[id].green; 
                    EniBook[id].updateStates(); 
                    e.diagram.commitTransaction("Toggle Input");
                }
            });


    var outputTemplate =
        $go(go.Node, "Spot", inoutStyle(), 
            $go(go.Panel, "Spot",
                {name: "OUTPUT"},
                $go(go.Shape, "Rectangle", shapeStyle(), { fill: this.green } ), 
                $go(go.Shape, "Rectangle", portStyle(true),
                    { portId: "in", alignment: new go.Spot(0,0.5) }
                ),
                new go.Binding("angle").makeTwoWay()
            ),
            $go(go.TextBlock, 
                { 
                    text     : "" ,
                    angle    : 0,
                    font     : "bold 18px sans-serif",
                    stroke   : "white",
                    alignment: go.Spot.Center, 
                    editable : true
                },
                new go.Binding("text").makeTwoWay()
            ),
            {
                rotateObjectName: "OUTPUT"
            });

    var hubTemplate =
        $go(go.Node, "Spot", gateStyle(), 
            $go(go.Shape, "Rectangle", shapeStyle(), 
                { 
                    fill       : "lightgray", 
                    desiredSize: new go.Size(30,20) 
                }), 
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in", alignment: new go.Spot(0,0.5) }
            ),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out1", fromSpot: go.Spot.Bottom, alignment: new go.Spot(0.5,1) }
            ),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out2", alignment: new go.Spot(1,0.5) }
            ),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out3", fromSpot: go.Spot.Top, alignment: new go.Spot(0.5,0) }
            ),
            new go.Binding("angle").makeTwoWay() );
        
        
    var andTemplate =
        $go(go.Node, "Spot", gateStyle(),
            $go(go.Shape, "AndGate", shapeStyle()),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in1", alignment: new go.Spot(0,0.3) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in2", alignment: new go.Spot(0,0.7) }),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out", alignment: new go.Spot(1,0.5) }) );

    var orTemplate =
        $go(go.Node, "Spot", gateStyle(),
            $go(go.Shape, "OrGate", shapeStyle()),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in1", alignment: new go.Spot(0.16,0.3) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in2", alignment: new go.Spot(0.16,0.7) }),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out", alignment: new go.Spot(1,0.5) }) );

    var xorTemplate =
        $go(go.Node, "Spot", gateStyle(),
            $go(go.Shape, "XorGate", shapeStyle()),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in1", alignment: new go.Spot(0.26,0.3) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in2", alignment: new go.Spot(0.26,0.7) }),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out", alignment: new go.Spot(1,0.5) }) );

    var norTemplate =
        $go(go.Node, "Spot", gateStyle(),
            $go(go.Shape, "NorGate", shapeStyle()),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in1", alignment: new go.Spot(0.16,0.3) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in2", alignment: new go.Spot(0.16,0.7) }),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out", alignment: new go.Spot(1,0.5) }) );

    var xnorTemplate =
        $go(go.Node, "Spot", gateStyle(),
            $go(go.Shape, "XnorGate", shapeStyle()),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in1", alignment: new go.Spot(0.26,0.3) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in2", alignment: new go.Spot(0.26,0.7) }),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out", alignment: new go.Spot(1,0.5) }) );

    var nandTemplate =
        $go(go.Node, "Spot", gateStyle(),
            $go(go.Shape, "NandGate", shapeStyle()),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in1", alignment: new go.Spot(0,0.3) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in2", alignment: new go.Spot(0,0.7) }),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out", alignment: new go.Spot(1,0.5) }) );

    var notTemplate =
        $go(go.Node, "Spot", gateStyle(),
            $go(go.Shape, "Inverter", shapeStyle()),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in", alignment: new go.Spot(0,0.5) }),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out", alignment: new go.Spot(1,0.5) }) );

    var and3Template =
        $go(go.Node, "Spot", gateStyle(),
            $go(go.Shape, "AndGate", shapeStyle()),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in1", alignment: new go.Spot(0,0.3) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in2", alignment: new go.Spot(0,0.5) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in3", alignment: new go.Spot(0,0.7) }),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out", alignment: new go.Spot(1,0.5) }) );

    var or3Template =
        $go(go.Node, "Spot", gateStyle(),
            $go(go.Shape, "OrGate", shapeStyle()),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in1", alignment: new go.Spot(0.16,0.3) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in2", alignment: new go.Spot(0.18,0.5) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in3", alignment: new go.Spot(0.16,0.7) }),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out", alignment: new go.Spot(1,0.5) }) );

    var xor3Template =
        $go(go.Node, "Spot", gateStyle(),
            $go(go.Shape, "XorGate", shapeStyle()),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in1", alignment: new go.Spot(0.26,0.3) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in2", alignment: new go.Spot(0.28,0.5) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in3", alignment: new go.Spot(0.26,0.7) }),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out", alignment: new go.Spot(1,0.5) }) );

    var nor3Template =
        $go(go.Node, "Spot", gateStyle(),
            $go(go.Shape, "NorGate", shapeStyle()),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in1", alignment: new go.Spot(0.16,0.3) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in2", alignment: new go.Spot(0.18,0.5) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in3", alignment: new go.Spot(0.16,0.7) }),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out", alignment: new go.Spot(1,0.5) }) );

    var xnor3Template =
        $go(go.Node, "Spot", gateStyle(),
            $go(go.Shape, "XnorGate", shapeStyle()),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in1", alignment: new go.Spot(0.26,0.3) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in2", alignment: new go.Spot(0.28,0.5) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in3", alignment: new go.Spot(0.26,0.7) }),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out", alignment: new go.Spot(1,0.5) }) );

    var nand3Template =
        $go(go.Node, "Spot", gateStyle(),
            $go(go.Shape, "NandGate", shapeStyle()),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in1", alignment: new go.Spot(0,0.3) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in2", alignment: new go.Spot(0,0.5) }),
            $go(go.Shape, "Rectangle", portStyle(true),
                { portId: "in3", alignment: new go.Spot(0,0.7) }),
            $go(go.Shape, "Rectangle", portStyle(false),
                { portId: "out", alignment: new go.Spot(1,0.5) }) );

    this.graph.diagram.nodeTemplateMap.add("input",  inputTemplate);
    this.graph.diagram.nodeTemplateMap.add("hub",    hubTemplate);
    this.graph.diagram.nodeTemplateMap.add("output", outputTemplate);
    this.graph.diagram.nodeTemplateMap.add("and",    andTemplate);
    this.graph.diagram.nodeTemplateMap.add("or",     orTemplate);
    this.graph.diagram.nodeTemplateMap.add("xor",    xorTemplate);
    this.graph.diagram.nodeTemplateMap.add("not",    notTemplate);
    this.graph.diagram.nodeTemplateMap.add("nand",   nandTemplate);
    this.graph.diagram.nodeTemplateMap.add("nor",    norTemplate);
    this.graph.diagram.nodeTemplateMap.add("nxor",   xnorTemplate);
    this.graph.diagram.nodeTemplateMap.add("and3",   and3Template);
    this.graph.diagram.nodeTemplateMap.add("or3",    or3Template);
    this.graph.diagram.nodeTemplateMap.add("xor3",   xor3Template);
    this.graph.diagram.nodeTemplateMap.add("nand3",  nand3Template);
    this.graph.diagram.nodeTemplateMap.add("nor3",   nor3Template);
    this.graph.diagram.nodeTemplateMap.add("nxor3",  xnor3Template);

    // Palette
    this.graph.palette.push(new go.Palette(this.paletteid + "-0"));
    this.graph.palette.push(new go.Palette(this.paletteid + "-1"));
    this.graph.palette.push(new go.Palette(this.paletteid + "-2")); 
    this.graph.palette.push(new go.Palette(this.paletteid + "-3")); 

    for (var i = 0; i < this.graph.palette.length; i++) {
        var palette = this.graph.palette[i];
        palette.nodeTemplateMap = this.graph.diagram.nodeTemplateMap;
    }

    this.graph.palette[0].model.nodeDataArray = [
        { category: "input"  },
        { category: "hub"    },
        { category: "output" }
    ];
    
    this.graph.palette[1].model.nodeDataArray = [
        { category: "not" }
    ];
    
    this.graph.palette[2].model.nodeDataArray = [    
        { category: "and"  },
        { category: "or"   },
        { category: "xor"  },
        { category: "nand" },
        { category: "nor"  },
        { category: "nxor" }
    ];

    this.graph.palette[3].model.nodeDataArray = [
        { category: "and3"  },
        { category: "or3"   },
        { category: "xor3"  },
        { category: "nand3" },
        { category: "nor3"  },
        { category: "nxor3" }
    ];

    $(this.$palette).accordion(
        {
            heightStyle: "content",
            activate: function(event, ui) { EniBook[id].refresh(); }
        });

    // load the diagram from this.$code
    this.load();

    // update the diagram every timestep (in milliseconds)
    var timestep = 250;
    this.loop(timestep);
}

//-----------------------------------------------------------------------------
Logic.prototype = Object.create(Graph.prototype); // inherits from Graph

//-----------------------------------------------------------------------------
Logic.prototype.updateStates = function() { 
    var oldskip = this.graph.diagram.skipsUndoManager; 
    this.graph.diagram.skipsUndoManager = true; 

    // "input" nodes first
    var nodes = this.graph.diagram.nodes; 
    var iterator = nodes.iterator;
    while(iterator.next()) {
        var node = iterator.value; 
        if (node.category === "input") { this.doInput(node); }
    }
    // other kinds of nodes 
    iterator.reset();
    while(iterator.next()) {
        var node = iterator.value; 
        switch (node.category) {
            case "hub"   : this.doHub(node);    break;
            case "and"   : this.doAnd(node);    break;
            case "or"    : this.doOr(node);     break;
            case "xor"   : this.doXor(node);    break;
            case "not"   : this.doNot(node);    break;
            case "nand"  : this.doNand(node);   break;
            case "nor"   : this.doNor(node);    break;
            case "nxor"  : this.doXnor(node);   break;
            case "and3"  : this.doAnd(node);    break;
            case "or3"   : this.doOr(node);     break;
            case "xor3"  : this.doXor(node);    break;
            case "nand3" : this.doNand(node);   break;
            case "nor3"  : this.doNor(node);    break;
            case "nxor3" : this.doXnor(node);   break;
            case "output": this.doOutput(node); break;
            case "input" :                      break;  // already called
            default      :                      break;
        }
    }
    this.graph.diagram.skipsUndoManager = oldskip;
}

//-----------------------------------------------------------------------------
Logic.prototype.loop = function(timestep) {
    var id = this.id;
    this.updateStates(); 
    setTimeout( function() { EniBook[id].loop(timestep); }, timestep );
}

//------------------------------------------------------------------------------
Logic.prototype.linkIsTrue = function(link) {  // assume the given Link has a Shape named "SHAPE"
    return link.findObject("SHAPE").stroke === this.green;
}

//------------------------------------------------------------------------------
Logic.prototype.setOutputLinks = function(node, color) {
    node.findLinksOutOf().each(function(link) { link.findObject("SHAPE").stroke = color; });
}

//------------------------------------------------------------------------------
Logic.prototype.doInput = function(node) { 
    this.setOutputLinks(node, node.findObject("NODESHAPE").fill);
}

//------------------------------------------------------------------------------
Logic.prototype.doHub = function(node) {
    var links = node.findLinksInto();
    var iterator = links.iterator;
    var allTrue = true;
    while (iterator.next() && allTrue) {
        var link = iterator.value;
        if (!this.linkIsTrue(link)) { allTrue = false; }
    }
    var color = allTrue ? this.green : this.red;
    //var color = node.findLinksInto().all(linkIsTrue) ? this.green : this.red;
    this.setOutputLinks(node, color); 
}

//------------------------------------------------------------------------------
Logic.prototype.doAnd = function(node) { 
    var links = node.findLinksInto();
    var iterator = links.iterator;
    var allTrue = true;
    while (iterator.next() && allTrue) {
        var link = iterator.value;
        if (!this.linkIsTrue(link)) { allTrue = false; }
    }
    var color = allTrue ? this.green : this.red;
    //var color = node.findLinksInto().all(linkIsTrue) ? this.green : this.red;
    this.setOutputLinks(node, color); 
}

//------------------------------------------------------------------------------
Logic.prototype.doNand = function(node) {
    var links = node.findLinksInto();
    var iterator = links.iterator;
    var allFalse = true;
    while (iterator.next() && allFalse) {
        var link = iterator.value;
        if (this.linkIsTrue(link)) { allFalse = false; }
    }
    var color = allFalse ? this.green : this.red;
    //var color = !node.findLinksInto().all(linkIsTrue) ? this.green : this.red;
    this.setOutputLinks(node, color);
}

//------------------------------------------------------------------------------
Logic.prototype.doNot = function(node) {
    var links = node.findLinksInto();
    var iterator = links.iterator;
    var allFalse = true;
    while (iterator.next() && allFalse) {
        var link = iterator.value;
        if (this.linkIsTrue(link)) { allFalse = false; }
    }
    var color = allFalse ? this.green : this.red;
    //var color = !node.findLinksInto().all(linkIsTrue) ? this.green : this.red;
    this.setOutputLinks(node, color);
}

//------------------------------------------------------------------------------
Logic.prototype.doOr = function(node) {
    var links = node.findLinksInto();
    var iterator = links.iterator;
    var oneTrue = false;
    while (iterator.next() && !oneTrue) {
        var link = iterator.value;
        if (this.linkIsTrue(link)) { oneTrue = true; }
    }
    var color = oneTrue ? this.green : this.red;
    //var color = node.findLinksInto().any(linkIsTrue) ? this.green : this.red;
    this.setOutputLinks(node, color);
}

//------------------------------------------------------------------------------
Logic.prototype.doNor = function(node) {
    var links = node.findLinksInto();
    var iterator = links.iterator;
    var oneTrue = false;
    while (iterator.next() && !oneTrue) {
        var link = iterator.value;
        if (this.linkIsTrue(link)) { oneTrue = true; }
    }
    var color = oneTrue ? this.red : this.green;
    //var color = !node.findLinksInto().any(linkIsTrue) ? this.green : this.red;
    this.setOutputLinks(node, color);
}

//------------------------------------------------------------------------------
Logic.prototype.doXor = function(node) { 
    var truecount = 0;
    var links = node.findLinksInto();
    var iterator = links.iterator;
    while(iterator.next()) { 
        var link = iterator.value; 
        if (this.linkIsTrue(link)) { truecount++; } 
    }
    var color = truecount % 2 === 0 ? this.red : this.green;
    this.setOutputLinks(node, color); 
}

//------------------------------------------------------------------------------
Logic.prototype.doXnor = function(node) {
    var truecount = 0;
    var links = node.findLinksInto();
    var iterator = links.iterator;
    while(iterator.next()) { 
        var link = iterator.value; 
        if (this.linkIsTrue(link)) { truecount++; } 
    }
    //node.findLinksInto().each(function(link) { if (linkIsTrue(link)) { truecount++; } });
    var color = truecount % 2 === 0 ? this.green : this.red;
    this.setOutputLinks(node, color);
}

//------------------------------------------------------------------------------
Logic.prototype.doOutput = function(node) { 
    node.linksConnected.each( function(link) { 
        node.findObject("NODESHAPE").fill = link.findObject("SHAPE").stroke; }
    );
}


//------------------------------------------------------------------------------
Logic.prototype.feedback = function() {
    var nodes = this.graph.diagram.nodes;
    var links = this.graph.diagram.links;

    var nbout      = 0;
    var nbin       = 0;
    var ins        = [];
    var outs       = [];
    var outFormula = {};
    var comment    = "";
    var ok         = true;
    var cptin      = 0;
    var cptout     = 0;

    $(this.$feedback).css('display','none');
    $(this.$feedback).removeClass('feedback-false');
    $(this.$feedback).removeClass('feedback-true');
    $(this.$feedback).addClass('feedback');
    $(this.$feedback).css('display','block');

    this.tries += 1;
    var res = "Essai " + this.tries.toString();

    switch (EniBook['mode']) {
        case 'assessing' :
            var date    = new Date();
            var hour    = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getHours());
            var minutes = new Intl.NumberFormat("fr-FR",{minimumIntegerDigits: 2}).format(date.getMinutes()); 
            res += " mémorisé à " + hour + "h" + minutes + "."; 
            this.save();
            EniBook['assessing'][this.directive][this.id].user = $(this.$code).val();
            $(this.$feedback).addClass('feedback-info');
            break;
        default :
            res += "<br />";
            break;
    }
    $(this.$feedback).append(res);

    res = "";    
    var iterator = nodes.iterator;
    while(iterator.next()) {
        var theNode = iterator.value
        if (theNode.category === "output") {
            nbout++; 
            var resNode = theNode.data.text;
            if (resNode === undefined || resNode === "") { 
                ok = false;
                $(this.$feedback).addClass("feedback-false");
                resNode = "\\$o_" + cptout.toString();
                //theNode.data.text = resNode;
                cptout++;
            }
            outs.push(resNode);

            var key = resNode;
            var resNodesTo = this.searchNodesTo(theNode);
            if (resNodesTo) { resNode += ' = ' + resNodesTo; }
            outFormula[key] = resNode;
        }
        if (theNode.category === "input")  { 
            nbin++; 
            var resNode = theNode.data.text; 
            if (resNode === undefined || resNode === "") { 
                ok = false;
                $(this.$feedback).addClass("feedback-false");
                resNode = "\\$i_" + cptin.toString(); 
                //theNode.data.text = resNode;
                cptin++;
            }
            ins.push(resNode);
        }
    }
    iterator.reset();

    if (ok) { 
        if (EniBook['mode'] !== 'assessing') {
            ins.sort(); 
            outs.sort();
            res += this.inoutTable(ins,outs,outFormula);
            res += this.truthTable(ins,outs,outFormula);
        }
    }
    else { 
        res += "<div class='feedback-false'>"
            +  "    Les entrées-sorties doivent toutes être nommées explicitement."
            +  "</div>"; 
    }   
    $(this.$feedback).append(res);

    if (EniBook['mode'] !== 'assessing') {        
        var feedbacks = this.feedbackId(); 
        if (feedbacks.len != 0) { // feedbacks
            for (f in feedbacks) { 
                if (f == ok.toString()) { 
                    comment += this.compareTable(EniBook[feedbacks[f]]); 
                }
            }
        }
        $(this.$feedback).append(comment);        
        //if (typeof MathJax != "undefined") { MathJax.Hub.Typeset($(this.$feedback).attr("id")); }
        renderKatex(this.id + "-graph-feedback");
    }
}

//------------------------------------------------------------------------------
Logic.prototype.searchNodesTo = function(node) {
    var res = "";

    var it = node.findNodesInto(); 
    var size = it.count; 

    while (it.next()) {
        var category = it.value.category;
        if (category === "input") { res += it.value.data.text; }
        else { 
            if (category === "hub") { res += this.searchNodesTo(it.value); }
            else { 
                res += it.value.category + '('; 
                res += this.searchNodesTo(it.value);  
                res += ')'; 
            }
        }
        if (size-1 > 0) { res += ','; }
        size--;
    }

    return res;
}

//------------------------------------------------------------------------------
Logic.prototype.inoutTable = function(ins,outs,outFormula) {
    var res = "";
    res += "<table id='" + this.id +  "-inouttable'"
        +  "    data-role='table'"
        +  "    class='diagram-table ui-responsive ui-shadow'>" 
        +  "    <caption>Entrées/Sorties</caption>"
        +  "    <thead>"
        +  "        <tr>"; 
    res += "            <th>Entrées (" + (ins.length).toString()  +  ")</th>" 
        +  "            <th>Sorties (" + (outs.length).toString() +  ")</th>"
        +  "        </tr>"
        +  "    </thead>"
        +  "    <tbody>";

    for (var i = 0; i < Math.max(ins.length,outs.length); i++) {
        res += "<tr>";
        if (i < ins.length)  { res += "<td>\\(" + this.toLatex(ins[i]) + "\\)</td>"; }
        else { res += "<td></td>"; }
        if (i < outs.length) { res += "<td>\\(" + this.toLatex(outFormula[outs[i]]) + "\\)</td>"; }
        else { res += "<td></td>"; }
        res += "</tr>";
    }

    res += "    </tbody>"
        +  "</table>"; 
    
    return res;
}

//------------------------------------------------------------------------------
Logic.prototype.truthTable = function(ins,outs,outFormula) {
    res = "";
    res += "<table id='" + this.id + "-truthTable'"
        +  "    data-role='table'"
        +  "    class='diagram-table ui-responsive ui-shadow'>" 
        +  "    <caption>Table de vérité</caption>"
        +  "    <thead>"
        +  "        <tr>";
        
    for (var i = 0; i < ins.length; i++)  { res += '<th>\\(' + this.toLatex(ins[i])  + '\\)</th>'; }
    for (var i = 0; i < outs.length; i++) { res += '<th>\\(' + this.toLatex(outs[i]) + '\\)</th>'; }
    
    res += "        </tr>"
        +  "    </thead>"
        +  "    <tbody>";

    var boucle = "";
    for (var i = 0; i < ins.length; i++) {
        boucle += "for (var " + ins[i] + " = 0; " + ins[i] + " < 2; " + ins[i] + "++) {\n";
    }
    for (var i = 0; i < outs.length; i++) {
        boucle += outFormula[outs[i]] + ";\n";
    }
    boucle += "res += '<tr>';\n";
    for (var i = 0; i < ins.length; i++)  { boucle += "res += '<td>' + " + ins[i]  + ".toString() + '</td>';\n"; }
    for (var i = 0; i < outs.length; i++) { boucle += "res += '<td>' + toint(" + outs[i] + ").toString() + '</td>';\n"; }
    boucle += "res += '</tr>';\n";
    for (var i = 0; i < ins.length; i++)  { boucle += "}\n"; }
    
    eval(boucle);

    function not(a)        { if(a == 1) { return 0; } else { return 1; } }
    function and(a,b)      { return (a && b); }
    function or(a,b)       { return (a || b); }
    function xor(a,b)      { return (a != b); }
    function nand(a,b)     { return !(a && b); }
    function nor(a,b)      { return !(a || b); }
    function nxor(a,b)     { return (a == b); }
    function and3(a,b,c)   { return (a && b && c); }
    function or3(a,b,c)    { return (a || b || c); }
    function xor3(a,b,c)   { return (a != b) != c; }
    function nand3(a,b,c)  { return !(a && b && c); }
    function nor3(a,b,c)   { return !(a || b || c); }
    function nxor3(a,b,c)  { return !((a != b) != c); }

    function toint(a) { if (a) { return 1; } else { return 0; } }

    res += "    </tbody>"
        +  "</table>";
       
    return res;  
}

//------------------------------------------------------------------------------
Logic.prototype.toLatex = function(expression) {
    var latex = "";
    var op0 = ['not','nand','nor','nxor','nand3','nor3','nxor3'];
    var op2 = ['and','or','xor'];
    var op3 = ['and3','or3','xor3'];
    var ops = [].concat(op0).concat(op2).concat(op3); 
    var latexOperators = {
        and : ' \\cdot ', 
        or  : ' + ', 
        xor : ' \\oplus ',
        and3: ' \\cdot ', 
        or3 : ' + ', 
        xor3: ' \\oplus '
    };
    var found = false;
    
    var list = expression.split(" = ");
    switch (list.length) {
        case 2:
            output = list[0];
            expression = list[1]; 
            latex += output + " = " + this.toLatex(expression);
            break;
        case 1:
            expression = list[0]; 
            found = false; 
            for (var i = 0; i < op0.length && !found; i++) { // nop(expr)
                var op = op0[i]; 
                var opar = op + '(';
                var str = expression.substr(0,opar.length); 
                if (str == opar) { 
                    found = true;
                    latex += "\\overline{";
                    var begin = opar.length;
                    var end   = this.parmatch(expression,begin);
                    if (op == 'not') { // not(expr) -> expr
                        expression = expression.substr(begin,end-begin);
                        latex += this.toLatex(expression); 
                    }
                    else { // nop(expr) -> op(expr)
                        expression = expression.substr(1);
                        latex += toLatex(expression); 
                    }
                    latex += "}";
                }
            }
            for (var i = 0; i < op2.length && !found; i++) { // op(e1,e2)
                var terme1 = '';
                var terme2 = '';
                var op = op2[i];
                var opar = op + '(';
                var str = expression.substr(0,opar.length);
                if (str == opar) { 
                    found = true;
                    expression = expression.slice(opar.length); 
                    var latexop = latexOperators[op]; 
                    var found2 = false;
                    for (var j = 0; j < ops.length && !found2; j++) {
                        var operator = ops[j]; 
                        var operatorpar = operator + '('; 
                        var str2 = expression.substr(0,operatorpar.length); 
                        if (str2 == operatorpar) {
                            found2 = true;
                            var begin = operatorpar.length;
                            var end   = this.parmatch(expression,begin);
                            terme1 = expression.substr(0,end+1);
                            terme2 = expression.substr(end+2);
                            terme2 = terme2.slice(0,terme2.length-1);
                        }
                    }
                    if (!found2) { 
                        var index2 = expression.search(','); 
                        terme1 = expression.substr(0,index2);
                        terme2 = expression.substr(index2+1);
                        terme2 = terme2.slice(0,terme2.length-1);
                    }
                    if (latexop != latexOperators['xor']) {
                        latex += this.toLatex(terme1) + latexop + this.toLatex(terme2);
                    }
                    else {
                        latex += '(' + this.toLatex(terme1) + latexop + this.toLatex(terme2) + ')';
                    }
                }
            }
            for (var i = 0; i < op3.length && !found; i++) { // op(e1,e2,e3)
                var terme1 = '';
                var terme2 = '';
                var terme3 = '';
                var op = op3[i];
                var opar = op + '(';
                var str = expression.substr(0,opar.length);
                if (str == opar) { 
                    found = true;
                    expression = expression.slice(opar.length); 
                    var latexop = latexOperators[op];
                    var found3 = false;
                    for (var j = 0; j < ops.length && !found3; j++) {
                        var operator = ops[j];
                        var operatorpar = operator + '(';
                        var str3 = expression.substr(0,operatorpar.length);
                        if (str3 == operatorpar) {
                            found3 = true;
                            var begin = operatorpar.length;
                            var end   = this.parmatch(expression,begin); 
                            terme1 = expression.substr(0,end+1);
                            terme2 = expression.substr(end+2);
                            terme2 = op.slice(0,op.length-1) + '(' + terme2.slice(0,terme3.length-1);
                        }
                    }
                    if (!found3) { 
                        var index3 = expression.search(','); 
                        terme1 = expression.substr(0,index3);
                        terme2 = expression.substr(index3+1);
                        index3 = terme2.search(',');
                        terme3 = terme2.substr(index3+1);
                        terme2 = terme2.substr(0,index3);
                        terme3 = terme3.slice(0,terme3.length-1);
                        latex  +=  '(' + this.toLatex(terme1) + latexop + this.toLatex(terme2) + latexop + this.toLatex(terme3) + ')';
                    }
                    else { latex += this.toLatex(terme1) + latexop + this.toLatex(terme2); }
                }
            }
            if (!found) { latex += expression; }
            break;
        default: 
            break;
    }
    return latex
}

//------------------------------------------------------------------------------
Logic.prototype.parmatch = function(expression,begin) {
    var par = 1;
    for (var end = begin; end < expression.length; end++) {
        switch (expression[end]) {
            case '(': 
                par++; 
                break;
            case ')': 
                par--;
                if (par == 0) { return end; }
                break;
            default : 
                break;
        }
    }
    return end;
}

//------------------------------------------------------------------------------
Logic.prototype.compareTable = function(feedback) { // feedback : Javascript object
    var res = "";
    var comment = "";
    var $table = $("#" + this.id + "-truthTable");
    var $div = $("<div></div>");
    $($div).attr("id",this.id + "-solTable");   
    $($div).html(feedback.feedbacktrueArray[0][1]);
    var $solutions = $($div).children("table");
    
    if ($solutions.length === 1) {
        var $solution = $solutions[0];
        var table_array    = this.table2array($table); 
        var solution_array = this.table2array($solution); 
        if (table_array.length > 0) {
            var thead = table_array[0];
            for (var i = 0; i < thead.length; i++) {
                thead[i] = thead[i].replace('\\(','');
                thead[i] = thead[i].replace('\\)','');
                table_array[0] = thead;
            }
        }
                
        var ok = true;
        if (table_array.length != solution_array.length) {
            ok = false;
            if (table_array.length > 1 && solution_array.length > 1) {
                var ins_table    = Math.log(table_array.length - 1)/Math.log(2);
                var ins_solution = Math.log(solution_array.length - 1)/Math.log(2);
                var diff = ins_table - ins_solution;
                var nbIn = (ins_table > 1) ? " entrées " : " entrée ";
                comment += "Le circuit a " + ins_table.toString() + nbIn +
                           ": soit " + Math.abs(diff).toString();
                if (diff > 0) { comment +=  " de trop que prévu."; }
                else { comment += " de moins que prévu."; }
            }
        }
        else {
            for (var i = 0; i < table_array.length && ok; i++) {
                if (table_array[i].length != solution_array[i].length) { 
                    ok = false; 
                    var ins_table = Math.log(table_array.length - 1)/Math.log(2);
                    var diff = table_array[i].length - solution_array[i].length;
                    var nbOut = (table_array[i].length - ins_table > 1) ? " sorties " : " sortie ";
                    comment += "Le circuit a " + (table_array[i].length - ins_table).toString() + 
                               nbOut + ": soit " + Math.abs(diff).toString();
                    if (diff > 0) { comment +=  " de trop que prévu."; }
                    else { comment += " de moins que prévu."; }
                }
                else {
                    for (var j = 0; j < table_array[i].length && ok; j++) {
                        if (table_array[i][j] != solution_array[i][j]) {
                            ok = false;
                            if (i == 0) { 
                                comment += "Colonne " + (j+1).toString() + ": " +
                                           "\\(" + solution_array[i][j] + 
                                            "\\) attendu, " + 
                                            "\\(" + table_array[i][j] + 
                                            "\\) trouvé."   
                            }
                            else {
                                comment += "Ligne " + (i+1).toString() + 
                                           ": problème avec la valeur de \\(" + 
                                           table_array[0][j] + "\\).";
                            }
                        }
                    }
                }
            }
        }        
        if (ok) { 
            res += "<div class='feedback-true'>C'est la table de vérité attendue. Bravo.<br />" 
                +  comment 
                +  "</div>"; 
        }
        else {
            res += "<div class='feedback-false'>" +
                   "Ce n'est pas la table de vérité attendue. Désolé.<br />" 
                +  comment 
                +  "</div>";
        }
    }
    return res; 
}

//------------------------------------------------------------------------------
Logic.prototype.table2array = function(table) {
    var table_array = new Array();

    var $theads = $(table).children("thead");
    if ($theads.length === 1) {
        var $thead = $theads[0]; 
        var $trs = $($thead).children("tr");
        for (var i = 0; i < $trs.length; i++) {
            var $ths = $($trs[i]).children("th");
            var row = new Array();
            for (var j = 0; j < $ths.length; j++) {
                row.push($($ths[j]).text());
            }
            table_array.push(row);     
        }
    }

    var $tbodies = $(table).children("tbody");
    if ($tbodies.length === 1) {
        var $tbody = $tbodies[0];
        var $trs = $($tbody).children("tr");
        for (var i = 0; i < $trs.length; i++) {
            var $tds = $($trs[i]).children("td");
            var row = new Array();
            for (var j = 0; j < $tds.length; j++) {
                row.push($($tds[j]).text());
            }
            table_array.push(row);     
        }
    }

    return table_array;
}

//alert('scope');
/******************************************************************************
 *
 * Scope
 *
 ******************************************************************************/

//------------------------------------------------------------------------------
function Scope(id) { // id: HTML identifier
    this.id         = id;
    this.$scope     = $("#" + id + "-scope");
    this.$zoom      = $("#" + id + "-scope-zoom");
    this.$divobject = $("#" + id + "-scope-object");
    this.$object    = $(this.$divobject).children("object");
    this.filename   = $(this.$scope).attr("filename");
    this.zoom       = $(this.$scope).attr("zoom"); 
    
    this.update();
    //console.log('initializing ',this.id);

}
    
//------------------------------------------------------------------------------
Scope.prototype.update = function() { 
    $(this.$object).attr("data", this.filename); 
    
    if (this.zoom == "in") { 
        $(this.$zoom).removeClass("glyphicons-zoom-out");
        $(this.$zoom).addClass("glyphicons-zoom-in");
        $(this.$divobject).css("display","none"); 
    }
    else { 
        $(this.$zoom).removeClass("glyphicons-zoom-in");
        $(this.$zoom).addClass("glyphicons-zoom-out");
        $(this.$divobject).css("display","block"); 
    }
}

//------------------------------------------------------------------------------
Scope.prototype.collapse = function() {
    this.toggle();
}
  
//------------------------------------------------------------------------------
Scope.prototype.toggle = function() { 
    if (this.zoom == "in") {
        $(this.$zoom).removeClass("glyphicons-zoom-in");
        $(this.$zoom).addClass("glyphicons-zoom-out");
        this.zoom = "out";
        $(this.$divobject).css("display","block");
        //$.mobile.silentScroll($(this.$scope).offset().top);
        this.update();
    }
    else {
        $(this.$zoom).removeClass("glyphicons-zoom-out");
        $(this.$zoom).addClass("glyphicons-zoom-in");
        this.zoom = "in";
        $(this.$divobject).css("display","none");
    }
}

//------------------------------------------------------------------------------
Scope.prototype.feedback = function() {}


/*
try {
  var worker = new Worker(url);
  worker.addEventListener('error', function (event) {
    // Error: Failed to load script (nsresult = 0x805303f4)
    // Prevent the event from bubbling
    event.preventDefault();
    // Handle the cross-origin load error for newer browsers
    ...
  });
} catch (ex) {
  // SecurityError
  // Handle the cross-origin load error for older browsers
  ...
}
*/

