# -*- coding: utf-8 -*-

# notabene.py

__author__ = 'jacques.tisseau@enib.fr'

from docutils import nodes
from docutils.parsers.rst import Directive
from docutils.parsers.rst import directives, roles

from enibook import EniBook

#------------------------------------------------------------------------------
# NotaBene
#------------------------------------------------------------------------------
NOTABENE_HTML_BEGIN = u"""
<div id="%(id)s-notabene" name="%(name)s-notabene" 
    class="notabene %(class)s-notabene" collapse="%(collapse)s"
    directive="%(directive)s">
    <div onclick="$('#%(id)s-notabene-content').toggle();" style="margin-bottom: 2px; cursor: pointer;">
        <span class="btn btn-warning %(class-icon)s"></span>
        <span id="%(id)s-notabene-title" name="%(name)s-notabene-title" directive="%(directive)s"
            class="notabene-title %(class)s-notabene-title" >%(title)s</span> 
        <span id="%(id)s-notabene-subtitle" name="%(name)s-notabene-subtitle" directive="%(directive)s"
            class="notabene-subtitle %(class)s-notabene-subtitle" >%(subtitle)s</span>
    </div>
    <div id="%(id)s-notabene-content" name="%(name)s-notabene-content"
        class="notabene-content %(class)s-notabene-content">
        <p>
"""

NOTABENE_HTML_END = u"""
        </p>
    </div>
</div>
<script type="text/javascript">
    //$(document).ready( function() { EniBook.init.push( function() { EniBook['%(id)s'] = new NotaBene('%(id)s'); }) });
    EniBook.init.push( function() { EniBook['%(id)s'] = new NotaBene('%(id)s'); } );
</script>
"""

NOTABENE_LATEX_BEGIN = u"""
\\begin{center}
\\begin{minipage}{0.95\\textwidth}
\\begin{description}
\\item[%(title)s] \\mbox{}

"""

NOTABENE_LATEX_END = u"""
\\end{description}
\\end{minipage}
\\end{center}
"""
#------------------------------------------------------------------------------
class notabene(nodes.General, nodes.Element):
    def __init__(self,options):
        super(notabene,self).__init__()
        self.options = options

def visit_html_notabene(self, node):
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_notabene(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_notabene(self, node):
    pass
def depart_latex_notabene(self,node):
    pass
#-----------------------------------------------------
class NotaBene(EniBook):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'title'     : directives.unchanged,
        'subtitle'  : directives.unchanged,
        'class-icon': directives.class_option,
        'collapse'  : directives.flag,
        'class'     : directives.class_option,
        'name'      : directives.unchanged
    }

    def run(self):
        super(NotaBene,self).run()

        if 'title' not in self.options :
            self.options['title'] = "NB: "
        if 'subtitle' not in self.options :
            self.options['subtitle'] = ""
        if 'class-icon' not in self.options :
            self.options['class-icon'] = "glyphicons glyphicons-comments"

        if 'collapse' not in self.options :
            self.options['collapse'] = 'false'
        else :
            self.options['collapse'] = 'true'


        node = notabene(self.options)
        node.html_begin  = NOTABENE_HTML_BEGIN
        node.html_end    = NOTABENE_HTML_END
        node.latex_begin = NOTABENE_LATEX_BEGIN
        node.latex_end   = NOTABENE_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)
        return [node]
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Goal
#------------------------------------------------------------------------------
class goal(notabene, nodes.Element):
    pass
#-----------------------------------------------------
class Goal(NotaBene):

    def run(self):
        if 'title' not in self.options :
            self.options['title'] = 'Objectif : '
        if 'class-icon' not in self.options :
            self.options['class-icon'] = 'glyphicons glyphicons-target'
        return super(Goal,self).run()
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Atwork
#------------------------------------------------------------------------------
class atwork(notabene, nodes.Element):
    pass
#-----------------------------------------------------
class Atwork(NotaBene):

    def run(self):
        if 'title' not in self.options :
            self.options['title'] = 'En travaux : '
        if 'class-icon' not in self.options :
            self.options['class-icon'] = 'glyphicons glyphicons-construction-cone'
        return super(Atwork,self).run()
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Todo
#------------------------------------------------------------------------------
class todo(notabene, nodes.Element):
    pass
#-----------------------------------------------------
class Todo(NotaBene):

    def run(self):
        if 'title' not in self.options :
            self.options['title'] = 'A faire : '
        if 'class-icon' not in self.options :
            self.options['class-icon'] = 'glyphicons glyphicons-circle-exclamation-mark'
        return super(Todo,self).run()
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Abstract
#------------------------------------------------------------------------------
class abstract(notabene, nodes.Element):
    pass
#-----------------------------------------------------
class Abstract(NotaBene):

    def run(self):
        if 'title' not in self.options :
            self.options['title'] = u'Résumé : '
        if 'class-icon' not in self.options :
            self.options['class-icon'] = 'glyphicons glyphicons-notes-2'
        return super(Abstract,self).run()
#------------------------------------------------------------------------------


#------------------------------------------------------------------------------
# Info
#------------------------------------------------------------------------------
class info(notabene, nodes.Element):
    pass
#-----------------------------------------------------
class Info(NotaBene):

    def run(self):
        if 'title' not in self.options :
            self.options['title'] = 'Information : '
        if 'class-icon' not in self.options :
            self.options['class-icon'] = 'glyphicons glyphicons-circle-info'
        return super(Info,self).run()
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Reminder
#------------------------------------------------------------------------------
class reminder(notabene, nodes.Element):
    pass
#-----------------------------------------------------
class Reminder(NotaBene):

    def run(self):
        if 'title' not in self.options :
            self.options['title'] = 'Rappel : '
        if 'class-icon' not in self.options :
            self.options['class-icon'] = 'glyphicons glyphicons-bookmark'
        return super(Reminder,self).run()
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Example
#------------------------------------------------------------------------------
class example(notabene, nodes.Element):
    pass
#-----------------------------------------------------
class Example(NotaBene):

    def run(self):
        if 'title' not in self.options :
            self.options['title'] = 'Exemple : '
        if 'class-icon' not in self.options :
            self.options['class-icon'] = 'glyphicons glyphicons-bookmark'
        return super(Example,self).run()
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Definition
#------------------------------------------------------------------------------
class defnode(notabene, nodes.Element):
    pass
#-----------------------------------------------------
class Definition(NotaBene):

    def run(self):
        if 'title' not in self.options :
            self.options['title'] = u'Définition : '
        if 'class-icon' not in self.options :
            self.options['class-icon'] = 'glyphicons glyphicons-bookmark'
        return super(Definition,self).run()
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Welcome
#------------------------------------------------------------------------------
class welcome(notabene, nodes.Element):
    pass
#-----------------------------------------------------
class Welcome(NotaBene):

    def run(self):
        if 'title' not in self.options :
            self.options['title'] = u'Bienvenue'
        if 'class-icon' not in self.options :
            self.options['class-icon'] = 'glyphicons glyphicons-user'
        return super(Welcome,self).run()
#------------------------------------------------------------------------------

