# -*- coding: utf-8 -*-

# __init__.py

__author__  = 'jacques.tisseau@enib.fr'
__version__ = '1.618033988' # ajouter une décimale au nombre d'or (1 + math.sqrt(5))/2 = 1.618033988749895 à chaque changement de version significatif 

import sys

sys.stderr.write('\t\033[1;36m' + 'EniBook ' + __version__  + '\033[0m')

#------------------------------------------------------------------------------
#from association    import *
from assessing      import *
from block          import *
from coderun        import *
from diagram        import *
from enibook        import *
from feedback       import *
from input          import *
from mcq            import *
from medias         import *
from multicolumn    import *
from multisort      import *
from notabene       import *
from question       import *
from roles          import *
from scope          import *

#------------------------------------------------------------------------------
def setup(app):
    # roles
    app.add_role('ln',      ln_function_role)
    app.add_role('img',     img_function_role)
    app.add_role('text',    text_function_role)
    app.add_role('solution',solution_function_role)
    app.add_role('input',   input_function_role)
    app.add_role('tmp',     template_function_role)

    # directives
    app.add_directive('enibook', EniBook)
    app.add_node(enibook, html=(visit_html_enibook, depart_html_enibook), 
                          latex=(visit_latex_enibook, depart_latex_enibook))
    app.add_directive('web-csv-table', WebCSVTable)
    app.add_node(webcsvtable, html=(visit_html_webcsvtable, depart_html_webcsvtable), 
                              latex=(visit_latex_webcsvtable, depart_latex_webcsvtable))

    app.add_directive('nota-bene', NotaBene)
    app.add_node(notabene, html=(visit_html_notabene, depart_html_notabene), 
                           latex=(visit_latex_notabene, depart_latex_notabene))
    app.add_directive('goal', Goal)
    app.add_node(goal, html=(visit_html_notabene, depart_html_notabene), 
                       latex=(visit_latex_notabene, depart_latex_notabene))
    app.add_directive('definition', Definition)
    app.add_node(defnode, html=(visit_html_notabene, depart_html_notabene), 
                       latex=(visit_latex_notabene, depart_latex_notabene))
    app.add_directive('atwork', Atwork)
    app.add_node(atwork, html=(visit_html_notabene, depart_html_notabene), 
                         latex=(visit_latex_notabene, depart_latex_notabene))
    app.add_directive('todo', Todo)
    app.add_node(todo, html=(visit_html_notabene, depart_html_notabene), 
                       latex=(visit_latex_notabene, depart_latex_notabene))
    app.add_directive('info', Info)
    app.add_node(info, html=(visit_html_notabene, depart_html_notabene), 
                       latex=(visit_latex_notabene, depart_latex_notabene))
    app.add_directive('abstract', Abstract)
    app.add_node(abstract, html=(visit_html_notabene, depart_html_notabene), 
                       latex=(visit_latex_notabene, depart_latex_notabene))
    app.add_directive('reminder', Reminder)
    app.add_node(reminder, html=(visit_html_notabene, depart_html_notabene), 
                           latex=(visit_latex_notabene, depart_latex_notabene))
    app.add_directive('example', Example)
    app.add_node(example, html=(visit_html_notabene, depart_html_notabene), 
                        latex=(visit_latex_notabene, depart_latex_notabene))
    app.add_directive('welcome', Welcome)
    app.add_node(welcome, html=(visit_html_notabene, depart_html_notabene), 
                        latex=(visit_latex_notabene, depart_latex_notabene))
    app.add_directive('block', Block)
    app.add_node(block, html=(visit_html_block, depart_html_block), 
                        latex=(visit_latex_block, depart_latex_block))

    app.add_directive('hint', Hint)
    app.add_node(hint, html=(visit_html_hint, depart_html_hint), 
                       latex=(visit_latex_hint, depart_latex_hint))
    app.add_directive('feedback', Feedback)
    app.add_node(feedback, html=(visit_html_feedback, depart_html_feedback), 
                           latex=(visit_latex_feedback, depart_latex_feedback))

    app.add_directive('mcq', Mcq)
    app.add_node(mcq, html=(visit_html_mcq, depart_html_mcq), 
                      latex=(visit_latex_mcq, depart_latex_mcq))
    app.add_directive('q-mcq', QMcq)
    app.add_node(qmcq, html=(visit_html_qmcq, depart_html_qmcq), 
                       latex=(visit_latex_qmcq, depart_latex_qmcq))

    app.add_directive('input', Input)
    app.add_node(inputnode, html=(visit_html_input, depart_html_input), 
                            latex=(visit_latex_input, depart_latex_input))
    app.add_directive('inputlines', InputLines)
    app.add_node(inputlines, html=(visit_html_inputlines, depart_html_inputlines), 
                            latex=(visit_latex_inputlines, depart_latex_inputlines))
    app.add_directive('fillblank', FillBlank)
    app.add_node(fillblank, html=(visit_html_fillblank, depart_html_fillblank), 
                            latex=(visit_latex_fillblank, depart_latex_fillblank))

    app.add_directive('multicolumn', Multicolumn)
    app.add_node(multicolumn, html=(visit_html_multicolumn, depart_html_multicolumn))
    app.add_directive('column', Column)
    app.add_node(column, html=(visit_html_column, depart_html_column))
    app.add_directive('multisort', Multisort)
    app.add_node(multisort, html=(visit_html_multisort, depart_html_multisort))
    app.add_directive('sort', Sort)
    app.add_node(sort, html=(visit_html_sort, depart_html_sort))


    app.add_directive('audio', Audio)
    app.add_directive('video', Video)
    app.add_directive('pdf',   Pdf)

    app.add_directive('container', Container)
    app.add_node(container, html=(visit_html_container, depart_html_container), 
                           latex=(visit_latex_container, depart_latex_container))
    app.add_directive('exercise', Exercise)
    app.add_node(exercise, html=(visit_html_exercise, depart_html_exercise), 
                           latex=(visit_latex_exercise, depart_latex_exercise))
    app.add_directive('question', Question)
    app.add_node(question, html=(visit_html_question, depart_html_question), 
                           latex=(visit_latex_question, depart_latex_question))
    app.add_directive('answer', Answer)
    app.add_node(answer, html=(visit_html_answer, depart_html_answer), 
                         latex=(visit_latex_answer, depart_latex_answer))
    app.add_directive('solution', Solution)
    app.add_node(solution, html=(visit_html_solution, depart_html_solution), 
                           latex=(visit_latex_solution, depart_latex_solution))
    app.add_directive('save', Save)
    app.add_node(save, html=(visit_html_save, depart_html_save), 
                           latex=(visit_latex_save, depart_latex_save))

    app.add_directive('code-run', Run)
    app.add_node(run,   html=(visit_html_run, depart_html_run),
                        latex=(visit_latex_run, depart_latex_run))
    app.add_directive('code-scope', Scope)
    app.add_node(scope, html=(visit_html_scope, depart_html_scope))

    app.add_directive('diagram-edit', Diagram)
    app.add_node(diagram, html=(visit_html_diagram, depart_html_diagram), 
                          latex=(visit_latex_diagram, depart_latex_diagram))
    app.add_directive('graph', Graph)
    app.add_node(graph, html=(visit_html_graph, depart_html_graph), 
                        latex=(visit_latex_graph, depart_latex_graph))

    # css
    app.add_stylesheet('enibook/css/glyphicons.css')
    app.add_stylesheet('enibook/css/jquery-ui.min.css')
    app.add_stylesheet('enibook/css/theme/jquery-mobile-theme-enibook.min.css')
    app.add_stylesheet('enibook/css/jquery.mobile-1.4.5.min.css')
    app.add_stylesheet('enibook/css/codemirror.css')
    app.add_stylesheet('enibook/js/addon/dialog/dialog.css')
    app.add_stylesheet('enibook/js/addon/display/fullscreen.css')
    app.add_stylesheet('enibook/css/pytutor.css')
    app.add_stylesheet('enibook/css/basictable.css')
    app.add_stylesheet('enibook/css/enibook.css')

    # js
    app.add_javascript('enibook/js/jquery.min.js')
    app.add_javascript('enibook/js/jquery-ui.min.js')
    app.add_javascript('enibook/js/jquery.ui.touch-punch.min.js')
    app.add_javascript('enibook/js/jquery.mobile-1.4.5.min.js')
    app.add_javascript('enibook/js/codemirror.js')
    app.add_javascript('enibook/js/mode/clike/clike.js')
    #app.add_javascript('js/mode/prolog/prolog.js')
    app.add_javascript('enibook/js/mode/python/python.js')
    app.add_javascript('enibook/js/mode/rst/rst.js')
    app.add_javascript('enibook/js/mode/sql/sql.js')
    app.add_javascript('enibook/js/mode/xml/xml.js')
    app.add_javascript('enibook/js/mode/javascript/javascript.js')
    app.add_javascript('enibook/js/mode/css/css.js')
    app.add_javascript('enibook/js/mode/htmlmixed/htmlmixed.js')
    #app.add_javascript('js/addon/display/autorefresh.js')
    app.add_javascript('enibook/js/addon/display/placeholder.js')
    app.add_javascript('enibook/js/addon/display/fullscreen.js')
    app.add_javascript('enibook/js/addon/fold/xml-fold.js')
    app.add_javascript('enibook/js/addon/edit/matchbrackets.js')
    app.add_javascript('enibook/js/addon/edit/matchtags.js')
    app.add_javascript('enibook/js/addon/search/search.js')
    app.add_javascript('enibook/js/addon/search/searchcursor.js')
    app.add_javascript('enibook/js/addon/search/match-highlighter.js')
    app.add_javascript('enibook/js/addon/selection/active-line.js')
    app.add_javascript('enibook/js/addon/selection/mark-selection.js')
    app.add_javascript('enibook/js/addon/dialog/dialog.js')
    app.add_javascript('enibook/js/language/python/skulpt.min.js' )
    app.add_javascript('enibook/js/language/python/skulpt-stdlib.js')
    app.add_javascript('enibook/js/language/sql/sql.js')
    #app.add_javascript('enibook/js/language/dot/viz.js')
    #app.add_javascript('js/language/c/JSCPP.es5.min.js')
    app.add_javascript('enibook/js/go-debug.js')
    app.add_javascript('enibook/js/PortShiftingTool.js')
    #app.add_javascript('enibook/js/d3.v2.min.js')
    #app.add_javascript('enibook/js/jquery.ba-bbq.min.js')
    #app.add_javascript('enibook/js/jquery.jsPlumb-1.3.10-all-min.js')
    #app.add_javascript('enibook/js/jsplumb.min.js')
    #app.add_javascript('enibook/js/jquery.qtip.min.js')
    #app.add_javascript('enibook/js/pytutor.js')
    app.add_javascript('enibook/js/md5.min.js')
    app.add_javascript('enibook/js/jquery.basictable.min.js')

    app.add_javascript('enibook/js/enibook.js')
    app.add_javascript('enibook/js/enibook-config.js')

    app.add_config_value('timeversion', '0', 'env')
    app.add_config_value('modeEnibook', 'learning', 'env')
    app.add_config_value('typeEnibook', 'book', 'env')
    app.add_config_value('versionEnibook', __version__, 'env')

    sys.stderr.write(' ... done\n')
#------------------------------------------------------------------------------
