# -*- coding: utf-8 -*-

# medias.py

__author__ = 'jacques.tisseau@enib.fr'

from docutils import io, nodes, statemachine, utils
from docutils.parsers.rst import Directive
from docutils.parsers.rst import directives, roles

from enibook import EniBook

#------------------------------------------------------------------------------
# Audio
#------------------------------------------------------------------------------
class Audio(EniBook):
    required_arguments = 1
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'autoplay'  : directives.flag,
        'controls'  : directives.flag,
        'loop'      : directives.flag,
        'muted'     : directives.flag,
        'preload'   : directives.flag,
        'title'     : directives.unchanged  
    }

    def run(self):
        super(Audio,self).run()

        self.options['src'] = self.arguments[0]

        if 'title' not in self.options :
            self.options['title'] = ''

        res = u"""
<div id="%(id)s" name="%(name)s" class="enibook-audio %(class)s">
    <table>
    <tr><td>
        <audio """ % self.options

        if 'controls' in self.options :
            res += u" controls"

        if 'muted' in self.options :
            res += u" muted"

        if 'loop' in self.options :
            res += u" loop"

        if 'autoplay' in self.options :
            res += u" autoplay"

        preload = self.options.get('preload')
        if preload:
            if preload in ['none', 'metadata', 'auto']:
                res += u" preload='%s'" % preload

        res += u""">
            <source type="audio/ogg"  src="%(src)s.ogg"  />
            <source type="audio/mpeg" src="%(src)s.mp3"  />
            <source type="audio/wav"  src="%(src)s.wav" />
            Enregistrement audio non supporté par le navigateur.
        </audio></td></tr>
    <tr><td><span class="enibook-title-audio">%(title)s</span></td></tr>
    </table>
</div>
""" % self.options
        return [nodes.raw('', res, format='html')]
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Video
#------------------------------------------------------------------------------
class Video(EniBook):
    required_arguments = 1
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'autoplay'  : directives.flag,
        'controls'  : directives.flag,
        'loop'      : directives.flag,
        'muted'     : directives.flag,
        'poster'    : directives.unchanged,
        'preload'   : directives.flag,
        'height'    : directives.length_or_unitless,
        'width'     : directives.length_or_percentage_or_unitless,
        'title'     : directives.unchanged  
    }

    def run(self):
        super(Video,self).run()

        self.options['src'] = self.arguments[0]

        if 'title' not in self.options :
            self.options['title'] = ''

        res = u"""
<div id="%(id)s" name="%(name)s" class="enibook-video %(class)s">
    <table>
    <tr><td>
        <video """ % self.options

        if 'controls' in self.options :
            res += u" controls"

        if 'muted' in self.options :
            res += u" muted"

        if 'loop' in self.options :
            res += u" loop"

        if 'autoplay' in self.options :
            res += u" autoplay"

        width = self.options.get('width')
        if width is not None:
            res += u" width='%s'" % width

        height = self.options.get('height')
        if height is not None:
            res += u" height='%s'" % height

        poster = self.options.get('poster')
        if poster is not None:
            res += u" poster='%s'" % poster

        preload = self.options.get('preload')
        if preload:
            if preload in ['none', 'metadata', 'auto']:
                res += u" preload='%s'" % preload
       
        res += u""">
            <source type="video/ogg"  src="%(src)s.ogg"  />
            <source type="video/mp4"  src="%(src)s.mp4"  />
            <source type="video/webm" src="%(src)s.webm" />
            Enregistrement vidéo non supporté par le navigateur.
        </video></td></tr>
    <tr><td><span class="enibook-title-video">%(title)s</span></td></tr>
    </table>
</div>
""" % self.options
        return [nodes.raw('', res, format='html')]
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Pdf
#------------------------------------------------------------------------------
class Pdf(EniBook):
    required_arguments = 1
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'height'    : directives.length_or_unitless,
        'width'     : directives.length_or_percentage_or_unitless,
        'page'      : directives.positive_int
    }

    def run(self):
        super(Pdf,self).run()

        self.options['src'] = self.arguments[0]

        if 'width' not in self.options :
            self.options['width'] = '100%'

        if 'height' not in self.options :
            self.options['height'] = '800px'

        if 'page' not in self.options :
            self.options['page'] = 1

        res = u"""
<div id="%(id)s" name="%(name)s" class="enibook-pdf %(class)s">
    <object id="%(id)s-pdf"
            data='https://web.enib.fr/~tisseau/tmp/pdfreader/web/viewer.html?file=%(src)s#page=%(page)s' type='text/html'
            width="%(width)s" height="%(height)s">
        Le navigateur n'accepte pas le lecteur pdf.
    </object>
</div>
""" % self.options

        return [nodes.raw('', res, format='html')]
#------------------------------------------------------------------------------
