# -*- coding: utf-8 -*-

# feedback.py

__author__ = 'jacques.tisseau@enib.fr'

from docutils import io, nodes, statemachine, utils
from docutils.parsers.rst import Directive
from docutils.parsers.rst import directives, roles

from enibook import EniBook

#------------------------------------------------------------------------------
# Hint
#------------------------------------------------------------------------------
HINT_HTML_BEGIN = u"""
<!-- début %(id)s -->
    <div class="hint %(class)s-hint" id="%(id)s-hint" name="%(name)s-hint" 
    maxitems="%(maxitems)s" items="%(items)s" levels="%(nolevels)s"
    directive="%(directive)s">
"""

HINT_HTML_END = u"""
    </div>
<!-- fin %(id)s -->
<script type="text/javascript">
    //$(document).ready( function() { EniBook.init.push( function() { EniBook["%(id)s"] = new Hint("%(id)s"); }) });
    EniBook.init.push( function() { EniBook["%(id)s"] = new Hint("%(id)s"); } );
</script>
"""

HINT_LATEX_BEGIN = u"""
"""

HINT_LATEX_END = u"""
"""

#-----------------------------------------------------
class hint(nodes.General, nodes.Element):
    def __init__(self,options):
        super(hint,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_hint(self, node):
    #if   isinstance(node.parent,qqcm)      : node.options["parent"] = "q-qcm"
    #elif isinstance(node.parent,inputnode) : node.options["parent"] = "input"
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_hint(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_hint(self, node):
    pass

def depart_latex_hint(self,node):
    pass
#-----------------------------------------------------

#-----------------------------------------------------
class Hint(EniBook):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'class'     : directives.class_option,
        'name'      : directives.unchanged,
        'nolevels'  : directives.flag
    }
	
    def run(self):
        super(Hint,self).run()

        if 'nolevels' not in self.options :
            self.options['nolevels'] = 'true'
        else :
            self.options['nolevels'] = 'false'
            
        self.options['maxitems'] = 'single'
        self.options['items'] = '0'

        node = hint(self.options)
        node.html_begin  = HINT_HTML_BEGIN
        node.html_end    = HINT_HTML_END
        node.latex_begin = HINT_LATEX_BEGIN
        node.latex_end   = HINT_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)
        return [node]
#------------------------------------------------------------------------------


#------------------------------------------------------------------------------
# Feedback
#------------------------------------------------------------------------------
FEEDBACK_HTML_BEGIN = u"""
<!-- début %(id)s -->
    <div class="feedback %(class)s-feedback" id="%(id)s-feedback" name="%(name)s-feedback"
        type="%(type)s" directive="%(directive)s">
"""

FEEDBACK_HTML_END = u"""
    </div>
<!-- fin %(id)s -->
<script type="text/javascript">
    //$(document).ready( function() { EniBook.init.push( function() { EniBook['%(id)s'] = new Feedback('%(id)s'); }) });
    EniBook.init.push( function() { EniBook['%(id)s'] = new Feedback('%(id)s'); } );
</script>
"""

FEEDBACK_LATEX_BEGIN = u"""
"""

FEEDBACK_LATEX_END = u"""
"""

#-----------------------------------------------------
class feedback(nodes.General, nodes.Element):
    def __init__(self,options):
        super(feedback,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_feedback(self, node):
    #if   isinstance(node.parent,qqcm)      : node.options["parent"] = "q-qcm"
    #elif isinstance(node.parent,inputnode) : node.options["parent"] = "input"
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_feedback(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_feedback(self, node):
    pass

def depart_latex_feedback(self,node):
    pass
#-----------------------------------------------------

#-----------------------------------------------------
class Feedback(EniBook):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'class'     : directives.class_option,
        'name'      : directives.unchanged,
        'true'      : directives.flag,
        'false'     : directives.flag
    }
	
    def run(self):
        super(Feedback,self).run()

        if 'true' not in self.options :
            self.options['type'] = 'false'
        else :
            self.options['type'] = 'true'

        node = feedback(self.options)
        node.html_begin  = FEEDBACK_HTML_BEGIN
        node.html_end    = FEEDBACK_HTML_END
        node.latex_begin = FEEDBACK_LATEX_BEGIN
        node.latex_end   = FEEDBACK_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)

        if self.options['modeEnibook'] != 'assessing' :
            return [node]
        else :
            return []
#------------------------------------------------------------------------------
