# -*- coding: utf-8 -*-

# help.py

__author__ = 'jacques.tisseau@enib.fr'

from docutils import io, nodes, statemachine, utils
from docutils.parsers.rst import Directive
from docutils.parsers.rst import directives, roles

from enibook import EniBook

#------------------------------------------------------------------------------
# Help
#------------------------------------------------------------------------------
HELP_HTML_BEGIN = u"""
<div id="%(id)s-help" name="%(name)s-help" class="help %(class)s-help" 
    collapse="%(collapse)s" maxitems="%(maxitems)s" items="%(items)s" 
    levels="%(nolevels)s" remarks="false" directive="%(directive)s">
"""

HELP_HTML_BLOCK = u"""
    <div id="%(id)s-help-title-block" name="%(name)s-help-title-block" 
        class="help-title-block  %(class)s-help-title-block">
        <div id="%(id)s-help-title" name="%(name)s-help-title" 
            class="help-title-block-title %(class)s-help-title-block-title">%(title)s
        <span id="%(id)s-help-btn" name="%(name)s-help-btn" 
                class="btn btn-warning help-btn-block %(class)s-help-btn-block glyphicons glyphicons-chevron-down"></span></div>
    </div>
    <script type="text/javascript">
        $("#%(id)s-help-title-block").on("click", function(event) { event.stopPropagation(); runHelp('%(id)s'); } );
    </script>
    <div class="help-content-block %(class)s-help-content-block" 
        id="%(id)s-help-content" name="%(name)s-help-content">
"""

HELP_HTML_LINK = u"""
    <span id="%(id)s-help-title" name="%(name)s-help-title" 
        class="help-title %(class)s-help-title">%(title)s</span>
    <span id="%(id)s-help-btn" name="%(name)s-help-btn" 
            class="btn btn-warning help-btn %(class)s-help-btn 
            glyphicons glyphicons-chevron-down"></span>
    <span id="%(id)s-help-btn-items" name="%(name)s-help-btn-items" 
        class="help-btn-items %(class)s-help-btn-items"></span>
    <div class="help-content %(class)s-help-content" id="%(id)s-help-content" 
        name="%(name)s-help-content">
"""

HELP_HTML_END = u"""
    </div>
</div>
<script type="text/javascript">
    $("#%(id)s-help-title").on("click", function(event) { event.stopPropagation(); runHelp('%(id)s'); } );
    $("#%(id)s-help-btn").on("click", function(event)   { event.stopPropagation(); runHelp('%(id)s'); } );
    $(document).ready( function() { initHelp('%(id)s'); } );
</script>
"""

HELP_LATEX_BEGIN = u"""
"""

HELP_LATEX_END = u"""
"""
#-----------------------------------------------------
class help(nodes.General, nodes.Element):
    def __init__(self,options):
        super(help,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_help(self, node):
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_help(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_help(self, node):
    pass

def depart_latex_help(self,node):
    pass
#-----------------------------------------------------

#-----------------------------------------------------
def collapsehelp(argument) :
    return directives.choice(argument, ("false","true"))
    
def typehelp(argument):
    return directives.choice(argument, ("link","block"))

class Help(EniBook):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'class'     : directives.class_option,
        'name'      : directives.unchanged,
        'title'     : directives.unchanged,
        'collapse'  : collapsehelp,
        'type'      : typehelp,
        'nolevels'  : directives.flag
    }
	
    def run(self):
        super(Help,self).run()
        
        if 'title' not in self.options :
            self.options['title'] = ''

        if 'type' not in self.options :
            self.options['type'] = 'link'

        if 'collapse' not in self.options :
            self.options['collapse'] = 'true'

        if 'nolevels' not in self.options :
            self.options['nolevels'] = 'true'
        else :
            self.options['nolevels'] = 'false'
            
        self.options['maxitems'] = 'single'
        self.options['items'] = '0'
        
        node = help(self.options)
        node.html_begin  = HELP_HTML_BEGIN
        if self.options['type'] == 'block' :
            node.html_begin  += HELP_HTML_BLOCK
        else :
            node.html_begin  += HELP_HTML_LINK
        node.html_end    = HELP_HTML_END
        node.latex_begin = HELP_LATEX_BEGIN
        node.latex_end   = HELP_LATEX_END

        self.state.nested_parse(self.content, self.content_offset, node)
        return [node]
#------------------------------------------------------------------------------
