# -*- coding: utf-8 -*-
#
# enibook-tools documentation build configuration file, created by
# sphinx-quickstart on Mon Feb  9 10:41:50 2015.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys
import os

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#sys.path.insert(0, os.path.abspath('.'))
enibook_path = '../../_enibook-sphinx-require/'
sys.path.insert(0, os.path.abspath(enibook_path))
print "\t\033[1;34menibook_path =", os.path.abspath(enibook_path), "\033[0m"
print "\t\033[1;34mcurrent_path =", os.path.abspath('.'), "\033[0m"

# -- General configuration ------------------------------------------------
# If your documentation needs a minimal Sphinx version, state it here.
#needs_sphinx = '1.0'

smartquotes = False

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.ifconfig',
    #'sphinxcontrib.tikz',
    'sphinx-extension.katex',
    'sphinx-extension.enibook'
]

#mathjax_path = 'js/MathJax/MathJax.js?config=TeX-AMS_HTML-full'
#mathjax_path = 'js/MathJax/MathJax.js?config=TeX-AMS_SVG'
katex_path = 'katex/'

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = u'.rst'

# The encoding of source files.
source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = u'index'

# General information about the project.
project   = u'EniBook'
copyright = u'2012-2018, EniBook'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = '1.'
# The full version, including alpha/beta/rc tags.
release = '1.'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = 'fr'

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
today_fmt = '%d %b %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['.']

# The reST default role (used for this markup: `text`) to use for all
# documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
#keep_warnings = False


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'sphinx-theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#html_theme_options = {}
# Theme options are theme-specific and customize the look and feel of a theme
html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
#html_theme_path = []
html_theme_path = ["_templates",enibook_path]

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None
html_title = u'My Project'

# A shorter title for the navigation bar.  Default is the same as html_title.
html_short_title = html_title

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = '_static/_images/logo-enibook.png'

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = '_static/_images/favicon-enib.ico'

html_add_permalinks = ''
html_search_language = 'fr'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
module_paths = [x.replace('.','/') for x in extensions]
#module_static_js  = '../sphinx-extension/js/'
#module_static_css = '../sphinx-extension/css/'

html_static_path = ['_static/', 
                    enibook_path + 'sphinx-extension/enibook/_static/',
                    enibook_path + 'sphinx-extension/katex/_static/'
                   ]


# Add any extra paths that contain custom files (such as robots.txt or
# .htaccess) here, relative to this directory. These files are copied
# directly to the root of the documentation.
#html_extra_path = []

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
html_last_updated_fmt = '%d %b %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {'**': ['globaltoc.html', 'sourcelink.html', 'searchbox.html']}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
#html_domain_indices = True

# If false, no index is generated.
html_use_index = True

# If true, the index is split into individual pages for each letter.
html_split_index = False

# If true, links to the reST sources are added to the pages.
#html_show_sourcelink = True
html_show_sourcelink = False

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
#html_show_sphinx = True
html_show_sphinx = False

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
#html_show_copyright = True
html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = None

# Output file base name for HTML help builder.
#htmlhelp_basename = ''

# tikz
#tikz_proc_suite = 'ImageMagick'
tikz_transparent = True
tikz_latex_preamble = '''
\usepackage{xcolor,colortbl}
\usepackage{amsmath,amssymb,amsfonts}
\usepackage{longtable}
\usepackage{fancybox,fancyvrb,fancyhdr}
\usepackage[french]{babel}
\usepackage{geometry}
\geometry{landscape,text={29cm,21cm},centering}
'''

