# -*- coding: utf-8 -*-
from __future__ import unicode_literals

# question.py

__author__ = 'jacques.tisseau@enib.fr'

from docutils import io, nodes, statemachine, utils
from docutils.parsers.rst import Directive
from docutils.parsers.rst import directives

import os, os.path

from enibook import EniBook

#------------------------------------------------------------------------------
# Container
#------------------------------------------------------------------------------
CONTAINER_HTML_BEGIN = u"""
<!-- begin %(id)s -->
<div id="%(id)s" name="%(name)s" style="margin-bottom: 10px; width: 100%%; display: block;">
    <span id="%(id)s-container-spanid" name="%(name)s-container-spanid"
        onclick="EniBook['%(id)s'].toggle_container(); EniBook['%(id)s'].update();" 
        <span id="%(id)s-container-btn" class="btn btn-warning glyphicons glyphicons-folder-closed"></span>
        <span id="%(id)s-container-items" name="%(name)s-container-items"
            class="container-items %(class)s-container-items">%(choices)s/%(questions)s</span>
        <span class="container-title %(class)s-container-title" id="%(id)s-container-title" 
            name="%(name)s-container-title"  style="cursor: pointer;"
            onclick="EniBook['%(id)s'].toggle_container(); EniBook['%(id)s'].update();" 
            >%(title)s</span>
    </span>
    <div class="container %(class)s-container" id="%(id)s-container" name="%(name)s-container" 
        user-class="%(class)s" norandom="%(norandom)s" collapse="%(collapse)s" choices="%(choices)s"
        questions="%(questions)s" type="%(type)s"
        directive="%(directive)s" typeEnibook="%(typeEnibook)s" modeEnibook="%(modeEnibook)s">
"""

CONTAINER_HTML_END = u"""
    </div>
</div>
<!-- end %(id)s -->
<script type="text/javascript">
    //$(document).ready( function() { EniBook.init.push( function() { EniBook['%(id)s'] = new Container('%(id)s'); }) });
    EniBook.init.push( function() { EniBook['%(id)s'] = new Container('%(id)s'); } );
</script>
"""

CONTAINER_LATEX_BEGIN = ""
CONTAINER_LATEX_END = ""

CONTAINER_PYTHON_CONFIG = u"""
pyEniBook['assessing']['%(directive)s']['%(id)s'] = {
    'title'     : u"%(title)s",
    'questions' : %(questions)s,
    'choices'   : %(choices)s,
    'norandom'  : "%(norandom)s",
    'items'     : [],
    'user'      : ""
}
"""

#-----------------------------------------------------
class container(nodes.General, nodes.Element):
    def __init__(self,options):
        super(container,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_container(self, node):
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_container(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_container(self, node):
    pass

def depart_latex_container(self,node):
    pass
#-----------------------------------------------------

#-----------------------------------------------------
class Container(EniBook):
    required_arguments = 1
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'class'     : directives.class_option,
        'name'      : directives.unchanged,
        'title'     : directives.unchanged,
        'collapse'  : directives.flag,
        'norandom'  : directives.flag,
        'choices'   : directives.positive_int
    }
	
    def run(self):
        super(Container,self).run()

        env = self.state.document.settings.env
        env.container_counter = 0
        
        self.options['type'] = directives.unchanged(self.arguments[0])

        if 'title' not in self.options :
            self.options['title'] = "Conteneur"

        if 'collapse' not in self.options :
            self.options['collapse'] = 'false'
        else :
            self.options['collapse'] = 'true'

        if 'norandom' not in self.options :
            self.options['norandom'] = 'false'
        else :
            self.options['norandom'] = 'true'

        node = container(self.options)
        node.html_begin  = CONTAINER_HTML_BEGIN
        node.html_end    = CONTAINER_HTML_END
        node.latex_begin = CONTAINER_LATEX_BEGIN
        node.latex_end   = CONTAINER_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)
        
        items = 0
        for str in self.content:
            if str.find('.. %s::'  % (self.options["type"])) != -1 :
                items += 1
        self.options['questions'] = items

        if 'choices' not in self.options :
            self.options['choices'] = self.options['questions']
        else :
            if self.options['choices'] > self.options['questions'] :
                self.options['choices'] = self.options['questions']
        
        if self.options['modeEnibook'] != "learning" and os.path.exists("pyenibook.cfg") :
            file = open("pyenibook.cfg","a")
            txt = CONTAINER_PYTHON_CONFIG % self.options
            txt = txt.encode("utf8")
            file.write(txt)
            file.close()
        
        env.container_counter = 0
        
        return [node]
#------------------------------------------------------------------------------



#------------------------------------------------------------------------------
# Exercise
#------------------------------------------------------------------------------
EXERCISE_HTML_BEGIN = u"""
<!-- begin %(id)s -->
<div id="%(id)s" name="%(name)s" class="exercise-block">
    <span id="%(id)s-exercise-spanid" name="%(name)s-exercise-spanid"
        onclick="$('#%(id)s-exercise').toggle(); EniBook['%(id)s'].update();" 
        <span class="btn btn-warning glyphicons glyphicons-cogwheels"></span>
        <span id="%(id)s-exercise-items" name="%(name)s-exercise-items"
            class="exercise-items %(class)s-exercise-items">%(choices)s/%(questions)s</span>
        <span class="exercise-title %(class)s-exercise-title" id="%(id)s-exercise-title" 
            name="%(name)s-exercise-title"  style="cursor: pointer;"
            onclick="$('#%(id)s-exercise').toggle(); EniBook['%(id)s'].update();">%(title)s</span>
    </span>
    <div class="exercise %(class)s-exercise" id="%(id)s-exercise" name="%(name)s-exercise" 
        user-class="%(class)s" norandom="%(norandom)s" collapse="%(collapse)s" choices="%(choices)s"
        questions="%(questions)s" criteria="%(criteria)s" 
        directive="%(directive)s" typeEnibook="%(typeEnibook)s" modeEnibook="%(modeEnibook)s">
"""

EXERCISE_PYTHON_CONFIG = u"""
pyEniBook['assessing']['%(directive)s']['%(id)s'] = {
    'title'     : u"%(title)s",
    'questions' : %(questions)s,
    'choices'   : %(choices)s,
    'norandom'  : "%(norandom)s",
    'items'     : [],
    'user'      : ""
}
"""

EXERCISE_HTML_END = u"""
    </div>
</div>
<!-- end %(id)s -->
<script type="text/javascript">
    //$(document).ready( function() { EniBook.init.push( function() { EniBook['%(id)s'] = new Exercise('%(id)s'); }) });
    EniBook.init.push( function() { EniBook['%(id)s'] = new Exercise('%(id)s'); } );
</script>
"""

EXERCISE_LATEX_BEGIN = u"""
"""

EXERCISE_LATEX_END = u"""
"""

#-----------------------------------------------------
class exercise(nodes.General, nodes.Element):
    def __init__(self,options):
        super(exercise,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_exercise(self, node):
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_exercise(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_exercise(self, node):
    res = node.latex_begin % node.options
    self.body.append(res)

def depart_latex_exercise(self,node):
    res = node.latex_end % node.options
    self.body.append(res)
#-----------------------------------------------------

#-----------------------------------------------------
class Exercise(EniBook):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'class'     : directives.class_option,
        'name'      : directives.unchanged,
        'title'     : directives.unchanged,
        'collapse'  : directives.flag,
        'norandom'  : directives.flag,
        'choices'   : directives.positive_int,
        'criteria'  : directives.unchanged
    }
	
    def run(self):
        super(Exercise,self).run()

        env = self.state.document.settings.env
        env.exercise_counter = 0

        if 'title' not in self.options :
            self.options['title'] = "Exercice"

        if 'collapse' not in self.options :
            self.options['collapse'] = 'false'
        else :
            self.options['collapse'] = 'true'

        if 'norandom' not in self.options :
            self.options['norandom'] = 'false'
        else :
            self.options['norandom'] = 'true'

        if 'criteria' not in self.options :
            self.options['criteria'] = ""

        node = exercise(self.options)
        node.html_begin  = EXERCISE_HTML_BEGIN
        node.html_end    = EXERCISE_HTML_END
        node.latex_begin = EXERCISE_LATEX_BEGIN
        node.latex_end   = EXERCISE_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)
        
        items = 0
        for str in self.content:
            if str.find('.. question::') != -1 :
                items += 1
        self.options['questions'] = items

        if 'choices' not in self.options :
            self.options['choices'] = self.options['questions']
        else :
            if self.options['choices'] > self.options['questions'] :
                self.options['choices'] = self.options['questions']
        
        if self.options['modeEnibook'] != "learning" and os.path.exists("pyenibook.cfg") :
            file = open("pyenibook.cfg","a")
            txt = EXERCISE_PYTHON_CONFIG % self.options
            txt = txt.encode("utf8")
            file.write(txt)
            file.close()
        
        env.exercise_counter = 0
        
        return [node]
#------------------------------------------------------------------------------


#------------------------------------------------------------------------------
# Question
#------------------------------------------------------------------------------
QUESTION_HTML_BEGIN = u""" 
<div id="%(id)s-question-div" name="%(name)s-question-div"
    class="question-div-class %(class)s-question-div-class"
    onclick="EniBook['%(id)s'].toggle();" style="cursor: pointer;">
    <span style="font-size: 50%%;" class="btn btn-warning glyphicons glyphicons-cogwheel"></span> 
    <span class="question-title %(class)s-question-title" id="%(id)s-question-title" 
        name="%(name)s-question-title">%(title)s</span>
</div>
<div id="%(id)s" class="question %(class)s-question">
    <div data-role="navbar" class="question-navbar %(class)s-question-navbar">
        <ul>
            <li><a id="%(id)s-question-btn" name="%(name)s-question-btn" 
                class="ui-btn-active"
                href="#" onclick="EniBook['%(id)s'].update();">Question</a></li>
            <li><a id="%(id)s-solution-btn" name="%(name)s-solution-btn" 
                href="#" onclick="EniBook['%(id)s'].solution();"><span id="%(id)s-solution-title">Solution</span></a></li>
        </ul>
    </div>
    <div id="%(id)s-question" name="%(name)s-question" question="%(id)s" exercise="%(exercise)s" collapse="%(collapse)s"
        directive="%(directive)s" typeEnibook="%(typeEnibook)s" modeEnibook="%(modeEnibook)s">
"""

QUESTION_HTML_END = u"""
    </div>
    <div id="%(id)s-question-footer" name="%(name)s-question-footer"
        class="question-footer %(class)s-question-footer">
        <span><a href='#' 
            onclick="$.mobile.silentScroll($('#%(id)s-question-div').offset().top);">
            <span class="btn btn-warning glyphicons glyphicons-chevron-up" style="font-size:90%%"></span></a></span>
    </div>
</div>
<script>
    //$(document).ready( function() { EniBook.init.push( function() { EniBook["%(id)s"] = new Question("%(id)s"); }) });
    EniBook.init.push( function() { EniBook["%(id)s"] = new Question("%(id)s"); } );
</script>
"""

QUESTION_PYTHON_CONFIG = u"""
pyEniBook['assessing']['%(directive)s']['%(id)s'] = {
    'title'     : u"%(title)s",
    'aleafile'  : "%(aleafile)s",
    'aleadico'  : {},
    'questions' : 1,
    'choices'   : 1,
    'items'     : []
}
"""

QUESTION_LATEX_BEGIN = u"""
"""

QUESTION_LATEX_END = u"""
"""
#------------------------------------------------------------------------------

#-----------------------------------------------------
class question(nodes.General, nodes.Element):
    def __init__(self,options):
        super(question,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_question(self, node):
    if isinstance(node.parent,exercise) :
        node.options['exercise'] = node.parent.options['id']
    else :
        node.options['exercise'] = "none"
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_question(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_question(self, node):
    res = node.latex_begin % node.options
    self.body.append(res)

def depart_latex_question(self,node):
    res = node.latex_end % node.options
    self.body.append(res)
#-----------------------------------------------------

#-----------------------------------------------------
class Question(EniBook):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'class'     : directives.class_option,
        'name'      : directives.unchanged,
        'title'     : directives.unchanged,
        'aleafile'  : directives.path,
        'aleastr'   : directives.unchanged,
        'collapse'  : directives.flag
    }
	
    def run(self):
        super(Question,self).run()

        if 'title' not in self.options :
            self.options['title'] = self.name

        if 'collapse' not in self.options :
            self.options['collapse'] = 'false'
        else :
            self.options['collapse'] = 'true'

        if 'aleastr' not in self.options :
            self.options['aleastr'] = '¿'

        if 'aleafile' not in self.options :
            self.options['aleafile'] = ''

        if self.options['aleafile'] :
            import re
            """
                if self.options['modeEnibook'] == 'learning' or self.options['aleafile'] == '':
                print '\n\t',self.options['id'],': using built-in aleadico() function',
                for i in range(len(self.content)) :
                    self.content[i] = re.sub(u'¿(?P<name>\S+)¿',u'\\g<name>',self.content[i])
                print '... done', 
            else :
            """
            aleastr = self.options['aleastr']
            filename = 'data/aleadico_' + self.options['id'] + '.py'
            if self.options['modeEnibook'] != 'training' :
                print '\n\t',self.options['id'],'«',self.options['title'],'»',': executing', self.options['aleafile'], 'to define specific aleadico() function',
                execfile(self.options['aleafile'],globals())
                print '... done'
                dico = aleadico(self.options['modeEnibook'])
                d = globals()
                if 'aleadico' in d : del d['aleadico']
                print '\t\tsaving',filename,
                f = open(filename,'w')
                f.write('_dico_ = ' + str(dico))
                f.close()
            else :
                dico = {} 
                print '\n\t',self.options['id'],'«',self.options['title'],'»',': loading', filename,
                execfile(filename,globals())
                dico = _dico_
                print '... done',
            for key in dico.keys() :
                for i in range(len(self.content)) :
                    #self.content[i] = re.sub(u'¿' + key + u'¿',dico[key],self.content[i])
                    self.content[i] = re.sub(aleastr + key + aleastr,dico[key],self.content[i])
        node = question(self.options)
        node.html_begin  = QUESTION_HTML_BEGIN
        node.html_end    = QUESTION_HTML_END
        node.latex_begin = QUESTION_LATEX_BEGIN
        node.latex_end   = QUESTION_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)

        if self.options['modeEnibook'] != "learning" :
            file = open("pyenibook.cfg","a")
            txt = QUESTION_PYTHON_CONFIG % self.options
            txt = txt.encode("utf8")
            file.write(txt)
            file.close()
        
        return [node]
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Answer
#------------------------------------------------------------------------------
ANSWER_HTML_BEGIN = u"""
<div id="%(id)s-answer" name="%(name)s-answer" class="answer %(class)s-answer" 
    question="%(question)s" 
    directive="%(directive)s" typeEnibook="%(typeEnibook)s" modeEnibook="%(modeEnibook)s">
    <h5 style="color: rgb(234,138,0);">%(title)s</h5>
"""

ANSWER_HTML_END = u"""
</div>
"""

ANSWER_LATEX_BEGIN = u"""
"""

ANSWER_LATEX_END = u"""
"""
#------------------------------------------------------------------------------

#-----------------------------------------------------
class answer(nodes.General, nodes.Element):
    def __init__(self,options):
        super(answer,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_answer(self, node):
    if isinstance(node.parent,question) :
        node.options['question'] = node.parent.options['id'];
    else :
        subdir = 'answer'
        parent = 'question'
        eniBookError(subdir,parent)
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_answer(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_answer(self, node):
    res = node.latex_begin % node.options
    self.body.append(res)

def depart_latex_answer(self,node):
    res = node.latex_end % node.options
    self.body.append(res)
#-----------------------------------------------------

#-----------------------------------------------------
class Answer(EniBook):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'title': directives.unchanged
    }
	
    def run(self):
        if 'title' not in self.options :
            self.options['title'] = u'Votre réponse : '

        super(Answer,self).run()


        node = answer(self.options)
        node.html_begin  = ANSWER_HTML_BEGIN
        node.html_end    = ANSWER_HTML_END
        node.latex_begin = ANSWER_LATEX_BEGIN
        node.latex_end   = ANSWER_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)
        
        return [node]
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Solution
#------------------------------------------------------------------------------
SOLUTION_HTML_BEGIN = u"""
<div id="%(id)s-solution" name="%(name)s-solution" 
    class="solution %(class)s-solution" 
    question="%(question)s" 
    directive="%(directive)s" typeEnibook="%(typeEnibook)s" modeEnibook="%(modeEnibook)s">
    <h5 style="color: rgb(234,138,0);">%(title)s</h5>
"""

SOLUTION_HTML_END = u"""
</div>
"""

SOLUTION_LATEX_BEGIN = u"""
"""

SOLUTION_LATEX_END = u"""
"""
#------------------------------------------------------------------------------

#-----------------------------------------------------
class solution(nodes.General, nodes.Element):
    def __init__(self,options):
        super(solution,self).__init__()
        self.options = options
#-----------------------------------------------------

#-----------------------------------------------------
def visit_html_solution(self, node):
    if isinstance(node.parent,question) :
        node.options['question'] = node.parent.options['id'];
    else :
        subdir = 'solution'
        parent = 'question'
        eniBookError(subdir,parent)
    res = node.html_begin % node.options
    self.body.append(res)

def depart_html_solution(self,node):
    res = node.html_end % node.options
    self.body.append(res)

def visit_latex_solution(self, node):
    res = node.latex_begin % node.options
    self.body.append(res)

def depart_latex_solution(self,node):
    res = node.latex_end % node.options
    self.body.append(res)
#-----------------------------------------------------

#-----------------------------------------------------
class Solution(EniBook):
    required_arguments = 0
    optional_arguments = 0
    final_argument_whitespace = True
    has_content = True
    option_spec = {
        'title': directives.unchanged
    }
	
    def run(self):
        if 'title' not in self.options :
            self.options['title'] = 'Une solution possible : '

        super(Solution,self).run()


        node = solution(self.options)
        node.html_begin  = SOLUTION_HTML_BEGIN
        node.html_end    = SOLUTION_HTML_END
        node.latex_begin = SOLUTION_LATEX_BEGIN
        node.latex_end   = SOLUTION_LATEX_END
        self.state.nested_parse(self.content, self.content_offset, node)

        if self.options['modeEnibook'] != 'assessing' :
            return [node]
        else :
            return []

#------------------------------------------------------------------------------
